/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.process.join;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.AbstractConsumeAllOperator;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumnBuilder;

public class HorizontallyConcatOperator
extends AbstractConsumeAllOperator {
    private final int[] inputIndex;
    private final int outputColumnCount;
    private final TsBlockBuilder tsBlockBuilder;
    private boolean finished;

    public HorizontallyConcatOperator(OperatorContext operatorContext, List<Operator> children, List<TSDataType> dataTypes) {
        super(operatorContext, children);
        Preconditions.checkArgument((!children.isEmpty() ? 1 : 0) != 0, (Object)"child size of VerticallyConcatOperator should be larger than 0");
        this.inputIndex = new int[this.inputOperatorsCount];
        this.outputColumnCount = dataTypes.size();
        this.tsBlockBuilder = new TsBlockBuilder(dataTypes);
    }

    @Override
    public TsBlock next() throws Exception {
        if (!this.prepareInput()) {
            return null;
        }
        this.tsBlockBuilder.reset();
        int maxRowCanBuild = Integer.MAX_VALUE;
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            maxRowCanBuild = Math.min(maxRowCanBuild, this.inputTsBlocks[i].getPositionCount() - this.inputIndex[i]);
        }
        TimeColumn firstTimeColumn = this.inputTsBlocks[0].getTimeColumn();
        TimeColumnBuilder timeColumnBuilder = this.tsBlockBuilder.getTimeColumnBuilder();
        ColumnBuilder[] valueColumnBuilders = this.tsBlockBuilder.getValueColumnBuilders();
        int currTsBlockIndex = this.inputIndex[0];
        for (int row = 0; row < maxRowCanBuild; ++row) {
            timeColumnBuilder.writeLong(firstTimeColumn.getLong(currTsBlockIndex + row));
            this.tsBlockBuilder.declarePosition();
        }
        int valueBuilderIndex = 0;
        int i = 0;
        while (i < this.inputOperatorsCount) {
            currTsBlockIndex = this.inputIndex[i];
            for (Column column : this.inputTsBlocks[i].getValueColumns()) {
                for (int row = 0; row < maxRowCanBuild; ++row) {
                    if (column.isNull(currTsBlockIndex + row)) {
                        valueColumnBuilders[valueBuilderIndex].appendNull();
                        continue;
                    }
                    valueColumnBuilders[valueBuilderIndex].write(column, currTsBlockIndex + row);
                }
                ++valueBuilderIndex;
            }
            int n = i++;
            this.inputIndex[n] = this.inputIndex[n] + maxRowCanBuild;
        }
        return this.tsBlockBuilder.build();
    }

    @Override
    public boolean hasNext() throws Exception {
        if (this.finished) {
            return false;
        }
        return !this.isEmpty(this.readyChildIndex) || ((Operator)this.children.get(this.readyChildIndex)).hasNextWithTimer();
    }

    @Override
    public void close() throws Exception {
        for (Operator child : this.children) {
            child.close();
        }
    }

    @Override
    public boolean isFinished() throws Exception {
        if (this.finished) {
            return true;
        }
        this.finished = this.isEmpty(this.readyChildIndex) && !((Operator)this.children.get(this.readyChildIndex)).hasNextWithTimer();
        return this.finished;
    }

    @Override
    public long calculateMaxPeekMemory() {
        long maxPeekMemory = 0L;
        long childrenMaxPeekMemory = 0L;
        for (Operator child : this.children) {
            childrenMaxPeekMemory = Math.max(childrenMaxPeekMemory, maxPeekMemory + child.calculateMaxPeekMemory());
            maxPeekMemory += child.calculateMaxReturnSize() + child.calculateRetainedSizeAfterCallingNext();
        }
        return Math.max(maxPeekMemory += this.calculateMaxReturnSize(), childrenMaxPeekMemory);
    }

    @Override
    public long calculateMaxReturnSize() {
        return (1L + (long)this.outputColumnCount) * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte();
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        long currentRetainedSize = 0L;
        long minChildReturnSize = Long.MAX_VALUE;
        for (Operator child : this.children) {
            long maxReturnSize = child.calculateMaxReturnSize();
            currentRetainedSize += maxReturnSize + child.calculateRetainedSizeAfterCallingNext();
            minChildReturnSize = Math.min(minChildReturnSize, maxReturnSize);
        }
        return currentRetainedSize - minChildReturnSize;
    }

    @Override
    protected boolean isEmpty(int tsBlockIndex) {
        return this.inputTsBlocks[tsBlockIndex] == null || this.inputTsBlocks[tsBlockIndex].getPositionCount() == this.inputIndex[tsBlockIndex];
    }

    @Override
    protected TsBlock getNextTsBlock(int childIndex) throws Exception {
        this.inputIndex[childIndex] = 0;
        return ((Operator)this.children.get(childIndex)).nextWithTimer();
    }
}

