/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.common;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.mpp.common.PlanFragmentId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class QueryId {
    public static QueryId mockQueryId = QueryId.valueOf("mock_query_id");
    private final String id;
    private int nextPlanNodeIndex;
    private int nextPlanFragmentIndex;

    public static QueryId valueOf(String queryId) {
        return new QueryId(queryId);
    }

    public QueryId(String id) {
        this.id = QueryId.validateId(id);
        this.nextPlanNodeIndex = 0;
        this.nextPlanFragmentIndex = 0;
    }

    public PlanNodeId genPlanNodeId() {
        return new PlanNodeId(String.format("%d", this.nextPlanNodeIndex++));
    }

    public PlanFragmentId genPlanFragmentId() {
        return new PlanFragmentId(this, this.nextPlanFragmentIndex++);
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return this.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QueryId other = (QueryId)obj;
        return Objects.equals(this.id, other.id);
    }

    public static List<String> parseDottedId(String id, int expectedParts, String name) {
        Objects.requireNonNull(id, "id is null");
        QueryId.checkArgument(expectedParts > 0, "expectedParts must be at least 1", new Object[0]);
        Objects.requireNonNull(name, "name is null");
        List<String> ids = Arrays.asList(id.split("\\."));
        QueryId.checkArgument(ids.size() == expectedParts, "Invalid %s %s", name, id);
        for (String part : ids) {
            QueryId.checkArgument(!part.isEmpty(), "Invalid id %s", id);
            QueryId.checkArgument(QueryId.isValidId(part), "Invalid id %s", id);
        }
        return ids;
    }

    private static void checkArgument(boolean condition, String message, Object ... messageArgs) {
        if (!condition) {
            throw new IllegalArgumentException(String.format(message, messageArgs));
        }
    }

    private static boolean isValidId(String id) {
        if (id.length() == 0) {
            return false;
        }
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (c == '_' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static String validateId(String id) {
        Objects.requireNonNull(id, "id is null");
        QueryId.checkArgument(!id.isEmpty(), "id is empty", new Object[0]);
        QueryId.checkArgument(QueryId.isValidId(id), "Invalid id %s", id);
        return id;
    }

    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((String)this.id, (ByteBuffer)byteBuffer);
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((String)this.id, (OutputStream)stream);
    }

    public static QueryId deserialize(ByteBuffer byteBuffer) {
        return new QueryId(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
    }
}

