/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.rescon;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.metadata.rescon.CachedSchemaEngineStatistics;
import org.apache.iotdb.db.metadata.rescon.ISchemaEngineStatistics;
import org.apache.iotdb.db.metadata.schemaregion.SchemaEngine;
import org.apache.iotdb.db.metadata.template.ClusterTemplateManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemSchemaEngineStatistics
implements ISchemaEngineStatistics {
    private static final Logger logger = LoggerFactory.getLogger(MemSchemaEngineStatistics.class);
    private final long memoryCapacity = IoTDBDescriptor.getInstance().getConfig().getAllocateMemoryForSchemaRegion();
    protected final AtomicLong memoryUsage = new AtomicLong(0L);
    private final AtomicLong totalSeriesNumber = new AtomicLong(0L);
    private final Map<Integer, Integer> templateUsage = new ConcurrentHashMap<Integer, Integer>();
    private volatile boolean allowToCreateNewSeries = true;

    @Override
    public boolean isAllowToCreateNewSeries() {
        return this.allowToCreateNewSeries;
    }

    @Override
    public boolean isExceedCapacity() {
        return this.memoryUsage.get() > this.memoryCapacity;
    }

    @Override
    public long getMemoryCapacity() {
        return this.memoryCapacity;
    }

    @Override
    public long getMemoryUsage() {
        return this.memoryUsage.get();
    }

    public void requestMemory(long size) {
        this.memoryUsage.addAndGet(size);
        if (this.memoryUsage.get() >= this.memoryCapacity) {
            logger.warn("Current series memory {} is too large...", (Object)this.memoryUsage);
            this.allowToCreateNewSeries = false;
        }
    }

    public void releaseMemory(long size) {
        this.memoryUsage.addAndGet(-size);
        if (!this.allowToCreateNewSeries && this.memoryUsage.get() < this.memoryCapacity) {
            logger.info("Current series memory {} come back to normal level, total series number is {}.", (Object)this.memoryUsage, (Object)this.totalSeriesNumber);
            this.allowToCreateNewSeries = true;
        }
    }

    @Override
    public long getTotalSeriesNumber() {
        return this.totalSeriesNumber.get() + this.getTemplateSeriesNumber();
    }

    @Override
    public int getSchemaRegionNumber() {
        return SchemaEngine.getInstance().getSchemaRegionNumber();
    }

    @Override
    public long getTemplateSeriesNumber() {
        ClusterTemplateManager clusterTemplateManager = ClusterTemplateManager.getInstance();
        return this.templateUsage.entrySet().stream().mapToLong(i -> (long)clusterTemplateManager.getTemplate((Integer)i.getKey()).getMeasurementNumber() * (long)((Integer)i.getValue()).intValue()).sum();
    }

    public void activateTemplate(int templateId) {
        this.templateUsage.compute(templateId, (k, v) -> v == null ? 1 : v + 1);
    }

    public void deactivateTemplate(int templateId, int cnt) {
        this.templateUsage.compute(templateId, (k, v) -> v == null || v <= cnt ? null : Integer.valueOf(v - cnt));
    }

    public void addTimeseries(long addedNum) {
        this.totalSeriesNumber.addAndGet(addedNum);
    }

    public void deleteTimeseries(long deletedNum) {
        this.totalSeriesNumber.addAndGet(-deletedNum);
    }

    @Override
    public MemSchemaEngineStatistics getAsMemSchemaEngineStatistics() {
        return this;
    }

    @Override
    public CachedSchemaEngineStatistics getAsCachedSchemaEngineStatistics() {
        throw new UnsupportedOperationException("Wrong SchemaEngineStatistics Type");
    }
}

