/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.schedule;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.execute.performer.ICompactionPerformer;
import org.apache.iotdb.db.engine.compaction.execute.task.CrossSpaceCompactionTask;
import org.apache.iotdb.db.engine.compaction.execute.task.InnerSpaceCompactionTask;
import org.apache.iotdb.db.engine.compaction.schedule.CompactionTaskManager;
import org.apache.iotdb.db.engine.compaction.selector.ICompactionSelector;
import org.apache.iotdb.db.engine.compaction.selector.ICrossSpaceSelector;
import org.apache.iotdb.db.engine.compaction.selector.utils.CrossCompactionTaskResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");
    private static IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();

    public static void scheduleCompaction(TsFileManager tsFileManager, long timePartition) {
        if (!tsFileManager.isAllowCompaction()) {
            return;
        }
        try {
            CompactionScheduler.tryToSubmitCrossSpaceCompactionTask(tsFileManager, timePartition);
            CompactionScheduler.tryToSubmitInnerSpaceCompactionTask(tsFileManager, timePartition, true);
            CompactionScheduler.tryToSubmitInnerSpaceCompactionTask(tsFileManager, timePartition, false);
        }
        catch (InterruptedException e) {
            LOGGER.error("Exception occurs when selecting compaction tasks", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public static void tryToSubmitInnerSpaceCompactionTask(TsFileManager tsFileManager, long timePartition, boolean sequence) throws InterruptedException {
        if (!config.isEnableSeqSpaceCompaction() && sequence || !config.isEnableUnseqSpaceCompaction() && !sequence) {
            return;
        }
        String storageGroupName = tsFileManager.getStorageGroupName();
        String dataRegionId = tsFileManager.getDataRegionId();
        ICompactionSelector innerSpaceCompactionSelector = sequence ? config.getInnerSequenceCompactionSelector().createInstance(storageGroupName, dataRegionId, timePartition, tsFileManager) : config.getInnerUnsequenceCompactionSelector().createInstance(storageGroupName, dataRegionId, timePartition, tsFileManager);
        List<List<TsFileResource>> taskList = innerSpaceCompactionSelector.selectInnerSpaceTask(sequence ? tsFileManager.getOrCreateSequenceListByTimePartition(timePartition) : tsFileManager.getOrCreateUnsequenceListByTimePartition(timePartition));
        for (List<TsFileResource> task : taskList) {
            ICompactionPerformer performer = sequence ? IoTDBDescriptor.getInstance().getConfig().getInnerSeqCompactionPerformer().createInstance() : IoTDBDescriptor.getInstance().getConfig().getInnerUnseqCompactionPerformer().createInstance();
            CompactionTaskManager.getInstance().addTaskToWaitingQueue(new InnerSpaceCompactionTask(timePartition, tsFileManager, task, sequence, performer, CompactionTaskManager.currentTaskNum, tsFileManager.getNextCompactionTaskId()));
        }
    }

    private static void tryToSubmitCrossSpaceCompactionTask(TsFileManager tsFileManager, long timePartition) throws InterruptedException {
        if (!config.isEnableCrossSpaceCompaction()) {
            return;
        }
        String logicalStorageGroupName = tsFileManager.getStorageGroupName();
        String dataRegionId = tsFileManager.getDataRegionId();
        ICrossSpaceSelector crossSpaceCompactionSelector = config.getCrossCompactionSelector().createInstance(logicalStorageGroupName, dataRegionId, timePartition, tsFileManager);
        List<CrossCompactionTaskResource> taskList = crossSpaceCompactionSelector.selectCrossSpaceTask(tsFileManager.getOrCreateSequenceListByTimePartition(timePartition), tsFileManager.getOrCreateUnsequenceListByTimePartition(timePartition));
        List memoryCost = taskList.stream().map(CrossCompactionTaskResource::getTotalMemoryCost).collect(Collectors.toList());
        int size = taskList.size();
        for (int i = 0; i < size; ++i) {
            CompactionTaskManager.getInstance().addTaskToWaitingQueue(new CrossSpaceCompactionTask(timePartition, tsFileManager, taskList.get(i).getSeqFiles(), taskList.get(i).getUnseqFiles(), IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), CompactionTaskManager.currentTaskNum, (Long)memoryCost.get(i), tsFileManager.getNextCompactionTaskId()));
        }
    }
}

