/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.metricsets.jvm;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class JvmThreadMetrics
implements IMetricSet {
    @Override
    public void bindTo(AbstractMetricService metricService) {
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        metricService.createAutoGauge("jvm_threads_peak_threads", MetricLevel.CORE, threadBean, ThreadMXBean::getPeakThreadCount, new String[0]);
        metricService.createAutoGauge("jvm_threads_daemon_threads", MetricLevel.CORE, threadBean, ThreadMXBean::getDaemonThreadCount, new String[0]);
        metricService.createAutoGauge("jvm_threads_live_threads", MetricLevel.CORE, threadBean, ThreadMXBean::getThreadCount, new String[0]);
        try {
            threadBean.getAllThreadIds();
            for (Thread.State state : Thread.State.values()) {
                metricService.createAutoGauge("jvm_threads_states_threads", MetricLevel.CORE, threadBean, bean -> JvmThreadMetrics.getThreadStateCount(bean, state), "state", JvmThreadMetrics.getStateTagValue(state));
            }
        }
        catch (Error error) {
            // empty catch block
        }
    }

    @Override
    public void unbindFrom(AbstractMetricService metricService) {
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        metricService.remove(MetricType.AUTO_GAUGE, "jvm_threads_peak_threads", new String[0]);
        metricService.remove(MetricType.AUTO_GAUGE, "jvm_threads_daemon_threads", new String[0]);
        metricService.remove(MetricType.AUTO_GAUGE, "jvm_threads_live_threads", new String[0]);
        try {
            threadBean.getAllThreadIds();
            for (Thread.State state : Thread.State.values()) {
                metricService.remove(MetricType.AUTO_GAUGE, "jvm_threads_states_threads", "state", JvmThreadMetrics.getStateTagValue(state));
            }
        }
        catch (Error error) {
            // empty catch block
        }
    }

    static long getThreadStateCount(ThreadMXBean threadBean, Thread.State state) {
        return Arrays.stream(threadBean.getThreadInfo(threadBean.getAllThreadIds())).filter(threadInfo -> threadInfo != null && threadInfo.getThreadState() == state).count();
    }

    private static String getStateTagValue(Thread.State state) {
        return state.name().toLowerCase().replace("_", "-");
    }
}

