/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.ratis;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.ClientManager;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.apache.iotdb.commons.client.property.ClientPoolProperty;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.consensus.IConsensus;
import org.apache.iotdb.consensus.IStateMachine;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.consensus.common.Peer;
import org.apache.iotdb.consensus.common.Utils;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.common.response.ConsensusGenericResponse;
import org.apache.iotdb.consensus.common.response.ConsensusReadResponse;
import org.apache.iotdb.consensus.common.response.ConsensusWriteResponse;
import org.apache.iotdb.consensus.config.ConsensusConfig;
import org.apache.iotdb.consensus.config.RatisConfig;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.consensus.exception.ConsensusGroupNotExistException;
import org.apache.iotdb.consensus.exception.NodeReadOnlyException;
import org.apache.iotdb.consensus.exception.PeerAlreadyInConsensusGroupException;
import org.apache.iotdb.consensus.exception.PeerNotInConsensusGroupException;
import org.apache.iotdb.consensus.exception.RatisRequestFailedException;
import org.apache.iotdb.consensus.ratis.ApplicationStateMachineProxy;
import org.apache.iotdb.consensus.ratis.RatisClient;
import org.apache.iotdb.consensus.ratis.RequestMessage;
import org.apache.iotdb.consensus.ratis.ResponseMessage;
import org.apache.iotdb.consensus.ratis.Utils;
import org.apache.iotdb.consensus.ratis.metrics.RatisMetricSet;
import org.apache.iotdb.consensus.ratis.metrics.RatisMetricsManager;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.ratis.client.RaftClientRpc;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.grpc.GrpcFactory;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.GroupManagementRequest;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.SnapshotManagementRequest;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.apache.ratis.protocol.exceptions.ResourceUnavailableException;
import org.apache.ratis.server.DivisionInfo;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.util.function.CheckedSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RatisConsensus
implements IConsensus {
    private final Logger logger = LoggerFactory.getLogger(RatisConsensus.class);
    private final RaftPeer myself;
    private final RaftServer server;
    private final RaftProperties properties = new RaftProperties();
    private final RaftClientRpc clientRpc;
    private final IClientManager<RaftGroup, RatisClient> clientManager;
    private final Map<RaftGroupId, RaftGroup> lastSeen = new ConcurrentHashMap<RaftGroupId, RaftGroup>();
    private final ClientId localFakeId = ClientId.randomId();
    private final AtomicLong localFakeCallId = new AtomicLong(0L);
    private static final int DEFAULT_PRIORITY = 0;
    private static final int LEADER_PRIORITY = 1;
    private static final int DEFAULT_WAIT_LEADER_READY_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(20L);
    private final ExecutorService addExecutor;
    private final ScheduledExecutorService diskGuardian;
    private final RatisConfig config;
    private final ConcurrentHashMap<File, Utils.MemorizedFileSizeCalc> calcMap = new ConcurrentHashMap();
    private final RatisMetricSet ratisMetricSet;
    private TConsensusGroupType consensusGroupType = null;

    public RatisConsensus(ConsensusConfig config, IStateMachine.Registry registry) throws IOException {
        this.myself = Utils.fromNodeInfoAndPriorityToRaftPeer(config.getThisNodeId(), config.getThisNodeEndPoint(), 0);
        RaftServerConfigKeys.setStorageDir((RaftProperties)this.properties, Collections.singletonList(new File(config.getStorageDir())));
        GrpcConfigKeys.Server.setPort((RaftProperties)this.properties, (int)config.getThisNodeEndPoint().getPort());
        this.addExecutor = IoTDBThreadPoolFactory.newCachedThreadPool((String)"ratis-add");
        this.diskGuardian = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)"ratis-bg-disk-guardian");
        Utils.initRatisConfig(this.properties, config.getRatisConfig());
        this.config = config.getRatisConfig();
        this.ratisMetricSet = new RatisMetricSet();
        this.clientManager = new IClientManager.Factory().createClientManager((IClientPoolFactory)new RatisClientPoolFactory());
        this.clientRpc = new GrpcFactory(new Parameters()).newRaftClientRpc(ClientId.randomId(), this.properties);
        this.server = RaftServer.newBuilder().setServerId(this.myself.getId()).setProperties(this.properties).setStateMachineRegistry(raftGroupId -> new ApplicationStateMachineProxy((IStateMachine)registry.apply(Utils.fromRaftGroupIdToConsensusGroupId(raftGroupId)), (RaftGroupId)raftGroupId)).build();
    }

    @Override
    public void start() throws IOException {
        MetricService.getInstance().addMetricSet((IMetricSet)this.ratisMetricSet);
        this.server.start();
        this.startSnapshotGuardian();
    }

    @Override
    public void stop() throws IOException {
        this.addExecutor.shutdown();
        this.diskGuardian.shutdown();
        try {
            this.addExecutor.awaitTermination(5L, TimeUnit.SECONDS);
            this.diskGuardian.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.logger.warn("{}: interrupted when shutting down add Executor with exception {}", (Object)this, (Object)e);
            Thread.currentThread().interrupt();
        }
        finally {
            this.clientManager.close();
            this.server.close();
        }
        MetricService.getInstance().removeMetricSet((IMetricSet)this.ratisMetricSet);
    }

    private boolean shouldRetry(RaftClientReply reply) {
        return !reply.isSuccess() && reply.getException() instanceof ResourceUnavailableException;
    }

    private RaftClientReply writeWithRetry(CheckedSupplier<RaftClientReply, IOException> caller) throws IOException {
        int maxRetryTimes = this.config.getImpl().getRetryTimesMax();
        long waitMillis = this.config.getImpl().getRetryWaitMillis();
        int retry = 0;
        RaftClientReply reply = null;
        while (retry < maxRetryTimes) {
            ++retry;
            reply = (RaftClientReply)caller.get();
            if (!this.shouldRetry(reply)) {
                return reply;
            }
            this.logger.debug("{} sending write request with retry = {} and reply = {}", new Object[]{this, retry, reply});
            try {
                Thread.sleep(waitMillis);
            }
            catch (InterruptedException e) {
                this.logger.warn("{} retry write sleep is interrupted: {}", (Object)this, (Object)e);
                Thread.currentThread().interrupt();
            }
        }
        return reply;
    }

    private RaftClientReply writeLocallyWithRetry(RaftClientRequest request) throws IOException {
        return this.writeWithRetry((CheckedSupplier<RaftClientReply, IOException>)((CheckedSupplier)() -> this.server.submitClientRequest(request)));
    }

    private RaftClientReply writeRemotelyWithRetry(RatisClient client, Message message) throws IOException {
        return this.writeWithRetry((CheckedSupplier<RaftClientReply, IOException>)((CheckedSupplier)() -> client.getRaftClient().io().send(message)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConsensusWriteResponse write(ConsensusGroupId consensusGroupId, IConsensusRequest IConsensusRequest2) {
        TSStatus writeResult;
        RaftGroupId raftGroupId = Utils.fromConsensusGroupIdToRaftGroupId(consensusGroupId);
        RaftGroup raftGroup = this.getGroupInfo(raftGroupId);
        if (raftGroup == null || !raftGroup.getPeers().contains(this.myself)) {
            return this.failedWrite(new ConsensusGroupNotExistException(consensusGroupId));
        }
        if (this.isLeader(consensusGroupId) && CommonDescriptor.getInstance().getConfig().isReadOnly()) {
            try {
                this.forceStepDownLeader(raftGroup);
            }
            catch (Exception e) {
                this.logger.warn("leader {} read only, force step down failed due to {}", (Object)this.myself, (Object)e);
            }
            return this.failedWrite(new NodeReadOnlyException(this.myself));
        }
        RequestMessage message = new RequestMessage(IConsensusRequest2);
        RaftClientRequest clientRequest = this.buildRawRequest(raftGroupId, message, RaftClientRequest.writeRequestType());
        long writeToRatisStartTime = System.nanoTime();
        RaftPeer suggestedLeader = null;
        if (this.isLeader(consensusGroupId) && this.waitUntilLeaderReady(raftGroupId)) {
            try {
                RaftClientReply localServerReply = this.writeLocallyWithRetry(clientRequest);
                if (localServerReply.isSuccess()) {
                    ResponseMessage responseMessage = (ResponseMessage)localServerReply.getMessage();
                    TSStatus writeStatus = (TSStatus)responseMessage.getContentHolder();
                    ConsensusWriteResponse consensusWriteResponse = ConsensusWriteResponse.newBuilder().setStatus(writeStatus).build();
                    return consensusWriteResponse;
                }
                NotLeaderException ex = localServerReply.getNotLeaderException();
                if (ex != null) {
                    suggestedLeader = ex.getSuggestedLeader();
                }
            }
            catch (IOException e) {
                ConsensusWriteResponse writeStatus = this.failedWrite(new RatisRequestFailedException(e));
                return writeStatus;
            }
            finally {
                if (this.consensusGroupType == null) {
                    this.consensusGroupType = Utils.getConsensusGroupTypeFromPrefix(raftGroupId.toString());
                }
                RatisMetricsManager.getInstance().recordWriteLocallyCost(System.nanoTime() - writeToRatisStartTime, this.consensusGroupType);
            }
        }
        RatisClient client = null;
        try {
            client = this.getRaftClient(raftGroup);
            RaftClientReply reply = this.writeRemotelyWithRetry(client, message);
            if (!reply.isSuccess()) {
                ConsensusWriteResponse consensusWriteResponse = this.failedWrite(new RatisRequestFailedException((Exception)reply.getException()));
                return consensusWriteResponse;
            }
            writeResult = Utils.deserializeFrom(reply.getMessage().getContent().asReadOnlyByteBuffer());
        }
        catch (Exception e) {
            ConsensusWriteResponse consensusWriteResponse = this.failedWrite(new RatisRequestFailedException(e));
            return consensusWriteResponse;
        }
        finally {
            if (client != null) {
                client.returnSelf();
            }
            if (this.consensusGroupType == null) {
                this.consensusGroupType = Utils.getConsensusGroupTypeFromPrefix(raftGroupId.toString());
            }
            RatisMetricsManager.getInstance().recordWriteRemotelyCost(System.nanoTime() - writeToRatisStartTime, this.consensusGroupType);
        }
        if (suggestedLeader != null) {
            TEndPoint leaderEndPoint = Utils.fromRaftPeerAddressToTEndPoint(suggestedLeader.getAddress());
            writeResult.setRedirectNode(new TEndPoint(leaderEndPoint.getIp(), leaderEndPoint.getPort()));
        }
        return ConsensusWriteResponse.newBuilder().setStatus(writeResult).build();
    }

    @Override
    public ConsensusReadResponse read(ConsensusGroupId consensusGroupId, IConsensusRequest IConsensusRequest2) {
        RaftClientReply reply;
        RaftGroupId groupId = Utils.fromConsensusGroupIdToRaftGroupId(consensusGroupId);
        RaftGroup group = this.getGroupInfo(groupId);
        if (group == null || !group.getPeers().contains(this.myself)) {
            return this.failedRead(new ConsensusGroupNotExistException(consensusGroupId));
        }
        try {
            RequestMessage message = new RequestMessage(IConsensusRequest2);
            RaftClientRequest clientRequest = this.buildRawRequest(groupId, message, RaftClientRequest.staleReadRequestType((long)-1L));
            long readRatisStartTime = System.nanoTime();
            reply = this.server.submitClientRequest(clientRequest);
            if (this.consensusGroupType == null) {
                this.consensusGroupType = Utils.getConsensusGroupTypeFromPrefix(groupId.toString());
            }
            RatisMetricsManager.getInstance().recordReadRequestCost(System.nanoTime() - readRatisStartTime, this.consensusGroupType);
            if (!reply.isSuccess()) {
                return this.failedRead(new RatisRequestFailedException((Exception)reply.getException()));
            }
        }
        catch (IOException e) {
            return this.failedRead(new RatisRequestFailedException(e));
        }
        Message ret = reply.getMessage();
        ResponseMessage readResponseMessage = (ResponseMessage)ret;
        DataSet dataSet = (DataSet)readResponseMessage.getContentHolder();
        return ConsensusReadResponse.newBuilder().setDataSet(dataSet).build();
    }

    @Override
    public ConsensusGenericResponse createPeer(ConsensusGroupId groupId, List<Peer> peers) {
        RaftGroup group = this.buildRaftGroup(groupId, peers);
        return this.addNewGroupToServer(group, this.myself);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConsensusGenericResponse addNewGroupToServer(RaftGroup group, RaftPeer server) {
        RaftClientReply reply;
        RatisClient client = null;
        try {
            client = group.getPeers().isEmpty() ? this.getRaftClient(RaftGroup.valueOf((RaftGroupId)group.getGroupId(), (RaftPeer[])new RaftPeer[]{server})) : this.getRaftClient(group);
            reply = client.getRaftClient().getGroupManagementApi(server.getId()).add(group);
            if (!reply.isSuccess()) {
                ConsensusGenericResponse consensusGenericResponse = this.failed(new RatisRequestFailedException((Exception)reply.getException()));
                return consensusGenericResponse;
            }
        }
        catch (Exception e) {
            ConsensusGenericResponse consensusGenericResponse = this.failed(new RatisRequestFailedException(e));
            return consensusGenericResponse;
        }
        finally {
            if (client != null) {
                client.returnSelf();
            }
        }
        return ConsensusGenericResponse.newBuilder().setSuccess(reply.isSuccess()).build();
    }

    @Override
    public ConsensusGenericResponse deletePeer(ConsensusGroupId groupId) {
        RaftClientReply reply;
        RaftGroupId raftGroupId = Utils.fromConsensusGroupIdToRaftGroupId(groupId);
        try {
            reply = this.server.groupManagement(GroupManagementRequest.newRemove((ClientId)this.localFakeId, (RaftPeerId)this.myself.getId(), (long)this.localFakeCallId.incrementAndGet(), (RaftGroupId)raftGroupId, (boolean)true, (boolean)false));
            if (!reply.isSuccess()) {
                return this.failed(new RatisRequestFailedException((Exception)reply.getException()));
            }
        }
        catch (IOException e) {
            return this.failed(new RatisRequestFailedException(e));
        }
        return ConsensusGenericResponse.newBuilder().setSuccess(reply.isSuccess()).build();
    }

    @Override
    public ConsensusGenericResponse addPeer(ConsensusGroupId groupId, Peer peer) {
        RaftClientReply reply;
        RaftGroupId raftGroupId = Utils.fromConsensusGroupIdToRaftGroupId(groupId);
        RaftGroup group = this.getGroupInfo(raftGroupId);
        RaftPeer peerToAdd = Utils.fromPeerAndPriorityToRaftPeer(peer, 0);
        if (group == null || !group.getPeers().contains(this.myself)) {
            return this.failed(new ConsensusGroupNotExistException(groupId));
        }
        if (group.getPeers().contains(peerToAdd)) {
            return this.failed(new PeerAlreadyInConsensusGroupException(groupId, peer));
        }
        ArrayList<RaftPeer> newConfig = new ArrayList<RaftPeer>(group.getPeers());
        newConfig.add(peerToAdd);
        try {
            reply = this.sendReconfiguration(RaftGroup.valueOf((RaftGroupId)raftGroupId, newConfig));
        }
        catch (RatisRequestFailedException e) {
            return this.failed(e);
        }
        return ConsensusGenericResponse.newBuilder().setSuccess(reply.isSuccess()).build();
    }

    @Override
    public ConsensusGenericResponse removePeer(ConsensusGroupId groupId, Peer peer) {
        RaftClientReply reply;
        RaftGroupId raftGroupId = Utils.fromConsensusGroupIdToRaftGroupId(groupId);
        RaftGroup group = this.getGroupInfo(raftGroupId);
        RaftPeer peerToRemove = Utils.fromPeerAndPriorityToRaftPeer(peer, 0);
        if (group == null || !group.getPeers().contains(this.myself)) {
            return this.failed(new ConsensusGroupNotExistException(groupId));
        }
        if (!group.getPeers().contains(peerToRemove)) {
            return this.failed(new PeerNotInConsensusGroupException(groupId, this.myself));
        }
        List newConfig = group.getPeers().stream().filter(raftPeer -> !raftPeer.equals((Object)peerToRemove)).collect(Collectors.toList());
        try {
            reply = this.sendReconfiguration(RaftGroup.valueOf((RaftGroupId)raftGroupId, newConfig));
        }
        catch (RatisRequestFailedException e) {
            return this.failed(e);
        }
        return ConsensusGenericResponse.newBuilder().setSuccess(reply.isSuccess()).build();
    }

    @Override
    public ConsensusGenericResponse updatePeer(ConsensusGroupId groupId, Peer oldPeer, Peer newPeer) {
        return ConsensusGenericResponse.newBuilder().setSuccess(false).build();
    }

    @Override
    public ConsensusGenericResponse changePeer(ConsensusGroupId groupId, List<Peer> newPeers) {
        RaftClientReply reply;
        RaftGroup raftGroup = this.buildRaftGroup(groupId, newPeers);
        if (!raftGroup.getPeers().contains(this.myself)) {
            return this.failed(new ConsensusGroupNotExistException(groupId));
        }
        try {
            reply = this.sendReconfiguration(raftGroup);
        }
        catch (RatisRequestFailedException e) {
            return this.failed(e);
        }
        return ConsensusGenericResponse.newBuilder().setSuccess(reply.isSuccess()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConsensusGenericResponse transferLeader(ConsensusGroupId groupId, Peer newLeader) {
        RaftClientReply reply;
        RaftGroupId raftGroupId = Utils.fromConsensusGroupIdToRaftGroupId(groupId);
        RaftGroup raftGroup = this.getGroupInfo(raftGroupId);
        if (raftGroup == null) {
            return this.failed(new ConsensusGroupNotExistException(groupId));
        }
        RaftPeer newRaftLeader = Utils.fromPeerAndPriorityToRaftPeer(newLeader, 1);
        ArrayList<RaftPeer> newConfiguration = new ArrayList<RaftPeer>();
        for (RaftPeer raftPeer : raftGroup.getPeers()) {
            if (raftPeer.getId().equals((Object)newRaftLeader.getId())) {
                newConfiguration.add(newRaftLeader);
                continue;
            }
            newConfiguration.add(Utils.fromNodeInfoAndPriorityToRaftPeer(Utils.fromRaftPeerIdToNodeId(raftPeer.getId()), Utils.fromRaftPeerAddressToTEndPoint(raftPeer.getAddress()), 0));
        }
        RatisClient client = null;
        try {
            client = this.getRaftClient(raftGroup);
            RaftClientReply configChangeReply = client.getRaftClient().admin().setConfiguration(newConfiguration);
            if (!configChangeReply.isSuccess()) {
                ConsensusGenericResponse consensusGenericResponse = this.failed(new RatisRequestFailedException((Exception)configChangeReply.getException()));
                return consensusGenericResponse;
            }
            reply = this.transferLeader(raftGroup, newRaftLeader);
            if (!reply.isSuccess()) {
                ConsensusGenericResponse consensusGenericResponse = this.failed(new RatisRequestFailedException((Exception)reply.getException()));
                return consensusGenericResponse;
            }
        }
        catch (Exception e) {
            ConsensusGenericResponse consensusGenericResponse = this.failed(new RatisRequestFailedException(e));
            return consensusGenericResponse;
        }
        finally {
            if (client != null) {
                client.returnSelf();
            }
        }
        return ConsensusGenericResponse.newBuilder().setSuccess(reply.isSuccess()).build();
    }

    private void forceStepDownLeader(RaftGroup group) throws ClientManagerException, IOException {
        this.transferLeader(group, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RaftClientReply transferLeader(RaftGroup group, RaftPeer newLeader) throws ClientManagerException, IOException {
        RatisClient client = null;
        try {
            client = this.getRaftClient(group);
            RaftClientReply raftClientReply = client.getRaftClient().admin().transferLeadership(newLeader != null ? newLeader.getId() : null, 10000L);
            return raftClientReply;
        }
        finally {
            if (client != null) {
                client.returnSelf();
            }
        }
    }

    @Override
    public boolean isLeader(ConsensusGroupId groupId) {
        boolean isLeader;
        RaftGroupId raftGroupId = Utils.fromConsensusGroupIdToRaftGroupId(groupId);
        try {
            isLeader = this.server.getDivision(raftGroupId).getInfo().isLeader();
        }
        catch (IOException exception) {
            this.logger.info("isLeader request failed with exception: ", (Throwable)exception);
            isLeader = false;
        }
        return isLeader;
    }

    private boolean waitUntilLeaderReady(RaftGroupId groupId) {
        DivisionInfo divisionInfo;
        try {
            divisionInfo = this.server.getDivision(groupId).getInfo();
        }
        catch (IOException e) {
            this.logger.info("isLeaderReady checking failed with exception: ", (Throwable)e);
            return false;
        }
        long startTime = System.currentTimeMillis();
        try {
            while (divisionInfo.isLeader() && !divisionInfo.isLeaderReady()) {
                Thread.sleep(10L);
                long consumedTime = System.currentTimeMillis() - startTime;
                if (consumedTime < (long)DEFAULT_WAIT_LEADER_READY_TIMEOUT) continue;
                this.logger.warn("{}: leader is still not ready after {}ms", (Object)groupId, (Object)consumedTime);
                return false;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.warn("Unexpected interruption", (Throwable)e);
            return false;
        }
        return divisionInfo.isLeader();
    }

    @Override
    public Peer getLeader(ConsensusGroupId groupId) {
        RaftPeerId leaderId;
        RaftGroupId raftGroupId = Utils.fromConsensusGroupIdToRaftGroupId(groupId);
        try {
            leaderId = this.server.getDivision(raftGroupId).getInfo().getLeaderId();
        }
        catch (IOException e) {
            this.logger.warn("fetch division info for group " + groupId + " failed due to: ", (Throwable)e);
            return null;
        }
        if (leaderId == null) {
            return null;
        }
        int nodeId = Utils.fromRaftPeerIdToNodeId(leaderId);
        return new Peer(groupId, nodeId, null);
    }

    @Override
    public List<ConsensusGroupId> getAllConsensusGroupIds() {
        ArrayList<ConsensusGroupId> ids = new ArrayList<ConsensusGroupId>();
        this.server.getGroupIds().forEach(groupId -> ids.add(Utils.fromRaftGroupIdToConsensusGroupId(groupId)));
        return ids;
    }

    @Override
    public ConsensusGenericResponse triggerSnapshot(ConsensusGroupId groupId) {
        RaftClientReply reply;
        RaftGroupId raftGroupId = Utils.fromConsensusGroupIdToRaftGroupId(groupId);
        RaftGroup groupInfo = this.getGroupInfo(raftGroupId);
        if (groupInfo == null || !groupInfo.getPeers().contains(this.myself)) {
            return this.failed(new ConsensusGroupNotExistException(groupId));
        }
        SnapshotManagementRequest request = SnapshotManagementRequest.newCreate((ClientId)this.localFakeId, (RaftPeerId)this.myself.getId(), (RaftGroupId)raftGroupId, (long)this.localFakeCallId.incrementAndGet(), (long)30000L);
        try {
            reply = this.server.snapshotManagement(request);
            if (!reply.isSuccess()) {
                return this.failed(new RatisRequestFailedException((Exception)reply.getException()));
            }
        }
        catch (IOException ioException) {
            return this.failed(new RatisRequestFailedException(ioException));
        }
        return ConsensusGenericResponse.newBuilder().setSuccess(reply.isSuccess()).build();
    }

    private void triggerSnapshotByCustomize() {
        for (RaftGroupId raftGroupId : this.server.getGroupIds()) {
            long triggerSnapshotFileSize;
            File currentDir;
            try {
                currentDir = this.server.getDivision(raftGroupId).getRaftStorage().getStorageDir().getCurrentDir();
            }
            catch (IOException e) {
                this.logger.warn("{}: get division {} failed: ", new Object[]{this, raftGroupId, e});
                continue;
            }
            long currentDirLength = this.calcMap.computeIfAbsent(currentDir, Utils.MemorizedFileSizeCalc::new).getTotalFolderSize();
            if (currentDirLength < (triggerSnapshotFileSize = this.config.getImpl().getTriggerSnapshotFileSize())) continue;
            ConsensusGenericResponse consensusGenericResponse = this.triggerSnapshot(Utils.fromRaftGroupIdToConsensusGroupId(raftGroupId));
            if (consensusGenericResponse.isSuccess()) {
                this.logger.info("Raft group {} took snapshot successfully", (Object)raftGroupId);
                continue;
            }
            this.logger.warn("Raft group {} failed to take snapshot due to {}", (Object)raftGroupId, (Object)consensusGenericResponse.getException());
        }
    }

    private void startSnapshotGuardian() {
        long delay = this.config.getImpl().getTriggerSnapshotTime();
        ScheduledExecutorUtil.safelyScheduleWithFixedDelay((ScheduledExecutorService)this.diskGuardian, this::triggerSnapshotByCustomize, (long)0L, (long)delay, (TimeUnit)TimeUnit.SECONDS);
    }

    private ConsensusGenericResponse failed(ConsensusException e) {
        this.logger.debug("{} request failed with exception {}", (Object)this, (Object)e);
        return ConsensusGenericResponse.newBuilder().setSuccess(false).setException(e).build();
    }

    private ConsensusWriteResponse failedWrite(ConsensusException e) {
        this.logger.debug("{} write request failed with exception {}", (Object)this, (Object)e);
        return ConsensusWriteResponse.newBuilder().setException(e).build();
    }

    private ConsensusReadResponse failedRead(ConsensusException e) {
        this.logger.debug("{} read request failed with exception {}", (Object)this, (Object)e);
        return ConsensusReadResponse.newBuilder().setException(e).build();
    }

    private RaftClientRequest buildRawRequest(RaftGroupId groupId, Message message, RaftClientRequest.Type type) {
        return RaftClientRequest.newBuilder().setServerId(this.server.getId()).setClientId(this.localFakeId).setCallId(this.localFakeCallId.incrementAndGet()).setGroupId(groupId).setType(type).setMessage(message).build();
    }

    private RaftGroup getGroupInfo(RaftGroupId raftGroupId) {
        RaftGroup raftGroup = null;
        try {
            raftGroup = this.server.getDivision(raftGroupId).getGroup();
            RaftGroup lastSeenGroup = this.lastSeen.getOrDefault(raftGroupId, null);
            if (lastSeenGroup != null && !lastSeenGroup.equals((Object)raftGroup)) {
                this.clientManager.clear((Object)lastSeenGroup);
                this.lastSeen.put(raftGroupId, raftGroup);
            }
        }
        catch (IOException e) {
            this.logger.debug("get group {} failed ", (Object)raftGroupId, (Object)e);
        }
        return raftGroup;
    }

    private RaftGroup buildRaftGroup(ConsensusGroupId groupId, List<Peer> peers) {
        return RaftGroup.valueOf((RaftGroupId)Utils.fromConsensusGroupIdToRaftGroupId(groupId), Utils.fromPeersAndPriorityToRaftPeers(peers, 0));
    }

    private RatisClient getRaftClient(RaftGroup group) throws ClientManagerException {
        try {
            return (RatisClient)this.clientManager.borrowClient((Object)group);
        }
        catch (ClientManagerException e) {
            this.logger.error(String.format("Borrow client from pool for group %s failed.", group), (Throwable)e);
            throw e;
        }
    }

    private RaftClientReply sendReconfiguration(RaftGroup newGroupConf) throws RatisRequestFailedException {
        RaftClientReply reply;
        RatisClient client = null;
        try {
            client = this.getRaftClient(newGroupConf);
            reply = client.getRaftClient().admin().setConfiguration(new ArrayList(newGroupConf.getPeers()));
            if (!reply.isSuccess()) {
                throw new RatisRequestFailedException((Exception)reply.getException());
            }
        }
        catch (Exception e) {
            throw new RatisRequestFailedException(e);
        }
        finally {
            if (client != null) {
                client.returnSelf();
            }
        }
        return reply;
    }

    public RaftServer getServer() {
        return this.server;
    }

    private class RatisClientPoolFactory
    implements IClientPoolFactory<RaftGroup, RatisClient> {
        private RatisClientPoolFactory() {
        }

        public KeyedObjectPool<RaftGroup, RatisClient> createClientPool(ClientManager<RaftGroup, RatisClient> manager) {
            return new GenericKeyedObjectPool((KeyedPooledObjectFactory)new RatisClient.Factory(manager, RatisConsensus.this.properties, RatisConsensus.this.clientRpc, RatisConsensus.this.config.getClient()), new ClientPoolProperty.Builder().setCoreClientNumForEachNode(RatisConsensus.this.config.getClient().getCoreClientNumForEachNode()).setMaxClientNumForEachNode(RatisConsensus.this.config.getClient().getMaxClientNumForEachNode()).build().getConfig());
        }
    }
}

