/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.wal.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import org.apache.iotdb.db.wal.io.ILogWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LogWriter
implements ILogWriter {
    private static final Logger logger = LoggerFactory.getLogger(LogWriter.class);
    protected final File logFile;
    protected final FileOutputStream logStream;
    protected final FileChannel logChannel;
    protected long size;

    protected LogWriter(File logFile) throws FileNotFoundException {
        this.logFile = logFile;
        this.logStream = new FileOutputStream(logFile, true);
        this.logChannel = this.logStream.getChannel();
    }

    @Override
    public void write(ByteBuffer buffer) throws IOException {
        this.size += (long)buffer.position();
        buffer.flip();
        try {
            this.logChannel.write(buffer);
        }
        catch (ClosedChannelException e) {
            logger.warn("Cannot write to {}", (Object)this.logFile, (Object)e);
        }
    }

    @Override
    public void force() throws IOException {
        this.force(true);
    }

    @Override
    public void force(boolean metaData) throws IOException {
        if (this.logChannel != null && this.logChannel.isOpen()) {
            this.logChannel.force(metaData);
        }
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public File getLogFile() {
        return this.logFile;
    }

    @Override
    public void close() throws IOException {
        if (this.logChannel != null) {
            try {
                if (this.logChannel.isOpen()) {
                    this.logChannel.force(true);
                }
            }
            finally {
                this.logChannel.close();
                this.logStream.close();
            }
        }
    }
}

