/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.transport.server;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.sync.PipeDataLoadException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.sync.transport.SyncIdentityInfo;
import org.apache.iotdb.commons.sync.utils.SyncPathUtil;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.mpp.plan.Coordinator;
import org.apache.iotdb.db.mpp.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.mpp.plan.execution.ExecutionResult;
import org.apache.iotdb.db.mpp.plan.statement.metadata.DatabaseSchemaStatement;
import org.apache.iotdb.db.query.control.SessionManager;
import org.apache.iotdb.db.sync.pipedata.PipeData;
import org.apache.iotdb.db.sync.pipedata.TsFilePipeData;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TSyncIdentityInfo;
import org.apache.iotdb.service.rpc.thrift.TSyncTransportMetaInfo;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceiverManager {
    private static final Logger logger = LoggerFactory.getLogger(ReceiverManager.class);
    private final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final ThreadLocal<Long> currentConnectionId = new ThreadLocal();
    private final Map<Long, SyncIdentityInfo> connectionIdToIdentityInfoMap = new ConcurrentHashMap<Long, SyncIdentityInfo>();
    private final Map<Long, Map<String, Long>> connectionIdToStartIndexRecord = new ConcurrentHashMap<Long, Map<String, Long>>();
    private final Map<String, String> registeredDatabase = new ConcurrentHashMap<String, String>();
    private final AtomicLong connectionIdGenerator = new AtomicLong();

    private CheckResult checkStartIndexValid(File file, long startIndex) throws IOException {
        long localIndex = this.getCurrentFileStartIndex(file.getAbsolutePath());
        if (localIndex < 0L && file.exists()) {
            localIndex = file.length();
            this.recordStartIndex(file, localIndex);
        }
        if (localIndex < 0L && startIndex != 0L) {
            logger.error("The start index {} of data sync is not valid. The file is not exist and start index should equal to 0).", (Object)startIndex);
            return new CheckResult(false, "0");
        }
        if (localIndex >= 0L && localIndex != startIndex) {
            logger.error("The start index {} of data sync is not valid. The start index of the file should equal to {}.", (Object)startIndex, (Object)localIndex);
            return new CheckResult(false, String.valueOf(localIndex));
        }
        return new CheckResult(true, "0");
    }

    private void recordStartIndex(File file, long position) {
        Long id = this.currentConnectionId.get();
        if (id != null) {
            Map map = this.connectionIdToStartIndexRecord.computeIfAbsent(id, i -> new ConcurrentHashMap());
            map.put(file.getAbsolutePath(), position);
        }
    }

    public TSStatus handshake(TSyncIdentityInfo tIdentityInfo, String remoteAddress, IPartitionFetcher partitionFetcher, ISchemaFetcher schemaFetcher) {
        SyncIdentityInfo identityInfo = new SyncIdentityInfo(tIdentityInfo, remoteAddress);
        logger.info("Invoke handshake method from client ip = {}", (Object)identityInfo.getRemoteAddress());
        if (!this.verifyIPSegment(this.config.getIpWhiteList(), identityInfo.getRemoteAddress())) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPESERVER_ERROR, (String)String.format("permission is not allowed: the sender IP <%s>, the white list of receiver <%s>", identityInfo.getRemoteAddress(), this.config.getIpWhiteList()));
        }
        if (!this.config.getIoTDBMajorVersion(identityInfo.version).equals(this.config.getIoTDBMajorVersion())) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPESERVER_ERROR, (String)String.format("version mismatch: the sender <%s>, the receiver <%s>", identityInfo.version, this.config.getIoTDBVersion()));
        }
        if (!new File(SyncPathUtil.getFileDataDirPath((SyncIdentityInfo)identityInfo)).exists()) {
            new File(SyncPathUtil.getFileDataDirPath((SyncIdentityInfo)identityInfo)).mkdirs();
        }
        this.createConnection(identityInfo);
        if (!StringUtils.isEmpty((CharSequence)identityInfo.getDatabase()) && !this.registerDatabase(identityInfo.getDatabase(), partitionFetcher, schemaFetcher)) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPESERVER_ERROR, (String)String.format("Auto register database %s error.", identityInfo.getDatabase()));
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"");
    }

    private boolean verifyIPSegment(String ipWhiteList, String ipAddress) {
        String[] ipSegments;
        for (String IPsegment : ipSegments = ipWhiteList.split(",")) {
            int subnetMask = Integer.parseInt(IPsegment.substring(IPsegment.indexOf(47) + 1));
            if (!this.verifyIP(IPsegment = IPsegment.substring(0, IPsegment.indexOf(47)), ipAddress, subnetMask)) continue;
            return true;
        }
        return false;
    }

    private boolean verifyIP(String ipSegment, String ipAddress, int subnetMark) {
        String[] ipSplits = ipSegment.split("\\.");
        DecimalFormat df = new DecimalFormat("00000000");
        StringBuilder ipSegmentBuilder = new StringBuilder();
        for (String IPsplit : ipSplits) {
            ipSegmentBuilder.append(df.format(Integer.parseInt(Integer.toBinaryString(Integer.parseInt(IPsplit)))));
        }
        String ipSegmentBinary = ipSegmentBuilder.toString();
        ipSegmentBinary = ipSegmentBinary.substring(0, subnetMark);
        ipSplits = ipAddress.split("\\.");
        StringBuilder ipAddressBuilder = new StringBuilder();
        for (String IPsplit : ipSplits) {
            ipAddressBuilder.append(df.format(Integer.parseInt(Integer.toBinaryString(Integer.parseInt(IPsplit)))));
        }
        String ipAddressBinary = ipAddressBuilder.toString();
        ipAddressBinary = ipAddressBinary.substring(0, subnetMark);
        return ipAddressBinary.equals(ipSegmentBinary);
    }

    public TSStatus transportPipeData(ByteBuffer buff) throws TException {
        PipeData pipeData;
        SyncIdentityInfo identityInfo = this.getCurrentSyncIdentityInfo();
        if (identityInfo == null) {
            throw new TException("Thrift connection is not alive.");
        }
        logger.debug("Invoke transportPipeData method from client ip = {}", (Object)identityInfo.getRemoteAddress());
        String fileDir = SyncPathUtil.getFileDataDirPath((SyncIdentityInfo)identityInfo);
        try {
            int length = buff.capacity();
            byte[] byteArray = new byte[length];
            buff.get(byteArray);
            pipeData = PipeData.createPipeData(byteArray);
            if (pipeData instanceof TsFilePipeData) {
                TsFilePipeData tsFilePipeData = (TsFilePipeData)pipeData;
                tsFilePipeData.setDatabase(identityInfo.getDatabase());
                this.handleTsFilePipeData(tsFilePipeData, fileDir);
            }
        }
        catch (IOException | IllegalPathException e) {
            logger.error("Pipe data transport error, {}", (Object)e.getMessage());
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPESERVER_ERROR, (String)("Pipe data transport error, " + e.getMessage()));
        }
        logger.info("Start load pipeData with serialize number {} and type {},value={}", new Object[]{pipeData.getSerialNumber(), pipeData.getPipeDataType(), pipeData});
        try {
            pipeData.createLoader().load();
            logger.info("Load pipeData with serialize number {} successfully.", (Object)pipeData.getSerialNumber());
        }
        catch (PipeDataLoadException e) {
            logger.error("Fail to load pipeData because {}.", (Object)e.getMessage());
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPESERVER_ERROR, (String)("Fail to load pipeData because " + e.getMessage()));
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"");
    }

    public TSStatus transportFile(TSyncTransportMetaInfo metaInfo, ByteBuffer buff) throws TException {
        SyncIdentityInfo identityInfo = this.getCurrentSyncIdentityInfo();
        if (identityInfo == null) {
            throw new TException("Thrift connection is not alive.");
        }
        logger.debug("Invoke transportData method from client ip = {}", (Object)identityInfo.getRemoteAddress());
        String fileDir = SyncPathUtil.getFileDataDirPath((SyncIdentityInfo)identityInfo);
        String fileName = metaInfo.fileName;
        long startIndex = metaInfo.startIndex;
        File file = new File(fileDir, fileName + ".patch");
        try {
            CheckResult result = this.checkStartIndexValid(new File(fileDir, fileName), startIndex);
            if (!result.isResult()) {
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SYNC_FILE_REDIRECTION_ERROR, (String)result.getIndex());
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SYNC_FILE_ERROR, (String)e.getMessage());
        }
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");){
            int length = buff.capacity();
            randomAccessFile.seek(startIndex);
            byte[] byteArray = new byte[length];
            buff.get(byteArray);
            randomAccessFile.write(byteArray);
            this.recordStartIndex(new File(fileDir, fileName), startIndex + (long)length);
            logger.debug("Sync " + fileName + " start at " + startIndex + " to " + (startIndex + (long)length) + " is done.");
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SYNC_FILE_ERROR, (String)e.getMessage());
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"");
    }

    private void handleTsFilePipeData(TsFilePipeData tsFilePipeData, String fileDir) {
        File dir = new File(fileDir);
        String tsFileName = tsFilePipeData.getTsFileName();
        File[] targetFiles = dir.listFiles((dir1, name) -> name.startsWith(tsFileName) && name.endsWith(".patch"));
        if (targetFiles != null) {
            for (File targetFile : targetFiles) {
                File newFile = new File(dir, targetFile.getName().substring(0, targetFile.getName().length() - ".patch".length()));
                targetFile.renameTo(newFile);
            }
        }
        tsFilePipeData.setParentDirPath(dir.getAbsolutePath());
    }

    private boolean checkConnection() {
        return this.currentConnectionId.get() != null;
    }

    private SyncIdentityInfo getCurrentSyncIdentityInfo() {
        Long id = this.currentConnectionId.get();
        if (id != null) {
            return this.connectionIdToIdentityInfoMap.get(id);
        }
        return null;
    }

    private long getCurrentFileStartIndex(String absolutePath) {
        Map<String, Long> map;
        Long id = this.currentConnectionId.get();
        if (id != null && (map = this.connectionIdToStartIndexRecord.get(id)) != null && map.containsKey(absolutePath)) {
            return map.get(absolutePath);
        }
        return -1L;
    }

    private void createConnection(SyncIdentityInfo identityInfo) {
        long connectionId = this.connectionIdGenerator.incrementAndGet();
        this.currentConnectionId.set(connectionId);
        this.connectionIdToIdentityInfoMap.put(connectionId, identityInfo);
    }

    private boolean registerDatabase(String database, IPartitionFetcher partitionFetcher, ISchemaFetcher schemaFetcher) {
        if (this.registeredDatabase.containsKey(database)) {
            return true;
        }
        try {
            DatabaseSchemaStatement statement = new DatabaseSchemaStatement(DatabaseSchemaStatement.DatabaseSchemaStatementType.CREATE);
            statement.setStorageGroupPath(new PartialPath(database));
            long queryId = SessionManager.getInstance().requestQueryId();
            ExecutionResult result = Coordinator.getInstance().execute(statement, queryId, null, "", partitionFetcher, schemaFetcher, IoTDBDescriptor.getInstance().getConfig().getQueryTimeoutThreshold());
            if (result.status.code != TSStatusCode.SUCCESS_STATUS.getStatusCode() && result.status.code != TSStatusCode.DATABASE_ALREADY_EXISTS.getStatusCode()) {
                logger.error("Create Database error, statement: {}.", (Object)statement);
                logger.error("Create database result status : {}.", (Object)result.status);
                return false;
            }
        }
        catch (IllegalPathException e) {
            logger.error(String.format("Parse database PartialPath %s error", database), (Throwable)e);
            return false;
        }
        this.registeredDatabase.put(database, "");
        return true;
    }

    public void handleClientExit() {
        if (this.checkConnection()) {
            long id = this.currentConnectionId.get();
            this.connectionIdToIdentityInfoMap.remove(id);
            this.connectionIdToStartIndexRecord.remove(id);
            this.currentConnectionId.remove();
        }
    }

    public List<SyncIdentityInfo> getAllTSyncIdentityInfos() {
        return new ArrayList<SyncIdentityInfo>(this.connectionIdToIdentityInfoMap.values());
    }

    private class CheckResult {
        boolean result;
        String index;

        public CheckResult(boolean result, String index) {
            this.result = result;
            this.index = index;
        }

        public boolean isResult() {
            return this.result;
        }

        public String getIndex() {
            return this.index;
        }
    }
}

