/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.transport.client;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.commons.exception.sync.PipeException;
import org.apache.iotdb.commons.exception.sync.SyncConnectionException;
import org.apache.iotdb.commons.sync.pipe.PipeMessage;
import org.apache.iotdb.commons.sync.pipesink.PipeSink;
import org.apache.iotdb.commons.sync.utils.SyncConstant;
import org.apache.iotdb.db.sync.SyncService;
import org.apache.iotdb.db.sync.pipedata.PipeData;
import org.apache.iotdb.db.sync.sender.pipe.Pipe;
import org.apache.iotdb.db.sync.transport.client.ISyncClient;
import org.apache.iotdb.db.sync.transport.client.SyncClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SenderManager {
    private static final Logger logger = LoggerFactory.getLogger(SenderManager.class);
    private final Map<String, ISyncClient> clientMap;
    private final Map<String, Future<?>> transportFutureMap;
    private ScheduledFuture<?> heartbeatFuture;
    private final Pipe pipe;
    private final PipeSink pipeSink;
    private final BlockingQueue<Object> blockingQueue = new LinkedBlockingQueue<Object>();
    protected ExecutorService transportExecutorService;
    protected ScheduledExecutorService heartbeatExecutorService;
    protected long lastReportTime = 0L;
    protected long lostConnectionTime = Long.MAX_VALUE;
    private boolean isRunning;
    private boolean isError = false;

    public SenderManager(Pipe pipe, PipeSink pipeSink) {
        this.pipe = pipe;
        this.pipeSink = pipeSink;
        this.transportExecutorService = IoTDBThreadPoolFactory.newCachedThreadPool((String)(ThreadName.SYNC_SENDER_PIPE.getName() + "-" + pipe.getName()));
        this.heartbeatExecutorService = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)(ThreadName.SYNC_SENDER_HEARTBEAT.getName() + "-" + pipe.getName()));
        this.clientMap = new HashMap<String, ISyncClient>();
        this.transportFutureMap = new HashMap();
        this.isRunning = false;
    }

    public void checkConnection() {
        try (ISyncClient client = SyncClientFactory.createHeartbeatClient(this.pipe, this.pipeSink);){
            client.handshake();
        }
    }

    public void start() {
        this.blockingQueue.clear();
        this.lastReportTime = System.currentTimeMillis();
        this.lostConnectionTime = Long.MAX_VALUE;
        for (Map.Entry<String, ISyncClient> entry : this.clientMap.entrySet()) {
            String dataRegionId = entry.getKey();
            ISyncClient syncClient = entry.getValue();
            this.transportFutureMap.put(dataRegionId, this.transportExecutorService.submit(() -> this.takePipeDataAndTransport(syncClient, dataRegionId)));
        }
        this.heartbeatFuture = ScheduledExecutorUtil.safelyScheduleWithFixedDelay((ScheduledExecutorService)this.heartbeatExecutorService, this::heartbeat, (long)0L, (long)5000L, (TimeUnit)TimeUnit.MILLISECONDS);
        this.isRunning = true;
    }

    public void stop() {
        if (this.heartbeatFuture != null) {
            this.heartbeatFuture.cancel(true);
        }
        for (Future<?> future : this.transportFutureMap.values()) {
            future.cancel(true);
        }
        this.blockingQueue.clear();
        this.isRunning = false;
    }

    public void close() throws PipeException {
        try {
            this.transportExecutorService.shutdownNow();
            boolean isClosed = this.transportExecutorService.awaitTermination(SyncConstant.DEFAULT_WAITING_FOR_STOP_MILLISECONDS, TimeUnit.MILLISECONDS);
            this.heartbeatExecutorService.shutdownNow();
            if (!(isClosed &= this.heartbeatExecutorService.awaitTermination(SyncConstant.DEFAULT_WAITING_FOR_STOP_MILLISECONDS, TimeUnit.MILLISECONDS))) {
                throw new PipeException(String.format("Close SenderManager of Pipe %s error after %s %s, please try again.", this.pipe.getName(), SyncConstant.DEFAULT_WAITING_FOR_STOP_MILLISECONDS, TimeUnit.MILLISECONDS.name()));
            }
        }
        catch (InterruptedException e) {
            throw new PipeException(String.format("Interrupted when waiting for clear SenderManager of Pipe %s.", this.pipe.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void heartbeat() {
        try {
            Object object = this.blockingQueue.take();
            try (ISyncClient client = SyncClientFactory.createHeartbeatClient(this.pipe, this.pipeSink);){
                client.handshake();
                this.lostConnectionTime = Long.MAX_VALUE;
                logger.info("Reconnect to {} successfully.", (Object)this.pipeSink);
                Object object2 = object;
                synchronized (object2) {
                    object.notify();
                }
                while (!this.blockingQueue.isEmpty()) {
                    object2 = object = this.blockingQueue.take();
                    synchronized (object2) {
                        object.notify();
                    }
                }
                this.isError = false;
            }
        }
        catch (InterruptedException e) {
            logger.info("Interrupted by PIPE operation, exit heartbeat.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void takePipeDataAndTransport(ISyncClient syncClient, String dataRegionId) {
        try {
            Object lock;
            Object object = lock = new Object();
            synchronized (object) {
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        syncClient.handshake();
                        while (!Thread.currentThread().isInterrupted()) {
                            PipeData pipeData = this.pipe.take(dataRegionId);
                            if (!syncClient.send(pipeData)) {
                                logger.error("Can not transfer PipeData {}, skip it.", (Object)pipeData);
                                SyncService.getInstance().recordMessage(this.pipe.getName(), new PipeMessage(PipeMessage.PipeMessageType.WARN, String.format("Transfer PipeData %s error, skip it.", pipeData.getSerialNumber())));
                            }
                            this.pipe.commit(dataRegionId);
                        }
                    }
                    catch (SyncConnectionException e) {
                        logger.error("Connect to receiver {} error, because {}.", (Object)this.pipeSink, (Object)e.getMessage());
                        this.lostConnectionTime = Math.min(this.lostConnectionTime, System.currentTimeMillis());
                        this.blockingQueue.offer(lock);
                        lock.wait();
                    }
                }
            }
        }
        catch (InterruptedException e) {
            logger.info("Interrupted by PIPE operation, exit transport.");
        }
        finally {
            syncClient.close();
        }
    }

    public void registerDataRegion(String dataRegionId) {
        ISyncClient syncClient = SyncClientFactory.createSyncClient(this.pipe, this.pipeSink, dataRegionId);
        this.clientMap.put(dataRegionId, syncClient);
        if (this.isRunning) {
            this.transportFutureMap.put(dataRegionId, this.transportExecutorService.submit(() -> this.takePipeDataAndTransport(syncClient, dataRegionId)));
        }
    }

    public void unregisterDataRegion(String dataRegionId) {
        Future<?> future = this.transportFutureMap.remove(dataRegionId);
        if (future != null) {
            future.cancel(true);
            this.clientMap.remove(dataRegionId);
        }
    }

    public void setSyncClient(ISyncClient syncClient) {
    }
}

