/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.sender.recovery;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.iotdb.commons.sync.utils.SyncPathUtil;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.db.sync.sender.pipe.TsFilePipe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFilePipeLogger {
    private static final Logger logger = LoggerFactory.getLogger(TsFilePipeLogger.class);
    private final String pipeDir;
    private final String tsFileDir;

    public TsFilePipeLogger(TsFilePipe tsFilePipe) {
        this.pipeDir = SyncPathUtil.getSenderPipeDir((String)tsFilePipe.getName(), (long)tsFilePipe.getCreateTime());
        this.tsFileDir = SyncPathUtil.getSenderFileDataDir((String)tsFilePipe.getName(), (long)tsFilePipe.getCreateTime());
    }

    public boolean isHardlinkExist(File tsFile) {
        File link = new File(this.tsFileDir, this.getRelativeFilePath(tsFile));
        return link.exists();
    }

    public File createTsFileAndModsHardlink(File tsFile, long modsOffset) throws IOException {
        File mods = new File(tsFile.getPath() + ".mods");
        if (mods.exists()) {
            File modsHardLink = this.createHardLink(mods);
            if (modsOffset != 0L) {
                this.serializeModsOffset(new File(modsHardLink.getPath() + ".offset"), modsOffset);
            }
        } else if (modsOffset != 0L) {
            logger.warn(String.format("Can not find %s mods to create hard link. The mods offset is %d.", mods.getPath(), modsOffset));
        }
        this.createTsFileResourceHardlink(tsFile);
        return this.createTsFileHardlink(tsFile);
    }

    private void serializeModsOffset(File modsOffsetFile, long modsOffset) {
        try {
            SyncPathUtil.createFile((File)modsOffsetFile);
            try (BufferedWriter bw = new BufferedWriter(new FileWriter(modsOffsetFile));){
                bw.write(String.valueOf(modsOffset));
                bw.flush();
            }
        }
        catch (IOException e) {
            logger.warn(String.format("Serialize mods offset in %s error. The mods offset is %d", modsOffsetFile.getPath(), modsOffset));
        }
    }

    public File createTsFileHardlink(File tsFile) throws IOException {
        return this.createHardLink(tsFile);
    }

    public void createTsFileResourceHardlink(File tsFile) throws IOException {
        File tsFileResource = new File(tsFile.getPath() + ".resource");
        try {
            this.createHardLink(tsFileResource);
        }
        catch (IOException e) {
            logger.warn(String.format("Record tsfile resource %s on disk error, make a empty to close it.", tsFileResource.getPath()));
            SyncPathUtil.createFile((File)new File(this.tsFileDir, this.getRelativeFilePath(tsFileResource)));
        }
    }

    private File createHardLink(File file) throws IOException {
        File link = new File(this.tsFileDir, this.getRelativeFilePath(file));
        if (!link.getParentFile().exists()) {
            link.getParentFile().mkdirs();
        }
        Path sourcePath = FileSystems.getDefault().getPath(file.getAbsolutePath(), new String[0]);
        Path linkPath = FileSystems.getDefault().getPath(link.getAbsolutePath(), new String[0]);
        Files.createLink(linkPath, sourcePath);
        return link;
    }

    private String getRelativeFilePath(File file) {
        StringBuilder builder = new StringBuilder(file.getName());
        while (!file.getName().equals("sequence") && !file.getName().equals("unsequence")) {
            file = file.getParentFile();
            builder = new StringBuilder(file.getName()).append("-").append((CharSequence)builder);
        }
        return builder.toString();
    }

    public void finishCollect() {
        try {
            if (SyncPathUtil.createFile((File)new File(this.pipeDir, "finishCollect.lock"))) {
                logger.info("Create finish collecting Lock file in {}.", (Object)this.pipeDir);
            }
        }
        catch (IOException e) {
            logger.warn(String.format("Can not make lock file in %s, because %s", this.pipeDir, e));
        }
    }

    public boolean isCollectFinished() {
        return new File(this.pipeDir, "finishCollect.lock").exists();
    }

    public void clear() throws IOException {
        File pipeDir = new File(this.pipeDir);
        if (pipeDir.exists()) {
            FileUtils.deleteDirectory((File)pipeDir);
        }
    }
}

