/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.externalpipe.operation;

import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.sync.externalpipe.operation.Operation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteOperation
extends Operation {
    private static final Logger logger = LoggerFactory.getLogger(DeleteOperation.class);
    private PartialPath deletePath;
    private long startTime;
    private long endTime;

    public DeleteOperation(String storageGroup, long startIndex, long endIndex, PartialPath deletePath, long startTime, long endTime) {
        super(Operation.OperationType.DELETE, storageGroup, startIndex, endIndex);
        this.deletePath = deletePath;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public PartialPath getDeletePath() {
        return this.deletePath;
    }

    public String getDeletePathStr() {
        return this.deletePath.getFullPath();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    @Override
    public String toString() {
        return "DeleteOperation{" + super.toString() + ", deletePath=" + this.deletePath.getFullPath() + ", startTime=" + this.startTime + ", endTime=" + this.endTime + '}';
    }
}

