/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.metrics;

import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.service.metrics.recorder.CompactionMetricsManager;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class CompactionMetrics
implements IMetricSet {
    private final CompactionMetricsManager COMPACTION_METRICS_MANAGER = CompactionMetricsManager.getInstance();

    public void bindTo(AbstractMetricService metricService) {
        this.bindTaskInfo(metricService);
        this.bindPerformanceInfo(metricService);
    }

    public void unbindFrom(AbstractMetricService metricService) {
        this.unbindTaskInfo(metricService);
        this.unbindPerformanceInfo(metricService);
    }

    private void bindTaskInfo(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.QUEUE.toString(), MetricLevel.IMPORTANT, (Object)this.COMPACTION_METRICS_MANAGER, CompactionMetricsManager::getWaitingCrossCompactionTaskNum, new String[]{Tag.NAME.toString(), "compaction_cross", Tag.STATUS.toString(), "waiting"});
        metricService.createAutoGauge(Metric.QUEUE.toString(), MetricLevel.IMPORTANT, (Object)this.COMPACTION_METRICS_MANAGER, CompactionMetricsManager::getWaitingSeqInnerCompactionTaskNum, new String[]{Tag.NAME.toString(), "compaction_inner_seq", Tag.STATUS.toString(), "waiting"});
        metricService.createAutoGauge(Metric.QUEUE.toString(), MetricLevel.IMPORTANT, (Object)this.COMPACTION_METRICS_MANAGER, CompactionMetricsManager::getWaitingUnseqInnerCompactionTaskNum, new String[]{Tag.NAME.toString(), "compaction_inner_unseq", Tag.STATUS.toString(), "waiting"});
        metricService.createAutoGauge(Metric.QUEUE.toString(), MetricLevel.IMPORTANT, (Object)this.COMPACTION_METRICS_MANAGER, CompactionMetricsManager::getRunningCrossCompactionTaskNum, new String[]{Tag.NAME.toString(), "compaction_cross", Tag.STATUS.toString(), "running"});
        metricService.createAutoGauge(Metric.QUEUE.toString(), MetricLevel.IMPORTANT, (Object)this.COMPACTION_METRICS_MANAGER, CompactionMetricsManager::getRunningSeqInnerCompactionTaskNum, new String[]{Tag.NAME.toString(), "compaction_inner_seq", Tag.STATUS.toString(), "running"});
        metricService.createAutoGauge(Metric.QUEUE.toString(), MetricLevel.IMPORTANT, (Object)this.COMPACTION_METRICS_MANAGER, CompactionMetricsManager::getRunningUnseqInnerCompactionTaskNum, new String[]{Tag.NAME.toString(), "compaction_inner_unseq", Tag.STATUS.toString(), "running"});
        metricService.createAutoGauge(Metric.COMPACTION_TASK_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this.COMPACTION_METRICS_MANAGER, CompactionMetricsManager::getFinishSeqInnerCompactionTaskNum, new String[]{Tag.NAME.toString(), "inner_seq"});
        metricService.createAutoGauge(Metric.COMPACTION_TASK_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this.COMPACTION_METRICS_MANAGER, CompactionMetricsManager::getFinishUnseqInnerCompactionTaskNum, new String[]{Tag.NAME.toString(), "inner_unseq"});
        metricService.createAutoGauge(Metric.COMPACTION_TASK_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this.COMPACTION_METRICS_MANAGER, CompactionMetricsManager::getFinishCrossCompactionTaskNum, new String[]{Tag.NAME.toString(), "cross"});
        metricService.getOrCreateTimer(Metric.COST_TASK.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "inner_seq_compaction"});
        metricService.getOrCreateTimer(Metric.COST_TASK.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "inner_unseq_compaction"});
        metricService.getOrCreateTimer(Metric.COST_TASK.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "cross_compaction"});
    }

    private void unbindTaskInfo(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.QUEUE.toString(), new String[]{Tag.NAME.toString(), "compaction_cross", Tag.STATUS.toString(), "waiting"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.QUEUE.toString(), new String[]{Tag.NAME.toString(), "compaction_inner_seq", Tag.STATUS.toString(), "waiting"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.QUEUE.toString(), new String[]{Tag.NAME.toString(), "compaction_inner_unseq", Tag.STATUS.toString(), "waiting"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.QUEUE.toString(), new String[]{Tag.NAME.toString(), "compaction_cross", Tag.STATUS.toString(), "running"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.QUEUE.toString(), new String[]{Tag.NAME.toString(), "compaction_inner_seq", Tag.STATUS.toString(), "running"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.QUEUE.toString(), new String[]{Tag.NAME.toString(), "compaction_inner_unseq", Tag.STATUS.toString(), "running"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.COMPACTION_TASK_COUNT.toString(), new String[]{Tag.NAME.toString(), "inner_seq"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.COMPACTION_TASK_COUNT.toString(), new String[]{Tag.NAME.toString(), "inner_unseq"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.COMPACTION_TASK_COUNT.toString(), new String[]{Tag.NAME.toString(), "cross"});
        metricService.remove(MetricType.TIMER, Metric.COST_TASK.toString(), new String[]{Tag.NAME.toString(), "inner_seq_compaction"});
        metricService.remove(MetricType.TIMER, Metric.COST_TASK.toString(), new String[]{Tag.NAME.toString(), "inner_unseq_compaction"});
        metricService.remove(MetricType.TIMER, Metric.COST_TASK.toString(), new String[]{Tag.NAME.toString(), "cross_compaction"});
    }

    private void bindPerformanceInfo(AbstractMetricService metricService) {
        metricService.getOrCreateCounter("Compacted_Point_Num", MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "compaction"});
        metricService.getOrCreateCounter("Compacted_Chunk_Num", MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "compaction"});
        metricService.getOrCreateCounter("Directly_Flush_Chunk_Num", MetricLevel.NORMAL, new String[]{Tag.NAME.toString(), "compaction"});
        metricService.getOrCreateCounter("Deserialized_Chunk_Num", MetricLevel.NORMAL, new String[]{Tag.NAME.toString(), "compaction"});
        metricService.getOrCreateCounter("Merged_Chunk_Num", MetricLevel.NORMAL, new String[]{Tag.NAME.toString(), "compaction"});
    }

    private void unbindPerformanceInfo(AbstractMetricService metricService) {
        metricService.remove(MetricType.COUNTER, "Compacted_Point_Num", new String[]{Tag.NAME.toString(), "compaction"});
        metricService.remove(MetricType.COUNTER, "Compacted_Chunk_Num", new String[]{Tag.NAME.toString(), "compaction"});
        metricService.remove(MetricType.COUNTER, "Directly_Flush_Chunk_Num", new String[]{Tag.NAME.toString(), "compaction"});
        metricService.remove(MetricType.COUNTER, "Deserialized_Chunk_Num", new String[]{Tag.NAME.toString(), "compaction"});
        metricService.remove(MetricType.COUNTER, "Merged_Chunk_Num", new String[]{Tag.NAME.toString(), "compaction"});
    }
}

