/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.transformation.dag.udf;

import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.commons.udf.service.UDFClassLoaderManager;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.mpp.transformation.dag.udf.UDTFExecutor;
import org.apache.iotdb.db.service.TemporaryQueryDataFileService;

public class UDTFContext {
    protected final ZoneId zoneId;
    protected Map<String, UDTFExecutor> expressionName2Executor = new HashMap<String, UDTFExecutor>();

    public UDTFContext(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    public void constructUdfExecutors(Expression[] outputExpressions) {
        for (Expression expression : outputExpressions) {
            expression.constructUdfExecutors(this.expressionName2Executor, this.zoneId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalizeUDFExecutors(long queryId) {
        try {
            for (UDTFExecutor executor : this.expressionName2Executor.values()) {
                executor.beforeDestroy();
            }
        }
        finally {
            UDFClassLoaderManager.getInstance().finalizeUDFQuery(queryId);
            TemporaryQueryDataFileService.getInstance().deregister(queryId);
        }
    }

    public UDTFExecutor getExecutorByFunctionExpression(FunctionExpression functionExpression) {
        return this.expressionName2Executor.get(functionExpression.getExpressionString());
    }
}

