/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.scheduler;

import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.service.metric.enums.PerformanceOverviewMetrics;
import org.apache.iotdb.mpp.rpc.thrift.TSendPlanNodeResp;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.async.AsyncMethodCallback;

public class AsyncSendPlanNodeHandler
implements AsyncMethodCallback<TSendPlanNodeResp> {
    private final int instanceId;
    private final AtomicLong pendingNumber;
    private final Map<Integer, TSendPlanNodeResp> instanceId2RespMap;
    private final long sendTime;
    private static final PerformanceOverviewMetrics PERFORMANCE_OVERVIEW_METRICS = PerformanceOverviewMetrics.getInstance();

    public AsyncSendPlanNodeHandler(int instanceId, AtomicLong pendingNumber, Map<Integer, TSendPlanNodeResp> instanceId2RespMap, long sendTime) {
        this.instanceId = instanceId;
        this.pendingNumber = pendingNumber;
        this.instanceId2RespMap = instanceId2RespMap;
        this.sendTime = sendTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onComplete(TSendPlanNodeResp tSendPlanNodeResp) {
        this.instanceId2RespMap.put(this.instanceId, tSendPlanNodeResp);
        if (this.pendingNumber.decrementAndGet() == 0L) {
            PERFORMANCE_OVERVIEW_METRICS.recordScheduleRemoteCost(System.nanoTime() - this.sendTime);
            AtomicLong atomicLong = this.pendingNumber;
            synchronized (atomicLong) {
                this.pendingNumber.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Exception e) {
        TSendPlanNodeResp resp = new TSendPlanNodeResp();
        String errorMsg = String.format("Fail to send plan node, exception message: %s", e);
        resp.setAccepted(false);
        resp.setMessage(errorMsg);
        resp.setStatus(RpcUtils.getStatus((int)TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode(), (String)errorMsg));
        this.instanceId2RespMap.put(this.instanceId, resp);
        if (this.pendingNumber.decrementAndGet() == 0L) {
            PERFORMANCE_OVERVIEW_METRICS.recordScheduleRemoteCost(System.nanoTime() - this.sendTime);
            AtomicLong atomicLong = this.pendingNumber;
            synchronized (atomicLong) {
                this.pendingNumber.notifyAll();
            }
        }
    }
}

