/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.expression;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.mpp.common.NodeRef;
import org.apache.iotdb.db.mpp.plan.expression.ExpressionType;
import org.apache.iotdb.db.mpp.plan.expression.binary.AdditionExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.DivisionExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.EqualToExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.GreaterEqualExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.GreaterThanExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.LessEqualExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.LessThanExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.LogicAndExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.LogicOrExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.ModuloExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.MultiplicationExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.NonEqualExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.SubtractionExpression;
import org.apache.iotdb.db.mpp.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.NullOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimestampOperand;
import org.apache.iotdb.db.mpp.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.mpp.plan.expression.ternary.BetweenExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.InExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.IsNullExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.LikeExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.LogicNotExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.NegationExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.RegularExpression;
import org.apache.iotdb.db.mpp.plan.expression.visitor.ExpressionVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.mpp.plan.statement.StatementNode;
import org.apache.iotdb.db.mpp.transformation.dag.memory.LayerMemoryAssigner;
import org.apache.iotdb.db.mpp.transformation.dag.udf.UDTFExecutor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public abstract class Expression
extends StatementNode {
    protected Boolean isConstantOperandCache = null;
    protected Integer inputColumnIndex = null;
    private String expressionStringCache;

    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitExpression(this, context);
    }

    public abstract ExpressionType getExpressionType();

    public boolean isBuiltInAggregationFunctionExpression() {
        return false;
    }

    public boolean isCompareBinaryExpression() {
        return false;
    }

    public abstract boolean isMappable(Map<NodeRef<Expression>, TSDataType> var1);

    public final boolean isConstantOperand() {
        if (this.isConstantOperandCache == null) {
            this.isConstantOperandCache = this.isConstantOperandInternal();
        }
        return this.isConstantOperandCache;
    }

    protected abstract boolean isConstantOperandInternal();

    public abstract void constructUdfExecutors(Map<String, UDTFExecutor> var1, ZoneId var2);

    public abstract void bindInputLayerColumnIndexWithExpression(Map<String, List<InputLocation>> var1);

    public Integer getInputColumnIndex() {
        return this.inputColumnIndex;
    }

    public abstract void updateStatisticsForMemoryAssigner(LayerMemoryAssigner var1);

    public final String toString() {
        return this.getExpressionString();
    }

    public final String getExpressionString() {
        if (this.expressionStringCache == null) {
            this.expressionStringCache = this.getExpressionStringInternal();
        }
        return this.expressionStringCache;
    }

    protected abstract String getExpressionStringInternal();

    public final int hashCode() {
        return this.getExpressionString().hashCode();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Expression)) {
            return false;
        }
        return this.getExpressionString().equals(((Expression)o).getExpressionString());
    }

    public static void serialize(Expression expression, ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((short)expression.getExpressionType().getExpressionTypeInShortEnum(), (ByteBuffer)byteBuffer);
        expression.serialize(byteBuffer);
        ReadWriteIOUtils.write((Boolean)(expression.inputColumnIndex != null ? 1 : 0), (ByteBuffer)byteBuffer);
        if (expression.inputColumnIndex != null) {
            ReadWriteIOUtils.write((int)expression.inputColumnIndex, (ByteBuffer)byteBuffer);
        }
    }

    public static void serialize(Expression expression, DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((short)expression.getExpressionType().getExpressionTypeInShortEnum(), (OutputStream)stream);
        expression.serialize(stream);
        ReadWriteIOUtils.write((Boolean)(expression.inputColumnIndex != null ? 1 : 0), (OutputStream)stream);
        if (expression.inputColumnIndex != null) {
            ReadWriteIOUtils.write((int)expression.inputColumnIndex, (OutputStream)stream);
        }
    }

    public static Expression deserialize(ByteBuffer byteBuffer) {
        Expression expression;
        short type = ReadWriteIOUtils.readShort((ByteBuffer)byteBuffer);
        switch (type) {
            case -4: {
                expression = new ConstantOperand(byteBuffer);
                break;
            }
            case -3: {
                expression = new TimestampOperand(byteBuffer);
                break;
            }
            case -2: {
                expression = new TimeSeriesOperand(byteBuffer);
                break;
            }
            case -1: {
                expression = new FunctionExpression(byteBuffer);
                break;
            }
            case 0: {
                expression = new NegationExpression(byteBuffer);
                break;
            }
            case 1: {
                expression = new LogicNotExpression(byteBuffer);
                break;
            }
            case 2: {
                expression = new MultiplicationExpression(byteBuffer);
                break;
            }
            case 3: {
                expression = new DivisionExpression(byteBuffer);
                break;
            }
            case 4: {
                expression = new ModuloExpression(byteBuffer);
                break;
            }
            case 5: {
                expression = new AdditionExpression(byteBuffer);
                break;
            }
            case 6: {
                expression = new SubtractionExpression(byteBuffer);
                break;
            }
            case 7: {
                expression = new EqualToExpression(byteBuffer);
                break;
            }
            case 8: {
                expression = new NonEqualExpression(byteBuffer);
                break;
            }
            case 9: {
                expression = new GreaterEqualExpression(byteBuffer);
                break;
            }
            case 10: {
                expression = new GreaterThanExpression(byteBuffer);
                break;
            }
            case 11: {
                expression = new LessEqualExpression(byteBuffer);
                break;
            }
            case 12: {
                expression = new LessThanExpression(byteBuffer);
                break;
            }
            case 13: {
                expression = new LikeExpression(byteBuffer);
                break;
            }
            case 14: {
                expression = new RegularExpression(byteBuffer);
                break;
            }
            case 15: {
                expression = new IsNullExpression(byteBuffer);
                break;
            }
            case 16: {
                expression = new BetweenExpression(byteBuffer);
                break;
            }
            case 17: {
                expression = new InExpression(byteBuffer);
                break;
            }
            case 18: {
                expression = new LogicAndExpression(byteBuffer);
                break;
            }
            case 19: {
                expression = new LogicOrExpression(byteBuffer);
                break;
            }
            case 20: {
                expression = new NullOperand();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid expression type: " + type);
            }
        }
        boolean hasInputColumnIndex = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        if (hasInputColumnIndex) {
            expression.inputColumnIndex = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        }
        return expression;
    }

    protected abstract void serialize(ByteBuffer var1);

    protected abstract void serialize(DataOutputStream var1) throws IOException;

    public abstract List<Expression> getExpressions();

    public final Iterator<Expression> iterator() {
        return new ExpressionIterator(this);
    }

    private static class ExpressionIterator
    implements Iterator<Expression> {
        private final Deque<Expression> queue = new LinkedList<Expression>();

        public ExpressionIterator(Expression expression) {
            this.queue.add(expression);
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public Expression next() {
            if (!this.hasNext()) {
                return null;
            }
            Expression current = this.queue.pop();
            if (current != null) {
                for (Expression subExp : current.getExpressions()) {
                    this.queue.push(subExp);
                }
            }
            return current;
        }
    }
}

