/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.metric;

import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.mpp.metric.DataExchangeCostMetricSet;
import org.apache.iotdb.db.mpp.metric.DataExchangeCountMetricSet;
import org.apache.iotdb.db.mpp.metric.QueryExecutionMetricSet;
import org.apache.iotdb.db.mpp.metric.SeriesScanCostMetricSet;
import org.apache.iotdb.metrics.utils.MetricInfo;
import org.apache.iotdb.metrics.utils.MetricLevel;

public class QueryMetricsManager {
    private final MetricService metricService = MetricService.getInstance();

    public void recordPlanCost(String stage, long costTimeInNanos) {
        this.metricService.timer(costTimeInNanos, TimeUnit.NANOSECONDS, Metric.QUERY_PLAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), stage});
    }

    public void recordOperatorExecutionCost(String operatorType, long costTimeInNanos) {
        this.metricService.timer(costTimeInNanos, TimeUnit.NANOSECONDS, Metric.OPERATOR_EXECUTION_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), operatorType});
    }

    public void recordOperatorExecutionCount(String operatorType, long count) {
        this.metricService.count(count, Metric.OPERATOR_EXECUTION_COUNT.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), operatorType});
    }

    public void recordSeriesScanCost(String stage, long costTimeInNanos) {
        MetricInfo metricInfo = SeriesScanCostMetricSet.metricInfoMap.get(stage);
        this.metricService.timer(costTimeInNanos, TimeUnit.NANOSECONDS, metricInfo.getName(), MetricLevel.IMPORTANT, metricInfo.getTagsInArray());
    }

    public void recordExecutionCost(String stage, long costTimeInNanos) {
        MetricInfo metricInfo = QueryExecutionMetricSet.metricInfoMap.get(stage);
        this.metricService.timer(costTimeInNanos, TimeUnit.NANOSECONDS, metricInfo.getName(), MetricLevel.IMPORTANT, metricInfo.getTagsInArray());
    }

    public void recordQueryResourceNum(String type, int count) {
        this.metricService.histogram((long)count, Metric.QUERY_RESOURCE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), type});
    }

    public void recordDataExchangeCost(String stage, long costTimeInNanos) {
        MetricInfo metricInfo = DataExchangeCostMetricSet.metricInfoMap.get(stage);
        this.metricService.timer(costTimeInNanos, TimeUnit.NANOSECONDS, metricInfo.getName(), MetricLevel.IMPORTANT, metricInfo.getTagsInArray());
    }

    public void recordDataBlockNum(String type, int num) {
        MetricInfo metricInfo = DataExchangeCountMetricSet.metricInfoMap.get(type);
        this.metricService.histogram((long)num, metricInfo.getName(), MetricLevel.IMPORTANT, metricInfo.getTagsInArray());
    }

    public void recordTaskQueueTime(String name, long queueTimeInNanos) {
        this.metricService.timer(queueTimeInNanos, TimeUnit.NANOSECONDS, Metric.DRIVER_SCHEDULER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), name});
    }

    public static QueryMetricsManager getInstance() {
        return QueryMetricsManagerHolder.INSTANCE;
    }

    private static class QueryMetricsManagerHolder {
        private static final QueryMetricsManager INSTANCE = new QueryMetricsManager();

        private QueryMetricsManagerHolder() {
        }
    }
}

