/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.schema.source;

import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.query.info.IDeviceSchemaInfo;
import org.apache.iotdb.db.metadata.query.info.INodeSchemaInfo;
import org.apache.iotdb.db.metadata.query.info.ITimeSeriesSchemaInfo;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.mpp.execution.operator.schema.source.DeviceSchemaSource;
import org.apache.iotdb.db.mpp.execution.operator.schema.source.ISchemaSource;
import org.apache.iotdb.db.mpp.execution.operator.schema.source.NodeSchemaSource;
import org.apache.iotdb.db.mpp.execution.operator.schema.source.PathsUsingTemplateSource;
import org.apache.iotdb.db.mpp.execution.operator.schema.source.TimeSeriesSchemaSource;

public class SchemaSourceFactory {
    private SchemaSourceFactory() {
    }

    public static ISchemaSource<ITimeSeriesSchemaInfo> getTimeSeriesSchemaSource(PartialPath pathPattern, boolean isPrefixMatch, String key, String value, boolean isContains, Map<Integer, Template> templateMap) {
        return new TimeSeriesSchemaSource(pathPattern, isPrefixMatch, 0L, 0L, key, value, isContains, templateMap);
    }

    public static ISchemaSource<ITimeSeriesSchemaInfo> getTimeSeriesSchemaSource(PartialPath pathPattern, boolean isPrefixMatch, long limit, long offset, String key, String value, boolean isContains, Map<Integer, Template> templateMap) {
        return new TimeSeriesSchemaSource(pathPattern, isPrefixMatch, limit, offset, key, value, isContains, templateMap);
    }

    public static ISchemaSource<IDeviceSchemaInfo> getDeviceSchemaSource(PartialPath pathPattern, boolean isPrefixPath) {
        return new DeviceSchemaSource(pathPattern, isPrefixPath, 0L, 0L, false);
    }

    public static ISchemaSource<IDeviceSchemaInfo> getDeviceSchemaSource(PartialPath pathPattern, boolean isPrefixPath, long limit, long offset, boolean hasSgCol) {
        return new DeviceSchemaSource(pathPattern, isPrefixPath, limit, offset, hasSgCol);
    }

    public static ISchemaSource<INodeSchemaInfo> getNodeSchemaSource(PartialPath pathPattern, int level) {
        return new NodeSchemaSource(pathPattern, level);
    }

    public static ISchemaSource<IDeviceSchemaInfo> getPathsUsingTemplateSource(List<PartialPath> pathPatternList, int templateId) {
        return new PathsUsingTemplateSource(pathPatternList, templateId);
    }
}

