/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.process;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.common.header.ColumnHeader;
import org.apache.iotdb.db.mpp.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.AbstractIntoOperator;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertMultiTabletsStatement;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumnBuilder;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.Pair;

public class DeviceViewIntoOperator
extends AbstractIntoOperator {
    private final Map<String, Map<PartialPath, Map<String, InputLocation>>> deviceToTargetPathSourceInputLocationMap;
    private final Map<String, Map<PartialPath, Map<String, TSDataType>>> deviceToTargetPathDataTypeMap;
    private final Map<String, Boolean> targetDeviceToAlignedMap;
    private final Map<String, List<Pair<String, PartialPath>>> deviceToSourceTargetPathPairListMap;
    private String currentDevice;
    private final TsBlockBuilder resultTsBlockBuilder;

    public DeviceViewIntoOperator(OperatorContext operatorContext, Operator child, List<TSDataType> inputColumnTypes, Map<String, Map<PartialPath, Map<String, InputLocation>>> deviceToTargetPathSourceInputLocationMap, Map<String, Map<PartialPath, Map<String, TSDataType>>> deviceToTargetPathDataTypeMap, Map<String, Boolean> targetDeviceToAlignedMap, Map<String, List<Pair<String, PartialPath>>> deviceToSourceTargetPathPairListMap, Map<String, InputLocation> sourceColumnToInputLocationMap, ExecutorService intoOperationExecutor, long maxStatementSize) {
        super(operatorContext, child, inputColumnTypes, sourceColumnToInputLocationMap, intoOperationExecutor, maxStatementSize);
        this.deviceToTargetPathSourceInputLocationMap = deviceToTargetPathSourceInputLocationMap;
        this.deviceToTargetPathDataTypeMap = deviceToTargetPathDataTypeMap;
        this.targetDeviceToAlignedMap = targetDeviceToAlignedMap;
        this.deviceToSourceTargetPathPairListMap = deviceToSourceTargetPathPairListMap;
        List outputDataTypes = ColumnHeaderConstant.selectIntoAlignByDeviceColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        this.resultTsBlockBuilder = new TsBlockBuilder(outputDataTypes);
    }

    @Override
    protected boolean processTsBlock(TsBlock inputTsBlock) {
        if (inputTsBlock == null || inputTsBlock.isEmpty()) {
            return true;
        }
        String device = String.valueOf(inputTsBlock.getValueColumns()[0].getBinary(0));
        if (!Objects.equals(device, this.currentDevice)) {
            InsertMultiTabletsStatement insertMultiTabletsStatement = this.constructInsertMultiTabletsStatement(false);
            this.updateResultTsBlock();
            this.insertTabletStatementGenerators = this.constructInsertTabletStatementGeneratorsByDevice(device);
            this.currentDevice = device;
            if (insertMultiTabletsStatement != null) {
                this.executeInsertMultiTabletsStatement(insertMultiTabletsStatement);
                this.cachedTsBlock = inputTsBlock;
                return false;
            }
        }
        int readIndex = 0;
        while (readIndex < inputTsBlock.getPositionCount()) {
            int lastReadIndex = readIndex;
            for (AbstractIntoOperator.InsertTabletStatementGenerator generator : this.insertTabletStatementGenerators) {
                lastReadIndex = Math.max(lastReadIndex, generator.processTsBlock(inputTsBlock, readIndex));
            }
            readIndex = lastReadIndex;
            if (!this.insertMultiTabletsInternally(true)) continue;
            this.cachedTsBlock = inputTsBlock.subTsBlock(readIndex);
            return false;
        }
        return true;
    }

    @Override
    protected TsBlock tryToReturnResultTsBlock() {
        InsertMultiTabletsStatement insertMultiTabletsStatement = this.constructInsertMultiTabletsStatement(false);
        this.updateResultTsBlock();
        this.currentDevice = null;
        if (insertMultiTabletsStatement != null) {
            this.executeInsertMultiTabletsStatement(insertMultiTabletsStatement);
            return null;
        }
        this.finished = true;
        return this.resultTsBlockBuilder.build();
    }

    private List<AbstractIntoOperator.InsertTabletStatementGenerator> constructInsertTabletStatementGeneratorsByDevice(String currentDevice) {
        Map<PartialPath, Map<String, InputLocation>> targetPathToSourceInputLocationMap = this.deviceToTargetPathSourceInputLocationMap.get(currentDevice);
        Map<PartialPath, Map<String, TSDataType>> targetPathToDataTypeMap = this.deviceToTargetPathDataTypeMap.get(currentDevice);
        return DeviceViewIntoOperator.constructInsertTabletStatementGenerators(targetPathToSourceInputLocationMap, targetPathToDataTypeMap, this.targetDeviceToAlignedMap, this.typeConvertors);
    }

    private void updateResultTsBlock() {
        if (this.currentDevice == null) {
            return;
        }
        TimeColumnBuilder timeColumnBuilder = this.resultTsBlockBuilder.getTimeColumnBuilder();
        ColumnBuilder[] columnBuilders = this.resultTsBlockBuilder.getValueColumnBuilders();
        for (Pair<String, PartialPath> sourceTargetPathPair : this.deviceToSourceTargetPathPairListMap.get(this.currentDevice)) {
            timeColumnBuilder.writeLong(0L);
            columnBuilders[0].writeBinary(new Binary(this.currentDevice));
            columnBuilders[1].writeBinary(new Binary((String)sourceTargetPathPair.left));
            columnBuilders[2].writeBinary(new Binary(((PartialPath)sourceTargetPathPair.right).toString()));
            columnBuilders[3].writeInt(this.findWritten(((PartialPath)sourceTargetPathPair.right).getDevice(), ((PartialPath)sourceTargetPathPair.right).getMeasurement()));
            this.resultTsBlockBuilder.declarePosition();
        }
    }
}

