/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.db.mpp.common.QueryId;
import org.apache.iotdb.db.mpp.execution.QueryState;
import org.apache.iotdb.db.mpp.execution.StateMachine;

public class QueryStateMachine {
    private final String name;
    private final StateMachine<QueryState> queryState;
    private Executor stateMachineExecutor;
    private Throwable failureException;
    private TSStatus failureStatus;

    public QueryStateMachine(QueryId queryId, ExecutorService executor) {
        this.name = String.format("QueryStateMachine[%s]", queryId);
        this.stateMachineExecutor = executor;
        this.queryState = new StateMachine<QueryState>(queryId.toString(), this.stateMachineExecutor, QueryState.QUEUED, QueryState.TERMINAL_INSTANCE_STATES);
    }

    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> stateChangeListener) {
        this.queryState.addStateChangeListener(stateChangeListener);
    }

    public ListenableFuture<QueryState> getStateChange(QueryState currentState) {
        return this.queryState.getStateChange(currentState);
    }

    private String getName() {
        return this.name;
    }

    public QueryState getState() {
        return this.queryState.get();
    }

    public void transitionToQueued() {
        this.queryState.set(QueryState.QUEUED);
    }

    public void transitionToPlanned() {
        this.queryState.set(QueryState.PLANNED);
    }

    public void transitionToDispatching() {
        this.queryState.set(QueryState.DISPATCHING);
    }

    public void transitionToPendingRetry(TSStatus failureStatus) {
        if (this.queryState.get().isDone()) {
            return;
        }
        this.failureStatus = failureStatus;
        this.queryState.set(QueryState.PENDING_RETRY);
    }

    public void transitionToRunning() {
        this.queryState.set(QueryState.RUNNING);
    }

    public void transitionToFinished() {
        if (this.queryState.get().isDone()) {
            return;
        }
        this.queryState.set(QueryState.FINISHED);
    }

    public void transitionToCanceled() {
        if (this.queryState.get().isDone()) {
            return;
        }
        this.queryState.set(QueryState.CANCELED);
    }

    public void transitionToCanceled(Throwable throwable, TSStatus failureStatus) {
        if (this.queryState.get().isDone()) {
            return;
        }
        this.failureException = throwable;
        this.failureStatus = failureStatus;
        this.queryState.set(QueryState.CANCELED);
    }

    public void transitionToAborted() {
        if (this.queryState.get().isDone()) {
            return;
        }
        this.queryState.set(QueryState.ABORTED);
    }

    public void transitionToFailed() {
        if (this.queryState.get().isDone()) {
            return;
        }
        this.queryState.set(QueryState.FAILED);
    }

    public void transitionToFailed(Throwable throwable) {
        if (this.queryState.get().isDone()) {
            return;
        }
        this.failureException = throwable;
        this.queryState.set(QueryState.FAILED);
    }

    public void transitionToFailed(TSStatus failureStatus) {
        if (this.queryState.get().isDone()) {
            return;
        }
        this.failureStatus = failureStatus;
        this.queryState.set(QueryState.FAILED);
    }

    public String getFailureMessage() {
        if (this.failureException != null) {
            return this.failureException.getMessage();
        }
        return "no detailed failure reason in QueryStateMachine";
    }

    public Throwable getFailureException() {
        if (this.failureException == null) {
            return new IoTDBException(this.getFailureStatus().getMessage(), this.getFailureStatus().code);
        }
        return this.failureException;
    }

    public TSStatus getFailureStatus() {
        return this.failureStatus;
    }
}

