/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.traverser;

import java.util.Iterator;
import java.util.Map;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.tree.AbstractTreeVisitor;
import org.apache.iotdb.commons.schema.tree.ITreeNode;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.iterator.IMNodeIterator;
import org.apache.iotdb.db.metadata.mnode.iterator.MNodeIterator;
import org.apache.iotdb.db.metadata.mtree.store.IMTreeStore;
import org.apache.iotdb.db.metadata.mtree.store.ReentrantReadOnlyCachedMTreeStore;
import org.apache.iotdb.db.metadata.template.Template;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Traverser<R>
extends AbstractTreeVisitor<IMNode, R> {
    private static final Logger logger = LoggerFactory.getLogger(Traverser.class);
    protected IMTreeStore store;
    protected IMNode startNode;
    protected String[] nodes;
    protected Map<Integer, Template> templateMap;
    protected boolean skipPreDeletedSchema = false;
    protected boolean isPrefixMatch = false;

    protected Traverser() {
    }

    protected Traverser(IMNode startNode, PartialPath path, IMTreeStore store, boolean isPrefixMatch) throws MetadataException {
        super((ITreeNode)startNode, path, isPrefixMatch);
        this.store = store.getWithReentrantReadLock();
        this.initStack();
        String[] nodes = path.getNodes();
        if (nodes.length == 0 || !nodes[0].equals("root")) {
            throw new IllegalPathException(path.getFullPath(), path.getFullPath() + " doesn't start with " + startNode.getName());
        }
        this.startNode = startNode;
        this.nodes = nodes;
    }

    public void traverse() throws MetadataException {
        while (this.hasNext()) {
            this.next();
        }
        if (!this.isSuccess()) {
            Throwable e = this.getFailure();
            logger.warn(e.getMessage(), e);
            throw new MetadataException(e.getMessage(), e);
        }
    }

    protected IMNode getChild(IMNode parent, String childName) throws MetadataException {
        Template template;
        IMNode child = null;
        if (parent.isAboveDatabase()) {
            child = parent.getChild(childName);
        } else if (!(this.templateMap == null || this.templateMap.isEmpty() || parent.getSchemaTemplateId() == -1 || this.skipPreDeletedSchema && parent.getAsEntityMNode().isPreDeactivateTemplate() || (template = this.templateMap.get(parent.getSchemaTemplateId())) == null)) {
            child = this.templateMap.get(parent.getSchemaTemplateId()).getDirectNode(childName);
        }
        if (child == null) {
            child = this.store.getChild(parent, childName);
        }
        return child;
    }

    protected void releaseNode(IMNode node) {
        if (!node.isAboveDatabase() && !node.isStorageGroup()) {
            this.store.unPin(node);
        }
    }

    protected Iterator<IMNode> getChildrenIterator(IMNode parent) throws MetadataException {
        if (parent.isAboveDatabase()) {
            return new MNodeIterator(parent.getChildren().values().iterator());
        }
        return this.store.getTraverserIterator(parent, this.templateMap, this.skipPreDeletedSchema);
    }

    protected void releaseNodeIterator(Iterator<IMNode> nodeIterator) {
        ((IMNodeIterator)nodeIterator).close();
    }

    public void close() {
        super.close();
        if (this.store instanceof ReentrantReadOnlyCachedMTreeStore) {
            ((ReentrantReadOnlyCachedMTreeStore)this.store).unlockRead();
        }
    }

    public void setTemplateMap(Map<Integer, Template> templateMap) {
        this.templateMap = templateMap;
    }

    public void setSkipPreDeletedSchema(boolean skipPreDeletedSchema) {
        this.skipPreDeletedSchema = skipPreDeletedSchema;
    }
}

