/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.metadata.AliasAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.AlignedTimeseriesException;
import org.apache.iotdb.db.exception.metadata.MNodeTypeMismatchException;
import org.apache.iotdb.db.exception.metadata.MeasurementAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.MeasurementInBlackListException;
import org.apache.iotdb.db.exception.metadata.PathAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.metadata.template.DifferentTemplateException;
import org.apache.iotdb.db.exception.metadata.template.TemplateImcompatibeException;
import org.apache.iotdb.db.exception.metadata.template.TemplateIsInUseException;
import org.apache.iotdb.db.metadata.MetadataConstant;
import org.apache.iotdb.db.metadata.mnode.IEntityMNode;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.IStorageGroupMNode;
import org.apache.iotdb.db.metadata.mnode.InternalMNode;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.iterator.IMNodeIterator;
import org.apache.iotdb.db.metadata.mtree.IMTreeBelowSG;
import org.apache.iotdb.db.metadata.mtree.store.IMTreeStore;
import org.apache.iotdb.db.metadata.mtree.store.MemMTreeStore;
import org.apache.iotdb.db.metadata.mtree.traverser.Traverser;
import org.apache.iotdb.db.metadata.mtree.traverser.TraverserWithLimitOffsetWrapper;
import org.apache.iotdb.db.metadata.mtree.traverser.collector.EntityCollector;
import org.apache.iotdb.db.metadata.mtree.traverser.collector.MNodeCollector;
import org.apache.iotdb.db.metadata.mtree.traverser.collector.MeasurementCollector;
import org.apache.iotdb.db.metadata.mtree.traverser.counter.EntityCounter;
import org.apache.iotdb.db.metadata.mtree.traverser.counter.MeasurementCounter;
import org.apache.iotdb.db.metadata.mtree.traverser.updater.EntityUpdater;
import org.apache.iotdb.db.metadata.mtree.traverser.updater.MeasurementUpdater;
import org.apache.iotdb.db.metadata.plan.schemaregion.read.IShowDevicesPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.read.IShowNodesPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.read.IShowTimeSeriesPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.result.ShowDevicesResult;
import org.apache.iotdb.db.metadata.plan.schemaregion.result.ShowNodesResult;
import org.apache.iotdb.db.metadata.query.info.IDeviceSchemaInfo;
import org.apache.iotdb.db.metadata.query.info.INodeSchemaInfo;
import org.apache.iotdb.db.metadata.query.info.ITimeSeriesSchemaInfo;
import org.apache.iotdb.db.metadata.query.reader.ISchemaReader;
import org.apache.iotdb.db.metadata.rescon.MemSchemaRegionStatistics;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.metadata.utils.MetaFormatUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class MTreeBelowSGMemoryImpl
implements IMTreeBelowSG {
    private final MemMTreeStore store;
    private volatile IStorageGroupMNode storageGroupMNode;
    private final IMNode rootNode;
    private final Function<IMeasurementMNode, Map<String, String>> tagGetter;
    private final int levelOfSG;
    private final MemSchemaRegionStatistics regionStatistics;

    public MTreeBelowSGMemoryImpl(PartialPath storageGroupPath, Function<IMeasurementMNode, Map<String, String>> tagGetter, MemSchemaRegionStatistics regionStatistics) {
        this.store = new MemMTreeStore(storageGroupPath, true, regionStatistics);
        this.regionStatistics = regionStatistics;
        this.storageGroupMNode = this.store.getRoot().getAsStorageGroupMNode();
        this.rootNode = this.store.generatePrefix(storageGroupPath);
        this.levelOfSG = storageGroupPath.getNodeLength() - 1;
        this.tagGetter = tagGetter;
    }

    private MTreeBelowSGMemoryImpl(PartialPath storageGroupPath, MemMTreeStore store, Function<IMeasurementMNode, Map<String, String>> tagGetter, MemSchemaRegionStatistics regionStatistics) {
        this.store = store;
        this.regionStatistics = regionStatistics;
        this.storageGroupMNode = store.getRoot().getAsStorageGroupMNode();
        this.rootNode = store.generatePrefix(storageGroupPath);
        this.levelOfSG = storageGroupPath.getNodeLength() - 1;
        this.tagGetter = tagGetter;
    }

    @Override
    public void clear() {
        this.store.clear();
        this.storageGroupMNode = null;
    }

    protected void replaceStorageGroupMNode(IStorageGroupMNode newMNode) {
        this.storageGroupMNode.getParent().replaceChild(this.storageGroupMNode.getName(), newMNode);
        this.storageGroupMNode = newMNode;
    }

    @Override
    public synchronized boolean createSnapshot(File snapshotDir) {
        return this.store.createSnapshot(snapshotDir);
    }

    public static MTreeBelowSGMemoryImpl loadFromSnapshot(File snapshotDir, String storageGroupFullPath, MemSchemaRegionStatistics regionStatistics, Consumer<IMeasurementMNode> measurementProcess, Consumer<IEntityMNode> deviceProcess, Function<IMeasurementMNode, Map<String, String>> tagGetter) throws IOException, IllegalPathException {
        return new MTreeBelowSGMemoryImpl(new PartialPath(storageGroupFullPath), MemMTreeStore.loadFromSnapshot(snapshotDir, measurementProcess, deviceProcess, regionStatistics), tagGetter, regionStatistics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMeasurementMNode createTimeseries(PartialPath path, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props, String alias) throws MetadataException {
        String[] nodeNames = path.getNodes();
        if (nodeNames.length <= 2) {
            throw new IllegalPathException(path.getFullPath());
        }
        MetaFormatUtils.checkTimeseries(path);
        PartialPath devicePath = path.getDevicePath();
        IMNode deviceParent = this.checkAndAutoCreateInternalPath(devicePath);
        MTreeBelowSGMemoryImpl mTreeBelowSGMemoryImpl = this;
        synchronized (mTreeBelowSGMemoryImpl) {
            IEntityMNode entityMNode;
            IMNode device = this.checkAndAutoCreateDeviceNode(devicePath.getTailNode(), deviceParent);
            MetaFormatUtils.checkTimeseriesProps(path.getFullPath(), props);
            String leafName = path.getMeasurement();
            if (alias != null && device.hasChild(alias)) {
                throw new AliasAlreadyExistException(path.getFullPath(), alias);
            }
            if (device.hasChild(leafName)) {
                IMNode node = device.getChild(leafName);
                if (node.isMeasurement()) {
                    if (node.getAsMeasurementMNode().isPreDeleted()) {
                        throw new MeasurementInBlackListException(path);
                    }
                    throw new MeasurementAlreadyExistException(path.getFullPath(), node.getAsMeasurementMNode().getMeasurementPath());
                }
                throw new PathAlreadyExistException(path.getFullPath());
            }
            if (device.isEntity() && device.getAsEntityMNode().isAligned()) {
                throw new AlignedTimeseriesException("timeseries under this entity is aligned, please use createAlignedTimeseries or change entity.", device.getFullPath());
            }
            if (device.isEntity()) {
                entityMNode = device.getAsEntityMNode();
            } else {
                entityMNode = this.store.setToEntity(device);
                if (entityMNode.isStorageGroup()) {
                    this.replaceStorageGroupMNode(entityMNode.getAsStorageGroupMNode());
                }
            }
            IMeasurementMNode measurementMNode = MeasurementMNode.getMeasurementMNode(entityMNode, leafName, (IMeasurementSchema)new MeasurementSchema(leafName, dataType, encoding, compressor, props), alias);
            this.store.addChild(entityMNode, leafName, measurementMNode);
            if (alias != null) {
                entityMNode.addAlias(alias, measurementMNode);
            }
            return measurementMNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IMeasurementMNode> createAlignedTimeseries(PartialPath devicePath, List<String> measurements, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, List<String> aliasList) throws MetadataException {
        ArrayList<IMeasurementMNode> measurementMNodeList = new ArrayList<IMeasurementMNode>();
        MetaFormatUtils.checkSchemaMeasurementNames(measurements);
        IMNode deviceParent = this.checkAndAutoCreateInternalPath(devicePath);
        MTreeBelowSGMemoryImpl mTreeBelowSGMemoryImpl = this;
        synchronized (mTreeBelowSGMemoryImpl) {
            IEntityMNode entityMNode;
            IMNode device = this.checkAndAutoCreateDeviceNode(devicePath.getTailNode(), deviceParent);
            for (int i = 0; i < measurements.size(); ++i) {
                if (device.hasChild(measurements.get(i))) {
                    IMNode node = device.getChild(measurements.get(i));
                    if (node.isMeasurement()) {
                        if (node.getAsMeasurementMNode().isPreDeleted()) {
                            throw new MeasurementInBlackListException(devicePath.concatNode(measurements.get(i)));
                        }
                        throw new MeasurementAlreadyExistException(devicePath.getFullPath() + "." + measurements.get(i), node.getAsMeasurementMNode().getMeasurementPath());
                    }
                    throw new PathAlreadyExistException(devicePath.getFullPath() + "." + measurements.get(i));
                }
                if (aliasList == null || aliasList.get(i) == null || !device.hasChild(aliasList.get(i))) continue;
                throw new AliasAlreadyExistException(devicePath.getFullPath() + "." + measurements.get(i), aliasList.get(i));
            }
            if (device.isEntity() && !device.getAsEntityMNode().isAligned()) {
                throw new AlignedTimeseriesException("Timeseries under this entity is not aligned, please use createTimeseries or change entity.", devicePath.getFullPath());
            }
            if (device.isEntity()) {
                entityMNode = device.getAsEntityMNode();
            } else {
                entityMNode = this.store.setToEntity(device);
                entityMNode.setAligned(true);
                if (entityMNode.isStorageGroup()) {
                    this.replaceStorageGroupMNode(entityMNode.getAsStorageGroupMNode());
                }
            }
            for (int i = 0; i < measurements.size(); ++i) {
                IMeasurementMNode measurementMNode = MeasurementMNode.getMeasurementMNode(entityMNode, measurements.get(i), (IMeasurementSchema)new MeasurementSchema(measurements.get(i), dataTypes.get(i), encodings.get(i), compressors.get(i)), aliasList == null ? null : aliasList.get(i));
                this.store.addChild(entityMNode, measurements.get(i), measurementMNode);
                if (aliasList != null && aliasList.get(i) != null) {
                    entityMNode.addAlias(aliasList.get(i), measurementMNode);
                }
                measurementMNodeList.add(measurementMNode);
            }
            return measurementMNodeList;
        }
    }

    private IMNode checkAndAutoCreateInternalPath(PartialPath devicePath) throws MetadataException {
        String[] nodeNames = devicePath.getNodes();
        MetaFormatUtils.checkTimeseries(devicePath);
        if (nodeNames.length == this.levelOfSG + 1) {
            return null;
        }
        IMNode cur = this.storageGroupMNode;
        for (int i = this.levelOfSG + 1; i < nodeNames.length - 1; ++i) {
            String childName = nodeNames[i];
            IMNode child = cur.getChild(childName);
            if (child == null) {
                child = this.store.addChild(cur, childName, new InternalMNode(cur, childName));
            }
            if (!(cur = child).isMeasurement()) continue;
            throw new PathAlreadyExistException(cur.getFullPath());
        }
        return cur;
    }

    private IMNode checkAndAutoCreateDeviceNode(String deviceName, IMNode deviceParent) throws PathAlreadyExistException {
        if (deviceParent == null) {
            return this.storageGroupMNode;
        }
        IMNode device = this.store.getChild(deviceParent, deviceName);
        if (device == null) {
            device = this.store.addChild(deviceParent, deviceName, new InternalMNode(deviceParent, deviceName));
        }
        if (device.isMeasurement()) {
            throw new PathAlreadyExistException(device.getFullPath());
        }
        return device;
    }

    @Override
    public Map<Integer, MetadataException> checkMeasurementExistence(PartialPath devicePath, List<String> measurementList, List<String> aliasList) {
        IMNode device;
        try {
            device = this.getNodeByPath(devicePath);
        }
        catch (PathNotExistException e) {
            return Collections.emptyMap();
        }
        if (!device.isEntity()) {
            return Collections.emptyMap();
        }
        HashMap<Integer, MetadataException> failingMeasurementMap = new HashMap<Integer, MetadataException>();
        for (int i = 0; i < measurementList.size(); ++i) {
            if (device.hasChild(measurementList.get(i))) {
                IMNode node = device.getChild(measurementList.get(i));
                if (node.isMeasurement()) {
                    if (node.getAsMeasurementMNode().isPreDeleted()) {
                        failingMeasurementMap.put(i, new MeasurementInBlackListException(devicePath.concatNode(measurementList.get(i))));
                    } else {
                        failingMeasurementMap.put(i, new MeasurementAlreadyExistException(devicePath.getFullPath() + "." + measurementList.get(i), node.getAsMeasurementMNode().getMeasurementPath()));
                    }
                } else {
                    failingMeasurementMap.put(i, new PathAlreadyExistException(devicePath.getFullPath() + "." + measurementList.get(i)));
                }
            }
            if (aliasList == null || aliasList.get(i) == null || !device.hasChild(aliasList.get(i))) continue;
            failingMeasurementMap.put(i, new AliasAlreadyExistException(devicePath.getFullPath() + "." + measurementList.get(i), aliasList.get(i)));
        }
        return failingMeasurementMap;
    }

    @Override
    public IMeasurementMNode deleteTimeseries(PartialPath path) throws MetadataException {
        String[] nodes = path.getNodes();
        if (nodes.length == 0) {
            throw new IllegalPathException(path.getFullPath());
        }
        IMeasurementMNode deletedNode = this.getMeasurementMNode(path);
        IEntityMNode parent = deletedNode.getParent();
        this.store.deleteChild(parent, path.getMeasurement());
        if (deletedNode.getAlias() != null) {
            parent.deleteAliasChild(deletedNode.getAlias());
        }
        this.deleteEmptyInternalMNode(parent);
        return deletedNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteEmptyInternalMNode(IEntityMNode entityMNode) {
        IMNode curNode = entityMNode;
        if (!entityMNode.isUseTemplate()) {
            boolean hasMeasurement = false;
            IMNodeIterator iterator = this.store.getChildrenIterator(entityMNode);
            while (iterator.hasNext()) {
                IMNode child = (IMNode)iterator.next();
                if (!child.isMeasurement()) continue;
                hasMeasurement = true;
                break;
            }
            if (!hasMeasurement) {
                MTreeBelowSGMemoryImpl mTreeBelowSGMemoryImpl = this;
                synchronized (mTreeBelowSGMemoryImpl) {
                    curNode = this.store.setToInternal(entityMNode);
                    if (curNode.isStorageGroup()) {
                        this.replaceStorageGroupMNode(curNode.getAsStorageGroupMNode());
                    }
                }
            }
        }
        while (this.isEmptyInternalMNode(curNode)) {
            if (curNode.isStorageGroup()) {
                return;
            }
            this.store.deleteChild(curNode.getParent(), curNode.getName());
            curNode = curNode.getParent();
        }
    }

    @Override
    public boolean isEmptyInternalMNode(IMNode node) {
        return !"root".equals(node.getName()) && !node.isMeasurement() && !node.isUseTemplate() && node.getChildren().isEmpty();
    }

    @Override
    public List<PartialPath> constructSchemaBlackList(PartialPath pathPattern) throws MetadataException {
        final ArrayList<PartialPath> result = new ArrayList<PartialPath>();
        try (MeasurementUpdater updater = new MeasurementUpdater(this.rootNode, pathPattern, this.store, false){

            @Override
            protected void updateMeasurement(IMeasurementMNode node) {
                node.setPreDeleted(true);
                result.add(this.getPartialPathFromRootToNode(node));
            }
        };){
            updater.update();
        }
        return result;
    }

    @Override
    public List<PartialPath> rollbackSchemaBlackList(PartialPath pathPattern) throws MetadataException {
        final ArrayList<PartialPath> result = new ArrayList<PartialPath>();
        try (MeasurementUpdater updater = new MeasurementUpdater(this.rootNode, pathPattern, this.store, false){

            @Override
            protected void updateMeasurement(IMeasurementMNode node) {
                node.setPreDeleted(false);
                result.add(this.getPartialPathFromRootToNode(node));
            }
        };){
            updater.update();
        }
        return result;
    }

    @Override
    public List<PartialPath> getPreDeletedTimeseries(PartialPath pathPattern) throws MetadataException {
        final LinkedList<PartialPath> result = new LinkedList<PartialPath>();
        try (MeasurementCollector<Void> collector = new MeasurementCollector<Void>(this.rootNode, pathPattern, (IMTreeStore)this.store, false){

            @Override
            protected Void collectMeasurement(IMeasurementMNode node) {
                if (node.isPreDeleted()) {
                    result.add(this.getPartialPathFromRootToNode(node));
                }
                return null;
            }
        };){
            collector.traverse();
        }
        return result;
    }

    @Override
    public Set<PartialPath> getDevicesOfPreDeletedTimeseries(PartialPath pathPattern) throws MetadataException {
        final HashSet<PartialPath> result = new HashSet<PartialPath>();
        try (MeasurementCollector<Void> collector = new MeasurementCollector<Void>(this.rootNode, pathPattern, (IMTreeStore)this.store, false){

            @Override
            protected Void collectMeasurement(IMeasurementMNode node) {
                if (node.isPreDeleted()) {
                    result.add(this.getPartialPathFromRootToNode(node).getDevicePath());
                }
                return null;
            }
        };){
            collector.traverse();
        }
        return result;
    }

    @Override
    public void setAlias(IMeasurementMNode measurementMNode, String alias) throws MetadataException {
        this.store.setAlias(measurementMNode, alias);
    }

    @Override
    public IMNode getDeviceNodeWithAutoCreating(PartialPath deviceId) throws MetadataException {
        MetaFormatUtils.checkTimeseries(deviceId);
        String[] nodeNames = deviceId.getNodes();
        IMNode cur = this.storageGroupMNode;
        for (int i = this.levelOfSG + 1; i < nodeNames.length; ++i) {
            IMNode child = cur.getChild(nodeNames[i]);
            if (child == null) {
                child = this.store.addChild(cur, nodeNames[i], new InternalMNode(cur, nodeNames[i]));
            }
            cur = child;
        }
        return cur;
    }

    @Override
    public List<MeasurementPath> fetchSchema(PartialPath pathPattern, Map<Integer, Template> templateMap, final boolean withTags) throws MetadataException {
        final LinkedList<MeasurementPath> result = new LinkedList<MeasurementPath>();
        try (MeasurementCollector<Void> collector = new MeasurementCollector<Void>(this.rootNode, pathPattern, (IMTreeStore)this.store, false){

            @Override
            protected Void collectMeasurement(IMeasurementMNode node) {
                MeasurementPath path = this.getCurrentMeasurementPathInTraverse(node);
                if (this.nodes[this.nodes.length - 1].equals(node.getAlias())) {
                    path.setMeasurementAlias(node.getAlias());
                }
                if (withTags) {
                    path.setTagMap((Map)MTreeBelowSGMemoryImpl.this.tagGetter.apply(node));
                }
                result.add(path);
                return null;
            }
        };){
            collector.setTemplateMap(templateMap);
            collector.setSkipPreDeletedSchema(true);
            collector.traverse();
        }
        return result;
    }

    @Override
    public IMNode getNodeByPath(PartialPath path) throws PathNotExistException {
        String[] nodes = path.getNodes();
        IMNode cur = this.storageGroupMNode;
        for (int i = this.levelOfSG + 1; i < nodes.length; ++i) {
            IMNode next = cur.getChild(nodes[i]);
            if (next == null) {
                throw new PathNotExistException(path.getFullPath(), true);
            }
            if (next.isMeasurement()) {
                if (i == nodes.length - 1) {
                    return next;
                }
                throw new PathNotExistException(path.getFullPath(), true);
            }
            cur = next;
        }
        return cur;
    }

    @Override
    public IMeasurementMNode getMeasurementMNode(PartialPath path) throws MetadataException {
        IMNode node = this.getNodeByPath(path);
        if (node.isMeasurement()) {
            return node.getAsMeasurementMNode();
        }
        throw new MNodeTypeMismatchException(path.getFullPath(), 2);
    }

    @Override
    public long countAllMeasurement() throws MetadataException {
        try (MeasurementCounter measurementCounter = new MeasurementCounter(this.rootNode, MetadataConstant.ALL_MATCH_PATTERN, this.store, false);){
            long l = measurementCounter.count();
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activateTemplate(PartialPath activatePath, Template template) throws MetadataException {
        IEntityMNode entityMNode;
        String[] nodes = activatePath.getNodes();
        IMNode cur = this.storageGroupMNode;
        for (int i = this.levelOfSG + 1; i < nodes.length; ++i) {
            cur = cur.getChild(nodes[i]);
        }
        MTreeBelowSGMemoryImpl mTreeBelowSGMemoryImpl = this;
        synchronized (mTreeBelowSGMemoryImpl) {
            for (String measurement : template.getSchemaMap().keySet()) {
                if (!cur.hasChild(measurement)) continue;
                throw new TemplateImcompatibeException(activatePath.concatNode(measurement).getFullPath(), template.getName());
            }
            if (cur.isUseTemplate()) {
                if (template.getId() == cur.getSchemaTemplateId()) {
                    throw new TemplateIsInUseException(cur.getFullPath());
                }
                throw new DifferentTemplateException(activatePath.getFullPath(), template.getName());
            }
            if (cur.isEntity()) {
                entityMNode = cur.getAsEntityMNode();
            } else {
                entityMNode = this.store.setToEntity(cur);
                if (entityMNode.isStorageGroup()) {
                    this.replaceStorageGroupMNode(entityMNode.getAsStorageGroupMNode());
                }
            }
        }
        if (!entityMNode.isAligned()) {
            entityMNode.setAligned(template.isDirectAligned());
        }
        entityMNode.setUseTemplate(true);
        entityMNode.setSchemaTemplateId(template.getId());
        this.regionStatistics.activateTemplate(template.getId());
    }

    @Override
    public Map<PartialPath, List<Integer>> constructSchemaBlackListWithTemplate(Map<PartialPath, List<Integer>> templateSetInfo) throws MetadataException {
        final HashMap<PartialPath, List<Integer>> resultTemplateSetInfo = new HashMap<PartialPath, List<Integer>>();
        for (final Map.Entry<PartialPath, List<Integer>> entry : templateSetInfo.entrySet()) {
            try (EntityUpdater updater = new EntityUpdater(this.rootNode, entry.getKey(), this.store, false){

                @Override
                protected void updateEntity(IEntityMNode node) throws MetadataException {
                    if (((List)entry.getValue()).contains(node.getSchemaTemplateId())) {
                        resultTemplateSetInfo.put(node.getPartialPath(), Collections.singletonList(node.getSchemaTemplateId()));
                        node.preDeactivateTemplate();
                        this.store.updateMNode(node);
                    }
                }
            };){
                updater.update();
            }
        }
        return resultTemplateSetInfo;
    }

    @Override
    public Map<PartialPath, List<Integer>> rollbackSchemaBlackListWithTemplate(Map<PartialPath, List<Integer>> templateSetInfo) throws MetadataException {
        final HashMap<PartialPath, List<Integer>> resultTemplateSetInfo = new HashMap<PartialPath, List<Integer>>();
        for (final Map.Entry<PartialPath, List<Integer>> entry : templateSetInfo.entrySet()) {
            try (EntityUpdater updater = new EntityUpdater(this.rootNode, entry.getKey(), this.store, false){

                @Override
                protected void updateEntity(IEntityMNode node) {
                    if (((List)entry.getValue()).contains(node.getSchemaTemplateId()) && node.isPreDeactivateTemplate()) {
                        resultTemplateSetInfo.put(node.getPartialPath(), Collections.singletonList(node.getSchemaTemplateId()));
                        node.rollbackPreDeactivateTemplate();
                    }
                }
            };){
                updater.update();
            }
        }
        return resultTemplateSetInfo;
    }

    @Override
    public Map<PartialPath, List<Integer>> deactivateTemplateInBlackList(Map<PartialPath, List<Integer>> templateSetInfo) throws MetadataException {
        final HashMap<PartialPath, List<Integer>> resultTemplateSetInfo = new HashMap<PartialPath, List<Integer>>();
        for (final Map.Entry<PartialPath, List<Integer>> entry : templateSetInfo.entrySet()) {
            try (EntityUpdater collector = new EntityUpdater(this.rootNode, entry.getKey(), this.store, false){

                @Override
                protected void updateEntity(IEntityMNode node) {
                    if (((List)entry.getValue()).contains(node.getSchemaTemplateId()) && node.isPreDeactivateTemplate()) {
                        resultTemplateSetInfo.put(node.getPartialPath(), Collections.singletonList(node.getSchemaTemplateId()));
                        MTreeBelowSGMemoryImpl.this.regionStatistics.deactivateTemplate(node.getSchemaTemplateId());
                        node.deactivateTemplate();
                        MTreeBelowSGMemoryImpl.this.deleteEmptyInternalMNode(node);
                    }
                }
            };){
                collector.traverse();
            }
        }
        return resultTemplateSetInfo;
    }

    public void activateTemplateWithoutCheck(PartialPath activatePath, int templateId, boolean isAligned) {
        IEntityMNode entityMNode;
        String[] nodes = activatePath.getNodes();
        IMNode cur = this.storageGroupMNode;
        for (int i = this.levelOfSG + 1; i < nodes.length; ++i) {
            cur = cur.getChild(nodes[i]);
        }
        if (cur.isEntity()) {
            entityMNode = cur.getAsEntityMNode();
        } else {
            entityMNode = this.store.setToEntity(cur);
            if (entityMNode.isStorageGroup()) {
                this.replaceStorageGroupMNode(entityMNode.getAsStorageGroupMNode());
            }
        }
        if (!entityMNode.isAligned()) {
            entityMNode.setAligned(isAligned);
        }
        entityMNode.setUseTemplate(true);
        entityMNode.setSchemaTemplateId(templateId);
    }

    @Override
    public long countPathsUsingTemplate(PartialPath pathPattern, int templateId) throws MetadataException {
        try (EntityCounter counter = new EntityCounter(this.rootNode, pathPattern, this.store, false);){
            counter.setSchemaTemplateFilter(templateId);
            long l = counter.count();
            return l;
        }
    }

    public ISchemaReader<IDeviceSchemaInfo> getDeviceReader(IShowDevicesPlan showDevicesPlan) throws MetadataException {
        EntityCollector<IDeviceSchemaInfo> collector = new EntityCollector<IDeviceSchemaInfo>(this.rootNode, showDevicesPlan.getPath(), (IMTreeStore)this.store, showDevicesPlan.isPrefixMatch()){

            @Override
            protected IDeviceSchemaInfo collectEntity(IEntityMNode node) {
                PartialPath device = this.getPartialPathFromRootToNode(node);
                return new ShowDevicesResult(device.getFullPath(), node.isAligned());
            }
        };
        if (showDevicesPlan.usingSchemaTemplate()) {
            collector.setSchemaTemplateFilter(showDevicesPlan.getSchemaTemplateId());
        }
        final TraverserWithLimitOffsetWrapper<IDeviceSchemaInfo> traverser = new TraverserWithLimitOffsetWrapper<IDeviceSchemaInfo>(collector, showDevicesPlan.getLimit(), showDevicesPlan.getOffset());
        return new ISchemaReader<IDeviceSchemaInfo>(){

            @Override
            public boolean isSuccess() {
                return traverser.isSuccess();
            }

            @Override
            public Throwable getFailure() {
                return traverser.getFailure();
            }

            @Override
            public void close() {
                traverser.close();
            }

            @Override
            public boolean hasNext() {
                return traverser.hasNext();
            }

            @Override
            public IDeviceSchemaInfo next() {
                return (IDeviceSchemaInfo)traverser.next();
            }
        };
    }

    public ISchemaReader<ITimeSeriesSchemaInfo> getTimeSeriesReader(IShowTimeSeriesPlan showTimeSeriesPlan, final Function<Long, Pair<Map<String, String>, Map<String, String>>> tagAndAttributeProvider) throws MetadataException {
        MeasurementCollector<ITimeSeriesSchemaInfo> collector = new MeasurementCollector<ITimeSeriesSchemaInfo>(this.rootNode, showTimeSeriesPlan.getPath(), (IMTreeStore)this.store, showTimeSeriesPlan.isPrefixMatch()){

            @Override
            protected ITimeSeriesSchemaInfo collectMeasurement(final IMeasurementMNode node) {
                return new ITimeSeriesSchemaInfo(){
                    private Pair<Map<String, String>, Map<String, String>> tagAndAttribute = null;

                    @Override
                    public String getAlias() {
                        return node.getAlias();
                    }

                    @Override
                    public MeasurementSchema getSchema() {
                        return (MeasurementSchema)node.getSchema();
                    }

                    @Override
                    public Map<String, String> getTags() {
                        if (this.tagAndAttribute == null) {
                            this.tagAndAttribute = (Pair)tagAndAttributeProvider.apply(node.getOffset());
                        }
                        return (Map)this.tagAndAttribute.left;
                    }

                    @Override
                    public Map<String, String> getAttributes() {
                        if (this.tagAndAttribute == null) {
                            this.tagAndAttribute = (Pair)tagAndAttributeProvider.apply(node.getOffset());
                        }
                        return (Map)this.tagAndAttribute.right;
                    }

                    @Override
                    public boolean isUnderAlignedDevice() {
                        return ((IMNode)this.getParentOfNextMatchedNode()).getAsEntityMNode().isAligned();
                    }

                    @Override
                    public String getFullPath() {
                        return this.getPartialPathFromRootToNode(node).getFullPath();
                    }

                    @Override
                    public PartialPath getPartialPath() {
                        return this.getPartialPathFromRootToNode(node);
                    }
                };
            }
        };
        collector.setTemplateMap(showTimeSeriesPlan.getRelatedTemplate());
        final Traverser traverser = showTimeSeriesPlan.getLimit() > 0L || showTimeSeriesPlan.getOffset() > 0L ? new TraverserWithLimitOffsetWrapper<ITimeSeriesSchemaInfo>(collector, showTimeSeriesPlan.getLimit(), showTimeSeriesPlan.getOffset()) : collector;
        return new ISchemaReader<ITimeSeriesSchemaInfo>(){

            @Override
            public boolean isSuccess() {
                return traverser.isSuccess();
            }

            @Override
            public Throwable getFailure() {
                return traverser.getFailure();
            }

            @Override
            public void close() {
                traverser.close();
            }

            @Override
            public boolean hasNext() {
                return traverser.hasNext();
            }

            @Override
            public ITimeSeriesSchemaInfo next() {
                return (ITimeSeriesSchemaInfo)traverser.next();
            }
        };
    }

    public ISchemaReader<INodeSchemaInfo> getNodeReader(IShowNodesPlan showNodesPlan) throws MetadataException {
        final MNodeCollector<INodeSchemaInfo> collector = new MNodeCollector<INodeSchemaInfo>(this.rootNode, showNodesPlan.getPath(), (IMTreeStore)this.store, showNodesPlan.isPrefixMatch()){

            @Override
            protected INodeSchemaInfo collectMNode(IMNode node) {
                return new ShowNodesResult(this.getPartialPathFromRootToNode(node).getFullPath(), node.getMNodeType(false));
            }
        };
        collector.setTargetLevel(showNodesPlan.getLevel());
        return new ISchemaReader<INodeSchemaInfo>(){

            @Override
            public boolean isSuccess() {
                return collector.isSuccess();
            }

            @Override
            public Throwable getFailure() {
                return collector.getFailure();
            }

            @Override
            public void close() {
                collector.close();
            }

            @Override
            public boolean hasNext() {
                return collector.hasNext();
            }

            @Override
            public INodeSchemaInfo next() {
                return (INodeSchemaInfo)collector.next();
            }
        };
    }
}

