/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.service.metric.enums.PerformanceOverviewMetrics;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.directories.DirectoryManager;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.TsFileMetricManager;
import org.apache.iotdb.db.engine.cache.BloomFilterCache;
import org.apache.iotdb.db.engine.cache.ChunkCache;
import org.apache.iotdb.db.engine.cache.TimeSeriesMetadataCache;
import org.apache.iotdb.db.engine.compaction.execute.recover.CompactionRecoverManager;
import org.apache.iotdb.db.engine.compaction.execute.task.AbstractCompactionTask;
import org.apache.iotdb.db.engine.compaction.schedule.CompactionScheduler;
import org.apache.iotdb.db.engine.compaction.schedule.CompactionTaskManager;
import org.apache.iotdb.db.engine.flush.CloseFileListener;
import org.apache.iotdb.db.engine.flush.FlushListener;
import org.apache.iotdb.db.engine.flush.FlushStatus;
import org.apache.iotdb.db.engine.flush.TsFileFlushPolicy;
import org.apache.iotdb.db.engine.memtable.IMemTable;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.DataRegionInfo;
import org.apache.iotdb.db.engine.storagegroup.DataRegionMetrics;
import org.apache.iotdb.db.engine.storagegroup.HashLastFlushTimeMap;
import org.apache.iotdb.db.engine.storagegroup.IDTableLastFlushTimeMap;
import org.apache.iotdb.db.engine.storagegroup.IDataRegionForQuery;
import org.apache.iotdb.db.engine.storagegroup.ILastFlushTimeMap;
import org.apache.iotdb.db.engine.storagegroup.TimePartitionInfo;
import org.apache.iotdb.db.engine.storagegroup.TimePartitionManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileNameGenerator;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessor;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessorInfo;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceList;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceStatus;
import org.apache.iotdb.db.engine.upgrade.UpgradeCheckStatus;
import org.apache.iotdb.db.engine.upgrade.UpgradeLog;
import org.apache.iotdb.db.engine.version.SimpleFileVersionController;
import org.apache.iotdb.db.engine.version.VersionController;
import org.apache.iotdb.db.exception.BatchProcessException;
import org.apache.iotdb.db.exception.DataRegionException;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.exception.LoadFileException;
import org.apache.iotdb.db.exception.TsFileProcessorException;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.exception.WriteProcessRejectException;
import org.apache.iotdb.db.exception.query.OutOfTTLException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.cache.DataNodeSchemaCache;
import org.apache.iotdb.db.metadata.idtable.IDTable;
import org.apache.iotdb.db.metadata.idtable.IDTableManager;
import org.apache.iotdb.db.mpp.metric.QueryMetricsManager;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.DeleteDataNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertMultiTabletsNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertRowsNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertRowsOfOneDeviceNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.db.rescon.TsFileResourceManager;
import org.apache.iotdb.db.service.SettleService;
import org.apache.iotdb.db.sync.SyncService;
import org.apache.iotdb.db.sync.sender.manager.ISyncManager;
import org.apache.iotdb.db.tools.settle.TsFileAndModSettleTool;
import org.apache.iotdb.db.utils.CopyOnReadLinkedList;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.apache.iotdb.db.utils.UpgradeUtils;
import org.apache.iotdb.db.wal.WALManager;
import org.apache.iotdb.db.wal.node.IWALNode;
import org.apache.iotdb.db.wal.recover.WALRecoverManager;
import org.apache.iotdb.db.wal.recover.file.SealedTsFileRecoverPerformer;
import org.apache.iotdb.db.wal.recover.file.UnsealedTsFileRecoverPerformer;
import org.apache.iotdb.db.wal.utils.WALMode;
import org.apache.iotdb.db.wal.utils.listener.AbstractResultListener;
import org.apache.iotdb.db.wal.utils.listener.WALFlushListener;
import org.apache.iotdb.db.wal.utils.listener.WALRecoverListener;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.fileSystem.fsFactory.FSFactory;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataRegion
implements IDataRegionForQuery {
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final Logger DEBUG_LOGGER = LoggerFactory.getLogger((String)"QUERY_DEBUG");
    private static final int MERGE_MOD_START_VERSION_NUM = 1;
    private static final Logger logger = LoggerFactory.getLogger(DataRegion.class);
    private static final int POS_OVERLAP = -3;
    private final boolean enableMemControl = config.isEnableMemControl();
    private final ReadWriteLock insertLock = new ReentrantReadWriteLock();
    private final Condition deletedCondition = this.insertLock.writeLock().newCondition();
    private volatile boolean deleted = false;
    private final Object closeStorageGroupCondition = new Object();
    private final ReadWriteLock closeQueryLock = new ReentrantReadWriteLock();
    private final TreeMap<Long, TsFileProcessor> workSequenceTsFileProcessors = new TreeMap();
    private final TreeMap<Long, TsFileProcessor> workUnsequenceTsFileProcessors = new TreeMap();
    private final List<TsFileResource> upgradeSeqFileList = new LinkedList<TsFileResource>();
    private final CopyOnReadLinkedList<TsFileProcessor> closingSequenceTsFileProcessor = new CopyOnReadLinkedList();
    private final List<TsFileResource> upgradeUnseqFileList = new LinkedList<TsFileResource>();
    private final CopyOnReadLinkedList<TsFileProcessor> closingUnSequenceTsFileProcessor = new CopyOnReadLinkedList();
    private final AtomicInteger upgradeFileCount = new AtomicInteger();
    private final AtomicBoolean isSettling = new AtomicBoolean();
    private final String dataRegionId;
    private final String databaseName;
    private File storageGroupSysDir;
    private final TsFileManager tsFileManager;
    private final TsFileResourceManager tsFileResourceManager = TsFileResourceManager.getInstance();
    private final HashMap<Long, VersionController> timePartitionIdVersionControllerMap = new HashMap();
    private long dataTTL = Long.MAX_VALUE;
    private final FSFactory fsFactory = FSFactoryProducer.getFSFactory();
    private TsFileFlushPolicy fileFlushPolicy;
    private Map<Long, Long> partitionMaxFileVersions = new HashMap<Long, Long>();
    private final DataRegionInfo dataRegionInfo = new DataRegionInfo(this);
    private boolean isReady = false;
    private List<CloseFileListener> customCloseFileListeners = Collections.emptyList();
    private List<FlushListener> customFlushListeners = Collections.emptyList();
    private ILastFlushTimeMap lastFlushTimeMap;
    private String insertWriteLockHolder = "";
    private ScheduledExecutorService timedCompactionScheduleTask;
    public static final long COMPACTION_TASK_SUBMIT_DELAY = 20000L;
    private IDTable idTable;
    private final QueryMetricsManager queryMetricsManager = QueryMetricsManager.getInstance();
    private static final PerformanceOverviewMetrics PERFORMANCE_OVERVIEW_METRICS = PerformanceOverviewMetrics.getInstance();

    public DataRegion(String systemDir, String dataRegionId, TsFileFlushPolicy fileFlushPolicy, String databaseName) throws DataRegionException {
        this.dataRegionId = dataRegionId;
        this.databaseName = databaseName;
        this.fileFlushPolicy = fileFlushPolicy;
        this.storageGroupSysDir = SystemFileFactory.INSTANCE.getFile(systemDir, dataRegionId);
        this.tsFileManager = new TsFileManager(databaseName, dataRegionId, this.storageGroupSysDir.getPath());
        if (this.storageGroupSysDir.mkdirs()) {
            logger.info("Database system Directory {} doesn't exist, create it", (Object)this.storageGroupSysDir.getPath());
        } else if (!this.storageGroupSysDir.exists()) {
            logger.error("create database system Directory {} failed", (Object)this.storageGroupSysDir.getPath());
        }
        if (config.isEnableIDTable()) {
            this.idTable = IDTableManager.getInstance().getIDTableDirectly(databaseName);
            this.lastFlushTimeMap = new IDTableLastFlushTimeMap(this.idTable, this.tsFileManager);
        } else {
            this.lastFlushTimeMap = new HashLastFlushTimeMap(this.tsFileManager);
        }
        if (config.isClusterMode() && config.getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus") && !StorageEngine.getInstance().isAllSgReady()) {
            logger.debug("Skip recovering data region {}[{}] when consensus protocol is ratis and storage engine is not ready.", (Object)databaseName, (Object)dataRegionId);
            for (String fileFolder : DirectoryManager.getInstance().getAllFilesFolders()) {
                File[] timePartitions;
                File dataRegionFolder = this.fsFactory.getFile(fileFolder, databaseName + File.separator + dataRegionId);
                if (!dataRegionFolder.exists() || (timePartitions = dataRegionFolder.listFiles()) == null) continue;
                for (File timePartition : timePartitions) {
                    try {
                        FileUtils.forceDelete((File)timePartition);
                    }
                    catch (IOException e) {
                        logger.error("Exception occurs when deleting time partition directory {} for {}-{}", new Object[]{timePartitions, databaseName, dataRegionId, e});
                    }
                }
            }
        } else {
            this.recover();
        }
        MetricService.getInstance().addMetricSet((IMetricSet)new DataRegionMetrics(this));
    }

    public DataRegion(String databaseName, String id) {
        this.databaseName = databaseName;
        this.dataRegionId = id;
        this.tsFileManager = new TsFileManager(databaseName, id, "");
        this.partitionMaxFileVersions = new HashMap<Long, Long>();
        this.partitionMaxFileVersions.put(0L, 0L);
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    public boolean isReady() {
        return this.isReady;
    }

    public void setReady(boolean ready) {
        this.isReady = ready;
    }

    private Map<Long, List<TsFileResource>> splitResourcesByPartition(List<TsFileResource> resources) {
        TreeMap<Long, List<TsFileResource>> ret = new TreeMap<Long, List<TsFileResource>>();
        for (TsFileResource resource : resources) {
            ret.computeIfAbsent(resource.getTimePartition(), l -> new ArrayList()).add(resource);
        }
        return ret;
    }

    public AtomicBoolean getIsSettling() {
        return this.isSettling;
    }

    public void setSettling(boolean isSettling) {
        this.isSettling.set(isSettling);
    }

    private void recover() throws DataRegionException {
        try {
            this.recoverCompaction();
        }
        catch (Exception e) {
            throw new DataRegionException(e);
        }
        try {
            WALRecoverListener recoverListener;
            Object tsFileResource;
            Pair<List<TsFileResource>, List<TsFileResource>> seqTsFilesPair = this.getAllFiles(DirectoryManager.getInstance().getAllSequenceFileFolders());
            List tmpSeqTsFiles = (List)seqTsFilesPair.left;
            List oldSeqTsFiles = (List)seqTsFilesPair.right;
            this.upgradeSeqFileList.addAll(oldSeqTsFiles);
            Pair<List<TsFileResource>, List<TsFileResource>> unseqTsFilesPair = this.getAllFiles(DirectoryManager.getInstance().getAllUnSequenceFileFolders());
            List tmpUnseqTsFiles = (List)unseqTsFilesPair.left;
            List oldUnseqTsFiles = (List)unseqTsFilesPair.right;
            this.upgradeUnseqFileList.addAll(oldUnseqTsFiles);
            if (this.upgradeSeqFileList.size() + this.upgradeUnseqFileList.size() != 0) {
                this.upgradeFileCount.set(this.upgradeSeqFileList.size() + this.upgradeUnseqFileList.size());
            }
            DataRegionRecoveryContext dataRegionRecoveryContext = new DataRegionRecoveryContext(tmpSeqTsFiles.size() + tmpUnseqTsFiles.size());
            Map<Long, List<TsFileResource>> partitionTmpSeqTsFiles = this.splitResourcesByPartition(tmpSeqTsFiles);
            Map<Long, List<TsFileResource>> partitionTmpUnseqTsFiles = this.splitResourcesByPartition(tmpUnseqTsFiles);
            ArrayList<WALRecoverListener> recoverListeners = new ArrayList<WALRecoverListener>();
            for (List<TsFileResource> value : partitionTmpSeqTsFiles.values()) {
                for (TsFileResource resource : value) {
                    if (!resource.resourceFileExists()) continue;
                    TsFileMetricManager.getInstance().addFile(resource.getTsFile().length(), true);
                    if (!resource.getModFile().exists()) continue;
                    TsFileMetricManager.getInstance().increaseModFileNum(1);
                    TsFileMetricManager.getInstance().increaseModFileSize(resource.getModFile().getSize());
                }
                while (!value.isEmpty() && !((TsFileResource)(tsFileResource = value.get(value.size() - 1))).resourceFileExists()) {
                    value.remove(value.size() - 1);
                    recoverListener = this.recoverUnsealedTsFile((TsFileResource)tsFileResource, dataRegionRecoveryContext, true);
                    if (recoverListener == null) continue;
                    recoverListeners.add(recoverListener);
                }
            }
            for (List<TsFileResource> value : partitionTmpUnseqTsFiles.values()) {
                tsFileResource = value.iterator();
                while (tsFileResource.hasNext()) {
                    TsFileResource resource;
                    resource = tsFileResource.next();
                    if (resource.resourceFileExists()) {
                        TsFileMetricManager.getInstance().addFile(resource.getTsFile().length(), false);
                    }
                    if (!resource.getModFile().exists()) continue;
                    TsFileMetricManager.getInstance().increaseModFileNum(1);
                    TsFileMetricManager.getInstance().increaseModFileSize(resource.getModFile().getSize());
                }
                while (!value.isEmpty() && !((TsFileResource)(tsFileResource = value.get(value.size() - 1))).resourceFileExists()) {
                    value.remove(value.size() - 1);
                    recoverListener = this.recoverUnsealedTsFile((TsFileResource)tsFileResource, dataRegionRecoveryContext, false);
                    if (recoverListener == null) continue;
                    recoverListeners.add(recoverListener);
                }
            }
            WALRecoverManager.getInstance().getAllDataRegionScannedLatch().countDown();
            if (!partitionTmpSeqTsFiles.isEmpty()) {
                long latestPartitionId = (Long)((TreeMap)partitionTmpSeqTsFiles).lastKey();
                for (Map.Entry<Long, List<TsFileResource>> partitionFiles : partitionTmpSeqTsFiles.entrySet()) {
                    this.recoverFilesInPartition(partitionFiles.getKey(), dataRegionRecoveryContext, partitionFiles.getValue(), true, partitionFiles.getKey() == latestPartitionId);
                }
            }
            for (Map.Entry<Long, List<TsFileResource>> partitionFiles : partitionTmpUnseqTsFiles.entrySet()) {
                this.recoverFilesInPartition(partitionFiles.getKey(), dataRegionRecoveryContext, partitionFiles.getValue(), false, false);
            }
            for (WALRecoverListener recoverListener2 : recoverListeners) {
                if (recoverListener2.waitForResult() == AbstractResultListener.Status.FAILURE) {
                    logger.error("Fail to recover unsealed TsFile {}, skip it.", (Object)recoverListener2.getFilePath(), (Object)recoverListener2.getCause());
                }
                dataRegionRecoveryContext.incrementRecoveredFilesNum();
            }
            dataRegionRecoveryContext.recoverPerformers.sort((p1, p2) -> this.compareFileName(p1.getTsFileResource().getTsFile(), p2.getTsFileResource().getTsFile()));
            for (UnsealedTsFileRecoverPerformer recoverPerformer : dataRegionRecoveryContext.recoverPerformers) {
                this.recoverUnsealedTsFileCallBack(recoverPerformer);
            }
            for (TsFileResource resource : this.tsFileManager.getTsFileList(true)) {
                long partitionNum = resource.getTimePartition();
                this.updatePartitionFileVersion(partitionNum, resource.getVersion());
            }
            for (TsFileResource resource : this.tsFileManager.getTsFileList(false)) {
                long partitionNum = resource.getTimePartition();
                this.updatePartitionFileVersion(partitionNum, resource.getVersion());
            }
            for (TsFileResource resource : this.upgradeSeqFileList) {
                long partitionNum = resource.getTimePartition();
                this.updatePartitionFileVersion(partitionNum, resource.getVersion());
            }
            for (TsFileResource resource : this.upgradeUnseqFileList) {
                long partitionNum = resource.getTimePartition();
                this.updatePartitionFileVersion(partitionNum, resource.getVersion());
            }
            this.updateLatestFlushedTime();
        }
        catch (IOException e) {
            throw new DataRegionException(e);
        }
        this.initCompaction();
        if (StorageEngine.getInstance().isAllSgReady()) {
            logger.info("The data region {}[{}] is created successfully", (Object)this.databaseName, (Object)this.dataRegionId);
        } else {
            logger.info("The data region {}[{}] is recovered successfully", (Object)this.databaseName, (Object)this.dataRegionId);
        }
    }

    private void updateLastFlushTime(TsFileResource resource, boolean isSeq) {
        if (isSeq) {
            long timePartitionId = resource.getTimePartition();
            HashMap<String, Long> endTimeMap = new HashMap<String, Long>();
            for (String deviceId : resource.getDevices()) {
                long endTime = resource.getEndTime(deviceId);
                endTimeMap.put(deviceId.intern(), endTime);
            }
            this.lastFlushTimeMap.setMultiDeviceFlushedTime(timePartitionId, endTimeMap);
            this.lastFlushTimeMap.setMultiDeviceGlobalFlushedTime(endTimeMap);
        }
    }

    private void initCompaction() {
        if (!(config.isEnableSeqSpaceCompaction() || config.isEnableUnseqSpaceCompaction() || config.isEnableCrossSpaceCompaction())) {
            return;
        }
        this.timedCompactionScheduleTask = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)(ThreadName.COMPACTION_SCHEDULE.getName() + "-" + this.databaseName + "-" + this.dataRegionId));
        ScheduledExecutorUtil.safelyScheduleWithFixedDelay((ScheduledExecutorService)this.timedCompactionScheduleTask, this::executeCompaction, (long)20000L, (long)IoTDBDescriptor.getInstance().getConfig().getCompactionScheduleIntervalInMs(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    private void recoverCompaction() {
        CompactionRecoverManager compactionRecoverManager = new CompactionRecoverManager(this.tsFileManager, this.databaseName, this.dataRegionId);
        compactionRecoverManager.recoverInnerSpaceCompaction(true);
        compactionRecoverManager.recoverInnerSpaceCompaction(false);
        compactionRecoverManager.recoverCrossSpaceCompaction();
    }

    private void updatePartitionFileVersion(long partitionNum, long fileVersion) {
        long oldVersion = this.partitionMaxFileVersions.getOrDefault(partitionNum, 0L);
        if (fileVersion > oldVersion) {
            this.partitionMaxFileVersions.put(partitionNum, fileVersion);
        }
    }

    private void updateLatestFlushedTime() throws IOException {
        SimpleFileVersionController versionController = new SimpleFileVersionController(this.storageGroupSysDir.getPath());
        long currentVersion = versionController.currVersion();
        for (TsFileResource resource : this.upgradeSeqFileList) {
            for (String deviceId : resource.getDevices()) {
                long endTime = resource.getEndTime(deviceId);
                long endTimePartitionId = StorageEngine.getTimePartition(endTime);
                this.lastFlushTimeMap.setOneDeviceGlobalFlushedTime(deviceId, endTime);
                for (long partitionId = StorageEngine.getTimePartition(resource.getStartTime(deviceId)); partitionId <= endTimePartitionId; ++partitionId) {
                    File versionFile;
                    this.lastFlushTimeMap.setOneDeviceFlushedTime(partitionId, deviceId, endTime);
                    if (this.timePartitionIdVersionControllerMap.containsKey(partitionId)) continue;
                    File directory = SystemFileFactory.INSTANCE.getFile(this.storageGroupSysDir, String.valueOf(partitionId));
                    if (!directory.exists()) {
                        directory.mkdirs();
                    }
                    if (!(versionFile = SystemFileFactory.INSTANCE.getFile(directory, "Version-" + currentVersion)).createNewFile()) {
                        logger.warn("Version file {} has already been created ", (Object)versionFile);
                    }
                    this.timePartitionIdVersionControllerMap.put(partitionId, new SimpleFileVersionController(this.storageGroupSysDir.getPath(), partitionId));
                }
            }
        }
    }

    private Pair<List<TsFileResource>, List<TsFileResource>> getAllFiles(List<String> folders) throws IOException, DataRegionException {
        ArrayList tsFiles = new ArrayList();
        ArrayList upgradeFiles = new ArrayList();
        for (String baseDir : folders) {
            File fileFolder = this.fsFactory.getFile(baseDir + File.separator + this.databaseName, this.dataRegionId);
            if (!fileFolder.exists()) continue;
            this.continueFailedRenames(fileFolder, ".temp");
            File[] subFiles = fileFolder.listFiles();
            if (subFiles == null) continue;
            for (File partitionFolder : subFiles) {
                if (!partitionFolder.isDirectory()) {
                    logger.warn("{} is not a directory.", (Object)partitionFolder.getAbsolutePath());
                    continue;
                }
                if (!partitionFolder.getName().equals("upgrade")) {
                    this.continueFailedRenames(partitionFolder, ".temp");
                    Collections.addAll(tsFiles, this.fsFactory.listFilesBySuffix(partitionFolder.getAbsolutePath(), ".tsfile"));
                    continue;
                }
                Collections.addAll(upgradeFiles, this.fsFactory.listFilesBySuffix(partitionFolder.getAbsolutePath(), ".tsfile"));
            }
        }
        tsFiles.sort(this::compareFileName);
        if (!tsFiles.isEmpty()) {
            this.checkTsFileTime((File)tsFiles.get(tsFiles.size() - 1));
        }
        ArrayList ret = new ArrayList();
        tsFiles.forEach(f -> ret.add(new TsFileResource((File)f)));
        upgradeFiles.sort(this::compareFileName);
        if (!upgradeFiles.isEmpty()) {
            this.checkTsFileTime((File)upgradeFiles.get(upgradeFiles.size() - 1));
        }
        ArrayList<TsFileResource> upgradeRet = new ArrayList<TsFileResource>();
        for (File f2 : upgradeFiles) {
            TsFileResource fileResource = new TsFileResource(f2);
            fileResource.setStatus(TsFileResourceStatus.CLOSED);
            fileResource.deserializeFromOldFile();
            upgradeRet.add(fileResource);
        }
        return new Pair(ret, upgradeRet);
    }

    private void continueFailedRenames(File fileFolder, String suffix) {
        File[] files = this.fsFactory.listFilesBySuffix(fileFolder.getAbsolutePath(), suffix);
        if (files != null) {
            for (File tempResource : files) {
                File originResource = this.fsFactory.getFile(tempResource.getPath().replace(suffix, ""));
                if (originResource.exists()) {
                    tempResource.delete();
                    continue;
                }
                tempResource.renameTo(originResource);
            }
        }
    }

    private void checkTsFileTime(File tsFile) throws DataRegionException {
        long currentTime;
        String[] items = tsFile.getName().replace(".tsfile", "").split("-");
        long fileTime = Long.parseLong(items[0]);
        if (fileTime > (currentTime = System.currentTimeMillis())) {
            throw new DataRegionException(String.format("data region %s[%s] is down, because the time of tsfile %s is larger than system current time, file time is %d while system current time is %d, please check it.", this.databaseName, this.dataRegionId, tsFile.getAbsolutePath(), fileTime, currentTime));
        }
    }

    private WALRecoverListener recoverUnsealedTsFile(TsFileResource unsealedTsFile, DataRegionRecoveryContext context, boolean isSeq) {
        UnsealedTsFileRecoverPerformer recoverPerformer = new UnsealedTsFileRecoverPerformer(unsealedTsFile, isSeq, this.idTable, context.recoverPerformers::add);
        return WALRecoverManager.getInstance().addRecoverPerformer(recoverPerformer);
    }

    private void recoverUnsealedTsFileCallBack(UnsealedTsFileRecoverPerformer recoverPerformer) {
        try {
            TsFileResource tsFileResource = recoverPerformer.getTsFileResource();
            boolean isSeq = recoverPerformer.isSequence();
            if (!recoverPerformer.canWrite()) {
                for (ISyncManager syncManager : SyncService.getInstance().getOrCreateSyncManager(this.dataRegionId)) {
                    syncManager.syncRealTimeTsFile(tsFileResource.getTsFile());
                }
                try {
                    tsFileResource.close();
                }
                catch (IOException e) {
                    logger.error("Fail to close TsFile {} when recovering", (Object)tsFileResource.getTsFile(), (Object)e);
                }
                this.updateLastFlushTime(tsFileResource, isSeq);
                this.tsFileResourceManager.registerSealedTsFileResource(tsFileResource);
                TsFileMetricManager.getInstance().addFile(tsFileResource.getTsFile().length(), recoverPerformer.isSequence());
            } else {
                RestorableTsFileIOWriter writer = recoverPerformer.getWriter();
                long timePartitionId = tsFileResource.getTimePartition();
                TimePartitionManager.getInstance().updateAfterOpeningTsFileProcessor(new DataRegionId(Integer.parseInt(this.dataRegionId)), timePartitionId);
                TsFileProcessor tsFileProcessor = new TsFileProcessor(this.dataRegionId, this.dataRegionInfo, tsFileResource, this::closeUnsealedTsFileProcessorCallBack, isSeq ? this::sequenceFlushCallback : this::unsequenceFlushCallback, isSeq, writer);
                if (isSeq) {
                    this.workSequenceTsFileProcessors.put(timePartitionId, tsFileProcessor);
                } else {
                    this.workUnsequenceTsFileProcessors.put(timePartitionId, tsFileProcessor);
                }
                tsFileResource.setProcessor(tsFileProcessor);
                tsFileResource.removeResourceFile();
                tsFileProcessor.setTimeRangeId(timePartitionId);
                writer.makeMetadataVisible();
                if (this.enableMemControl) {
                    TsFileProcessorInfo tsFileProcessorInfo = new TsFileProcessorInfo(this.dataRegionInfo);
                    tsFileProcessor.setTsFileProcessorInfo(tsFileProcessorInfo);
                    this.dataRegionInfo.initTsFileProcessorInfo(tsFileProcessor);
                    long chunkMetadataSize = 0L;
                    for (Map metaMap : writer.getMetadatasForQuery().values()) {
                        for (List metadatas : metaMap.values()) {
                            for (ChunkMetadata chunkMetadata : metadatas) {
                                chunkMetadataSize += chunkMetadata.calculateRamSize();
                            }
                        }
                    }
                    tsFileProcessorInfo.addTSPMemCost(chunkMetadataSize);
                }
            }
            this.tsFileManager.add(tsFileResource, recoverPerformer.isSequence());
        }
        catch (Throwable e) {
            logger.error("Fail to recover unsealed TsFile {}, skip it.", (Object)recoverPerformer.getTsFileAbsolutePath(), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverSealedTsFiles(TsFileResource sealedTsFile, DataRegionRecoveryContext context, boolean isSeq) {
        try (SealedTsFileRecoverPerformer recoverPerformer = new SealedTsFileRecoverPerformer(sealedTsFile);){
            recoverPerformer.recover();
            if (recoverPerformer.hasCrashed()) {
                if (TsFileResource.getInnerCompactionCount(sealedTsFile.getTsFile().getName()) > 0) {
                    this.tsFileManager.addForRecover(sealedTsFile, isSeq);
                    return;
                }
                logger.warn("Sealed TsFile {} has crashed at zero level, truncate and recover it.", (Object)sealedTsFile.getTsFilePath());
            }
            sealedTsFile.close();
            this.tsFileManager.add(sealedTsFile, isSeq);
            this.tsFileResourceManager.registerSealedTsFileResource(sealedTsFile);
        }
        catch (Throwable e) {
            logger.error("Fail to recover sealed TsFile {}, skip it.", (Object)sealedTsFile.getTsFilePath(), (Object)e);
        }
        finally {
            context.incrementRecoveredFilesNum();
        }
    }

    private void recoverFilesInPartition(long partitionId, DataRegionRecoveryContext context, List<TsFileResource> resourceList, boolean isSeq, boolean isLatestPartition) {
        for (TsFileResource tsFileResource : resourceList) {
            this.recoverSealedTsFiles(tsFileResource, context, isSeq);
        }
        if (isLatestPartition && isSeq) {
            this.lastFlushTimeMap.checkAndCreateFlushedTimePartition(partitionId);
            for (TsFileResource tsFileResource : resourceList) {
                this.updateLastFlushTime(tsFileResource, true);
            }
            TimePartitionManager.getInstance().registerTimePartitionInfo(new TimePartitionInfo(new DataRegionId(Integer.parseInt(this.dataRegionId)), partitionId, false, Long.MAX_VALUE, this.lastFlushTimeMap.getMemSize(partitionId), true));
        }
    }

    private int compareFileName(File o1, File o2) {
        long ver2;
        String[] items1 = o1.getName().replace(".tsfile", "").split("-");
        String[] items2 = o2.getName().replace(".tsfile", "").split("-");
        long ver1 = Long.parseLong(items1[0]);
        int cmp = Long.compare(ver1, ver2 = Long.parseLong(items2[0]));
        if (cmp == 0) {
            return Long.compare(Long.parseLong(items1[1]), Long.parseLong(items2[1]));
        }
        return cmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(InsertRowNode insertRowNode) throws WriteProcessException {
        if (!this.isAlive(insertRowNode.getTime())) {
            throw new OutOfTTLException(insertRowNode.getTime(), DateTimeUtils.currentTime() - this.dataTTL);
        }
        if (this.enableMemControl) {
            StorageEngine.blockInsertionIfReject(null);
        }
        long startTime = System.nanoTime();
        this.writeLock("InsertRow");
        PERFORMANCE_OVERVIEW_METRICS.recordScheduleLockCost(System.nanoTime() - startTime);
        try {
            boolean isSequence;
            if (this.deleted) {
                return;
            }
            long timePartitionId = StorageEngine.getTimePartition(insertRowNode.getTime());
            if (!this.lastFlushTimeMap.checkAndCreateFlushedTimePartition(timePartitionId)) {
                TimePartitionManager.getInstance().registerTimePartitionInfo(new TimePartitionInfo(new DataRegionId(Integer.parseInt(this.dataRegionId)), timePartitionId, true, Long.MAX_VALUE, 0L, this.tsFileManager.isLatestTimePartition(timePartitionId)));
            }
            boolean bl = isSequence = insertRowNode.getTime() > this.lastFlushTimeMap.getFlushedTime(timePartitionId, insertRowNode.getDevicePath().getFullPath());
            if (!isSequence && IoTDBDescriptor.getInstance().getConfig().isEnableDiscardOutOfOrderData()) {
                return;
            }
            this.insertToTsFileProcessor(insertRowNode, isSequence, timePartitionId);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertTablet(InsertTabletNode insertTabletNode) throws BatchProcessException, WriteProcessException {
        if (this.enableMemControl) {
            StorageEngine.blockInsertionIfReject(null);
        }
        long startTime = System.nanoTime();
        this.writeLock("insertTablet");
        PERFORMANCE_OVERVIEW_METRICS.recordScheduleLockCost(System.nanoTime() - startTime);
        try {
            long currTime;
            int loc;
            if (this.deleted) {
                return;
            }
            Object[] results = new TSStatus[insertTabletNode.getRowCount()];
            Arrays.fill(results, RpcUtils.SUCCESS_STATUS);
            boolean noFailure = true;
            for (loc = 0; loc < insertTabletNode.getRowCount() && !this.isAlive(currTime = insertTabletNode.getTimes()[loc]); ++loc) {
                results[loc] = RpcUtils.getStatus((TSStatusCode)TSStatusCode.OUT_OF_TTL, (String)String.format("Insertion time [%s] is less than ttl time bound [%s]", DateTimeUtils.convertMillsecondToZonedDateTime(currTime), DateTimeUtils.convertMillsecondToZonedDateTime(DateTimeUtils.currentTime() - this.dataTTL)));
                noFailure = false;
            }
            if (loc == insertTabletNode.getRowCount()) {
                throw new OutOfTTLException(insertTabletNode.getTimes()[insertTabletNode.getTimes().length - 1], DateTimeUtils.currentTime() - this.dataTTL);
            }
            int before = loc;
            long beforeTimePartition = StorageEngine.getTimePartition(insertTabletNode.getTimes()[before]);
            if (!this.lastFlushTimeMap.checkAndCreateFlushedTimePartition(beforeTimePartition)) {
                TimePartitionManager.getInstance().registerTimePartitionInfo(new TimePartitionInfo(new DataRegionId(Integer.parseInt(this.dataRegionId)), beforeTimePartition, true, Long.MAX_VALUE, 0L, this.tsFileManager.isLatestTimePartition(beforeTimePartition)));
            }
            long lastFlushTime = this.lastFlushTimeMap.getFlushedTime(beforeTimePartition, insertTabletNode.getDevicePath().getFullPath());
            boolean isSequence = false;
            while (loc < insertTabletNode.getRowCount()) {
                long time = insertTabletNode.getTimes()[loc];
                if (!isSequence && time > lastFlushTime) {
                    if (!IoTDBDescriptor.getInstance().getConfig().isEnableDiscardOutOfOrderData()) {
                        noFailure = this.insertTabletToTsFileProcessor(insertTabletNode, before, loc, false, (TSStatus[])results, beforeTimePartition) && noFailure;
                    }
                    before = loc;
                    isSequence = true;
                }
                ++loc;
            }
            if (before < loc && (isSequence || !IoTDBDescriptor.getInstance().getConfig().isEnableDiscardOutOfOrderData())) {
                noFailure = this.insertTabletToTsFileProcessor(insertTabletNode, before, loc, isSequence, (TSStatus[])results, beforeTimePartition) && noFailure;
            }
            long globalLatestFlushedTime = this.lastFlushTimeMap.getGlobalFlushedTime(insertTabletNode.getDevicePath().getFullPath());
            startTime = System.nanoTime();
            this.tryToUpdateBatchInsertLastCache(insertTabletNode, globalLatestFlushedTime);
            PERFORMANCE_OVERVIEW_METRICS.recordScheduleUpdateLastCacheCost(System.nanoTime() - startTime);
            if (!noFailure) {
                throw new BatchProcessException((TSStatus[])results);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    private boolean isAlive(long time) {
        return this.dataTTL == Long.MAX_VALUE || DateTimeUtils.currentTime() - time <= this.dataTTL;
    }

    private boolean insertTabletToTsFileProcessor(InsertTabletNode insertTabletNode, int start, int end, boolean sequence, TSStatus[] results, long timePartitionId) {
        if (start >= end) {
            return true;
        }
        TsFileProcessor tsFileProcessor = this.getOrCreateTsFileProcessor(timePartitionId, sequence);
        if (tsFileProcessor == null) {
            for (int i = start; i < end; ++i) {
                results[i] = RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)("can not create TsFileProcessor, timePartitionId: " + timePartitionId));
            }
            return false;
        }
        try {
            tsFileProcessor.insertTablet(insertTabletNode, start, end, results);
        }
        catch (WriteProcessRejectException e) {
            logger.warn("insert to TsFileProcessor rejected, {}", (Object)e.getMessage());
            return false;
        }
        catch (WriteProcessException e) {
            logger.error("insert to TsFileProcessor error ", (Throwable)((Object)e));
            return false;
        }
        if (tsFileProcessor.shouldFlush()) {
            this.fileFlushPolicy.apply(this, tsFileProcessor, sequence);
        }
        return true;
    }

    private void tryToUpdateBatchInsertLastCache(InsertTabletNode node, long latestFlushedTime) {
        if (!IoTDBDescriptor.getInstance().getConfig().isLastCacheEnabled()) {
            return;
        }
        for (int i = 0; i < node.getColumns().length; ++i) {
            if (node.getColumns()[i] == null) continue;
            DataNodeSchemaCache.getInstance().updateLastCache(node.getDevicePath().concatNode(node.getMeasurements()[i]), node.composeLastTimeValuePair(i), true, latestFlushedTime);
        }
    }

    private void insertToTsFileProcessor(InsertRowNode insertRowNode, boolean sequence, long timePartitionId) throws WriteProcessException {
        TsFileProcessor tsFileProcessor = this.getOrCreateTsFileProcessor(timePartitionId, sequence);
        if (tsFileProcessor == null) {
            return;
        }
        tsFileProcessor.insert(insertRowNode);
        long globalLatestFlushTime = this.lastFlushTimeMap.getGlobalFlushedTime(insertRowNode.getDevicePath().getFullPath());
        long startTime = System.nanoTime();
        this.tryToUpdateInsertLastCache(insertRowNode, globalLatestFlushTime);
        PERFORMANCE_OVERVIEW_METRICS.recordScheduleUpdateLastCacheCost(System.nanoTime() - startTime);
        if (tsFileProcessor.shouldFlush()) {
            this.fileFlushPolicy.apply(this, tsFileProcessor, sequence);
        }
    }

    private void tryToUpdateInsertLastCache(InsertRowNode node, long latestFlushedTime) {
        if (!IoTDBDescriptor.getInstance().getConfig().isLastCacheEnabled()) {
            return;
        }
        for (int i = 0; i < node.getValues().length; ++i) {
            if (node.getValues()[i] == null) continue;
            DataNodeSchemaCache.getInstance().updateLastCache(node.getDevicePath().concatNode(node.getMeasurements()[i]), node.composeTimeValuePair(i), true, latestFlushedTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean submitAFlushTask(long timeRangeId, boolean sequence, IMemTable memTable) {
        this.writeLock("submitAFlushTask");
        try {
            boolean shouldSubmit;
            if (memTable.getFlushStatus() != FlushStatus.WORKING) {
                boolean bl = false;
                return bl;
            }
            TsFileProcessor tsFileProcessor = sequence ? this.workSequenceTsFileProcessors.get(timeRangeId) : this.workUnsequenceTsFileProcessors.get(timeRangeId);
            boolean bl = shouldSubmit = tsFileProcessor != null && tsFileProcessor.getWorkMemTable() == memTable;
            if (shouldSubmit) {
                this.fileFlushPolicy.apply(this, tsFileProcessor, tsFileProcessor.isSequence());
            }
            boolean bl2 = shouldSubmit;
            return bl2;
        }
        finally {
            this.writeUnlock();
        }
    }

    public void submitAFlushTaskWhenShouldFlush(TsFileProcessor tsFileProcessor) {
        this.writeLock("submitAFlushTaskWhenShouldFlush");
        try {
            if (tsFileProcessor.shouldFlush()) {
                this.fileFlushPolicy.apply(this, tsFileProcessor, tsFileProcessor.isSequence());
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    private TsFileProcessor getOrCreateTsFileProcessor(long timeRangeId, boolean sequence) {
        TsFileProcessor tsFileProcessor = null;
        int retryCnt = 0;
        do {
            try {
                if (sequence) {
                    tsFileProcessor = this.getOrCreateTsFileProcessorIntern(timeRangeId, this.workSequenceTsFileProcessors, true);
                    continue;
                }
                tsFileProcessor = this.getOrCreateTsFileProcessorIntern(timeRangeId, this.workUnsequenceTsFileProcessors, false);
            }
            catch (DiskSpaceInsufficientException e) {
                logger.error("disk space is insufficient when creating TsFile processor, change system mode to read-only", (Throwable)((Object)e));
                CommonDescriptor.getInstance().getConfig().setNodeStatus(NodeStatus.ReadOnly);
                break;
            }
            catch (IOException e) {
                if (retryCnt < 3) {
                    logger.warn("meet IOException when creating TsFileProcessor, retry it again", (Throwable)e);
                    ++retryCnt;
                    continue;
                }
                logger.error("meet IOException when creating TsFileProcessor, change system mode to error", (Throwable)e);
                CommonDescriptor.getInstance().getConfig().handleUnrecoverableError();
                break;
            }
        } while (tsFileProcessor == null);
        return tsFileProcessor;
    }

    private TsFileProcessor getOrCreateTsFileProcessorIntern(long timeRangeId, TreeMap<Long, TsFileProcessor> tsFileProcessorTreeMap, boolean sequence) throws IOException, DiskSpaceInsufficientException {
        TsFileProcessor res = tsFileProcessorTreeMap.get(timeRangeId);
        if (null == res) {
            TimePartitionManager.getInstance().updateAfterOpeningTsFileProcessor(new DataRegionId(Integer.valueOf(this.dataRegionId).intValue()), timeRangeId);
            res = this.newTsFileProcessor(sequence, timeRangeId);
            tsFileProcessorTreeMap.put(timeRangeId, res);
            this.tsFileManager.add(res.getTsFileResource(), sequence);
        }
        return res;
    }

    private TsFileProcessor newTsFileProcessor(boolean sequence, long timePartitionId) throws IOException, DiskSpaceInsufficientException {
        long version = this.partitionMaxFileVersions.getOrDefault(timePartitionId, 0L) + 1L;
        this.partitionMaxFileVersions.put(timePartitionId, version);
        String filePath = TsFileNameGenerator.generateNewTsFilePathWithMkdir(sequence, this.databaseName, this.dataRegionId, timePartitionId, System.currentTimeMillis(), version, 0, 0);
        return this.getTsFileProcessor(sequence, filePath, timePartitionId);
    }

    private TsFileProcessor getTsFileProcessor(boolean sequence, String filePath, long timePartitionId) throws IOException {
        TsFileProcessor tsFileProcessor = sequence ? new TsFileProcessor(this.databaseName + "-" + this.dataRegionId, this.fsFactory.getFileWithParent(filePath), this.dataRegionInfo, this::closeUnsealedTsFileProcessorCallBack, this::sequenceFlushCallback, true) : new TsFileProcessor(this.databaseName + "-" + this.dataRegionId, this.fsFactory.getFileWithParent(filePath), this.dataRegionInfo, this::closeUnsealedTsFileProcessorCallBack, this::unsequenceFlushCallback, false);
        if (this.enableMemControl) {
            TsFileProcessorInfo tsFileProcessorInfo = new TsFileProcessorInfo(this.dataRegionInfo);
            tsFileProcessor.setTsFileProcessorInfo(tsFileProcessorInfo);
            this.dataRegionInfo.initTsFileProcessorInfo(tsFileProcessor);
        }
        tsFileProcessor.addCloseFileListeners(this.customCloseFileListeners);
        tsFileProcessor.addFlushListeners(this.customFlushListeners);
        tsFileProcessor.setTimeRangeId(timePartitionId);
        return tsFileProcessor;
    }

    private String getNewTsFileName(long timePartitionId) {
        long version = this.partitionMaxFileVersions.getOrDefault(timePartitionId, 0L) + 1L;
        this.partitionMaxFileVersions.put(timePartitionId, version);
        return this.getNewTsFileName(System.currentTimeMillis(), version, 0, 0);
    }

    private String getNewTsFileName(long time, long version, int mergeCnt, int unseqCompactionCnt) {
        return TsFileNameGenerator.generateNewTsFileName(time, version, mergeCnt, unseqCompactionCnt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncCloseOneTsFileProcessor(boolean sequence, TsFileProcessor tsFileProcessor) {
        Object object = this.closeStorageGroupCondition;
        synchronized (object) {
            try {
                this.asyncCloseOneTsFileProcessor(sequence, tsFileProcessor);
                long startTime = System.currentTimeMillis();
                while (this.closingSequenceTsFileProcessor.contains(tsFileProcessor) || this.closingUnSequenceTsFileProcessor.contains(tsFileProcessor)) {
                    this.closeStorageGroupCondition.wait(60000L);
                    if (System.currentTimeMillis() - startTime <= 60000L) continue;
                    logger.warn("{} has spent {}s to wait for closing one tsfile.", (Object)(this.databaseName + "-" + this.dataRegionId), (Object)((System.currentTimeMillis() - startTime) / 1000L));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error("syncCloseOneTsFileProcessor error occurs while waiting for closing the storage group {}", (Object)(this.databaseName + "-" + this.dataRegionId), (Object)e);
            }
        }
    }

    public void asyncCloseOneTsFileProcessor(boolean sequence, TsFileProcessor tsFileProcessor) {
        if (this.closingSequenceTsFileProcessor.contains(tsFileProcessor) || this.closingUnSequenceTsFileProcessor.contains(tsFileProcessor) || tsFileProcessor.alreadyMarkedClosing()) {
            return;
        }
        logger.info("Async close tsfile: {}", (Object)tsFileProcessor.getTsFileResource().getTsFile().getAbsolutePath());
        if (sequence) {
            this.closingSequenceTsFileProcessor.add(tsFileProcessor);
            tsFileProcessor.asyncClose();
            this.workSequenceTsFileProcessors.remove(tsFileProcessor.getTimeRangeId());
            if (!this.workUnsequenceTsFileProcessors.containsKey(tsFileProcessor.getTimeRangeId())) {
                this.timePartitionIdVersionControllerMap.remove(tsFileProcessor.getTimeRangeId());
            }
            logger.info("close a sequence tsfile processor {}", (Object)(this.databaseName + "-" + this.dataRegionId));
        } else {
            this.closingUnSequenceTsFileProcessor.add(tsFileProcessor);
            tsFileProcessor.asyncClose();
            this.workUnsequenceTsFileProcessors.remove(tsFileProcessor.getTimeRangeId());
            if (!this.workSequenceTsFileProcessors.containsKey(tsFileProcessor.getTimeRangeId())) {
                this.timePartitionIdVersionControllerMap.remove(tsFileProcessor.getTimeRangeId());
            }
        }
    }

    public void deleteFolder(String systemDir) {
        logger.info("{} will close all files for deleting data folder {}", (Object)(this.databaseName + "-" + this.dataRegionId), (Object)systemDir);
        this.writeLock("deleteFolder");
        try {
            File dataRegionSystemFolder = SystemFileFactory.INSTANCE.getFile(systemDir + File.separator + this.databaseName, this.dataRegionId);
            org.apache.iotdb.commons.utils.FileUtils.deleteDirectoryAndEmptyParent((File)dataRegionSystemFolder);
        }
        finally {
            this.writeUnlock();
        }
    }

    public void closeAllResources() {
        for (TsFileResource tsFileResource : this.tsFileManager.getTsFileList(false)) {
            try {
                tsFileResource.close();
            }
            catch (IOException e) {
                logger.error("Cannot close a TsFileResource {}", (Object)tsFileResource, (Object)e);
            }
        }
        for (TsFileResource tsFileResource : this.tsFileManager.getTsFileList(true)) {
            try {
                tsFileResource.close();
            }
            catch (IOException e) {
                logger.error("Cannot close a TsFileResource {}", (Object)tsFileResource, (Object)e);
            }
        }
    }

    public void syncDeleteDataFiles() {
        logger.info("{} will close all files for deleting data files", (Object)(this.databaseName + "-" + this.dataRegionId));
        this.writeLock("syncDeleteDataFiles");
        try {
            this.syncCloseAllWorkingTsFileProcessors();
            this.closeAllResources();
            List<TsFileResource> tsFileResourceList = this.tsFileManager.getTsFileList(true);
            tsFileResourceList.addAll(this.tsFileManager.getTsFileList(false));
            tsFileResourceList.forEach(x -> {
                if (x.getModFile().exists()) {
                    TsFileMetricManager.getInstance().decreaseModFileNum(1);
                    TsFileMetricManager.getInstance().decreaseModFileSize(x.getModFile().getSize());
                }
            });
            this.deleteAllSGFolders(DirectoryManager.getInstance().getAllFilesFolders());
            this.workSequenceTsFileProcessors.clear();
            this.workUnsequenceTsFileProcessors.clear();
            this.tsFileManager.clear();
            this.lastFlushTimeMap.clearFlushedTime();
            this.lastFlushTimeMap.clearGlobalFlushedTime();
        }
        finally {
            this.writeUnlock();
        }
    }

    private void deleteAllSGFolders(List<String> folder) {
        for (String tsfilePath : folder) {
            File dataRegionDataFolder = this.fsFactory.getFile(tsfilePath, this.databaseName + File.separator + this.dataRegionId);
            if (!dataRegionDataFolder.exists()) continue;
            org.apache.iotdb.commons.utils.FileUtils.deleteDirectoryAndEmptyParent((File)dataRegionDataFolder);
        }
    }

    public synchronized void checkFilesTTL() {
        if (this.dataTTL == Long.MAX_VALUE) {
            logger.debug("{}: TTL not set, ignore the check", (Object)(this.databaseName + "-" + this.dataRegionId));
            return;
        }
        long ttlLowerBound = DateTimeUtils.currentTime() - this.dataTTL;
        logger.debug("{}: TTL removing files before {}", (Object)(this.databaseName + "-" + this.dataRegionId), (Object)new Date(ttlLowerBound));
        ArrayList<TsFileResource> seqFiles = new ArrayList<TsFileResource>(this.tsFileManager.getTsFileList(true));
        ArrayList<TsFileResource> unseqFiles = new ArrayList<TsFileResource>(this.tsFileManager.getTsFileList(false));
        for (TsFileResource tsFileResource : seqFiles) {
            this.checkFileTTL(tsFileResource, ttlLowerBound, true);
        }
        for (TsFileResource tsFileResource : unseqFiles) {
            this.checkFileTTL(tsFileResource, ttlLowerBound, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFileTTL(TsFileResource resource, long ttlLowerBound, boolean isSeq) {
        if (!resource.isClosed() || !resource.isDeleted() && resource.stillLives(ttlLowerBound)) {
            return;
        }
        if (resource.tryWriteLock()) {
            try {
                resource.remove();
                this.tsFileManager.remove(resource, isSeq);
                logger.info("Removed a file {} before {} by ttl ({} {})", new Object[]{resource.getTsFilePath(), new Date(ttlLowerBound), this.dataTTL, config.getTimestampPrecision()});
            }
            finally {
                resource.writeUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timedFlushSeqMemTable() {
        this.writeLock("timedFlushSeqMemTable");
        try {
            ArrayList<TsFileProcessor> tsFileProcessors = new ArrayList<TsFileProcessor>(this.workSequenceTsFileProcessors.values());
            long timeLowerBound = System.currentTimeMillis() - config.getSeqMemtableFlushInterval();
            for (TsFileProcessor tsFileProcessor : tsFileProcessors) {
                if (tsFileProcessor.getWorkMemTableCreatedTime() >= timeLowerBound) continue;
                logger.info("Exceed sequence memtable flush interval, so flush working memtable of time partition {} in database {}[{}]", new Object[]{tsFileProcessor.getTimeRangeId(), this.databaseName, this.dataRegionId});
                this.fileFlushPolicy.apply(this, tsFileProcessor, tsFileProcessor.isSequence());
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timedFlushUnseqMemTable() {
        this.writeLock("timedFlushUnseqMemTable");
        try {
            ArrayList<TsFileProcessor> tsFileProcessors = new ArrayList<TsFileProcessor>(this.workUnsequenceTsFileProcessors.values());
            long timeLowerBound = System.currentTimeMillis() - config.getUnseqMemtableFlushInterval();
            for (TsFileProcessor tsFileProcessor : tsFileProcessors) {
                if (tsFileProcessor.getWorkMemTableCreatedTime() >= timeLowerBound) continue;
                logger.info("Exceed unsequence memtable flush interval, so flush working memtable of time partition {} in database {}[{}]", new Object[]{tsFileProcessor.getTimeRangeId(), this.databaseName, this.dataRegionId});
                this.fileFlushPolicy.apply(this, tsFileProcessor, tsFileProcessor.isSequence());
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncCloseAllWorkingTsFileProcessors() {
        Object object = this.closeStorageGroupCondition;
        synchronized (object) {
            try {
                this.asyncCloseAllWorkingTsFileProcessors();
                long startTime = System.currentTimeMillis();
                while (!this.closingSequenceTsFileProcessor.isEmpty() || !this.closingUnSequenceTsFileProcessor.isEmpty()) {
                    this.closeStorageGroupCondition.wait(60000L);
                    if (System.currentTimeMillis() - startTime <= 60000L) continue;
                    logger.warn("{} has spent {}s to wait for closing all TsFiles.", (Object)(this.databaseName + "-" + this.dataRegionId), (Object)((System.currentTimeMillis() - startTime) / 1000L));
                }
            }
            catch (InterruptedException e) {
                logger.error("CloseFileNodeCondition error occurs while waiting for closing the storage group {}", (Object)(this.databaseName + "-" + this.dataRegionId), (Object)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    public void asyncCloseAllWorkingTsFileProcessors() {
        this.writeLock("asyncCloseAllWorkingTsFileProcessors");
        try {
            logger.info("async force close all files in database: {}", (Object)(this.databaseName + "-" + this.dataRegionId));
            for (TsFileProcessor tsFileProcessor : new ArrayList<TsFileProcessor>(this.workSequenceTsFileProcessors.values())) {
                this.asyncCloseOneTsFileProcessor(true, tsFileProcessor);
            }
            for (TsFileProcessor tsFileProcessor : new ArrayList<TsFileProcessor>(this.workUnsequenceTsFileProcessors.values())) {
                this.asyncCloseOneTsFileProcessor(false, tsFileProcessor);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    public void forceCloseAllWorkingTsFileProcessors() throws TsFileProcessorException {
        this.writeLock("forceCloseAllWorkingTsFileProcessors");
        try {
            logger.info("force close all processors in database: {}", (Object)(this.databaseName + "-" + this.dataRegionId));
            for (TsFileProcessor tsFileProcessor : new ArrayList<TsFileProcessor>(this.workSequenceTsFileProcessors.values())) {
                tsFileProcessor.putMemTableBackAndClose();
            }
            for (TsFileProcessor tsFileProcessor : new ArrayList<TsFileProcessor>(this.workUnsequenceTsFileProcessors.values())) {
                tsFileProcessor.putMemTableBackAndClose();
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public QueryDataSource query(List<PartialPath> pathList, String singleDeviceId, QueryContext context, Filter timeFilter) throws QueryProcessException {
        try {
            List<TsFileResource> seqResources = this.getFileResourceListForQuery(this.tsFileManager.getTsFileList(true), this.upgradeSeqFileList, pathList, singleDeviceId, context, timeFilter, true);
            List<TsFileResource> unseqResources = this.getFileResourceListForQuery(this.tsFileManager.getTsFileList(false), this.upgradeUnseqFileList, pathList, singleDeviceId, context, timeFilter, false);
            this.queryMetricsManager.recordQueryResourceNum("sequence_tsfile", seqResources.size());
            this.queryMetricsManager.recordQueryResourceNum("unsequence_tsfile", unseqResources.size());
            QueryDataSource dataSource = new QueryDataSource(seqResources, unseqResources);
            dataSource.setDataTTL(this.dataTTL);
            return dataSource;
        }
        catch (MetadataException e) {
            throw new QueryProcessException((IoTDBException)e);
        }
    }

    @Override
    public void readLock() {
        this.insertLock.readLock().lock();
        this.tsFileManager.readLock();
    }

    @Override
    public void readUnlock() {
        this.tsFileManager.readUnlock();
        this.insertLock.readLock().unlock();
    }

    public void writeLock(String holder) {
        this.insertLock.writeLock().lock();
        this.insertWriteLockHolder = holder;
    }

    public void writeUnlock() {
        this.insertWriteLockHolder = "";
        this.insertLock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TsFileResource> getFileResourceListForQuery(Collection<TsFileResource> tsFileResources, List<TsFileResource> upgradeTsFileResources, List<PartialPath> pathList, String singleDeviceId, QueryContext context, Filter timeFilter, boolean isSeq) throws MetadataException {
        if (context.isDebug()) {
            DEBUG_LOGGER.info("Path: {}, get tsfile list: {} isSeq: {} timefilter: {}", new Object[]{pathList, tsFileResources, isSeq, timeFilter == null ? "null" : timeFilter});
        }
        ArrayList<TsFileResource> tsfileResourcesForQuery = new ArrayList<TsFileResource>();
        long timeLowerBound = this.dataTTL != Long.MAX_VALUE ? DateTimeUtils.currentTime() - this.dataTTL : Long.MIN_VALUE;
        context.setQueryTimeLowerBound(timeLowerBound);
        for (TsFileResource tsFileResource : upgradeTsFileResources) {
            if (!tsFileResource.isSatisfied(singleDeviceId, timeFilter, isSeq, this.dataTTL, context.isDebug())) continue;
            this.closeQueryLock.readLock().lock();
            try {
                tsfileResourcesForQuery.add(tsFileResource);
            }
            finally {
                this.closeQueryLock.readLock().unlock();
            }
        }
        for (TsFileResource tsFileResource : tsFileResources) {
            if (!tsFileResource.isSatisfied(singleDeviceId, timeFilter, isSeq, this.dataTTL, context.isDebug())) continue;
            this.closeQueryLock.readLock().lock();
            try {
                if (tsFileResource.isClosed()) {
                    tsfileResourcesForQuery.add(tsFileResource);
                    continue;
                }
                tsFileResource.getProcessor().query(pathList, context, tsfileResourcesForQuery);
            }
            catch (IOException e) {
                throw new MetadataException((Throwable)e);
            }
            finally {
                this.closeQueryLock.readLock().unlock();
            }
        }
        return tsfileResourcesForQuery;
    }

    private void separateTsFile(List<TsFileResource> sealedResource, List<TsFileResource> unsealedResource) {
        this.tsFileManager.getTsFileList(true).forEach(tsFileResource -> {
            if (tsFileResource.isClosed()) {
                sealedResource.add((TsFileResource)tsFileResource);
            } else {
                unsealedResource.add((TsFileResource)tsFileResource);
            }
        });
        this.tsFileManager.getTsFileList(false).forEach(tsFileResource -> {
            if (tsFileResource.isClosed()) {
                sealedResource.add((TsFileResource)tsFileResource);
            } else {
                unsealedResource.add((TsFileResource)tsFileResource);
            }
        });
    }

    public void deleteByDevice(PartialPath pattern, long startTime, long endTime, long searchIndex, TimePartitionFilter timePartitionFilter) throws IOException {
        if (this.upgradeFileCount.get() != 0) {
            throw new IOException("Delete failed. Please do not delete until the old files upgraded.");
        }
        if (SettleService.getINSTANCE().getFilesToBeSettledCount().get() != 0) {
            throw new IOException("Delete failed. Please do not delete until the old files settled.");
        }
        this.writeLock("delete");
        ArrayList<ModificationFile> updatedModFiles = new ArrayList<ModificationFile>();
        boolean hasReleasedLock = false;
        try {
            HashSet<PartialPath> devicePaths = new HashSet<PartialPath>(pattern.getDevicePathPattern());
            DataNodeSchemaCache.getInstance().invalidateAll();
            List<WALFlushListener> walListeners = this.logDeletionInWAL(startTime, endTime, searchIndex, pattern, timePartitionFilter);
            for (WALFlushListener walFlushListener : walListeners) {
                if (walFlushListener.waitForResult() != AbstractResultListener.Status.FAILURE) continue;
                logger.error("Fail to log delete to wal.", (Throwable)walFlushListener.getCause());
                throw walFlushListener.getCause();
            }
            Deletion deletion = new Deletion(pattern, 1L, startTime, endTime);
            ArrayList<TsFileResource> sealedTsFileResource = new ArrayList<TsFileResource>();
            ArrayList<TsFileResource> unsealedTsFileResource = new ArrayList<TsFileResource>();
            this.separateTsFile(sealedTsFileResource, unsealedTsFileResource);
            this.deleteDataInFiles(unsealedTsFileResource, deletion, devicePaths, updatedModFiles, timePartitionFilter);
            this.writeUnlock();
            hasReleasedLock = true;
            this.deleteDataInFiles(sealedTsFileResource, deletion, devicePaths, updatedModFiles, timePartitionFilter);
        }
        catch (Exception e) {
            for (ModificationFile modFile : updatedModFiles) {
                modFile.abort();
                modFile.close();
            }
            throw new IOException(e);
        }
        finally {
            if (!hasReleasedLock) {
                this.writeUnlock();
            }
        }
    }

    private List<WALFlushListener> logDeletionInWAL(long startTime, long endTime, long searchIndex, PartialPath path, TimePartitionFilter timePartitionFilter) {
        WALFlushListener walFlushListener;
        long timePartitionStartId = StorageEngine.getTimePartition(startTime);
        long timePartitionEndId = StorageEngine.getTimePartition(endTime);
        ArrayList<WALFlushListener> walFlushListeners = new ArrayList<WALFlushListener>();
        if (config.getWalMode() == WALMode.DISABLE) {
            return walFlushListeners;
        }
        DeleteDataNode deleteDataNode = new DeleteDataNode(new PlanNodeId(""), Collections.singletonList(path), startTime, endTime);
        deleteDataNode.setSearchIndex(searchIndex);
        for (Map.Entry<Long, TsFileProcessor> entry : this.workSequenceTsFileProcessors.entrySet()) {
            if (timePartitionStartId > entry.getKey() || entry.getKey() > timePartitionEndId || timePartitionFilter != null && !timePartitionFilter.satisfy(this.databaseName, entry.getKey())) continue;
            walFlushListener = entry.getValue().logDeleteDataNodeInWAL(deleteDataNode);
            walFlushListeners.add(walFlushListener);
        }
        for (Map.Entry<Long, TsFileProcessor> entry : this.workUnsequenceTsFileProcessors.entrySet()) {
            if (timePartitionStartId > entry.getKey() || entry.getKey() > timePartitionEndId || timePartitionFilter != null && !timePartitionFilter.satisfy(this.databaseName, entry.getKey())) continue;
            walFlushListener = entry.getValue().logDeleteDataNodeInWAL(deleteDataNode);
            walFlushListeners.add(walFlushListener);
        }
        return walFlushListeners;
    }

    private boolean canSkipDelete(TsFileResource tsFileResource, Set<PartialPath> devicePaths, long deleteStart, long deleteEnd, TimePartitionFilter timePartitionFilter) {
        if (timePartitionFilter != null && !timePartitionFilter.satisfy(this.databaseName, tsFileResource.getTimePartition())) {
            return true;
        }
        for (PartialPath device : devicePaths) {
            long deviceEndTime;
            long deviceStartTime;
            if (device.hasWildcard()) {
                Pair<Long, Long> startAndEndTime = tsFileResource.getPossibleStartTimeAndEndTime(device);
                if (startAndEndTime == null) continue;
                deviceStartTime = (Long)startAndEndTime.getLeft();
                deviceEndTime = (Long)startAndEndTime.getRight();
            } else {
                String deviceId = device.getFullPath();
                if (!tsFileResource.mayContainsDevice(deviceId)) continue;
                deviceStartTime = tsFileResource.getStartTime(deviceId);
                deviceEndTime = tsFileResource.getEndTime(deviceId);
            }
            if (!(!tsFileResource.isClosed() && deviceEndTime == Long.MIN_VALUE ? deleteEnd >= deviceStartTime : deleteEnd >= deviceStartTime && deleteStart <= deviceEndTime)) continue;
            return false;
        }
        return true;
    }

    private void deleteDataInFiles(Collection<TsFileResource> tsFileResourceList, Deletion deletion, Set<PartialPath> devicePaths, List<ModificationFile> updatedModFiles, TimePartitionFilter timePartitionFilter) throws IOException {
        for (TsFileResource tsFileResource : tsFileResourceList) {
            if (this.canSkipDelete(tsFileResource, devicePaths, deletion.getStartTime(), deletion.getEndTime(), timePartitionFilter)) continue;
            if (tsFileResource.isClosed()) {
                if (tsFileResource.isCompacting()) {
                    deletion.setFileOffset(Long.MAX_VALUE);
                    tsFileResource.getCompactionModFile().write(deletion);
                    tsFileResource.getModFile().write(deletion);
                    tsFileResource.getCompactionModFile().close();
                    tsFileResource.getModFile().close();
                } else {
                    deletion.setFileOffset(tsFileResource.getTsFileSize());
                    boolean modFileExists = tsFileResource.getModFile().exists();
                    long originSize = tsFileResource.getModFile().getSize();
                    tsFileResource.getModFile().write(deletion);
                    tsFileResource.getModFile().close();
                    if (!modFileExists) {
                        TsFileMetricManager.getInstance().increaseModFileNum(1);
                    }
                    TsFileMetricManager.getInstance().increaseModFileSize(tsFileResource.getModFile().getSize() - originSize);
                }
                logger.info("[Deletion] Deletion with path:{}, time:{}-{} written into mods file:{}.", new Object[]{deletion.getPath(), deletion.getStartTime(), deletion.getEndTime(), tsFileResource.getModFile().getFilePath()});
            } else {
                tsFileResource.getProcessor().deleteDataInMemory(deletion, devicePaths);
            }
            for (ISyncManager syncManager : SyncService.getInstance().getOrCreateSyncManager(this.dataRegionId)) {
                syncManager.syncRealTimeDeletion(deletion);
            }
            updatedModFiles.add(tsFileResource.getModFile());
        }
    }

    private void unsequenceFlushCallback(TsFileProcessor processor, Map<String, Long> updateMap, long systemFlushTime) {
        TimePartitionManager.getInstance().updateAfterFlushing(new DataRegionId(Integer.valueOf(this.dataRegionId).intValue()), processor.getTimeRangeId(), systemFlushTime, this.lastFlushTimeMap.getMemSize(processor.getTimeRangeId()), this.workSequenceTsFileProcessors.get(processor.getTimeRangeId()) != null);
    }

    private void sequenceFlushCallback(TsFileProcessor processor, Map<String, Long> updateMap, long systemFlushTime) {
        this.lastFlushTimeMap.updateLatestFlushTime(processor.getTimeRangeId(), updateMap);
        TimePartitionManager.getInstance().updateAfterFlushing(new DataRegionId(Integer.valueOf(this.dataRegionId).intValue()), processor.getTimeRangeId(), systemFlushTime, this.lastFlushTimeMap.getMemSize(processor.getTimeRangeId()), this.workUnsequenceTsFileProcessors.get(processor.getTimeRangeId()) != null);
    }

    public void updateNewlyFlushedPartitionLatestFlushedTimeForEachDevice(long partitionId, String deviceId, long time) {
        this.lastFlushTimeMap.updateNewlyFlushedPartitionLatestFlushedTimeForEachDevice(partitionId, deviceId, time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeUnsealedTsFileProcessorCallBack(TsFileProcessor tsFileProcessor) throws TsFileProcessorException {
        this.closeQueryLock.writeLock().lock();
        try {
            tsFileProcessor.close();
            if (tsFileProcessor.isEmpty()) {
                try {
                    this.fsFactory.deleteIfExists(tsFileProcessor.getTsFileResource().getTsFile());
                    this.tsFileManager.remove(tsFileProcessor.getTsFileResource(), tsFileProcessor.isSequence());
                }
                catch (IOException e) {
                    logger.error("Remove empty file {} error", (Object)tsFileProcessor.getTsFileResource().getTsFile().getAbsolutePath());
                }
            } else {
                this.tsFileResourceManager.registerSealedTsFileResource(tsFileProcessor.getTsFileResource());
            }
        }
        finally {
            this.closeQueryLock.writeLock().unlock();
        }
        if (this.closingSequenceTsFileProcessor.contains(tsFileProcessor)) {
            this.closingSequenceTsFileProcessor.remove(tsFileProcessor);
        } else {
            this.closingUnSequenceTsFileProcessor.remove(tsFileProcessor);
        }
        Object object = this.closeStorageGroupCondition;
        synchronized (object) {
            this.closeStorageGroupCondition.notifyAll();
        }
        TsFileMetricManager.getInstance().addFile(tsFileProcessor.getTsFileResource().getTsFileSize(), tsFileProcessor.isSequence());
        logger.info("signal closing database condition in {}", (Object)(this.databaseName + "-" + this.dataRegionId));
    }

    protected void executeCompaction() {
        try {
            ArrayList<Long> timePartitions = new ArrayList<Long>(this.tsFileManager.getTimePartitions());
            timePartitions.sort(Comparator.reverseOrder());
            Iterator iterator = timePartitions.iterator();
            while (iterator.hasNext()) {
                long timePartition = (Long)iterator.next();
                CompactionScheduler.scheduleCompaction(this.tsFileManager, timePartition);
            }
        }
        catch (Throwable e) {
            logger.error("Meet error in compaction schedule.", e);
        }
    }

    public int countUpgradeFiles() {
        return this.upgradeFileCount.get();
    }

    public void upgrade() {
        for (TsFileResource seqTsFileResource : this.upgradeSeqFileList) {
            seqTsFileResource.setUpgradeTsFileResourceCallBack(this::upgradeTsFileResourceCallBack);
            seqTsFileResource.doUpgrade();
        }
        for (TsFileResource unseqTsFileResource : this.upgradeUnseqFileList) {
            unseqTsFileResource.setUpgradeTsFileResourceCallBack(this::upgradeTsFileResourceCallBack);
            unseqTsFileResource.doUpgrade();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeTsFileResourceCallBack(TsFileResource tsFileResource) {
        List<TsFileResource> upgradedResources = tsFileResource.getUpgradedResources();
        for (TsFileResource resource : upgradedResources) {
            long partitionId = resource.getTimePartition();
            resource.getDevices().forEach(device -> this.updateNewlyFlushedPartitionLatestFlushedTimeForEachDevice(partitionId, (String)device, resource.getEndTime((String)device)));
        }
        this.upgradeFileCount.getAndAdd(-1);
        if (this.upgradeFileCount.get() == 0) {
            this.writeLock("upgradeTsFileResourceCallBack");
            try {
                this.loadUpgradedResources(this.upgradeSeqFileList, true);
                this.loadUpgradedResources(this.upgradeUnseqFileList, false);
            }
            finally {
                this.writeUnlock();
            }
            this.lastFlushTimeMap.applyNewlyFlushedTimeToFlushedTime();
        }
    }

    private void settleTsFileCallBack(TsFileResource oldTsFileResource, List<TsFileResource> newTsFileResources) throws WriteProcessException {
        oldTsFileResource.readUnlock();
        oldTsFileResource.writeLock();
        try {
            TsFileAndModSettleTool.moveNewTsFile(oldTsFileResource, newTsFileResources);
            if (TsFileAndModSettleTool.getInstance().recoverSettleFileMap.size() != 0) {
                TsFileAndModSettleTool.getInstance().recoverSettleFileMap.remove(oldTsFileResource.getTsFile().getAbsolutePath());
            }
            DataRegion.operateClearCache();
            if (!oldTsFileResource.getTsFile().exists()) {
                this.tsFileManager.remove(oldTsFileResource, oldTsFileResource.isSeq());
            }
            FileReaderManager.getInstance().closeFileAndRemoveReader(oldTsFileResource.getTsFilePath());
            oldTsFileResource.setSettleTsFileCallBack(null);
            SettleService.getINSTANCE().getFilesToBeSettledCount().addAndGet(-1);
        }
        catch (IOException e) {
            logger.error("Exception to move new tsfile in settling", (Throwable)e);
            throw new WriteProcessException("Meet error when settling file: " + oldTsFileResource.getTsFile().getAbsolutePath(), e);
        }
        finally {
            oldTsFileResource.writeUnlock();
        }
    }

    public static void operateClearCache() {
        ChunkCache.getInstance().clear();
        TimeSeriesMetadataCache.getInstance().clear();
        BloomFilterCache.getInstance().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadUpgradedResources(List<TsFileResource> resources, boolean isseq) {
        if (resources.isEmpty()) {
            return;
        }
        for (TsFileResource resource : resources) {
            resource.writeLock();
            try {
                UpgradeUtils.moveUpgradedFiles(resource);
                this.tsFileManager.addAll(resource.getUpgradedResources(), isseq);
                resource.delete();
                Files.deleteIfExists(this.fsFactory.getFile(resource.getTsFile().toPath() + ".mods").toPath());
                UpgradeLog.writeUpgradeLogFile(resource.getTsFile().getAbsolutePath() + "," + (Object)((Object)UpgradeCheckStatus.UPGRADE_SUCCESS));
            }
            catch (IOException e) {
                logger.error("Unable to load {}, caused by ", (Object)resource, (Object)e);
            }
            finally {
                resource.writeUnlock();
            }
        }
        if (resources.get(0).getTsFile().getParentFile().isDirectory() && resources.get(0).getTsFile().getParentFile().listFiles().length == 0) {
            try {
                Files.delete(resources.get(0).getTsFile().getParentFile().toPath());
            }
            catch (IOException e) {
                logger.error("Delete upgrade folder {} failed, caused by ", (Object)resources.get(0).getTsFile().getParentFile(), (Object)e);
            }
        }
        resources.clear();
    }

    public void compact() {
        this.writeLock("merge");
        try {
            this.executeCompaction();
        }
        finally {
            this.writeUnlock();
        }
    }

    private void resetLastCacheWhenLoadingTsFile() throws IllegalPathException {
        if (!IoTDBDescriptor.getInstance().getConfig().isLastCacheEnabled()) {
            return;
        }
        DataNodeSchemaCache.getInstance().invalidateAll();
    }

    public void loadNewTsFile(TsFileResource newTsFileResource, boolean deleteOriginFile) throws LoadFileException {
        File tsfileToBeInserted = newTsFileResource.getTsFile();
        long newFilePartitionId = newTsFileResource.getTimePartitionWithCheck();
        this.writeLock("loadNewTsFile");
        try {
            TsFileResourceList sequenceList = this.tsFileManager.getOrCreateSequenceListByTimePartition(newFilePartitionId);
            int insertPos = this.findInsertionPosition(newTsFileResource, sequenceList);
            LoadTsFileType tsFileType = this.getLoadingTsFileType(insertPos, sequenceList);
            String renameInfo = tsFileType == LoadTsFileType.LOAD_SEQUENCE ? "sequence" : "unsequence";
            newTsFileResource.setSeq(tsFileType == LoadTsFileType.LOAD_SEQUENCE);
            String newFileName = this.getLoadingTsFileName(tsFileType, insertPos, newTsFileResource, sequenceList);
            if (!newFileName.equals(tsfileToBeInserted.getName())) {
                logger.info("TsFile {} must be renamed to {} for loading into the " + renameInfo + " list.", (Object)tsfileToBeInserted.getName(), (Object)newFileName);
                newTsFileResource.setFile(this.fsFactory.getFile(tsfileToBeInserted.getParentFile(), newFileName));
            }
            this.loadTsFileByType(tsFileType, tsfileToBeInserted, newTsFileResource, newFilePartitionId, insertPos, deleteOriginFile);
            TsFileMetricManager.getInstance().addFile(newTsFileResource.getTsFile().length(), tsFileType == LoadTsFileType.LOAD_SEQUENCE);
            this.resetLastCacheWhenLoadingTsFile();
            this.updateLastFlushTime(newTsFileResource);
            long partitionNum = newTsFileResource.getTimePartition();
            this.updatePartitionFileVersion(partitionNum, newTsFileResource.getVersion());
            logger.info("TsFile {} is successfully loaded in {} list.", (Object)newFileName, (Object)renameInfo);
        }
        catch (DiskSpaceInsufficientException e) {
            logger.error("Failed to append the tsfile {} to database processor {} because the disk space is insufficient.", (Object)tsfileToBeInserted.getAbsolutePath(), (Object)tsfileToBeInserted.getParentFile().getName());
            throw new LoadFileException((Exception)((Object)e));
        }
        catch (IllegalPathException e) {
            logger.error("Failed to reset last cache when loading file {}", (Object)newTsFileResource.getTsFilePath());
            throw new LoadFileException((Exception)((Object)e));
        }
        finally {
            this.writeUnlock();
        }
    }

    public void setPartitionFileVersionToMax(long partition, long version) {
        this.partitionMaxFileVersions.compute(partition, (prt, oldVer) -> this.computeMaxVersion((Long)oldVer, version));
    }

    private long computeMaxVersion(Long oldVersion, Long newVersion) {
        if (oldVersion == null) {
            return newVersion;
        }
        return Math.max(oldVersion, newVersion);
    }

    private Long getTsFileResourceEstablishTime(TsFileResource tsFileResource) {
        String tsFileName = tsFileResource.getTsFile().getName();
        return Long.parseLong(tsFileName.split("-")[0]);
    }

    private LoadTsFileType getLoadingTsFileType(int insertPos, List<TsFileResource> sequenceList) {
        if (insertPos == -3) {
            return LoadTsFileType.LOAD_UNSEQUENCE;
        }
        if (insertPos == sequenceList.size() - 1) {
            return LoadTsFileType.LOAD_SEQUENCE;
        }
        long preTime = insertPos == -1 ? 0L : this.getTsFileResourceEstablishTime(sequenceList.get(insertPos));
        long subsequenceTime = this.getTsFileResourceEstablishTime(sequenceList.get(insertPos + 1));
        return preTime == subsequenceTime ? LoadTsFileType.LOAD_UNSEQUENCE : LoadTsFileType.LOAD_SEQUENCE;
    }

    private int findInsertionPosition(TsFileResource newTsFileResource, List<TsFileResource> sequenceList) {
        int insertPos = -1;
        int i = 0;
        while (i < sequenceList.size()) {
            TsFileResource localFile = sequenceList.get(i);
            if (!localFile.isClosed() && localFile.getProcessor() != null) {
                this.syncCloseOneTsFileProcessor(true, localFile.getProcessor());
            }
            int fileComparison = this.compareTsFileDevices(newTsFileResource, localFile);
            switch (fileComparison) {
                case 0: {
                    return -3;
                }
                case -1: {
                    return i - 1;
                }
            }
            insertPos = i++;
        }
        return insertPos;
    }

    private int compareTsFileDevices(TsFileResource fileA, TsFileResource fileB) {
        boolean hasPre = false;
        boolean hasSubsequence = false;
        Set<String> fileADevices = fileA.getDevices();
        Set<String> fileBDevices = fileB.getDevices();
        for (String device : fileADevices) {
            if (!fileBDevices.contains(device)) continue;
            long startTimeA = fileA.getStartTime(device);
            long endTimeA = fileA.getEndTime(device);
            long startTimeB = fileB.getStartTime(device);
            long endTimeB = fileB.getEndTime(device);
            if (startTimeA > endTimeB) {
                hasPre = true;
                continue;
            }
            if (startTimeB > endTimeA) {
                hasSubsequence = true;
                continue;
            }
            return 0;
        }
        if (hasPre && hasSubsequence) {
            return 0;
        }
        if (!hasPre && hasSubsequence) {
            return -1;
        }
        return 1;
    }

    public void removeFullyOverlapFiles(TsFileResource resource) {
        this.writeLock("removeFullyOverlapFiles");
        try {
            Iterator<TsFileResource> iterator = this.tsFileManager.getIterator(true);
            this.removeFullyOverlapFiles(resource, iterator, true);
            iterator = this.tsFileManager.getIterator(false);
            this.removeFullyOverlapFiles(resource, iterator, false);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFullyOverlapFiles(TsFileResource newTsFile, Iterator<TsFileResource> iterator, boolean isSeq) {
        while (iterator.hasNext()) {
            TsFileResource existingTsFile = iterator.next();
            if (!newTsFile.isPlanRangeCovers(existingTsFile) || newTsFile.getTsFile().equals(existingTsFile.getTsFile()) || !existingTsFile.tryWriteLock()) continue;
            logger.info("{} is covered by {}: [{}, {}], [{}, {}], remove it", new Object[]{existingTsFile, newTsFile, existingTsFile.minPlanIndex, existingTsFile.maxPlanIndex, newTsFile.minPlanIndex, newTsFile.maxPlanIndex});
            try {
                this.removeFullyOverlapFile(existingTsFile, iterator, isSeq);
            }
            catch (Exception e) {
                logger.error("Something gets wrong while removing FullyOverlapFiles: {}", (Object)existingTsFile.getTsFile().getAbsolutePath(), (Object)e);
            }
            finally {
                existingTsFile.writeUnlock();
            }
        }
    }

    private void removeFullyOverlapFile(TsFileResource tsFileResource, Iterator<TsFileResource> iterator, boolean isSeq) {
        logger.info("Removing a covered file {}, closed: {}", (Object)tsFileResource, (Object)tsFileResource.isClosed());
        if (!tsFileResource.isClosed()) {
            try {
                long timePartition = tsFileResource.getTimePartition();
                TreeMap<Long, TsFileProcessor> fileProcessorMap = isSeq ? this.workSequenceTsFileProcessors : this.workUnsequenceTsFileProcessors;
                TsFileProcessor tsFileProcessor = (TsFileProcessor)fileProcessorMap.get(timePartition);
                if (tsFileProcessor != null && tsFileProcessor.getTsFileResource() == tsFileResource) {
                    tsFileProcessor.syncClose();
                    fileProcessorMap.remove(timePartition);
                }
            }
            catch (Exception e) {
                logger.error("Cannot close {}", (Object)tsFileResource, (Object)e);
            }
        }
        this.tsFileManager.remove(tsFileResource, isSeq);
        iterator.remove();
        tsFileResource.remove();
    }

    private String getLoadingTsFileName(LoadTsFileType tsFileType, int insertIndex, TsFileResource newTsFileResource, List<TsFileResource> sequenceList) {
        long timePartitionId = newTsFileResource.getTimePartition();
        if (tsFileType == LoadTsFileType.LOAD_UNSEQUENCE || insertIndex == sequenceList.size() - 1) {
            return this.getNewTsFileName(System.currentTimeMillis(), this.getAndSetNewVersion(timePartitionId, newTsFileResource), 0, 0);
        }
        long preTime = insertIndex == -1 ? 0L : this.getTsFileResourceEstablishTime(sequenceList.get(insertIndex));
        long subsequenceTime = this.getTsFileResourceEstablishTime(sequenceList.get(insertIndex + 1));
        long meanTime = preTime + (subsequenceTime - preTime >> 1);
        return this.getNewTsFileName(meanTime, this.getAndSetNewVersion(timePartitionId, newTsFileResource), 0, 0);
    }

    private long getAndSetNewVersion(long timePartitionId, TsFileResource tsFileResource) {
        long version = this.partitionMaxFileVersions.getOrDefault(timePartitionId, 0L) + 1L;
        this.partitionMaxFileVersions.put(timePartitionId, version);
        tsFileResource.setVersion(version);
        return version;
    }

    private void updateLastFlushTime(TsFileResource newTsFileResource) {
        for (String device : newTsFileResource.getDevices()) {
            long endTime = newTsFileResource.getEndTime(device);
            long timePartitionId = StorageEngine.getTimePartition(endTime);
            this.lastFlushTimeMap.updateFlushedTime(timePartitionId, device, endTime);
            this.lastFlushTimeMap.updateGlobalFlushedTime(device, endTime);
        }
    }

    private boolean loadTsFileByType(LoadTsFileType type, File tsFileToLoad, TsFileResource tsFileResource, long filePartitionId, int insertPos, boolean deleteOriginFile) throws LoadFileException, DiskSpaceInsufficientException {
        File targetFile;
        switch (type) {
            case LOAD_UNSEQUENCE: {
                targetFile = this.fsFactory.getFile(DirectoryManager.getInstance().getNextFolderForUnSequenceFile(), this.databaseName + File.separatorChar + this.dataRegionId + File.separatorChar + filePartitionId + File.separator + tsFileResource.getTsFile().getName());
                tsFileResource.setFile(targetFile);
                if (this.tsFileManager.contains(tsFileResource, false)) {
                    logger.error("The file {} has already been loaded in unsequence list", (Object)tsFileResource);
                    return false;
                }
                this.tsFileManager.add(tsFileResource, false);
                logger.info("Load tsfile in unsequence list, move file from {} to {}", (Object)tsFileToLoad.getAbsolutePath(), (Object)targetFile.getAbsolutePath());
                break;
            }
            case LOAD_SEQUENCE: {
                targetFile = this.fsFactory.getFile(DirectoryManager.getInstance().getNextFolderForSequenceFile(), this.databaseName + File.separatorChar + this.dataRegionId + File.separatorChar + filePartitionId + File.separator + tsFileResource.getTsFile().getName());
                tsFileResource.setFile(targetFile);
                if (this.tsFileManager.contains(tsFileResource, true)) {
                    logger.error("The file {} has already been loaded in sequence list", (Object)tsFileResource);
                    return false;
                }
                if (insertPos == -1) {
                    this.tsFileManager.insertToPartitionFileList(tsFileResource, filePartitionId, true, 0);
                } else {
                    this.tsFileManager.insertToPartitionFileList(tsFileResource, filePartitionId, true, insertPos + 1);
                }
                logger.info("Load tsfile in sequence list, move file from {} to {}", (Object)tsFileToLoad.getAbsolutePath(), (Object)targetFile.getAbsolutePath());
                break;
            }
            default: {
                throw new LoadFileException(String.format("Unsupported type of loading tsfile : %s", new Object[]{type}));
            }
        }
        if (!targetFile.getParentFile().exists()) {
            targetFile.getParentFile().mkdirs();
        }
        try {
            if (deleteOriginFile) {
                FileUtils.moveFile((File)tsFileToLoad, (File)targetFile);
            } else {
                Files.copy(tsFileToLoad.toPath(), targetFile.toPath(), new CopyOption[0]);
            }
        }
        catch (IOException e) {
            logger.error("File renaming failed when loading tsfile. Origin: {}, Target: {}", new Object[]{tsFileToLoad.getAbsolutePath(), targetFile.getAbsolutePath(), e});
            throw new LoadFileException(String.format("File renaming failed when loading tsfile. Origin: %s, Target: %s, because %s", tsFileToLoad.getAbsolutePath(), targetFile.getAbsolutePath(), e.getMessage()));
        }
        File resourceFileToLoad = this.fsFactory.getFile(tsFileToLoad.getAbsolutePath() + ".resource");
        File targetResourceFile = this.fsFactory.getFile(targetFile.getAbsolutePath() + ".resource");
        try {
            if (deleteOriginFile) {
                FileUtils.moveFile((File)resourceFileToLoad, (File)targetResourceFile);
            } else {
                Files.copy(resourceFileToLoad.toPath(), targetResourceFile.toPath(), new CopyOption[0]);
            }
        }
        catch (IOException e) {
            logger.error("File renaming failed when loading .resource file. Origin: {}, Target: {}", new Object[]{resourceFileToLoad.getAbsolutePath(), targetResourceFile.getAbsolutePath(), e});
            throw new LoadFileException(String.format("File renaming failed when loading .resource file. Origin: %s, Target: %s, because %s", resourceFileToLoad.getAbsolutePath(), targetResourceFile.getAbsolutePath(), e.getMessage()));
        }
        File modFileToLoad = this.fsFactory.getFile(tsFileToLoad.getAbsolutePath() + ".mods");
        if (modFileToLoad.exists()) {
            File targetModFile = this.fsFactory.getFile(targetFile.getAbsolutePath() + ".mods");
            try {
                Files.deleteIfExists(targetModFile.toPath());
            }
            catch (IOException e) {
                logger.warn("Cannot delete localModFile {}", (Object)targetModFile, (Object)e);
            }
            try {
                if (deleteOriginFile) {
                    FileUtils.moveFile((File)modFileToLoad, (File)targetModFile);
                } else {
                    Files.copy(modFileToLoad.toPath(), targetModFile.toPath(), new CopyOption[0]);
                }
            }
            catch (IOException e) {
                logger.error("File renaming failed when loading .mod file. Origin: {}, Target: {}", new Object[]{modFileToLoad.getAbsolutePath(), targetModFile.getAbsolutePath(), e});
                throw new LoadFileException(String.format("File renaming failed when loading .mod file. Origin: %s, Target: %s, because %s", modFileToLoad.getAbsolutePath(), targetModFile.getAbsolutePath(), e.getMessage()));
            }
            finally {
                tsFileResource.setModFile(null);
            }
        }
        this.updatePartitionFileVersion(filePartitionId, tsFileResource.getVersion());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteTsfile(File tsfieToBeDeleted) {
        TsFileResource tsFileResourceToBeDeleted;
        block9: {
            this.writeLock("deleteTsfile");
            tsFileResourceToBeDeleted = null;
            try {
                Iterator<TsFileResource> sequenceIterator = this.tsFileManager.getIterator(true);
                while (sequenceIterator.hasNext()) {
                    TsFileResource sequenceResource = sequenceIterator.next();
                    if (!sequenceResource.getTsFile().getName().equals(tsfieToBeDeleted.getName())) continue;
                    tsFileResourceToBeDeleted = sequenceResource;
                    this.tsFileManager.remove(tsFileResourceToBeDeleted, true);
                    break;
                }
                if (tsFileResourceToBeDeleted != null) break block9;
                Iterator<TsFileResource> unsequenceIterator = this.tsFileManager.getIterator(false);
                while (unsequenceIterator.hasNext()) {
                    TsFileResource unsequenceResource = unsequenceIterator.next();
                    if (!unsequenceResource.getTsFile().getName().equals(tsfieToBeDeleted.getName())) continue;
                    tsFileResourceToBeDeleted = unsequenceResource;
                    this.tsFileManager.remove(tsFileResourceToBeDeleted, false);
                    break;
                }
            }
            finally {
                this.writeUnlock();
            }
        }
        if (tsFileResourceToBeDeleted == null) {
            return false;
        }
        tsFileResourceToBeDeleted.writeLock();
        try {
            tsFileResourceToBeDeleted.remove();
            logger.info("Delete tsfile {} successfully.", (Object)tsFileResourceToBeDeleted.getTsFile());
        }
        finally {
            tsFileResourceToBeDeleted.writeUnlock();
        }
        return true;
    }

    public Collection<TsFileProcessor> getWorkSequenceTsFileProcessors() {
        return this.workSequenceTsFileProcessors.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unloadTsfile(File fileToBeUnloaded, File targetDir) {
        TsFileResource tsFileResourceToBeMoved;
        block9: {
            this.writeLock("unloadTsfile");
            tsFileResourceToBeMoved = null;
            try {
                Iterator<TsFileResource> sequenceIterator = this.tsFileManager.getIterator(true);
                while (sequenceIterator.hasNext()) {
                    TsFileResource sequenceResource = sequenceIterator.next();
                    if (!sequenceResource.getTsFile().getName().equals(fileToBeUnloaded.getName())) continue;
                    tsFileResourceToBeMoved = sequenceResource;
                    this.tsFileManager.remove(tsFileResourceToBeMoved, true);
                    break;
                }
                if (tsFileResourceToBeMoved != null) break block9;
                Iterator<TsFileResource> unsequenceIterator = this.tsFileManager.getIterator(false);
                while (unsequenceIterator.hasNext()) {
                    TsFileResource unsequenceResource = unsequenceIterator.next();
                    if (!unsequenceResource.getTsFile().getName().equals(fileToBeUnloaded.getName())) continue;
                    tsFileResourceToBeMoved = unsequenceResource;
                    this.tsFileManager.remove(tsFileResourceToBeMoved, false);
                    break;
                }
            }
            finally {
                this.writeUnlock();
            }
        }
        if (tsFileResourceToBeMoved == null) {
            return false;
        }
        tsFileResourceToBeMoved.writeLock();
        try {
            tsFileResourceToBeMoved.moveTo(targetDir);
            logger.info("Move tsfile {} to target dir {} successfully.", (Object)tsFileResourceToBeMoved.getTsFile(), (Object)targetDir.getPath());
        }
        finally {
            tsFileResourceToBeMoved.writeUnlock();
        }
        return true;
    }

    public Collection<TsFileProcessor> getWorkUnsequenceTsFileProcessors() {
        return this.workUnsequenceTsFileProcessors.values();
    }

    public void setDataTTLWithTimePrecisionCheck(long dataTTL) {
        if (dataTTL != Long.MAX_VALUE) {
            dataTTL = DateTimeUtils.convertMilliTimeWithPrecision(dataTTL, IoTDBDescriptor.getInstance().getConfig().getTimestampPrecision());
        }
        this.dataTTL = dataTTL;
    }

    public void setDataTTL(long dataTTL) {
        this.dataTTL = dataTTL;
    }

    public List<TsFileResource> getSequenceFileList() {
        return this.tsFileManager.getTsFileList(true);
    }

    public List<TsFileResource> getUnSequenceFileList() {
        return this.tsFileManager.getTsFileList(false);
    }

    public String getDataRegionId() {
        return this.dataRegionId;
    }

    public String getStorageGroupPath() {
        return this.databaseName + File.separator + this.dataRegionId;
    }

    public boolean isFileAlreadyExist(TsFileResource tsFileResource, long partitionNum) {
        return this.isFileAlreadyExistInWorking(tsFileResource, partitionNum, this.getWorkSequenceTsFileProcessors()) || this.isFileAlreadyExistInWorking(tsFileResource, partitionNum, this.getWorkUnsequenceTsFileProcessors()) || this.isFileAlreadyExistInClosed(tsFileResource, partitionNum, this.getSequenceFileList()) || this.isFileAlreadyExistInClosed(tsFileResource, partitionNum, this.getUnSequenceFileList());
    }

    private boolean isFileAlreadyExistInClosed(TsFileResource tsFileResource, long partitionNum, Collection<TsFileResource> existingFiles) {
        for (TsFileResource resource : existingFiles) {
            if (resource.getTimePartition() != partitionNum || resource.getMaxPlanIndex() <= tsFileResource.getMaxPlanIndex()) continue;
            logger.info("{} is covered by a closed file {}: [{}, {}] [{}, {}]", new Object[]{tsFileResource, resource, tsFileResource.minPlanIndex, tsFileResource.maxPlanIndex, resource.minPlanIndex, resource.maxPlanIndex});
            return true;
        }
        return false;
    }

    private boolean isFileAlreadyExistInWorking(TsFileResource tsFileResource, long partitionNum, Collection<TsFileProcessor> workingProcessors) {
        for (TsFileProcessor workingProcesssor : workingProcessors) {
            boolean isCovered;
            if (workingProcesssor.getTimeRangeId() != partitionNum) continue;
            TsFileResource workResource = workingProcesssor.getTsFileResource();
            boolean bl = isCovered = workResource.getMaxPlanIndex() > tsFileResource.getMaxPlanIndex();
            if (isCovered) {
                logger.info("{} is covered by a working file {}: [{}, {}] [{}, {}]", new Object[]{tsFileResource, workResource, tsFileResource.minPlanIndex, tsFileResource.maxPlanIndex, workResource.minPlanIndex, workResource.maxPlanIndex});
            }
            return isCovered;
        }
        return false;
    }

    public void removePartitions(TimePartitionFilter filter) {
        this.writeLock("removePartitions");
        try {
            this.abortCompaction();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.removePartitions(filter, this.workSequenceTsFileProcessors.entrySet(), true);
            this.removePartitions(filter, this.workUnsequenceTsFileProcessors.entrySet(), false);
            this.removePartitions(filter, this.tsFileManager.getIterator(true), true);
            this.removePartitions(filter, this.tsFileManager.getIterator(false), false);
        }
        finally {
            this.writeUnlock();
        }
    }

    public void abortCompaction() {
        this.tsFileManager.setAllowCompaction(false);
        List<AbstractCompactionTask> runningTasks = CompactionTaskManager.getInstance().abortCompaction(this.databaseName + "-" + this.dataRegionId);
        while (CompactionTaskManager.getInstance().isAnyTaskInListStillRunning(runningTasks)) {
            try {
                TimeUnit.MILLISECONDS.sleep(10L);
            }
            catch (InterruptedException e) {
                logger.error("Thread get interrupted when waiting compaction to finish", (Throwable)e);
                break;
            }
        }
    }

    private void removePartitions(TimePartitionFilter filter, Set<Map.Entry<Long, TsFileProcessor>> processorEntrys, boolean sequence) {
        Iterator<Map.Entry<Long, TsFileProcessor>> iterator = processorEntrys.iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, TsFileProcessor> longTsFileProcessorEntry = iterator.next();
            long partitionId = longTsFileProcessorEntry.getKey();
            this.lastFlushTimeMap.removePartition(partitionId);
            TimePartitionManager.getInstance().removePartition(new DataRegionId(Integer.valueOf(this.dataRegionId).intValue()), partitionId);
            TsFileProcessor processor = longTsFileProcessorEntry.getValue();
            if (!filter.satisfy(this.databaseName, partitionId)) continue;
            processor.syncClose();
            iterator.remove();
            processor.getTsFileResource().remove();
            this.tsFileManager.remove(processor.getTsFileResource(), sequence);
            logger.debug("{} is removed during deleting partitions", (Object)processor.getTsFileResource().getTsFilePath());
        }
    }

    private void removePartitions(TimePartitionFilter filter, Iterator<TsFileResource> iterator, boolean sequence) {
        while (iterator.hasNext()) {
            TsFileResource tsFileResource = iterator.next();
            if (!filter.satisfy(this.databaseName, tsFileResource.getTimePartition())) continue;
            tsFileResource.remove();
            this.tsFileManager.remove(tsFileResource, sequence);
            this.lastFlushTimeMap.removePartition(tsFileResource.getTimePartition());
            TimePartitionManager.getInstance().removePartition(new DataRegionId(Integer.valueOf(this.dataRegionId).intValue()), tsFileResource.getTimePartition());
            logger.debug("{} is removed during deleting partitions", (Object)tsFileResource.getTsFilePath());
        }
    }

    public TsFileManager getTsFileResourceManager() {
        return this.tsFileManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(InsertRowsOfOneDeviceNode insertRowsOfOneDeviceNode) throws WriteProcessException, BatchProcessException {
        if (this.enableMemControl) {
            StorageEngine.blockInsertionIfReject(null);
        }
        long startTime = System.nanoTime();
        this.writeLock("InsertRowsOfOneDevice");
        PERFORMANCE_OVERVIEW_METRICS.recordScheduleLockCost(System.nanoTime() - startTime);
        try {
            if (this.deleted) {
                return;
            }
            boolean isSequence = false;
            for (int i = 0; i < insertRowsOfOneDeviceNode.getInsertRowNodeList().size(); ++i) {
                InsertRowNode insertRowNode = insertRowsOfOneDeviceNode.getInsertRowNodeList().get(i);
                if (!this.isAlive(insertRowNode.getTime())) {
                    insertRowsOfOneDeviceNode.getResults().put(i, RpcUtils.getStatus((int)TSStatusCode.OUT_OF_TTL.getStatusCode(), (String)String.format("Insertion time [%s] is less than ttl time bound [%s]", DateTimeUtils.convertMillsecondToZonedDateTime(insertRowNode.getTime()), DateTimeUtils.convertMillsecondToZonedDateTime(DateTimeUtils.currentTime() - this.dataTTL))));
                    continue;
                }
                long timePartitionId = StorageEngine.getTimePartition(insertRowNode.getTime());
                if (!this.lastFlushTimeMap.checkAndCreateFlushedTimePartition(timePartitionId)) {
                    TimePartitionManager.getInstance().registerTimePartitionInfo(new TimePartitionInfo(new DataRegionId(Integer.valueOf(this.dataRegionId).intValue()), timePartitionId, true, Long.MAX_VALUE, 0L, this.tsFileManager.isLatestTimePartition(timePartitionId)));
                }
                if (!isSequence) {
                    boolean bl = isSequence = insertRowNode.getTime() > this.lastFlushTimeMap.getFlushedTime(timePartitionId, insertRowNode.getDevicePath().getFullPath());
                }
                if (!isSequence && IoTDBDescriptor.getInstance().getConfig().isEnableDiscardOutOfOrderData()) {
                    return;
                }
                try {
                    this.insertToTsFileProcessor(insertRowNode, isSequence, timePartitionId);
                    continue;
                }
                catch (WriteProcessException e) {
                    insertRowsOfOneDeviceNode.getResults().put(i, RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
                }
            }
        }
        finally {
            this.writeUnlock();
        }
        if (!insertRowsOfOneDeviceNode.getResults().isEmpty()) {
            throw new BatchProcessException("Partial failed inserting rows of one device");
        }
    }

    public void insert(InsertRowsNode insertRowsNode) throws BatchProcessException {
        for (int i = 0; i < insertRowsNode.getInsertRowNodeList().size(); ++i) {
            InsertRowNode insertRowNode = insertRowsNode.getInsertRowNodeList().get(i);
            try {
                this.insert(insertRowNode);
                continue;
            }
            catch (WriteProcessException e) {
                insertRowsNode.getResults().put(i, RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
            }
        }
        if (!insertRowsNode.getResults().isEmpty()) {
            throw new BatchProcessException("Partial failed inserting rows");
        }
    }

    public void insertTablets(InsertMultiTabletsNode insertMultiTabletsNode) throws BatchProcessException {
        for (int i = 0; i < insertMultiTabletsNode.getInsertTabletNodeList().size(); ++i) {
            InsertTabletNode insertTabletNode = insertMultiTabletsNode.getInsertTabletNodeList().get(i);
            try {
                this.insertTablet(insertTabletNode);
                continue;
            }
            catch (BatchProcessException | WriteProcessException e) {
                insertMultiTabletsNode.getResults().put(i, RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
            }
        }
        if (!insertMultiTabletsNode.getResults().isEmpty()) {
            throw new BatchProcessException("Partial failed inserting multi tablets");
        }
    }

    public long getPartitionMaxFileVersions(long partitionId) {
        return this.partitionMaxFileVersions.getOrDefault(partitionId, 0L);
    }

    public void addSettleFilesToList(List<TsFileResource> seqResourcesToBeSettled, List<TsFileResource> unseqResourcesToBeSettled, List<String> tsFilePaths) {
        if (tsFilePaths.isEmpty()) {
            for (TsFileResource resource : this.tsFileManager.getTsFileList(true)) {
                if (!resource.isClosed()) continue;
                resource.setSettleTsFileCallBack(this::settleTsFileCallBack);
                seqResourcesToBeSettled.add(resource);
            }
            for (TsFileResource resource : this.tsFileManager.getTsFileList(false)) {
                if (!resource.isClosed()) continue;
                resource.setSettleTsFileCallBack(this::settleTsFileCallBack);
                unseqResourcesToBeSettled.add(resource);
            }
        } else {
            block2: for (String tsFilePath : tsFilePaths) {
                File fileToBeSettled = new File(tsFilePath);
                if ("sequence".equals(fileToBeSettled.getParentFile().getParentFile().getParentFile().getParentFile().getName())) {
                    for (TsFileResource resource : this.tsFileManager.getTsFileList(true)) {
                        if (!resource.getTsFile().getAbsolutePath().equals(tsFilePath)) continue;
                        resource.setSettleTsFileCallBack(this::settleTsFileCallBack);
                        seqResourcesToBeSettled.add(resource);
                        continue block2;
                    }
                    continue;
                }
                for (TsFileResource resource : this.tsFileManager.getTsFileList(false)) {
                    if (!resource.getTsFile().getAbsolutePath().equals(tsFilePath)) continue;
                    unseqResourcesToBeSettled.add(resource);
                    continue block2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> collectHistoryTsFileForSync(ISyncManager syncManager, long dataStartTime) {
        this.writeLock("Collect data for sync");
        try {
            List<File> list = this.tsFileManager.collectHistoryTsFileForSync(syncManager, dataStartTime);
            return list;
        }
        finally {
            this.writeUnlock();
        }
    }

    public void setCustomCloseFileListeners(List<CloseFileListener> customCloseFileListeners) {
        this.customCloseFileListeners = customCloseFileListeners;
    }

    public void setCustomFlushListeners(List<FlushListener> customFlushListeners) {
        this.customFlushListeners = customFlushListeners;
    }

    public void setAllowCompaction(boolean allowCompaction) {
        this.tsFileManager.setAllowCompaction(allowCompaction);
    }

    public List<Long> getTimePartitions() {
        return new ArrayList<Long>(this.partitionMaxFileVersions.keySet());
    }

    public Long getLatestTimePartition() {
        return this.partitionMaxFileVersions.keySet().stream().max(Long::compareTo).orElse(0L);
    }

    public String getInsertWriteLockHolder() {
        return this.insertWriteLockHolder;
    }

    public ScheduledExecutorService getTimedCompactionScheduleTask() {
        return this.timedCompactionScheduleTask;
    }

    public IDTable getIdTable() {
        return this.idTable;
    }

    public IWALNode getWALNode() {
        if (!config.getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.iot.IoTConsensus")) {
            throw new UnsupportedOperationException();
        }
        return WALManager.getInstance().applyForWALNode(this.databaseName + "-" + this.dataRegionId);
    }

    public void waitForDeleted() {
        this.writeLock("waitForDeleted");
        try {
            if (!this.deleted) {
                this.deletedCondition.await();
            }
        }
        catch (InterruptedException e) {
            logger.error("Interrupted When waiting for data region deleted.");
            Thread.currentThread().interrupt();
        }
        finally {
            this.writeUnlock();
        }
    }

    public void markDeleted() {
        this.writeLock("markDeleted");
        try {
            this.deleted = true;
            this.deletedCondition.signalAll();
        }
        finally {
            this.writeUnlock();
        }
    }

    public void releaseFlushTimeMap(long timePartitionId) {
        this.lastFlushTimeMap.removePartition(timePartitionId);
    }

    public long getMemCost() {
        return this.dataRegionInfo.getMemCost();
    }

    @Override
    public long getDataTTL() {
        return this.dataTTL;
    }

    public ILastFlushTimeMap getLastFlushTimeMap() {
        return this.lastFlushTimeMap;
    }

    public TsFileManager getTsFileManager() {
        return this.tsFileManager;
    }

    @FunctionalInterface
    public static interface SettleTsFileCallBack {
        public void call(TsFileResource var1, List<TsFileResource> var2) throws WriteProcessException;
    }

    @FunctionalInterface
    public static interface TimePartitionFilter {
        public boolean satisfy(String var1, long var2);
    }

    @FunctionalInterface
    public static interface CompactionRecoverCallBack {
        public void call();
    }

    @FunctionalInterface
    public static interface UpgradeTsFileResourceCallBack {
        public void call(TsFileResource var1);
    }

    @FunctionalInterface
    public static interface UpdateEndTimeCallBack {
        public void call(TsFileProcessor var1, Map<String, Long> var2, long var3);
    }

    @FunctionalInterface
    public static interface CloseTsFileCallBack {
        public void call(TsFileProcessor var1) throws TsFileProcessorException, IOException;
    }

    private static enum LoadTsFileType {
        LOAD_SEQUENCE,
        LOAD_UNSEQUENCE;

    }

    private class DataRegionRecoveryContext {
        private final long numOfFilesToRecover;
        private final long filesNumLogCheckTrigger;
        private long recoveredFilesNum;
        private long lastLogTime;
        private long lastLogCheckFilesNum;
        private final List<UnsealedTsFileRecoverPerformer> recoverPerformers = new ArrayList<UnsealedTsFileRecoverPerformer>();

        public DataRegionRecoveryContext(long numOfFilesToRecover) {
            this.numOfFilesToRecover = numOfFilesToRecover;
            this.recoveredFilesNum = 0L;
            this.filesNumLogCheckTrigger = this.numOfFilesToRecover / 100L;
            this.lastLogTime = System.currentTimeMillis();
            this.lastLogCheckFilesNum = 0L;
        }

        public void incrementRecoveredFilesNum() {
            ++this.recoveredFilesNum;
            if (this.lastLogCheckFilesNum + this.filesNumLogCheckTrigger < this.recoveredFilesNum) {
                this.lastLogCheckFilesNum = this.recoveredFilesNum;
                if (this.lastLogTime + config.getRecoveryLogIntervalInMs() < System.currentTimeMillis()) {
                    logger.info("The data region {}[{}] has recovered {}%, please wait a moment.", new Object[]{DataRegion.this.databaseName, DataRegion.this.dataRegionId, (double)this.recoveredFilesNum * 1.0 / (double)this.numOfFilesToRecover});
                    this.lastLogTime = System.currentTimeMillis();
                }
            }
        }
    }
}

