/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.consensus.statemachine;

import java.io.File;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.db.consensus.statemachine.BaseStateMachine;
import org.apache.iotdb.db.metadata.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.metadata.visitor.SchemaExecutionVisitor;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceManager;
import org.apache.iotdb.db.mpp.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaRegionStateMachine
extends BaseStateMachine {
    private static final Logger logger = LoggerFactory.getLogger(SchemaRegionStateMachine.class);
    private final ISchemaRegion schemaRegion;
    private static final FragmentInstanceManager QUERY_INSTANCE_MANAGER = FragmentInstanceManager.getInstance();

    public SchemaRegionStateMachine(ISchemaRegion schemaRegion) {
        this.schemaRegion = schemaRegion;
    }

    public void start() {
    }

    public void stop() {
    }

    public boolean isReadOnly() {
        return CommonDescriptor.getInstance().getConfig().isReadOnly();
    }

    public boolean takeSnapshot(File snapshotDir) {
        return this.schemaRegion.createSnapshot(snapshotDir);
    }

    public void loadSnapshot(File latestSnapshotRootDir) {
        this.schemaRegion.loadSnapshot(latestSnapshotRootDir);
    }

    public TSStatus write(IConsensusRequest request) {
        try {
            return ((PlanNode)request).accept(new SchemaExecutionVisitor(), this.schemaRegion);
        }
        catch (IllegalArgumentException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
        }
    }

    public DataSet read(IConsensusRequest request) {
        FragmentInstance fragmentInstance;
        try {
            fragmentInstance = this.getFragmentInstance(request);
        }
        catch (IllegalArgumentException e) {
            logger.error(e.getMessage());
            return null;
        }
        logger.debug("SchemaRegionStateMachine[{}]: Execute read plan: FragmentInstance-{}", (Object)this.schemaRegion.getSchemaRegionId(), (Object)fragmentInstance.getId());
        return QUERY_INSTANCE_MANAGER.execSchemaQueryFragmentInstance(fragmentInstance, this.schemaRegion);
    }

    public boolean shouldRetry(TSStatus writeResult) {
        return super.shouldRetry(writeResult);
    }

    public TSStatus updateResult(TSStatus previousResult, TSStatus retryResult) {
        return super.updateResult(previousResult, retryResult);
    }

    public long getSleepTime() {
        return super.getSleepTime();
    }
}

