/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TFlushReq;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSetTTLReq;
import org.apache.iotdb.commons.client.ClientManager;
import org.apache.iotdb.commons.client.ThriftClient;
import org.apache.iotdb.commons.client.factory.ThriftClientFactory;
import org.apache.iotdb.commons.client.property.ThriftClientProperty;
import org.apache.iotdb.commons.client.sync.SyncThriftClientWithErrorHandler;
import org.apache.iotdb.commons.consensus.ConfigRegionId;
import org.apache.iotdb.confignode.rpc.thrift.IConfigNodeRPCService;
import org.apache.iotdb.confignode.rpc.thrift.TAddConsensusGroupReq;
import org.apache.iotdb.confignode.rpc.thrift.TAuthorizerReq;
import org.apache.iotdb.confignode.rpc.thrift.TAuthorizerResp;
import org.apache.iotdb.confignode.rpc.thrift.TCheckUserPrivilegesReq;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRegisterReq;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRegisterResp;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRestartReq;
import org.apache.iotdb.confignode.rpc.thrift.TCountDatabaseResp;
import org.apache.iotdb.confignode.rpc.thrift.TCreateCQReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateFunctionReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateModelReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreatePipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateSchemaTemplateReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateTriggerReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeConfigurationResp;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRegisterReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRegisterResp;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRemoveReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRemoveResp;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRestartReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRestartResp;
import org.apache.iotdb.confignode.rpc.thrift.TDataPartitionReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataPartitionTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchema;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchemaResp;
import org.apache.iotdb.confignode.rpc.thrift.TDeactivateSchemaTemplateReq;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteDatabaseReq;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteDatabasesReq;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteTimeSeriesReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropCQReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropFunctionReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropModelReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropPipeSinkReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropTriggerReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetAllPipeInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetAllTemplatesResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetDataNodeLocationsResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetJarInListReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetJarInListResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetLocationForTriggerResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetPathsSetTemplatesResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetPipeSinkReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetPipeSinkResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetRegionIdReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetRegionIdResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetSeriesSlotListReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetSeriesSlotListResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetTemplateResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetTimeSlotListReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetTimeSlotListResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetTriggerTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetUDFTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TLoginReq;
import org.apache.iotdb.confignode.rpc.thrift.TMigrateRegionReq;
import org.apache.iotdb.confignode.rpc.thrift.TPermissionInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TPipeSinkInfo;
import org.apache.iotdb.confignode.rpc.thrift.TRecordPipeMessageReq;
import org.apache.iotdb.confignode.rpc.thrift.TRegionMigrateResultReportReq;
import org.apache.iotdb.confignode.rpc.thrift.TRegionRouteMapResp;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaNodeManagementReq;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaNodeManagementResp;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaPartitionReq;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaPartitionTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TSetDataNodeStatusReq;
import org.apache.iotdb.confignode.rpc.thrift.TSetDataReplicationFactorReq;
import org.apache.iotdb.confignode.rpc.thrift.TSetSchemaReplicationFactorReq;
import org.apache.iotdb.confignode.rpc.thrift.TSetSchemaTemplateReq;
import org.apache.iotdb.confignode.rpc.thrift.TSetTimePartitionIntervalReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowCQResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowClusterResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowConfigNodesResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowDataNodesResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowDatabaseResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowModelReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowModelResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipeResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowRegionReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowRegionResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowTrailReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowTrailResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowVariablesResp;
import org.apache.iotdb.confignode.rpc.thrift.TSystemConfigurationResp;
import org.apache.iotdb.confignode.rpc.thrift.TUnsetSchemaTemplateReq;
import org.apache.iotdb.confignode.rpc.thrift.TUpdateModelInfoReq;
import org.apache.iotdb.confignode.rpc.thrift.TUpdateModelStateReq;
import org.apache.iotdb.db.client.ConfigNodeInfo;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.rpc.RpcTransportFactory;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigNodeClient
implements IConfigNodeRPCService.Iface,
ThriftClient,
AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ConfigNodeClient.class);
    private static final int RETRY_NUM = 5;
    public static final String MSG_RECONNECTION_FAIL = "Fail to connect to any config node. Please check status of ConfigNodes";
    private static final int RETRY_INTERVAL_MS = 1000;
    private final long connectionTimeout;
    private IConfigNodeRPCService.Iface client;
    private TTransport transport;
    private TEndPoint configLeader;
    private List<TEndPoint> configNodes;
    private TEndPoint configNode;
    private int cursor = 0;
    private final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    ClientManager<ConfigRegionId, ConfigNodeClient> clientManager;
    ConfigRegionId configRegionId = ConfigNodeInfo.CONFIG_REGION_ID;
    TProtocolFactory protocolFactory;

    public ConfigNodeClient(List<TEndPoint> configNodes, TProtocolFactory protocolFactory, long connectionTimeout, ClientManager<ConfigRegionId, ConfigNodeClient> clientManager) throws TException {
        this.configNodes = configNodes;
        this.protocolFactory = protocolFactory;
        this.connectionTimeout = connectionTimeout;
        this.clientManager = clientManager;
        this.init();
    }

    public void init() throws TException {
        try {
            this.tryToConnect();
        }
        catch (TException e) {
            this.syncLatestConfigNodeList();
            this.tryToConnect();
        }
    }

    public void connect(TEndPoint endpoint) throws TException {
        try {
            this.transport = RpcTransportFactory.INSTANCE.getTransport(endpoint.getIp(), endpoint.getPort(), (int)this.connectionTimeout);
            if (!this.transport.isOpen()) {
                this.transport.open();
            }
            this.configNode = endpoint;
        }
        catch (TTransportException e) {
            throw new TException((Throwable)e);
        }
        this.client = new IConfigNodeRPCService.Client(this.protocolFactory.getProtocol(this.transport));
    }

    private void waitAndReconnect() throws TException {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new TException("Unexpected interruption when waiting to retry to connect to ConfigNode");
        }
        try {
            this.tryToConnect();
        }
        catch (TException e) {
            this.syncLatestConfigNodeList();
            this.tryToConnect();
        }
    }

    private void tryToConnect() throws TException {
        if (this.configLeader != null) {
            try {
                this.connect(this.configLeader);
                return;
            }
            catch (TException e) {
                logger.warn("The current node may have been down {},try next node", (Object)this.configLeader);
                this.configLeader = null;
            }
        }
        if (this.transport != null) {
            this.transport.close();
        }
        for (int tryHostNum = 0; tryHostNum < this.configNodes.size(); ++tryHostNum) {
            this.cursor = (this.cursor + 1) % this.configNodes.size();
            TEndPoint tryEndpoint = this.configNodes.get(this.cursor);
            try {
                this.connect(tryEndpoint);
                return;
            }
            catch (TException e) {
                logger.warn("The current node may have been down {},try next node", (Object)tryEndpoint);
                continue;
            }
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TTransport getTransport() {
        return this.transport;
    }

    public void syncLatestConfigNodeList() {
        this.configNodes = ConfigNodeInfo.getInstance().getLatestConfigNodes();
        this.cursor = 0;
    }

    @Override
    public void close() {
        this.clientManager.returnClient((Object)this.configRegionId, (Object)this);
    }

    public void invalidate() {
        Optional.ofNullable(this.transport).ifPresent(TTransport::close);
    }

    public void invalidateAll() {
        this.clientManager.clear((Object)ConfigNodeInfo.CONFIG_REGION_ID);
    }

    private boolean updateConfigNodeLeader(TSStatus status) {
        if (status.getCode() == TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
            this.configLeader = status.isSetRedirectNode() ? new TEndPoint(status.getRedirectNode().getIp(), status.getRedirectNode().getPort()) : null;
            logger.warn("Failed to connect to ConfigNode {} from DataNode {}, because the current node is not leader, try next node", (Object)this.configNode, (Object)this.config.getAddressAndPort());
            return true;
        }
        return false;
    }

    public TSystemConfigurationResp getSystemConfiguration() throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSystemConfigurationResp resp = this.client.getSystemConfiguration();
                if (!this.updateConfigNodeLeader(resp.status)) {
                    return resp;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TDataNodeRegisterResp registerDataNode(TDataNodeRegisterReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TDataNodeRegisterResp resp = this.client.registerDataNode(req);
                if (!this.updateConfigNodeLeader(resp.status)) {
                    return resp;
                }
                ArrayList<TEndPoint> newConfigNodes = new ArrayList<TEndPoint>();
                for (TConfigNodeLocation configNodeLocation : resp.getConfigNodeList()) {
                    newConfigNodes.add(configNodeLocation.getInternalEndPoint());
                }
                this.configNodes = newConfigNodes;
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TDataNodeRestartResp restartDataNode(TDataNodeRestartReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TDataNodeRestartResp resp = this.client.restartDataNode(req);
                if (!this.updateConfigNodeLeader(resp.status)) {
                    return resp;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TDataNodeRemoveResp removeDataNode(TDataNodeRemoveReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TDataNodeRemoveResp resp = this.client.removeDataNode(req);
                if (!this.updateConfigNodeLeader(resp.status)) {
                    return resp;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus reportDataNodeShutdown(TDataNodeLocation dataNodeLocation) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.reportDataNodeShutdown(dataNodeLocation);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TDataNodeConfigurationResp getDataNodeConfiguration(int dataNodeId) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TDataNodeConfigurationResp resp = this.client.getDataNodeConfiguration(dataNodeId);
                if (!this.updateConfigNodeLeader(resp.status)) {
                    return resp;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus reportRegionMigrateResult(TRegionMigrateResultReportReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.reportRegionMigrateResult(req);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TShowClusterResp showCluster() throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TShowClusterResp resp = this.client.showCluster();
                if (!this.updateConfigNodeLeader(resp.status)) {
                    return resp;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TShowVariablesResp showVariables() throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TShowVariablesResp resp = this.client.showVariables();
                if (!this.updateConfigNodeLeader(resp.status)) {
                    return resp;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus setDatabase(TDatabaseSchema databaseSchema) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.setDatabase(databaseSchema);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus alterDatabase(TDatabaseSchema databaseSchema) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.alterDatabase(databaseSchema);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus deleteDatabase(TDeleteDatabaseReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.deleteDatabase(req);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus deleteDatabases(TDeleteDatabasesReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.deleteDatabases(req);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TCountDatabaseResp countMatchedDatabases(List<String> storageGroupPathPattern) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TCountDatabaseResp resp = this.client.countMatchedDatabases(storageGroupPathPattern);
                if (!this.updateConfigNodeLeader(resp.status)) {
                    return resp;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TDatabaseSchemaResp getMatchedDatabaseSchemas(List<String> storageGroupPathPattern) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TDatabaseSchemaResp resp = this.client.getMatchedDatabaseSchemas(storageGroupPathPattern);
                if (!this.updateConfigNodeLeader(resp.status)) {
                    return resp;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus setTTL(TSetTTLReq setTTLReq) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.setTTL(setTTLReq);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus setSchemaReplicationFactor(TSetSchemaReplicationFactorReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.setSchemaReplicationFactor(req);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus setDataReplicationFactor(TSetDataReplicationFactorReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.setDataReplicationFactor(req);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus setTimePartitionInterval(TSetTimePartitionIntervalReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.setTimePartitionInterval(req);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSchemaPartitionTableResp getSchemaPartitionTable(TSchemaPartitionReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSchemaPartitionTableResp resp = this.client.getSchemaPartitionTable(req);
                if (!this.updateConfigNodeLeader(resp.status)) {
                    return resp;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSchemaPartitionTableResp getOrCreateSchemaPartitionTable(TSchemaPartitionReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSchemaPartitionTableResp resp = this.client.getOrCreateSchemaPartitionTable(req);
                if (!this.updateConfigNodeLeader(resp.status)) {
                    return resp;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSchemaNodeManagementResp getSchemaNodeManagementPartition(TSchemaNodeManagementReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSchemaNodeManagementResp resp = this.client.getSchemaNodeManagementPartition(req);
                if (!this.updateConfigNodeLeader(resp.status)) {
                    return resp;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TDataPartitionTableResp getDataPartitionTable(TDataPartitionReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TDataPartitionTableResp resp = this.client.getDataPartitionTable(req);
                if (!this.updateConfigNodeLeader(resp.status)) {
                    return resp;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TDataPartitionTableResp getOrCreateDataPartitionTable(TDataPartitionReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TDataPartitionTableResp resp = this.client.getOrCreateDataPartitionTable(req);
                if (!this.updateConfigNodeLeader(resp.status)) {
                    return resp;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus operatePermission(TAuthorizerReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.operatePermission(req);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TAuthorizerResp queryPermission(TAuthorizerReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TAuthorizerResp resp = this.client.queryPermission(req);
                if (!this.updateConfigNodeLeader(resp.status)) {
                    return resp;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TPermissionInfoResp login(TLoginReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TPermissionInfoResp status = this.client.login(req);
                if (!this.updateConfigNodeLeader(status.getStatus())) {
                    return status;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TPermissionInfoResp checkUserPrivileges(TCheckUserPrivilegesReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TPermissionInfoResp status = this.client.checkUserPrivileges(req);
                if (!this.updateConfigNodeLeader(status.getStatus())) {
                    return status;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TConfigNodeRegisterResp registerConfigNode(TConfigNodeRegisterReq req) throws TException {
        throw new TException("DataNode to ConfigNode client doesn't support registerConfigNode.");
    }

    public TSStatus restartConfigNode(TConfigNodeRestartReq req) throws TException {
        throw new TException("DataNode to ConfigNode client doesn't support restartConfigNode.");
    }

    public TSStatus addConsensusGroup(TAddConsensusGroupReq registerResp) throws TException {
        throw new TException("DataNode to ConfigNode client doesn't support addConsensusGroup.");
    }

    public TSStatus notifyRegisterSuccess() throws TException {
        throw new TException("DataNode to ConfigNode client doesn't support notifyRegisterSuccess.");
    }

    public TSStatus removeConfigNode(TConfigNodeLocation configNodeLocation) throws TException {
        throw new TException("DataNode to ConfigNode client doesn't support removeConfigNode.");
    }

    public TSStatus deleteConfigNodePeer(TConfigNodeLocation configNodeLocation) throws TException {
        throw new TException("DataNode to ConfigNode client doesn't support removeConsensusGroup.");
    }

    public TSStatus reportConfigNodeShutdown(TConfigNodeLocation configNodeLocation) throws TException {
        throw new TException("DataNode to ConfigNode client doesn't support reportConfigNodeShutdown.");
    }

    public TSStatus stopConfigNode(TConfigNodeLocation configNodeLocation) throws TException {
        throw new TException("DataNode to ConfigNode client doesn't support stopConfigNode.");
    }

    public TSStatus merge() throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.merge();
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus flush(TFlushReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.flush(req);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus clearCache() throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.clearCache();
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus loadConfiguration() throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.loadConfiguration();
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus setSystemStatus(String systemStatus) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.setSystemStatus(systemStatus);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus setDataNodeStatus(TSetDataNodeStatusReq req) throws TException {
        throw new TException("DataNode to ConfigNode client doesn't support setDataNodeStatus.");
    }

    public TSStatus killQuery(String queryId, int dataNodeId) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.killQuery(queryId, dataNodeId);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TGetDataNodeLocationsResp getRunningDataNodeLocations() throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TGetDataNodeLocationsResp resp = this.client.getRunningDataNodeLocations();
                if (!this.updateConfigNodeLeader(resp.status)) {
                    return resp;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TShowRegionResp showRegion(TShowRegionReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TShowRegionResp showRegionResp = this.client.showRegion(req);
                if (!this.updateConfigNodeLeader(showRegionResp.getStatus())) {
                    return showRegionResp;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TShowDataNodesResp showDataNodes() throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TShowDataNodesResp showDataNodesResp = this.client.showDataNodes();
                showDataNodesResp.setStatus(showDataNodesResp.getStatus());
                if (!this.updateConfigNodeLeader(showDataNodesResp.getStatus())) {
                    return showDataNodesResp;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TShowConfigNodesResp showConfigNodes() throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TShowConfigNodesResp showConfigNodesResp = this.client.showConfigNodes();
                if (!this.updateConfigNodeLeader(showConfigNodesResp.getStatus())) {
                    return showConfigNodesResp;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TShowDatabaseResp showDatabase(List<String> storageGroupPathPattern) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TShowDatabaseResp showStorageGroupResp = this.client.showDatabase(storageGroupPathPattern);
                if (!this.updateConfigNodeLeader(showStorageGroupResp.getStatus())) {
                    return showStorageGroupResp;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TRegionRouteMapResp getLatestRegionRouteMap() throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TRegionRouteMapResp regionRouteMapResp = this.client.getLatestRegionRouteMap();
                if (!this.updateConfigNodeLeader(regionRouteMapResp.getStatus())) {
                    return regionRouteMapResp;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public long getConfigNodeHeartBeat(long timestamp) throws TException {
        throw new TException("DataNode to ConfigNode client doesn't support getConfigNodeHeartBeat.");
    }

    public TSStatus createFunction(TCreateFunctionReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.createFunction(req);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus dropFunction(TDropFunctionReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.dropFunction(req);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TGetUDFTableResp getUDFTable() throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TGetUDFTableResp resp = this.client.getUDFTable();
                if (!this.updateConfigNodeLeader(resp.getStatus())) {
                    return resp;
                }
            }
            catch (TException e) {
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TGetJarInListResp getUDFJar(TGetJarInListReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TGetJarInListResp resp = this.client.getUDFJar(req);
                if (!this.updateConfigNodeLeader(resp.getStatus())) {
                    return resp;
                }
            }
            catch (TException e) {
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus createTrigger(TCreateTriggerReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.createTrigger(req);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus dropTrigger(TDropTriggerReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.dropTrigger(req);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TGetLocationForTriggerResp getLocationOfStatefulTrigger(String triggerName) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TGetLocationForTriggerResp resp = this.client.getLocationOfStatefulTrigger(triggerName);
                if (!this.updateConfigNodeLeader(resp.getStatus())) {
                    return resp;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TGetTriggerTableResp getTriggerTable() throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TGetTriggerTableResp resp = this.client.getTriggerTable();
                if (!this.updateConfigNodeLeader(resp.getStatus())) {
                    return resp;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TGetTriggerTableResp getStatefulTriggerTable() throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TGetTriggerTableResp resp = this.client.getStatefulTriggerTable();
                if (!this.updateConfigNodeLeader(resp.getStatus())) {
                    return resp;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TGetJarInListResp getTriggerJar(TGetJarInListReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TGetJarInListResp resp = this.client.getTriggerJar(req);
                if (!this.updateConfigNodeLeader(resp.getStatus())) {
                    return resp;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus createSchemaTemplate(TCreateSchemaTemplateReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus tsStatus = this.client.createSchemaTemplate(req);
                if (!this.updateConfigNodeLeader(tsStatus)) {
                    return tsStatus;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TGetAllTemplatesResp getAllTemplates() throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TGetAllTemplatesResp resp = this.client.getAllTemplates();
                if (!this.updateConfigNodeLeader(resp.getStatus())) {
                    return resp;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TGetTemplateResp getTemplate(String req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TGetTemplateResp resp = this.client.getTemplate(req);
                if (!this.updateConfigNodeLeader(resp.getStatus())) {
                    return resp;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus setSchemaTemplate(TSetSchemaTemplateReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus tsStatus = this.client.setSchemaTemplate(req);
                if (!this.updateConfigNodeLeader(tsStatus)) {
                    return tsStatus;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TGetPathsSetTemplatesResp getPathsSetTemplate(String req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TGetPathsSetTemplatesResp tGetPathsSetTemplatesResp = this.client.getPathsSetTemplate(req);
                if (!this.updateConfigNodeLeader(tGetPathsSetTemplatesResp.getStatus())) {
                    return tGetPathsSetTemplatesResp;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus deactivateSchemaTemplate(TDeactivateSchemaTemplateReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.deactivateSchemaTemplate(req);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus unsetSchemaTemplate(TUnsetSchemaTemplateReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.unsetSchemaTemplate(req);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus dropSchemaTemplate(String req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.dropSchemaTemplate(req);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus deleteTimeSeries(TDeleteTimeSeriesReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.deleteTimeSeries(req);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus createPipeSink(TPipeSinkInfo req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.createPipeSink(req);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus dropPipeSink(TDropPipeSinkReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.dropPipeSink(req);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TGetPipeSinkResp getPipeSink(TGetPipeSinkReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TGetPipeSinkResp resp = this.client.getPipeSink(req);
                if (!this.updateConfigNodeLeader(resp.getStatus())) {
                    return resp;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus createPipe(TCreatePipeReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.createPipe(req);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus startPipe(String pipeName) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.startPipe(pipeName);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus stopPipe(String pipeName) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.stopPipe(pipeName);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus dropPipe(String pipeName) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.dropPipe(pipeName);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TShowPipeResp showPipe(TShowPipeReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TShowPipeResp resp = this.client.showPipe(req);
                if (!this.updateConfigNodeLeader(resp.getStatus())) {
                    return resp;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TGetAllPipeInfoResp getAllPipeInfo() throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TGetAllPipeInfoResp resp = this.client.getAllPipeInfo();
                if (!this.updateConfigNodeLeader(resp.getStatus())) {
                    return resp;
                }
            }
            catch (TException e) {
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus recordPipeMessage(TRecordPipeMessageReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.recordPipeMessage(req);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TGetRegionIdResp getRegionId(TGetRegionIdReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TGetRegionIdResp resp = this.client.getRegionId(req);
                if (!this.updateConfigNodeLeader(resp.getStatus())) {
                    return resp;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TGetTimeSlotListResp getTimeSlotList(TGetTimeSlotListReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TGetTimeSlotListResp resp = this.client.getTimeSlotList(req);
                if (!this.updateConfigNodeLeader(resp.getStatus())) {
                    return resp;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TGetSeriesSlotListResp getSeriesSlotList(TGetSeriesSlotListReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TGetSeriesSlotListResp resp = this.client.getSeriesSlotList(req);
                if (!this.updateConfigNodeLeader(resp.getStatus())) {
                    return resp;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus migrateRegion(TMigrateRegionReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.migrateRegion(req);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                logger.warn("Failed to connect to ConfigNode {} from DataNode {} when executing {}", new Object[]{this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName()});
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus createCQ(TCreateCQReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.createCQ(req);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus dropCQ(TDropCQReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.dropCQ(req);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TShowCQResp showCQ() throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TShowCQResp resp = this.client.showCQ();
                if (!this.updateConfigNodeLeader(resp.getStatus())) {
                    return resp;
                }
            }
            catch (TException e) {
                this.configLeader = null;
            }
            this.waitAndReconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus createModel(TCreateModelReq req) throws TException {
        throw new TException(new UnsupportedOperationException().getCause());
    }

    public TSStatus dropModel(TDropModelReq req) throws TException {
        throw new TException(new UnsupportedOperationException().getCause());
    }

    public TShowModelResp showModel(TShowModelReq req) throws TException {
        throw new TException(new UnsupportedOperationException().getCause());
    }

    public TShowTrailResp showTrail(TShowTrailReq req) throws TException {
        throw new TException(new UnsupportedOperationException().getCause());
    }

    public TSStatus updateModelInfo(TUpdateModelInfoReq req) throws TException {
        throw new TException(new UnsupportedOperationException().getCause());
    }

    public TSStatus updateModelState(TUpdateModelStateReq req) throws TException {
        throw new TException(new UnsupportedOperationException().getCause());
    }

    public static class Factory
    extends ThriftClientFactory<ConfigRegionId, ConfigNodeClient> {
        public Factory(ClientManager<ConfigRegionId, ConfigNodeClient> clientManager, ThriftClientProperty thriftClientProperty) {
            super(clientManager, thriftClientProperty);
        }

        public void destroyObject(ConfigRegionId configRegionId, PooledObject<ConfigNodeClient> pooledObject) {
            ((ConfigNodeClient)pooledObject.getObject()).invalidate();
        }

        public PooledObject<ConfigNodeClient> makeObject(ConfigRegionId configRegionId) throws Exception {
            return new DefaultPooledObject((Object)((ConfigNodeClient)SyncThriftClientWithErrorHandler.newErrorHandler(ConfigNodeClient.class, ConfigNodeClient.class.getConstructor(List.class, TProtocolFactory.class, Long.TYPE, this.clientManager.getClass()), (Object[])new Object[]{ConfigNodeInfo.getInstance().getLatestConfigNodes(), this.thriftClientProperty.getProtocolFactory(), this.thriftClientProperty.getConnectionTimeoutMs(), this.clientManager})));
        }

        public boolean validateObject(ConfigRegionId configRegionId, PooledObject<ConfigNodeClient> pooledObject) {
            return Optional.ofNullable(((ConfigNodeClient)pooledObject.getObject()).getTransport()).map(TTransport::isOpen).orElse(false);
        }
    }
}

