/*
 * Decompiled with CFR 0.152.
 */
package org.weakref.jmx.guice;

import com.google.inject.multibindings.Multibinder;
import java.util.function.BiFunction;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.weakref.jmx.guice.MapExportBinder;
import org.weakref.jmx.guice.MapMapping;

public class StringMapExportBinder<V>
extends MapExportBinder<String, V> {
    private final Class<V> valueClass;

    StringMapExportBinder(Multibinder<MapMapping<?, ?>> binder, Class<V> valueClass) {
        super(binder, String.class, valueClass);
        this.valueClass = valueClass;
    }

    public void withGeneratedName() {
        BiFunction nameFactory = (factory, entry) -> {
            try {
                return new ObjectName(factory.generatedNameOf(this.valueClass, (String)entry.getKey()));
            }
            catch (MalformedObjectNameException e) {
                throw new RuntimeException(e);
            }
        };
        this.as(nameFactory);
    }
}

