/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.sync;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.sync.PipeException;
import org.apache.iotdb.commons.sync.pipe.PipeInfo;
import org.apache.iotdb.commons.sync.pipe.PipeStatus;
import org.apache.iotdb.commons.sync.pipe.SyncOperation;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.impl.sync.AbstractOperatePipeProcedure;
import org.apache.iotdb.confignode.procedure.state.sync.OperatePipeState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopPipeProcedure
extends AbstractOperatePipeProcedure {
    private static final Logger LOGGER = LoggerFactory.getLogger(StopPipeProcedure.class);
    private String pipeName;
    private PipeInfo pipeInfo;
    private Set<Integer> executedDataNodeIds = new HashSet<Integer>();

    public StopPipeProcedure() {
    }

    public StopPipeProcedure(String pipeName) throws PipeException {
        this.pipeName = pipeName;
    }

    public void setPipeInfo(PipeInfo pipeInfo) {
        this.pipeInfo = pipeInfo;
    }

    public void setExecutedDataNodeIds(Set<Integer> executedDataNodeIds) {
        this.executedDataNodeIds = executedDataNodeIds;
    }

    @Override
    boolean executeCheckCanSkip(ConfigNodeProcedureEnv env) throws PipeException {
        LOGGER.info("Start to stop PIPE [{}]", (Object)this.pipeName);
        this.pipeInfo = env.getConfigManager().getSyncManager().getPipeInfo(this.pipeName);
        if (this.pipeInfo.getStatus().equals((Object)PipeStatus.DROP)) {
            throw new PipeException(String.format("PIPE [%s] has been dropped and cannot be stopped again.", this.pipeName));
        }
        return this.pipeInfo.getStatus().equals((Object)PipeStatus.STOP);
    }

    @Override
    void executePreOperatePipeOnConfigNode(ConfigNodeProcedureEnv env) throws PipeException {
        LOGGER.info("Start to pre-stop PIPE [{}] on Config Nodes", (Object)this.pipeName);
        TSStatus status = env.getConfigManager().getSyncManager().setPipeStatus(this.pipeName, PipeStatus.PARTIAL_STOP);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(status.getMessage());
        }
    }

    @Override
    void executeOperatePipeOnDataNode(ConfigNodeProcedureEnv env) throws PipeException {
        LOGGER.info("Start to broadcast stop PIPE [{}] on Data Nodes", (Object)this.pipeName);
        Map<Integer, TSStatus> responseMap = env.getConfigManager().getSyncManager().operatePipeOnDataNodes(this.pipeName, SyncOperation.STOP_PIPE);
        TSStatus status = RpcUtils.squashResponseStatusList(new ArrayList<TSStatus>(responseMap.values()));
        this.executedDataNodeIds.addAll(responseMap.keySet());
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(String.format("Fail to stop PIPE [%s] because %s.", this.pipeName, StringUtils.join((Object[])responseMap.values().stream().filter(i -> i.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()).map(TSStatus::getMessage).toArray(), (String)", ")));
        }
    }

    @Override
    void executeOperatePipeOnConfigNode(ConfigNodeProcedureEnv env) throws PipeException {
        LOGGER.info("Start to stop PIPE [{}] on Config Nodes", (Object)this.pipeName);
        TSStatus status = env.getConfigManager().getSyncManager().setPipeStatus(this.pipeName, PipeStatus.STOP);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(status.getMessage());
        }
    }

    @Override
    SyncOperation getOperation() {
        return SyncOperation.STOP_PIPE;
    }

    @Override
    protected boolean isRollbackSupported(OperatePipeState state) {
        switch (state) {
            case OPERATE_CHECK: 
            case PRE_OPERATE_PIPE_CONFIGNODE: 
            case OPERATE_PIPE_DATANODE: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, OperatePipeState state) throws IOException, InterruptedException, ProcedureException {
        LOGGER.info("Roll back StopPipeProcedure at STATE [{}]", (Object)state);
        switch (state) {
            case OPERATE_CHECK: {
                env.getConfigManager().getSyncManager().unlockSyncMetadata();
                break;
            }
            case PRE_OPERATE_PIPE_CONFIGNODE: {
                TSStatus status = env.getConfigManager().getSyncManager().setPipeStatus(this.pipeName, PipeStatus.RUNNING);
                if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) break;
                throw new ProcedureException(String.format("Failed to stop pipe and failed to roll back because %s. Please execute [STOP PIPE %s] manually.", status.getMessage(), this.pipeName));
            }
            case OPERATE_PIPE_DATANODE: {
                env.getConfigManager().getSyncManager().operatePipeOnDataNodesForRollback(this.pipeName, this.pipeInfo.getCreateTime(), SyncOperation.START_PIPE, this.executedDataNodeIds);
                break;
            }
            default: {
                LOGGER.error("Unsupported roll back STATE [{}]", (Object)state);
            }
        }
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.STOP_PIPE_PROCEDURE.getTypeCode());
        super.serialize(stream);
        ReadWriteIOUtils.write((String)this.pipeName, (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)(this.pipeInfo != null ? 1 : 0), (OutputStream)stream);
        if (this.pipeInfo != null) {
            this.pipeInfo.serialize((OutputStream)stream);
        }
        ReadWriteIOUtils.writeIntegerSet(this.executedDataNodeIds, (OutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.pipeName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        if (ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer)) {
            this.pipeInfo = PipeInfo.deserializePipeInfo((ByteBuffer)byteBuffer);
        }
        this.executedDataNodeIds = ReadWriteIOUtils.readIntegerSet((ByteBuffer)byteBuffer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StopPipeProcedure that = (StopPipeProcedure)o;
        return Objects.equals(this.pipeName, that.pipeName) && Objects.equals(this.pipeInfo, that.pipeInfo) && Objects.equals(this.executedDataNodeIds, that.executedDataNodeIds);
    }

    public int hashCode() {
        return Objects.hash(this.pipeName, this.pipeInfo, this.executedDataNodeIds);
    }
}

