/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.exception.sync.PipeException;
import org.apache.iotdb.commons.exception.sync.PipeSinkException;
import org.apache.iotdb.commons.exception.sync.PipeSinkNotExistException;
import org.apache.iotdb.commons.sync.pipe.PipeInfo;
import org.apache.iotdb.commons.sync.pipe.PipeMessage;
import org.apache.iotdb.commons.sync.pipe.PipeStatus;
import org.apache.iotdb.commons.sync.pipe.SyncOperation;
import org.apache.iotdb.commons.sync.pipesink.PipeSink;
import org.apache.iotdb.commons.utils.StatusUtils;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.confignode.client.async.AsyncDataNodeClientPool;
import org.apache.iotdb.confignode.client.async.handlers.AsyncClientHandler;
import org.apache.iotdb.confignode.consensus.request.write.sync.CreatePipeSinkPlan;
import org.apache.iotdb.confignode.consensus.request.write.sync.DropPipePlan;
import org.apache.iotdb.confignode.consensus.request.write.sync.DropPipeSinkPlan;
import org.apache.iotdb.confignode.consensus.request.write.sync.GetPipeSinkPlan;
import org.apache.iotdb.confignode.consensus.request.write.sync.PreCreatePipePlan;
import org.apache.iotdb.confignode.consensus.request.write.sync.RecordPipeMessagePlan;
import org.apache.iotdb.confignode.consensus.request.write.sync.SetPipeStatusPlan;
import org.apache.iotdb.confignode.consensus.request.write.sync.ShowPipePlan;
import org.apache.iotdb.confignode.consensus.response.pipe.PipeResp;
import org.apache.iotdb.confignode.consensus.response.pipe.PipeSinkResp;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.consensus.ConsensusManager;
import org.apache.iotdb.confignode.manager.node.NodeManager;
import org.apache.iotdb.confignode.manager.observer.NodeStatisticsEvent;
import org.apache.iotdb.confignode.persistence.sync.ClusterSyncInfo;
import org.apache.iotdb.confignode.rpc.thrift.TGetAllPipeInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetPipeSinkResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipeResp;
import org.apache.iotdb.mpp.rpc.thrift.TCreatePipeOnDataNodeReq;
import org.apache.iotdb.mpp.rpc.thrift.TOperatePipeOnDataNodeReq;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncManager.class);
    private final IManager configManager;
    private final ClusterSyncInfo clusterSyncInfo;

    public SyncManager(IManager configManager, ClusterSyncInfo clusterSyncInfo) {
        this.configManager = configManager;
        this.clusterSyncInfo = clusterSyncInfo;
    }

    public void lockSyncMetadata() {
        this.clusterSyncInfo.lockSyncMetadata();
    }

    public void unlockSyncMetadata() {
        this.clusterSyncInfo.unlockSyncMetadata();
    }

    public TSStatus createPipeSink(CreatePipeSinkPlan plan) {
        try {
            this.clusterSyncInfo.checkAddPipeSink(plan);
            return this.getConsensusManager().write(plan).getStatus();
        }
        catch (PipeSinkException e) {
            LOGGER.error(e.getMessage());
            return new TSStatus(TSStatusCode.CREATE_PIPE_SINK_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
    }

    public TSStatus dropPipeSink(DropPipeSinkPlan plan) {
        try {
            this.clusterSyncInfo.checkDropPipeSink(plan.getPipeSinkName());
            return this.getConsensusManager().write(plan).getStatus();
        }
        catch (PipeSinkException e) {
            LOGGER.error(e.getMessage());
            return new TSStatus(TSStatusCode.CREATE_PIPE_SINK_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
    }

    public TGetPipeSinkResp getPipeSink(String pipeSinkName) {
        GetPipeSinkPlan getPipeSinkPlan = new GetPipeSinkPlan(pipeSinkName);
        PipeSinkResp pipeSinkResp = (PipeSinkResp)this.getConsensusManager().read(getPipeSinkPlan).getDataset();
        TGetPipeSinkResp resp = new TGetPipeSinkResp();
        resp.setStatus(pipeSinkResp.getStatus());
        if (pipeSinkResp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            resp.setPipeSinkInfoList(pipeSinkResp.getPipeSinkList().stream().map(PipeSink::getTPipeSinkInfo).collect(Collectors.toList()));
        }
        return resp;
    }

    public void checkAddPipe(PipeInfo pipeInfo) throws PipeException, PipeSinkNotExistException {
        this.clusterSyncInfo.checkAddPipe(pipeInfo);
    }

    public TSStatus preCreatePipe(PipeInfo pipeInfo) {
        pipeInfo.setStatus(PipeStatus.PARTIAL_CREATE);
        return this.getConsensusManager().write(new PreCreatePipePlan(pipeInfo)).getStatus();
    }

    public TSStatus setPipeStatus(String pipeName, PipeStatus pipeStatus) {
        return this.getConsensusManager().write(new SetPipeStatusPlan(pipeName, pipeStatus)).getStatus();
    }

    public TSStatus dropPipe(String pipeName) {
        return this.getConsensusManager().write(new DropPipePlan(pipeName)).getStatus();
    }

    public TSStatus recordPipeMessage(String pipeName, PipeMessage pipeMessage) {
        return this.getConsensusManager().write(new RecordPipeMessagePlan(pipeName, pipeMessage)).getStatus();
    }

    public TShowPipeResp showPipe(String pipeName) {
        ShowPipePlan showPipePlan = new ShowPipePlan(pipeName);
        PipeResp pipeResp = (PipeResp)this.getConsensusManager().read(showPipePlan).getDataset();
        TShowPipeResp resp = new TShowPipeResp();
        resp.setStatus(pipeResp.getStatus());
        if (pipeResp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            resp.setPipeInfoList(pipeResp.getPipeInfoList().stream().map(PipeInfo::getTShowPipeInfo).collect(Collectors.toList()));
        }
        return resp;
    }

    public PipeInfo getPipeInfo(String pipeName) throws PipeException {
        return this.clusterSyncInfo.getPipeInfo(pipeName);
    }

    public TGetAllPipeInfoResp getAllPipeInfo() {
        try {
            this.lockSyncMetadata();
            TGetAllPipeInfoResp resp = new TGetAllPipeInfoResp();
            resp.setStatus(StatusUtils.OK);
            resp.setAllPipeInfo(this.clusterSyncInfo.getAllPipeInfos().stream().map(PipeInfo::serializeToByteBuffer).collect(Collectors.toList()));
            TGetAllPipeInfoResp tGetAllPipeInfoResp = resp;
            return tGetAllPipeInfoResp;
        }
        finally {
            this.unlockSyncMetadata();
        }
    }

    public Map<Integer, TSStatus> operatePipeOnDataNodes(String pipeName, SyncOperation operation) {
        NodeManager nodeManager = this.configManager.getNodeManager();
        ConcurrentHashMap<Integer, TDataNodeLocation> dataNodeLocationMap = new ConcurrentHashMap<Integer, TDataNodeLocation>();
        nodeManager.filterDataNodeThroughStatus(NodeStatus.Running).forEach(dataNodeConfiguration -> dataNodeLocationMap.put(dataNodeConfiguration.getLocation().getDataNodeId(), dataNodeConfiguration.getLocation()));
        TOperatePipeOnDataNodeReq request = new TOperatePipeOnDataNodeReq(pipeName, (byte)operation.ordinal());
        AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.OPERATE_PIPE, request, dataNodeLocationMap);
        AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
        return clientHandler.getResponseMap();
    }

    public void operatePipeOnDataNodesForRollback(String pipeName, long createTime, SyncOperation operation, Set<Integer> dataNodeIds) {
        NodeManager nodeManager = this.configManager.getNodeManager();
        ConcurrentHashMap<Integer, TDataNodeLocation> dataNodeLocationMap = new ConcurrentHashMap<Integer, TDataNodeLocation>();
        nodeManager.filterDataNodeThroughStatus(NodeStatus.Running).stream().filter(dataNodeConfiguration -> dataNodeIds.contains(dataNodeConfiguration.getLocation().dataNodeId)).forEach(dataNodeConfiguration -> dataNodeLocationMap.put(dataNodeConfiguration.getLocation().getDataNodeId(), dataNodeConfiguration.getLocation()));
        TOperatePipeOnDataNodeReq request = new TOperatePipeOnDataNodeReq(pipeName, (byte)operation.ordinal()).setCreateTime(createTime);
        AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.ROLLBACK_OPERATE_PIPE, request, dataNodeLocationMap);
        AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
        ArrayList<Integer> failedRollbackDataNodeId = new ArrayList<Integer>();
        for (Map.Entry responseEntry : clientHandler.getResponseMap().entrySet()) {
            if (((TSStatus)responseEntry.getValue()).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
            failedRollbackDataNodeId.add(responseEntry.getKey());
        }
        this.configManager.getRetryFailedTasksThread().retryRollbackReq(failedRollbackDataNodeId, request);
    }

    public Map<Integer, TSStatus> preCreatePipeOnDataNodes(PipeInfo pipeInfo) {
        NodeManager nodeManager = this.configManager.getNodeManager();
        ConcurrentHashMap<Integer, TDataNodeLocation> dataNodeLocationMap = new ConcurrentHashMap<Integer, TDataNodeLocation>();
        nodeManager.filterDataNodeThroughStatus(NodeStatus.Running).forEach(dataNodeConfiguration -> dataNodeLocationMap.put(dataNodeConfiguration.getLocation().getDataNodeId(), dataNodeConfiguration.getLocation()));
        TCreatePipeOnDataNodeReq request = new TCreatePipeOnDataNodeReq(pipeInfo.serializeToByteBuffer());
        AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.PRE_CREATE_PIPE, request, dataNodeLocationMap);
        AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
        return clientHandler.getResponseMap();
    }

    @Subscribe
    @AllowConcurrentEvents
    public void handleNodeStatistics(NodeStatisticsEvent nodeStatisticsEvent) {
    }

    private ConsensusManager getConsensusManager() {
        return this.configManager.getConsensusManager();
    }
}

