/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.sync.PipeException;
import org.apache.iotdb.commons.model.ModelInformation;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.trigger.TriggerInformation;
import org.apache.iotdb.commons.utils.StatusUtils;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.write.confignode.RemoveConfigNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.datanode.RemoveDataNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.procedure.UpdateProcedurePlan;
import org.apache.iotdb.confignode.consensus.request.write.region.CreateRegionGroupsPlan;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.partition.PartitionManager;
import org.apache.iotdb.confignode.manager.partition.heartbeat.RegionGroupCache;
import org.apache.iotdb.confignode.persistence.ProcedureInfo;
import org.apache.iotdb.confignode.procedure.Procedure;
import org.apache.iotdb.confignode.procedure.ProcedureExecutor;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.impl.cq.CreateCQProcedure;
import org.apache.iotdb.confignode.procedure.impl.model.CreateModelProcedure;
import org.apache.iotdb.confignode.procedure.impl.model.DropModelProcedure;
import org.apache.iotdb.confignode.procedure.impl.node.AddConfigNodeProcedure;
import org.apache.iotdb.confignode.procedure.impl.node.RemoveConfigNodeProcedure;
import org.apache.iotdb.confignode.procedure.impl.node.RemoveDataNodeProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.DeactivateTemplateProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.DeleteDatabaseProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.DeleteTimeSeriesProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.UnsetTemplateProcedure;
import org.apache.iotdb.confignode.procedure.impl.statemachine.CreateRegionGroupsProcedure;
import org.apache.iotdb.confignode.procedure.impl.statemachine.RegionMigrateProcedure;
import org.apache.iotdb.confignode.procedure.impl.sync.CreatePipeProcedure;
import org.apache.iotdb.confignode.procedure.impl.sync.DropPipeProcedure;
import org.apache.iotdb.confignode.procedure.impl.sync.StartPipeProcedure;
import org.apache.iotdb.confignode.procedure.impl.sync.StopPipeProcedure;
import org.apache.iotdb.confignode.procedure.impl.trigger.CreateTriggerProcedure;
import org.apache.iotdb.confignode.procedure.impl.trigger.DropTriggerProcedure;
import org.apache.iotdb.confignode.procedure.scheduler.ProcedureScheduler;
import org.apache.iotdb.confignode.procedure.scheduler.SimpleProcedureScheduler;
import org.apache.iotdb.confignode.procedure.store.ConfigProcedureStore;
import org.apache.iotdb.confignode.procedure.store.IProcedureStore;
import org.apache.iotdb.confignode.procedure.store.ProcedureFactory;
import org.apache.iotdb.confignode.procedure.store.ProcedureStore;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRegisterReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateCQReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreatePipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchema;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteTimeSeriesReq;
import org.apache.iotdb.confignode.rpc.thrift.TMigrateRegionReq;
import org.apache.iotdb.confignode.rpc.thrift.TRegionMigrateResultReportReq;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.Binary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcedureManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcedureManager.class);
    private static final ConfigNodeConfig CONFIG_NODE_CONFIG = ConfigNodeDescriptor.getInstance().getConf();
    private static final int PROCEDURE_WAIT_TIME_OUT = 30;
    private static final int PROCEDURE_WAIT_RETRY_TIMEOUT = 250;
    private final ConfigManager configManager;
    private ProcedureExecutor<ConfigNodeProcedureEnv> executor;
    private ProcedureScheduler scheduler;
    private IProcedureStore store;
    private ConfigNodeProcedureEnv env;
    private final long planSizeLimit;

    public ProcedureManager(ConfigManager configManager, ProcedureInfo procedureInfo) {
        this.configManager = configManager;
        this.scheduler = new SimpleProcedureScheduler();
        this.store = new ConfigProcedureStore(configManager, procedureInfo);
        this.env = new ConfigNodeProcedureEnv(configManager, this.scheduler);
        this.executor = new ProcedureExecutor<ConfigNodeProcedureEnv>(this.env, this.store, this.scheduler);
        this.planSizeLimit = ConfigNodeDescriptor.getInstance().getConf().getConfigNodeRatisConsensusLogAppenderBufferSize() - 48L;
    }

    public void shiftExecutor(boolean running) {
        if (running) {
            if (!this.executor.isRunning()) {
                this.executor.init(CONFIG_NODE_CONFIG.getProcedureCoreWorkerThreadsCount());
                this.executor.startWorkers();
                this.executor.startCompletedCleaner(CONFIG_NODE_CONFIG.getProcedureCompletedCleanInterval(), CONFIG_NODE_CONFIG.getProcedureCompletedEvictTTL());
                this.store.start();
                LOGGER.info("ProcedureManager is started successfully.");
            }
        } else if (this.executor.isRunning()) {
            this.executor.stop();
            if (!this.executor.isRunning()) {
                this.executor.join();
                this.store.stop();
                LOGGER.info("ProcedureManager is stopped successfully.");
            }
        }
    }

    public TSStatus deleteDatabases(ArrayList<TDatabaseSchema> deleteSgSchemaList) {
        ArrayList<Long> procedureIds = new ArrayList<Long>();
        for (TDatabaseSchema storageGroupSchema : deleteSgSchemaList) {
            DeleteDatabaseProcedure deleteDatabaseProcedure = new DeleteDatabaseProcedure(storageGroupSchema);
            long procedureId = this.executor.submitProcedure(deleteDatabaseProcedure);
            procedureIds.add(procedureId);
        }
        ArrayList<TSStatus> procedureStatus = new ArrayList<TSStatus>();
        boolean isSucceed = this.waitingProcedureFinished(procedureIds, procedureStatus);
        PartitionManager partitionManager = this.getConfigManager().getPartitionManager();
        partitionManager.getRegionMaintainer().submit(partitionManager::maintainRegionReplicas);
        if (isSucceed) {
            return StatusUtils.OK;
        }
        return RpcUtils.getStatus(procedureStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus deleteTimeSeries(TDeleteTimeSeriesReq req) {
        String queryId = req.getQueryId();
        PathPatternTree patternTree = PathPatternTree.deserialize((ByteBuffer)ByteBuffer.wrap(req.getPathPatternTree()));
        long procedureId = -1L;
        ProcedureManager procedureManager = this;
        synchronized (procedureManager) {
            boolean hasOverlappedTask = false;
            for (Procedure procedure : this.executor.getProcedures().values()) {
                ProcedureType type = ProcedureFactory.getProcedureType(procedure);
                if (type == null || !type.equals((Object)ProcedureType.DELETE_TIMESERIES_PROCEDURE)) continue;
                DeleteTimeSeriesProcedure deleteTimeSeriesProcedure = (DeleteTimeSeriesProcedure)procedure;
                if (queryId.equals(deleteTimeSeriesProcedure.getQueryId())) {
                    procedureId = deleteTimeSeriesProcedure.getProcId();
                    break;
                }
                if (!patternTree.isOverlapWith(deleteTimeSeriesProcedure.getPatternTree())) continue;
                hasOverlappedTask = true;
                break;
            }
            if (procedureId == -1L) {
                if (hasOverlappedTask) {
                    return RpcUtils.getStatus((TSStatusCode)TSStatusCode.OVERLAP_WITH_EXISTING_TASK, (String)"Some other task is deleting some target timeseries.");
                }
                procedureId = this.executor.submitProcedure(new DeleteTimeSeriesProcedure(queryId, patternTree));
            }
        }
        ArrayList<TSStatus> procedureStatus = new ArrayList<TSStatus>();
        boolean isSucceed = this.waitingProcedureFinished(Collections.singletonList(procedureId), procedureStatus);
        if (isSucceed) {
            return StatusUtils.OK;
        }
        return (TSStatus)procedureStatus.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus deactivateTemplate(String queryId, Map<PartialPath, List<Template>> templateSetInfo) {
        long procedureId = -1L;
        ProcedureManager procedureManager = this;
        synchronized (procedureManager) {
            boolean hasOverlappedTask = false;
            for (Procedure procedure : this.executor.getProcedures().values()) {
                ProcedureType type = ProcedureFactory.getProcedureType(procedure);
                if (type == null || !type.equals((Object)ProcedureType.DEACTIVATE_TEMPLATE_PROCEDURE)) continue;
                DeactivateTemplateProcedure deactivateTemplateProcedure = (DeactivateTemplateProcedure)procedure;
                if (queryId.equals(deactivateTemplateProcedure.getQueryId())) {
                    procedureId = deactivateTemplateProcedure.getProcId();
                    break;
                }
                for (PartialPath pattern : templateSetInfo.keySet()) {
                    for (PartialPath existingPattern : deactivateTemplateProcedure.getTemplateSetInfo().keySet()) {
                        if (!pattern.overlapWith(existingPattern)) continue;
                        hasOverlappedTask = true;
                        break;
                    }
                    if (!hasOverlappedTask) continue;
                    break;
                }
                if (!hasOverlappedTask) continue;
                break;
            }
            if (procedureId == -1L) {
                if (hasOverlappedTask) {
                    return RpcUtils.getStatus((TSStatusCode)TSStatusCode.OVERLAP_WITH_EXISTING_TASK, (String)"Some other task is deactivating some target template from target path.");
                }
                procedureId = this.executor.submitProcedure(new DeactivateTemplateProcedure(queryId, templateSetInfo));
            }
        }
        ArrayList<TSStatus> procedureStatus = new ArrayList<TSStatus>();
        boolean isSucceed = this.waitingProcedureFinished(Collections.singletonList(procedureId), procedureStatus);
        if (isSucceed) {
            return StatusUtils.OK;
        }
        return (TSStatus)procedureStatus.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus unsetSchemaTemplate(String queryId, Template template, PartialPath path) {
        long procedureId = -1L;
        ProcedureManager procedureManager = this;
        synchronized (procedureManager) {
            boolean hasOverlappedTask = false;
            for (Procedure procedure : this.executor.getProcedures().values()) {
                ProcedureType type = ProcedureFactory.getProcedureType(procedure);
                if (type == null || !type.equals((Object)ProcedureType.UNSET_TEMPLATE_PROCEDURE)) continue;
                UnsetTemplateProcedure unsetTemplateProcedure = (UnsetTemplateProcedure)procedure;
                if (queryId.equals(unsetTemplateProcedure.getQueryId())) {
                    procedureId = unsetTemplateProcedure.getProcId();
                    break;
                }
                if (template.getId() != unsetTemplateProcedure.getTemplateId() || !path.equals((Object)unsetTemplateProcedure.getPath())) continue;
                hasOverlappedTask = true;
                break;
            }
            if (procedureId == -1L) {
                if (hasOverlappedTask) {
                    return RpcUtils.getStatus((TSStatusCode)TSStatusCode.OVERLAP_WITH_EXISTING_TASK, (String)("Some other task is unsetting target template from target path " + path.getFullPath()));
                }
                procedureId = this.executor.submitProcedure(new UnsetTemplateProcedure(queryId, template, path));
            }
        }
        ArrayList<TSStatus> procedureStatus = new ArrayList<TSStatus>();
        boolean isSucceed = this.waitingProcedureFinished(Collections.singletonList(procedureId), procedureStatus);
        if (isSucceed) {
            return StatusUtils.OK;
        }
        return (TSStatus)procedureStatus.get(0);
    }

    public void addConfigNode(TConfigNodeRegisterReq req) {
        AddConfigNodeProcedure addConfigNodeProcedure = new AddConfigNodeProcedure(req.getConfigNodeLocation());
        this.executor.submitProcedure(addConfigNodeProcedure);
    }

    public void removeConfigNode(RemoveConfigNodePlan removeConfigNodePlan) {
        RemoveConfigNodeProcedure removeConfigNodeProcedure = new RemoveConfigNodeProcedure(removeConfigNodePlan.getConfigNodeLocation());
        this.executor.submitProcedure(removeConfigNodeProcedure);
        LOGGER.info("Submit RemoveConfigNodeProcedure successfully: {}", (Object)removeConfigNodePlan);
    }

    public boolean removeDataNode(RemoveDataNodePlan removeDataNodePlan) {
        removeDataNodePlan.getDataNodeLocations().forEach(tDataNodeLocation -> {
            this.executor.submitProcedure(new RemoveDataNodeProcedure((TDataNodeLocation)tDataNodeLocation));
            LOGGER.info("Submit RemoveDataNodeProcedure successfully, {}", tDataNodeLocation);
        });
        return true;
    }

    public TSStatus migrateRegion(TMigrateRegionReq migrateRegionReq) {
        Map<TConsensusGroupId, RegionGroupCache> regionReplicaMap = this.configManager.getPartitionManager().getRegionGroupCacheMap();
        Optional<TConsensusGroupId> regionId = regionReplicaMap.keySet().stream().filter(id -> id.getId() == migrateRegionReq.getRegionId()).findAny();
        TDataNodeLocation originalDataNode = this.configManager.getNodeManager().getRegisteredDataNode(migrateRegionReq.getFromId()).getLocation();
        TDataNodeLocation destDataNode = this.configManager.getNodeManager().getRegisteredDataNode(migrateRegionReq.getToId()).getLocation();
        if (!regionId.isPresent()) {
            LOGGER.warn("Submit RegionMigrateProcedure failed, because no Region {}", (Object)migrateRegionReq.getRegionId());
            TSStatus status = new TSStatus(TSStatusCode.MIGRATE_REGION_ERROR.getStatusCode());
            status.setMessage("Submit RegionMigrateProcedure failed, because no region Group " + migrateRegionReq.getRegionId());
            return status;
        }
        Set<Integer> dataNodesInRegion = regionReplicaMap.get(regionId.get()).getStatistics().getRegionStatisticsMap().keySet();
        if (originalDataNode == null) {
            LOGGER.warn("Submit RegionMigrateProcedure failed, because no original DataNode {}", (Object)migrateRegionReq.getFromId());
            TSStatus status = new TSStatus(TSStatusCode.MIGRATE_REGION_ERROR.getStatusCode());
            status.setMessage("Submit RegionMigrateProcedure failed, because no original DataNode " + migrateRegionReq.getFromId());
            return status;
        }
        if (destDataNode == null) {
            LOGGER.warn("Submit RegionMigrateProcedure failed, because no target DataNode {}", (Object)migrateRegionReq.getToId());
            TSStatus status = new TSStatus(TSStatusCode.MIGRATE_REGION_ERROR.getStatusCode());
            status.setMessage("Submit RegionMigrateProcedure failed, because no target DataNode " + migrateRegionReq.getToId());
            return status;
        }
        if (!dataNodesInRegion.contains(migrateRegionReq.getFromId())) {
            LOGGER.warn("Submit RegionMigrateProcedure failed, because the original DataNode {} doesn't contain Region {}", (Object)migrateRegionReq.getFromId(), (Object)migrateRegionReq.getRegionId());
            TSStatus status = new TSStatus(TSStatusCode.MIGRATE_REGION_ERROR.getStatusCode());
            status.setMessage("Submit RegionMigrateProcedure failed, because the original DataNode " + migrateRegionReq.getFromId() + " doesn't contain Region " + migrateRegionReq.getRegionId());
            return status;
        }
        if (dataNodesInRegion.contains(migrateRegionReq.getToId())) {
            LOGGER.warn("Submit RegionMigrateProcedure failed, because the target DataNode {} already contains Region {}", (Object)migrateRegionReq.getToId(), (Object)migrateRegionReq.getRegionId());
            TSStatus status = new TSStatus(TSStatusCode.MIGRATE_REGION_ERROR.getStatusCode());
            status.setMessage("Submit RegionMigrateProcedure failed, because the target DataNode " + migrateRegionReq.getToId() + " already contains Region " + migrateRegionReq.getRegionId());
            return status;
        }
        Set aliveDataNodes = this.configManager.getNodeManager().filterDataNodeThroughStatus(NodeStatus.Running).stream().map(TDataNodeConfiguration::getLocation).map(TDataNodeLocation::getDataNodeId).collect(Collectors.toSet());
        if (!aliveDataNodes.contains(migrateRegionReq.getFromId())) {
            LOGGER.warn("Submit RegionMigrateProcedure failed, because the sourceDataNode {} is Unknown.", (Object)migrateRegionReq.getFromId());
            TSStatus status = new TSStatus(TSStatusCode.MIGRATE_REGION_ERROR.getStatusCode());
            status.setMessage("Submit RegionMigrateProcedure failed, because the sourceDataNode " + migrateRegionReq.getFromId() + " is Unknown.");
            return status;
        }
        dataNodesInRegion.retainAll(aliveDataNodes);
        if (dataNodesInRegion.isEmpty()) {
            LOGGER.warn("Submit RegionMigrateProcedure failed, because all of the DataNodes in Region Group {} is unavailable.", (Object)migrateRegionReq.getRegionId());
            TSStatus status = new TSStatus(TSStatusCode.MIGRATE_REGION_ERROR.getStatusCode());
            status.setMessage("Submit RegionMigrateProcedure failed, because all of the DataNodes in Region Group " + migrateRegionReq.getRegionId() + " are unavailable.");
            return status;
        }
        if (!aliveDataNodes.contains(migrateRegionReq.getToId())) {
            LOGGER.warn("Submit RegionMigrateProcedure failed, because the destDataNode {} is ReadOnly or Unknown.", (Object)migrateRegionReq.getToId());
            TSStatus status = new TSStatus(TSStatusCode.MIGRATE_REGION_ERROR.getStatusCode());
            status.setMessage("Submit RegionMigrateProcedure failed, because the destDataNode " + migrateRegionReq.getToId() + " is ReadOnly or Unknown.");
            return status;
        }
        this.executor.submitProcedure(new RegionMigrateProcedure(regionId.get(), originalDataNode, destDataNode));
        LOGGER.info("Submit RegionMigrateProcedure successfully, Region: {}, From: {}, To: {}", new Object[]{migrateRegionReq.getRegionId(), migrateRegionReq.getFromId(), migrateRegionReq.getToId()});
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public TSStatus createRegionGroups(TConsensusGroupType consensusGroupType, CreateRegionGroupsPlan createRegionGroupsPlan) {
        long procedureId = this.executor.submitProcedure(new CreateRegionGroupsProcedure(consensusGroupType, createRegionGroupsPlan));
        ArrayList<TSStatus> statusList = new ArrayList<TSStatus>();
        boolean isSucceed = this.waitingProcedureFinished(Collections.singletonList(procedureId), statusList);
        if (isSucceed) {
            return RpcUtils.SUCCESS_STATUS;
        }
        return new TSStatus(TSStatusCode.CREATE_REGION_ERROR.getStatusCode()).setMessage(((TSStatus)statusList.get(0)).getMessage());
    }

    public TSStatus createTrigger(TriggerInformation triggerInformation, Binary jarFile) {
        CreateTriggerProcedure createTriggerProcedure = new CreateTriggerProcedure(triggerInformation, jarFile);
        try {
            if (jarFile != null && (long)new UpdateProcedurePlan(createTriggerProcedure).getSerializedSize() > this.planSizeLimit) {
                return new TSStatus(TSStatusCode.CREATE_TRIGGER_ERROR.getStatusCode()).setMessage(String.format("Fail to create trigger[%s], the size of Jar is too large, you can increase the value of property 'config_node_ratis_log_appender_buffer_size_max' on ConfigNode", triggerInformation.getTriggerName()));
            }
        }
        catch (IOException e) {
            return new TSStatus(TSStatusCode.CREATE_TRIGGER_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
        long procedureId = this.executor.submitProcedure(createTriggerProcedure);
        ArrayList<TSStatus> statusList = new ArrayList<TSStatus>();
        boolean isSucceed = this.waitingProcedureFinished(Collections.singletonList(procedureId), statusList);
        if (isSucceed) {
            return RpcUtils.SUCCESS_STATUS;
        }
        return new TSStatus(TSStatusCode.CREATE_TRIGGER_ERROR.getStatusCode()).setMessage(((TSStatus)statusList.get(0)).getMessage());
    }

    public TSStatus dropTrigger(String triggerName) {
        long procedureId = this.executor.submitProcedure(new DropTriggerProcedure(triggerName));
        ArrayList<TSStatus> statusList = new ArrayList<TSStatus>();
        boolean isSucceed = this.waitingProcedureFinished(Collections.singletonList(procedureId), statusList);
        if (isSucceed) {
            return RpcUtils.SUCCESS_STATUS;
        }
        return new TSStatus(TSStatusCode.DROP_TRIGGER_ERROR.getStatusCode()).setMessage(((TSStatus)statusList.get(0)).getMessage());
    }

    public TSStatus createCQ(TCreateCQReq req, ScheduledExecutorService scheduledExecutor) {
        long procedureId = this.executor.submitProcedure(new CreateCQProcedure(req, scheduledExecutor));
        ArrayList<TSStatus> statusList = new ArrayList<TSStatus>();
        this.waitingProcedureFinished(Collections.singletonList(procedureId), statusList);
        return (TSStatus)statusList.get(0);
    }

    public TSStatus createModel(ModelInformation modelInformation, Map<String, String> modelConfigs) {
        long procedureId = this.executor.submitProcedure(new CreateModelProcedure(modelInformation, modelConfigs));
        ArrayList<TSStatus> statusList = new ArrayList<TSStatus>();
        boolean isSucceed = this.waitingProcedureFinished(Collections.singletonList(procedureId), statusList);
        if (isSucceed) {
            return RpcUtils.SUCCESS_STATUS;
        }
        return new TSStatus(TSStatusCode.CREATE_MODEL_ERROR.getStatusCode()).setMessage(((TSStatus)statusList.get(0)).getMessage());
    }

    public TSStatus dropModel(String modelId) {
        long procedureId = this.executor.submitProcedure(new DropModelProcedure(modelId));
        ArrayList<TSStatus> statusList = new ArrayList<TSStatus>();
        boolean isSucceed = this.waitingProcedureFinished(Collections.singletonList(procedureId), statusList);
        if (isSucceed) {
            return RpcUtils.SUCCESS_STATUS;
        }
        return new TSStatus(TSStatusCode.DROP_MODEL_ERROR.getStatusCode()).setMessage(((TSStatus)statusList.get(0)).getMessage());
    }

    public TSStatus createPipe(TCreatePipeReq req) {
        try {
            long procedureId = this.executor.submitProcedure(new CreatePipeProcedure(req));
            ArrayList<TSStatus> statusList = new ArrayList<TSStatus>();
            boolean isSucceed = this.waitingProcedureFinished(Collections.singletonList(procedureId), statusList);
            if (isSucceed) {
                return RpcUtils.SUCCESS_STATUS;
            }
            return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage(((TSStatus)statusList.get(0)).getMessage());
        }
        catch (PipeException e) {
            return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
    }

    public TSStatus startPipe(String pipeName) {
        try {
            long procedureId = this.executor.submitProcedure(new StartPipeProcedure(pipeName));
            ArrayList<TSStatus> statusList = new ArrayList<TSStatus>();
            boolean isSucceed = this.waitingProcedureFinished(Collections.singletonList(procedureId), statusList);
            if (isSucceed) {
                return RpcUtils.SUCCESS_STATUS;
            }
            return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage(((TSStatus)statusList.get(0)).getMessage());
        }
        catch (PipeException e) {
            return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
    }

    public TSStatus stopPipe(String pipeName) {
        try {
            long procedureId = this.executor.submitProcedure(new StopPipeProcedure(pipeName));
            ArrayList<TSStatus> statusList = new ArrayList<TSStatus>();
            boolean isSucceed = this.waitingProcedureFinished(Collections.singletonList(procedureId), statusList);
            if (isSucceed) {
                return RpcUtils.SUCCESS_STATUS;
            }
            return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage(((TSStatus)statusList.get(0)).getMessage());
        }
        catch (PipeException e) {
            return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
    }

    public TSStatus dropPipe(String pipeName) {
        try {
            long procedureId = this.executor.submitProcedure(new DropPipeProcedure(pipeName));
            ArrayList<TSStatus> statusList = new ArrayList<TSStatus>();
            boolean isSucceed = this.waitingProcedureFinished(Collections.singletonList(procedureId), statusList);
            if (isSucceed) {
                return RpcUtils.SUCCESS_STATUS;
            }
            return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage(((TSStatus)statusList.get(0)).getMessage());
        }
        catch (PipeException e) {
            return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
    }

    private boolean waitingProcedureFinished(List<Long> procedureIds, List<TSStatus> statusList) {
        boolean isSucceed = true;
        for (long procedureId : procedureIds) {
            long startTimeForCurrentProcedure = System.currentTimeMillis();
            while (this.executor.isRunning() && !this.executor.isFinished(procedureId) && TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - startTimeForCurrentProcedure) < 30L) {
                ProcedureManager.sleepWithoutInterrupt(250L);
            }
            Procedure<ConfigNodeProcedureEnv> finishedProcedure = this.executor.getResultOrProcedure(procedureId);
            if (!finishedProcedure.isFinished()) {
                statusList.add(RpcUtils.getStatus((TSStatusCode)TSStatusCode.OVERLAP_WITH_EXISTING_TASK));
                isSucceed = false;
                continue;
            }
            if (finishedProcedure.isSuccess()) {
                statusList.add(StatusUtils.OK);
                continue;
            }
            if (finishedProcedure.getException().getCause() instanceof IoTDBException) {
                IoTDBException e = (IoTDBException)finishedProcedure.getException().getCause();
                statusList.add(RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
            } else {
                statusList.add(StatusUtils.EXECUTE_STATEMENT_ERROR.setMessage(finishedProcedure.getException().getMessage()));
            }
            isSucceed = false;
        }
        return isSucceed;
    }

    public static void sleepWithoutInterrupt(long timeToSleep) {
        long currentTime = System.currentTimeMillis();
        long endTime = timeToSleep + currentTime;
        boolean interrupted = false;
        while (currentTime < endTime) {
            try {
                Thread.sleep(endTime - currentTime);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
            currentTime = System.currentTimeMillis();
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public IManager getConfigManager() {
        return this.configManager;
    }

    public ProcedureExecutor<ConfigNodeProcedureEnv> getExecutor() {
        return this.executor;
    }

    public void setExecutor(ProcedureExecutor<ConfigNodeProcedureEnv> executor) {
        this.executor = executor;
    }

    public ProcedureScheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(ProcedureScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public IProcedureStore getStore() {
        return this.store;
    }

    public void setStore(ProcedureStore store) {
        this.store = store;
    }

    public ConfigNodeProcedureEnv getEnv() {
        return this.env;
    }

    public void setEnv(ConfigNodeProcedureEnv env) {
        this.env = env;
    }

    public void reportRegionMigrateResult(TRegionMigrateResultReportReq req) {
        this.executor.getProcedures().values().forEach(procedure -> {
            RegionMigrateProcedure regionMigrateProcedure;
            if (procedure instanceof RegionMigrateProcedure && (regionMigrateProcedure = (RegionMigrateProcedure)procedure).getConsensusGroupId().equals(req.getRegionId())) {
                regionMigrateProcedure.notifyTheRegionMigrateFinished(req);
            }
        });
    }
}

