/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager;

import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.confignode.client.sync.SyncDataNodeClientPool;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.consensus.request.auth.AuthorPlan;
import org.apache.iotdb.confignode.consensus.response.auth.PermissionInfoResp;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.manager.consensus.ConsensusManager;
import org.apache.iotdb.confignode.persistence.AuthorInfo;
import org.apache.iotdb.confignode.rpc.thrift.TPermissionInfoResp;
import org.apache.iotdb.mpp.rpc.thrift.TInvalidatePermissionCacheReq;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;

public class PermissionManager {
    private final ConfigManager configManager;
    private final AuthorInfo authorInfo;

    public PermissionManager(ConfigManager configManager, AuthorInfo authorInfo) {
        this.configManager = configManager;
        this.authorInfo = authorInfo;
    }

    public TSStatus operatePermission(AuthorPlan authorPlan) {
        TSStatus tsStatus;
        if (authorPlan.getAuthorType() == ConfigPhysicalPlanType.CreateUser || authorPlan.getAuthorType() == ConfigPhysicalPlanType.CreateRole) {
            tsStatus = this.getConsensusManager().write(authorPlan).getStatus();
        } else {
            tsStatus = this.invalidateCache(authorPlan.getUserName(), authorPlan.getRoleName());
            if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                tsStatus = this.getConsensusManager().write(authorPlan).getStatus();
            }
        }
        return tsStatus;
    }

    public PermissionInfoResp queryPermission(AuthorPlan authorPlan) {
        return (PermissionInfoResp)this.getConsensusManager().read(authorPlan).getDataset();
    }

    private ConsensusManager getConsensusManager() {
        return this.configManager.getConsensusManager();
    }

    public TPermissionInfoResp login(String username, String password) {
        return this.authorInfo.login(username, password);
    }

    public TPermissionInfoResp checkUserPrivileges(String username, List<String> paths, int permission) {
        return this.authorInfo.checkUserPrivileges(username, paths, permission);
    }

    public TSStatus invalidateCache(String username, String roleName) {
        List<TDataNodeConfiguration> allDataNodes = this.configManager.getNodeManager().getRegisteredDataNodes();
        TInvalidatePermissionCacheReq req = new TInvalidatePermissionCacheReq();
        req.setUsername(username);
        req.setRoleName(roleName);
        for (TDataNodeConfiguration dataNodeInfo : allDataNodes) {
            TSStatus status = SyncDataNodeClientPool.getInstance().sendSyncRequestToDataNodeWithRetry(dataNodeInfo.getLocation().getInternalEndPoint(), req, DataNodeRequestType.INVALIDATE_PERMISSION_CACHE);
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
            return status;
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }
}

