/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.model;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.rpc.thrift.TUpdateModelInfoReq;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class UpdateModelInfoPlan
extends ConfigPhysicalPlan {
    private String modelId;
    private String trailId;
    private Map<String, String> modelInfo;

    public UpdateModelInfoPlan() {
        super(ConfigPhysicalPlanType.UpdateModelInfo);
    }

    public UpdateModelInfoPlan(TUpdateModelInfoReq updateModelInfoReq) {
        super(ConfigPhysicalPlanType.UpdateModelInfo);
        this.modelId = updateModelInfoReq.getModelId();
        this.trailId = updateModelInfoReq.getTrailId();
        this.modelInfo = updateModelInfoReq.getModelInfo();
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getTrailId() {
        return this.trailId;
    }

    public Map<String, String> getModelInfo() {
        return this.modelInfo;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        ReadWriteIOUtils.write((String)this.modelId, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.trailId, (OutputStream)stream);
        ReadWriteIOUtils.write(this.modelInfo, (OutputStream)stream);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.modelId = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        this.trailId = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        this.modelInfo = ReadWriteIOUtils.readMap((ByteBuffer)buffer);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UpdateModelInfoPlan that = (UpdateModelInfoPlan)o;
        return this.modelId.equals(that.modelId) && this.trailId.equals(that.trailId) && this.modelInfo.equals(that.modelInfo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.modelId, this.trailId, this.modelInfo);
    }
}

