/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client.async.handlers.heartbeat;

import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.commons.cluster.RegionStatus;
import org.apache.iotdb.confignode.manager.load.balancer.RouteBalancer;
import org.apache.iotdb.confignode.manager.node.heartbeat.DataNodeHeartbeatCache;
import org.apache.iotdb.confignode.manager.node.heartbeat.NodeHeartbeatSample;
import org.apache.iotdb.confignode.manager.partition.heartbeat.RegionGroupCache;
import org.apache.iotdb.confignode.manager.partition.heartbeat.RegionHeartbeatSample;
import org.apache.iotdb.mpp.rpc.thrift.THeartbeatResp;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.thrift.async.AsyncMethodCallback;

public class DataNodeHeartbeatHandler
implements AsyncMethodCallback<THeartbeatResp> {
    private final TDataNodeLocation dataNodeLocation;
    private final DataNodeHeartbeatCache dataNodeHeartbeatCache;
    private final Map<TConsensusGroupId, RegionGroupCache> regionGroupCacheMap;
    private final RouteBalancer routeBalancer;

    public DataNodeHeartbeatHandler(TDataNodeLocation dataNodeLocation, DataNodeHeartbeatCache dataNodeHeartbeatCache, Map<TConsensusGroupId, RegionGroupCache> regionGroupCacheMap, RouteBalancer routeBalancer) {
        this.dataNodeLocation = dataNodeLocation;
        this.dataNodeHeartbeatCache = dataNodeHeartbeatCache;
        this.regionGroupCacheMap = regionGroupCacheMap;
        this.routeBalancer = routeBalancer;
    }

    public void onComplete(THeartbeatResp heartbeatResp) {
        long receiveTime = System.currentTimeMillis();
        this.dataNodeHeartbeatCache.cacheHeartbeatSample(new NodeHeartbeatSample(heartbeatResp, receiveTime));
        heartbeatResp.getJudgedLeaders().forEach((regionGroupId, isLeader) -> {
            this.regionGroupCacheMap.computeIfAbsent((TConsensusGroupId)regionGroupId, empty -> new RegionGroupCache((TConsensusGroupId)regionGroupId)).cacheHeartbeatSample(this.dataNodeLocation.getDataNodeId(), new RegionHeartbeatSample(heartbeatResp.getHeartbeatTimestamp(), receiveTime, RegionStatus.parse((String)heartbeatResp.getStatus())));
            if (isLeader.booleanValue()) {
                this.routeBalancer.cacheLeaderSample((TConsensusGroupId)regionGroupId, (Pair<Long, Integer>)new Pair((Object)heartbeatResp.getHeartbeatTimestamp(), (Object)this.dataNodeLocation.getDataNodeId()));
            }
        });
    }

    public void onError(Exception e) {
    }
}

