/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.auth.role;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.auth.entity.Role;
import org.apache.iotdb.commons.auth.role.IRoleAccessor;
import org.apache.iotdb.commons.auth.role.IRoleManager;
import org.apache.iotdb.commons.auth.role.LocalFileRoleAccessor;
import org.apache.iotdb.commons.concurrent.HashLock;
import org.apache.iotdb.commons.utils.AuthUtils;
import org.apache.iotdb.rpc.TSStatusCode;

public abstract class BasicRoleManager
implements IRoleManager {
    protected Map<String, Role> roleMap = new HashMap<String, Role>();
    protected IRoleAccessor accessor;
    protected HashLock lock;

    BasicRoleManager(LocalFileRoleAccessor accessor) {
        this.accessor = accessor;
        this.lock = new HashLock();
    }

    @Override
    public Role getRole(String rolename) throws AuthException {
        this.lock.readLock(rolename);
        Role role = this.roleMap.get(rolename);
        try {
            if (role == null && (role = this.accessor.loadRole(rolename)) != null) {
                this.roleMap.put(rolename, role);
            }
        }
        catch (IOException e) {
            throw new AuthException(TSStatusCode.AUTH_IO_EXCEPTION, (Throwable)e);
        }
        finally {
            this.lock.readUnlock(rolename);
        }
        return role;
    }

    @Override
    public boolean createRole(String rolename) throws AuthException {
        AuthUtils.validateRolename(rolename);
        Role role = this.getRole(rolename);
        if (role != null) {
            return false;
        }
        this.lock.writeLock(rolename);
        try {
            role = new Role(rolename);
            this.accessor.saveRole(role);
            this.roleMap.put(rolename, role);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw new AuthException(TSStatusCode.AUTH_IO_EXCEPTION, (Throwable)e);
        }
        finally {
            this.lock.writeUnlock(rolename);
        }
    }

    @Override
    public boolean deleteRole(String rolename) throws AuthException {
        this.lock.writeLock(rolename);
        try {
            if (this.accessor.deleteRole(rolename)) {
                this.roleMap.remove(rolename);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            throw new AuthException(TSStatusCode.AUTH_IO_EXCEPTION, (Throwable)e);
        }
        finally {
            this.lock.writeUnlock(rolename);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean grantPrivilegeToRole(String rolename, String path, int privilegeId) throws AuthException {
        AuthUtils.validatePrivilegeOnPath(path, privilegeId);
        this.lock.writeLock(rolename);
        try {
            Role role = this.getRole(rolename);
            if (role == null) {
                throw new AuthException(TSStatusCode.ROLE_NOT_EXIST, String.format("No such role %s", rolename));
            }
            if (role.hasPrivilege(path, privilegeId)) {
                boolean bl = false;
                return bl;
            }
            HashSet<Integer> privilegesCopy = new HashSet<Integer>(role.getPrivileges(path));
            role.addPrivilege(path, privilegeId);
            try {
                this.accessor.saveRole(role);
            }
            catch (IOException e) {
                role.setPrivileges(path, privilegesCopy);
                throw new AuthException(TSStatusCode.AUTH_IO_EXCEPTION, (Throwable)e);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeUnlock(rolename);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean revokePrivilegeFromRole(String rolename, String path, int privilegeId) throws AuthException {
        AuthUtils.validatePrivilegeOnPath(path, privilegeId);
        this.lock.writeLock(rolename);
        try {
            Role role = this.getRole(rolename);
            if (role == null) {
                throw new AuthException(TSStatusCode.ROLE_NOT_EXIST, String.format("No such role %s", rolename));
            }
            if (!role.hasPrivilege(path, privilegeId)) {
                boolean bl = false;
                return bl;
            }
            role.removePrivilege(path, privilegeId);
            try {
                this.accessor.saveRole(role);
            }
            catch (IOException e) {
                role.addPrivilege(path, privilegeId);
                throw new AuthException(TSStatusCode.AUTH_IO_EXCEPTION, (Throwable)e);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeUnlock(rolename);
        }
    }

    @Override
    public void reset() {
        this.accessor.reset();
        this.roleMap.clear();
    }

    @Override
    public List<String> listAllRoles() {
        List<String> rtlist = this.accessor.listAllRoles();
        rtlist.sort(null);
        return rtlist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceAllRoles(Map<String, Role> roles) throws AuthException {
        BasicRoleManager basicRoleManager = this;
        synchronized (basicRoleManager) {
            this.reset();
            this.roleMap = roles;
            for (Map.Entry<String, Role> entry : this.roleMap.entrySet()) {
                Role role = entry.getValue();
                try {
                    this.accessor.saveRole(role);
                }
                catch (IOException e) {
                    throw new AuthException(TSStatusCode.AUTH_IO_EXCEPTION, (Throwable)e);
                }
            }
        }
    }
}

