/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.config;

import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class IoTConsensusConfig {
    private final RPC rpc;
    private final Replication replication;

    private IoTConsensusConfig(RPC rpc, Replication replication) {
        this.rpc = rpc;
        this.replication = replication;
    }

    public RPC getRpc() {
        return this.rpc;
    }

    public Replication getReplication() {
        return this.replication;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Replication {
        private final int maxLogEntriesNumPerBatch;
        private final int maxSizePerBatch;
        private final int maxPendingBatchesNum;
        private final long maxWaitingTimeForWaitBatchInMs;
        private final int maxWaitingTimeForAccumulatingBatchInMs;
        private final long basicRetryWaitTimeMs;
        private final long maxRetryWaitTimeMs;
        private final long walThrottleThreshold;
        private final long throttleTimeOutMs;
        private final long checkpointGap;
        private final long allocateMemoryForConsensus;
        private final long allocateMemoryForQueue;

        private Replication(int maxLogEntriesNumPerBatch, int maxSizePerBatch, int maxPendingBatchesNum, long maxWaitingTimeForWaitBatchInMs, int maxWaitingTimeForAccumulatingBatchInMs, long basicRetryWaitTimeMs, long maxRetryWaitTimeMs, long walThrottleThreshold, long throttleTimeOutMs, long checkpointGap, long allocateMemoryForConsensus, double maxMemoryRatioForQueue) {
            this.maxLogEntriesNumPerBatch = maxLogEntriesNumPerBatch;
            this.maxSizePerBatch = maxSizePerBatch;
            this.maxPendingBatchesNum = maxPendingBatchesNum;
            this.maxWaitingTimeForWaitBatchInMs = maxWaitingTimeForWaitBatchInMs;
            this.maxWaitingTimeForAccumulatingBatchInMs = maxWaitingTimeForAccumulatingBatchInMs;
            this.basicRetryWaitTimeMs = basicRetryWaitTimeMs;
            this.maxRetryWaitTimeMs = maxRetryWaitTimeMs;
            this.walThrottleThreshold = walThrottleThreshold;
            this.throttleTimeOutMs = throttleTimeOutMs;
            this.checkpointGap = checkpointGap;
            this.allocateMemoryForConsensus = allocateMemoryForConsensus;
            this.allocateMemoryForQueue = (long)((double)allocateMemoryForConsensus * maxMemoryRatioForQueue);
        }

        public int getMaxLogEntriesNumPerBatch() {
            return this.maxLogEntriesNumPerBatch;
        }

        public int getMaxSizePerBatch() {
            return this.maxSizePerBatch;
        }

        public int getMaxPendingBatchesNum() {
            return this.maxPendingBatchesNum;
        }

        public long getMaxWaitingTimeForWaitBatchInMs() {
            return this.maxWaitingTimeForWaitBatchInMs;
        }

        public int getMaxWaitingTimeForAccumulatingBatchInMs() {
            return this.maxWaitingTimeForAccumulatingBatchInMs;
        }

        public long getBasicRetryWaitTimeMs() {
            return this.basicRetryWaitTimeMs;
        }

        public long getMaxRetryWaitTimeMs() {
            return this.maxRetryWaitTimeMs;
        }

        public long getWalThrottleThreshold() {
            return this.walThrottleThreshold;
        }

        public long getThrottleTimeOutMs() {
            return this.throttleTimeOutMs;
        }

        public long getCheckpointGap() {
            return this.checkpointGap;
        }

        public Long getAllocateMemoryForConsensus() {
            return this.allocateMemoryForConsensus;
        }

        public long getAllocateMemoryForQueue() {
            return this.allocateMemoryForQueue;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static class Builder {
            private int maxLogEntriesNumPerBatch = 30;
            private int maxSizePerBatch = 0x1000000;
            private int maxPendingBatchesNum = 5;
            private long maxWaitingTimeForWaitBatchInMs = 10000L;
            private int maxWaitingTimeForAccumulatingBatchInMs = 500;
            private long basicRetryWaitTimeMs = TimeUnit.MILLISECONDS.toMillis(100L);
            private long maxRetryWaitTimeMs = TimeUnit.SECONDS.toMillis(20L);
            private long walThrottleThreshold = 0xC80000000L;
            private long throttleTimeOutMs = TimeUnit.SECONDS.toMillis(30L);
            private long checkpointGap = 500L;
            private long allocateMemoryForConsensus = Runtime.getRuntime().maxMemory() / 10L;
            private double maxMemoryRatioForQueue = 0.6;

            public Builder setMaxLogEntriesNumPerBatch(int maxLogEntriesNumPerBatch) {
                this.maxLogEntriesNumPerBatch = maxLogEntriesNumPerBatch;
                return this;
            }

            public Builder setMaxSizePerBatch(int maxSizePerBatch) {
                this.maxSizePerBatch = maxSizePerBatch;
                return this;
            }

            public Builder setMaxPendingBatchesNum(int maxPendingBatchesNum) {
                this.maxPendingBatchesNum = maxPendingBatchesNum;
                return this;
            }

            public Builder setMaxWaitingTimeForWaitBatchInMs(long maxWaitingTimeForWaitBatchInMs) {
                this.maxWaitingTimeForWaitBatchInMs = maxWaitingTimeForWaitBatchInMs;
                return this;
            }

            public Builder setMaxWaitingTimeForAccumulatingBatchInMs(int maxWaitingTimeForAccumulatingBatchInMs) {
                this.maxWaitingTimeForAccumulatingBatchInMs = maxWaitingTimeForAccumulatingBatchInMs;
                return this;
            }

            public Builder setBasicRetryWaitTimeMs(long basicRetryWaitTimeMs) {
                this.basicRetryWaitTimeMs = basicRetryWaitTimeMs;
                return this;
            }

            public Builder setMaxRetryWaitTimeMs(long maxRetryWaitTimeMs) {
                this.maxRetryWaitTimeMs = maxRetryWaitTimeMs;
                return this;
            }

            public Builder setWalThrottleThreshold(long walThrottleThreshold) {
                this.walThrottleThreshold = walThrottleThreshold;
                return this;
            }

            public Builder setThrottleTimeOutMs(long throttleTimeOutMs) {
                this.throttleTimeOutMs = throttleTimeOutMs;
                return this;
            }

            public Builder setCheckpointGap(long checkpointGap) {
                this.checkpointGap = checkpointGap;
                return this;
            }

            public Builder setAllocateMemoryForConsensus(long allocateMemoryForConsensus) {
                this.allocateMemoryForConsensus = allocateMemoryForConsensus;
                return this;
            }

            public Builder setMaxMemoryRatioForQueue(double maxMemoryRatioForQueue) {
                this.maxMemoryRatioForQueue = maxMemoryRatioForQueue;
                return this;
            }

            public Replication build() {
                return new Replication(this.maxLogEntriesNumPerBatch, this.maxSizePerBatch, this.maxPendingBatchesNum, this.maxWaitingTimeForWaitBatchInMs, this.maxWaitingTimeForAccumulatingBatchInMs, this.basicRetryWaitTimeMs, this.maxRetryWaitTimeMs, this.walThrottleThreshold, this.throttleTimeOutMs, this.checkpointGap, this.allocateMemoryForConsensus, this.maxMemoryRatioForQueue);
            }
        }
    }

    public static class RPC {
        private final int rpcSelectorThreadNum;
        private final int rpcMinConcurrentClientNum;
        private final int rpcMaxConcurrentClientNum;
        private final int thriftServerAwaitTimeForStopService;
        private final boolean isRpcThriftCompressionEnabled;
        private final int selectorNumOfClientManager;
        private final int connectionTimeoutInMs;
        private final int thriftMaxFrameSize;
        private final int coreClientNumForEachNode;
        private final int maxClientNumForEachNode;

        private RPC(int rpcSelectorThreadNum, int rpcMinConcurrentClientNum, int rpcMaxConcurrentClientNum, int thriftServerAwaitTimeForStopService, boolean isRpcThriftCompressionEnabled, int selectorNumOfClientManager, int connectionTimeoutInMs, int thriftMaxFrameSize, int coreClientNumForEachNode, int maxClientNumForEachNode) {
            this.rpcSelectorThreadNum = rpcSelectorThreadNum;
            this.rpcMinConcurrentClientNum = rpcMinConcurrentClientNum;
            this.rpcMaxConcurrentClientNum = rpcMaxConcurrentClientNum;
            this.thriftServerAwaitTimeForStopService = thriftServerAwaitTimeForStopService;
            this.isRpcThriftCompressionEnabled = isRpcThriftCompressionEnabled;
            this.selectorNumOfClientManager = selectorNumOfClientManager;
            this.connectionTimeoutInMs = connectionTimeoutInMs;
            this.thriftMaxFrameSize = thriftMaxFrameSize;
            this.coreClientNumForEachNode = coreClientNumForEachNode;
            this.maxClientNumForEachNode = maxClientNumForEachNode;
        }

        public int getRpcSelectorThreadNum() {
            return this.rpcSelectorThreadNum;
        }

        public int getRpcMinConcurrentClientNum() {
            return this.rpcMinConcurrentClientNum;
        }

        public int getRpcMaxConcurrentClientNum() {
            return this.rpcMaxConcurrentClientNum;
        }

        public int getThriftServerAwaitTimeForStopService() {
            return this.thriftServerAwaitTimeForStopService;
        }

        public boolean isRpcThriftCompressionEnabled() {
            return this.isRpcThriftCompressionEnabled;
        }

        public int getSelectorNumOfClientManager() {
            return this.selectorNumOfClientManager;
        }

        public int getConnectionTimeoutInMs() {
            return this.connectionTimeoutInMs;
        }

        public int getThriftMaxFrameSize() {
            return this.thriftMaxFrameSize;
        }

        public int getCoreClientNumForEachNode() {
            return this.coreClientNumForEachNode;
        }

        public int getMaxClientNumForEachNode() {
            return this.maxClientNumForEachNode;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static class Builder {
            private int rpcSelectorThreadNum = 1;
            private int rpcMinConcurrentClientNum = Runtime.getRuntime().availableProcessors();
            private int rpcMaxConcurrentClientNum = 65535;
            private int thriftServerAwaitTimeForStopService = 60;
            private boolean isRpcThriftCompressionEnabled = false;
            private int selectorNumOfClientManager = 1;
            private int connectionTimeoutInMs = (int)TimeUnit.SECONDS.toMillis(20L);
            private int thriftMaxFrameSize = 0x20000000;
            private int coreClientNumForEachNode = 200;
            private int maxClientNumForEachNode = 300;

            public Builder setRpcSelectorThreadNum(int rpcSelectorThreadNum) {
                this.rpcSelectorThreadNum = rpcSelectorThreadNum;
                return this;
            }

            public Builder setRpcMinConcurrentClientNum(int rpcMinConcurrentClientNum) {
                this.rpcMinConcurrentClientNum = rpcMinConcurrentClientNum;
                return this;
            }

            public Builder setRpcMaxConcurrentClientNum(int rpcMaxConcurrentClientNum) {
                this.rpcMaxConcurrentClientNum = rpcMaxConcurrentClientNum;
                return this;
            }

            public Builder setThriftServerAwaitTimeForStopService(int thriftServerAwaitTimeForStopService) {
                this.thriftServerAwaitTimeForStopService = thriftServerAwaitTimeForStopService;
                return this;
            }

            public Builder setRpcThriftCompressionEnabled(boolean rpcThriftCompressionEnabled) {
                this.isRpcThriftCompressionEnabled = rpcThriftCompressionEnabled;
                return this;
            }

            public Builder setSelectorNumOfClientManager(int selectorNumOfClientManager) {
                this.selectorNumOfClientManager = selectorNumOfClientManager;
                return this;
            }

            public Builder setConnectionTimeoutInMs(int connectionTimeoutInMs) {
                this.connectionTimeoutInMs = connectionTimeoutInMs;
                return this;
            }

            public Builder setThriftMaxFrameSize(int thriftMaxFrameSize) {
                this.thriftMaxFrameSize = thriftMaxFrameSize;
                return this;
            }

            public Builder setCoreClientNumForEachNode(int coreClientNumForEachNode) {
                this.coreClientNumForEachNode = coreClientNumForEachNode;
                return this;
            }

            public Builder setMaxClientNumForEachNode(int maxClientNumForEachNode) {
                this.maxClientNumForEachNode = maxClientNumForEachNode;
                return this;
            }

            public RPC build() {
                return new RPC(this.rpcSelectorThreadNum, this.rpcMinConcurrentClientNum, this.rpcMaxConcurrentClientNum, this.thriftServerAwaitTimeForStopService, this.isRpcThriftCompressionEnabled, this.selectorNumOfClientManager, this.connectionTimeoutInMs, this.thriftMaxFrameSize, this.coreClientNumForEachNode, this.maxClientNumForEachNode);
            }
        }
    }

    public static class Builder {
        private RPC rpc;
        private Replication replication;

        public IoTConsensusConfig build() {
            return new IoTConsensusConfig(Optional.ofNullable(this.rpc).orElseGet(() -> new RPC.Builder().build()), Optional.ofNullable(this.replication).orElseGet(() -> new Replication.Builder().build()));
        }

        public Builder setRpc(RPC rpc) {
            this.rpc = rpc;
            return this;
        }

        public Builder setReplication(Replication replication) {
            this.replication = replication;
            return this;
        }
    }
}

