/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.micrometer.type;

import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.distribution.ValueAtPercentile;
import java.util.Arrays;

public class MicrometerHistogramSnapshot
implements org.apache.iotdb.metrics.type.HistogramSnapshot {
    HistogramSnapshot histogramSnapshot;

    public MicrometerHistogramSnapshot(HistogramSnapshot histogramSnapshot) {
        this.histogramSnapshot = histogramSnapshot;
    }

    public double getValue(double quantile) {
        int prevIndex = 0;
        for (int i = 0; i < this.histogramSnapshot.percentileValues().length; ++i) {
            if (this.histogramSnapshot.percentileValues()[i].percentile() <= quantile) {
                prevIndex = i;
            }
            if (this.histogramSnapshot.percentileValues()[i].percentile() >= quantile) break;
        }
        return this.histogramSnapshot.percentileValues()[prevIndex].value();
    }

    public double[] getValues() {
        return Arrays.stream(this.histogramSnapshot.percentileValues()).mapToDouble(ValueAtPercentile::value).toArray();
    }

    public int size() {
        return this.histogramSnapshot.percentileValues().length;
    }

    public double getMedian() {
        return this.getValue(0.5);
    }

    public double getMax() {
        return this.histogramSnapshot.max();
    }

    public double getMean() {
        return this.histogramSnapshot.mean();
    }

    public double getMin() {
        return this.getValue(0.0);
    }
}

