<!--

    Licensed to the Apache Software Foundation (ASF) under one
    or more contributor license agreements.  See the NOTICE file
    distributed with this work for additional information
    regarding copyright ownership.  The ASF licenses this file
    to you under the Apache License, Version 2.0 (the
    "License"); you may not use this file except in compliance
    with the License.  You may obtain a copy of the License at
    
        http://www.apache.org/licenses/LICENSE-2.0
    
    Unless required by applicable law or agreed to in writing,
    software distributed under the License is distributed on an
    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, either express or implied.  See the License for the
    specific language governing permissions and limitations
    under the License.

-->

# 原生接口对比

此章节主要为Java原生接口与Python原生接口的差异性对比，主要为方便区分Java原生接口与Python原生的不同之处。



| 序号 | 接口名称以及作用          | Java接口函数                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Python接口函数                                               | <div style="width: 200pt">接口对比说明</div>                                                 |
| ---- | ------------------------- |-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------| ------------------------------------------------------------ | ------------------------------------------------------------ |
| 1    | 初始化Session             | `Session.Builder.build();     Session.Builder().host(String host).port(int port).build();     Session.Builder().nodeUrls(List<String> nodeUrls).build();     Session.Builder().fetchSize(int fetchSize).username(String  username).password(String password).thriftDefaultBufferSize(int  thriftDefaultBufferSize).thriftMaxFrameSize(int  thriftMaxFrameSize).enableRedirection(boolean  enableCacheLeader).version(Version version).build();`                                                                                                                                                                                                           | `Session(ip, port_, username_,  password_,fetch_size=1024, zone_id="UTC+8")` | 1.Python原生接口缺少使用默认配置初始化session     2.Python原生接口缺少指定多个可连接节点初始化session     3.Python原生接口缺失使用其他配置项初始化session |
| 2    | 开启 Session              | `void open()     void open(boolean enableRPCCompression)`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | `session.open(enable_rpc_compression=False)`                 |                                                              |
| 3    | 关闭 Session              | `void close()`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | `session.close()`                                            |                                                              |
| 4    | 设置 Database                | `void setStorageGroup(String  storageGroupId)`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | `session.set_storage_group(group_name)`                      |                                                              |
| 5    | 删除 database                | `void deleteStorageGroup(String  storageGroup)     void deleteStorageGroups(List<String> storageGroups)`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | `session.delete_storage_group(group_name)     session.delete_storage_groups(group_name_lst)` |                                                              |
| 6    | 创建时间序列              | `void createTimeseries(String  path, TSDataType dataType,TSEncoding encoding, CompressionType compressor,  Map<String, String> props,Map<String, String> tags,  Map<String, String> attributes, String measurementAlias)             void createMultiTimeseries(List<String> paths, List<TSDataType>  dataTypes,List<TSEncoding> encodings, List<CompressionType>  compressors,List<Map<String, String>> propsList,  List<Map<String, String>> tagsList,List<Map<String,  String>> attributesList, List<String> measurementAliasList)`                                                                                                                    | `session.create_time_series(ts_path,  data_type, encoding, compressor,props=None, tags=None, attributes=None,  alias=None)             session.create_multi_time_series(ts_path_lst, data_type_lst, encoding_lst, compressor_lst,props_lst=None,  tags_lst=None, attributes_lst=None, alias_lst=None)` |                                                              |
| 7    | 创建对齐时间序列          | `void  createAlignedTimeseries(String prefixPath, List<String>  measurements,List<TSDataType> dataTypes, List<TSEncoding>  encodings,CompressionType compressor, List<String>  measurementAliasList);`                                                                                                                                                                                                                                                                                                                                                                                                                                                    | `session.create_aligned_time_series(device_id,  measurements_lst, data_type_lst, encoding_lst, compressor_lst)` |                                                              |
| 8    | 删除时间序列              | `void deleteTimeseries(String  path)     void deleteTimeseries(List<String> paths)`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | `session.delete_time_series(paths_list)`                     | Python原生接口缺少删除一个时间序列的接口                     |
| 9    | 检测时间序列是否存在      | `boolean  checkTimeseriesExists(String path)`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | `session.check_time_series_exists(path)`                     |                                                              |
| 10   | 元数据模版                | `public void  createSchemaTemplate(Template template);`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |                                                              |                                                              |
| 11   | 插入Tablet                | `void insertTablet(Tablet  tablet)     void insertTablets(Map<String, Tablet> tablets)`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | `session.insert_tablet(tablet_)     session.insert_tablets(tablet_lst)` |                                                              |
| 12   | 插入Record                | `void insertRecord(String  prefixPath, long time, List<String> measurements,List<TSDataType>  types, List<Object> values)     void insertRecords(List<String> deviceIds,List<Long>  times,List<List<String>> measurementsList,List<List<TSDataType>>  typesList,List<List<Object>> valuesList)     void insertRecordsOfOneDevice(String deviceId, List<Long>  times,List<List<Object>> valuesList)`                                                                                                                                                                                                                                                       | `session.insert_record(device_id,  timestamp, measurements_, data_types_, values_)     session.insert_records(device_ids_, time_list_, measurements_list_,  data_type_list_, values_list_)     session.insert_records_of_one_device(device_id, time_list, measurements_list,  data_types_list, values_list)` |                                                              |
| 13   | 带有类型推断的写入        | `void insertRecord(String  prefixPath, long time, List<String> measurements, List<String>  values)     void insertRecords(List<String> deviceIds, List<Long>  times,List<List<String>> measurementsList, List<List<String>>  valuesList)     void insertStringRecordsOfOneDevice(String deviceId, List<Long>  times,List<List<String>> measurementsList,  List<List<String>> valuesList)`                                                                                                                                                                                                                                                                 | `session.insert_str_record(device_id,  timestamp, measurements, string_values)` | 1.Python原生接口缺少插入多个  Record的接口     2.Python原生接口缺少插入同属于一个 device 的多个 Record |
| 14   | 对齐时间序列的写入        | `insertAlignedRecord     insertAlignedRecords     insertAlignedRecordsOfOneDevice     insertAlignedStringRecordsOfOneDevice     insertAlignedTablet     insertAlignedTablets`                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | `insert_aligned_record     insert_aligned_records     insert_aligned_records_of_one_device     insert_aligned_tablet     insert_aligned_tablets` | Python原生接口缺少带有判断类型的对齐时间序列的写入           |
| 15   | 数据删除                  | `void deleteData(String path,  long endTime)     void deleteData(List<String> paths, long endTime)`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |                                                              | 1.Python原生接口缺少删除一条数据的接口     2.Python原生接口缺少删除多条数据的接口 |
| 16   | 数据查询                  | `SessionDataSet  executeRawDataQuery(List<String> paths, long startTime, long  endTime)     SessionDataSet executeLastDataQuery(List<String> paths, long  LastTime)`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |                                                              | 1.Python原生接口缺少原始数据查询的接口     2.Python原生接口缺少查询最后一条时间戳大于等于某个时间点的数据的接口 |
| 17   | IoTDB-SQL 接口-查询语句   | `SessionDataSet  executeQueryStatement(String sql)`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | `session.execute_query_statement(sql)`                       |                                                              |
| 18   | IoTDB-SQL 接口-非查询语句 | `void  executeNonQueryStatement(String sql)`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | `session.execute_non_query_statement(sql)`                   |                                                              |
| 19   | 测试接口                  | `void testInsertRecord(String  deviceId, long time, List<String> measurements, List<String>  values)     void testInsertRecord(String deviceId, long time, List<String>  measurements,List<TSDataType> types, List<Object> values)     void testInsertRecords(List<String> deviceIds, List<Long>  times,List<List<String>> measurementsList,  List<List<String>> valuesList)     void testInsertRecords(List<String> deviceIds, List<Long> times,List<List<String>>  measurementsList, List<List<TSDataType>>  typesList,List<List<Object>> valuesList)     void testInsertTablet(Tablet tablet)     void testInsertTablets(Map<String, Tablet> tablets)` | Python  客户端对测试的支持是基于testcontainers库             | Python接口无原生的测试接口                                   |
| 20   | 针对原生接口的连接池      | `SessionPool`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |                                                              | Python接口无针对原生接口的连接池                             |
| 21   | 集群信息相关的接口        | `iotdb-thrift-cluster`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |                                                              | Python接口不支持集群信息相关的接口                           |