/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.util.List;
import org.apache.iotdb.db.rescon.PrimitiveArrayManager;
import org.apache.iotdb.db.utils.datastructure.QuickSort;

public interface BackwardSort
extends QuickSort {
    public static final double INVERSION_RATIOS_THRESHOLD = 0.004;

    public void setFromTmp(int var1, int var2);

    public void setToTmp(int var1, int var2);

    public void backward_set(int var1, int var2);

    public int compareTmp(int var1, int var2);

    public void checkTmpLength(int var1);

    public void clearTmp();

    default public void backwardSort(List<long[]> timestamps, int rowCount) {
        int block_size = this.setBlockLength(timestamps, 1);
        int B = rowCount / block_size + 1;
        this.sortBlock((B - 1) * block_size, rowCount - 1);
        for (int i = B - 2; i >= 0; --i) {
            int lo = i * block_size;
            int hi = lo + block_size - 1;
            this.sortBlock(lo, hi);
            this.backwardMergeBlocks(lo, hi, rowCount);
        }
    }

    default public int setBlockLength(List<long[]> timestamps, int step) {
        double overlap = 0.0;
        long last_time = timestamps.get(0)[0];
        int i = step;
        int blocks = 0;
        while (i < timestamps.size()) {
            long cur_time = timestamps.get(i)[0];
            if (last_time > cur_time) {
                overlap += 1.0;
            }
            last_time = cur_time;
            i += step;
            ++blocks;
        }
        double ratio = overlap / (double)blocks;
        int mul = (int)Math.ceil(ratio / 0.004);
        if (mul <= 1) {
            return step * PrimitiveArrayManager.ARRAY_SIZE;
        }
        return this.setBlockLength(timestamps, mul * step);
    }

    default public void backwardMergeBlocks(int lo, int hi, int rowCount) {
        int overlapIdx;
        for (overlapIdx = hi + 1; overlapIdx < rowCount && this.compare(hi, overlapIdx) == 1; ++overlapIdx) {
        }
        if (overlapIdx == hi + 1) {
            return;
        }
        int tmpIdx = 0;
        int len = overlapIdx - hi;
        this.checkTmpLength(len);
        for (int i = hi + 1; i < overlapIdx; ++i) {
            this.setToTmp(i, tmpIdx);
            ++tmpIdx;
        }
        int a = hi;
        int b = tmpIdx - 1;
        int idx = overlapIdx - 1;
        while (a >= lo && b >= 0) {
            if (this.compareTmp(a, b) == 1) {
                this.backward_set(a, idx);
                --a;
            } else {
                this.setFromTmp(b, idx);
                --b;
            }
            --idx;
        }
        while (b >= 0) {
            this.setFromTmp(b, idx);
            --b;
            --idx;
        }
    }

    default public void sortBlock(int lo, int hi) {
        this.qsort(lo, hi);
    }
}

