/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.externalpipe;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.sync.datasource.PipeOpManager;
import org.apache.iotdb.db.sync.externalpipe.ExtPipePlugin;
import org.apache.iotdb.db.sync.externalpipe.ExtPipePluginConfiguration;
import org.apache.iotdb.db.sync.externalpipe.ExternalPipeStatus;
import org.apache.iotdb.db.sync.pipedata.DeletionPipeData;
import org.apache.iotdb.db.sync.pipedata.PipeData;
import org.apache.iotdb.db.sync.pipedata.TsFilePipeData;
import org.apache.iotdb.db.sync.sender.pipe.TsFilePipe;
import org.apache.iotdb.pipe.external.api.IExternalPipeSinkWriterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtPipePluginManager {
    private static final Logger logger = LoggerFactory.getLogger(ExtPipePluginManager.class);
    private TsFilePipe tsFilePipe;
    private PipeOpManager pipeOpManager;
    private Map<String, ExtPipePlugin> extPipePluginMap = new HashMap<String, ExtPipePlugin>();
    private ExecutorService monitorService = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"ExtPipePluginManager-monitor");
    boolean alive = false;
    private long lastPipeDataSerialNumber = Long.MIN_VALUE;
    private Map<String, Map<String, AtomicInteger>> writerInvocationFailures;
    private byte[] commitTriggerLocker = new byte[0];
    private long commitTriggerCounter = 0L;

    public ExtPipePluginManager(TsFilePipe tsFilePipe) {
        this.tsFilePipe = tsFilePipe;
        this.pipeOpManager = new PipeOpManager(tsFilePipe);
        this.pipeOpManager.setNewDataEventHandler(this::newDataEventHandler);
    }

    public ExtPipePluginManager(String Name2, IExternalPipeSinkWriterFactory factory, ExtPipePluginConfiguration conf, TsFilePipe tsFilePipe) {
        this(null);
    }

    public void setPipeOpManager(PipeOpManager pipeOpManager) {
        this.pipeOpManager = pipeOpManager;
    }

    public ExtPipePluginManager setTsFilePipe(TsFilePipe tsFilePipe) {
        this.tsFilePipe = tsFilePipe;
        return this;
    }

    public void startExtPipe(String pipeTypeName, Map<String, String> sinkParams) throws IOException {
        logger.debug("Enter startExtPipe(), pipeTypeName={}, sinkParams={}.", (Object)pipeTypeName, sinkParams);
        ExtPipePlugin extPipePlugin = this.extPipePluginMap.computeIfAbsent(pipeTypeName, k -> new ExtPipePlugin(pipeTypeName, sinkParams, this, this.pipeOpManager));
        if (extPipePlugin.isAlive()) {
            String eMsg = "startExtPipe(), External Pipe " + pipeTypeName + "has been alive, can not be started again.";
            logger.error(eMsg);
            throw new IOException(eMsg);
        }
        extPipePlugin.start();
        this.alive = true;
        ThreadPoolExecutor tpe = (ThreadPoolExecutor)this.monitorService;
        if (tpe.getActiveCount() <= 0 && tpe.getQueue().size() <= 0) {
            this.monitorService.submit(this::monitorPipeData);
        }
        logger.info("startExtPipe() finish. pipeTypeName={} ", (Object)pipeTypeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerCommit(String sgName, long commitIndex) throws IOException {
        byte[] byArray = this.commitTriggerLocker;
        synchronized (this.commitTriggerLocker) {
            ++this.commitTriggerCounter;
            this.commitTriggerLocker.notifyAll();
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return;
        }
    }

    public int checkCommitIndex() {
        Set<String> sgSet = this.pipeOpManager.getSgSet();
        for (String sgName : sgSet) {
            long finalCommitIndex = Long.MAX_VALUE;
            for (ExtPipePlugin extPipePlugin : this.extPipePluginMap.values()) {
                long commitIndex = extPipePlugin.getDataCommitIndex(sgName);
                if (commitIndex < 0L || commitIndex >= finalCommitIndex) continue;
                finalCommitIndex = commitIndex;
            }
            if (finalCommitIndex >= Long.MAX_VALUE || finalCommitIndex < 0L) continue;
            this.pipeOpManager.commitData(sgName, finalCommitIndex);
        }
        return this.pipeOpManager.getInUseOpBlockNum();
    }

    private void newDataEventHandler(String sgName, long newDataBeginIndex, long newDataCount) {
        for (ExtPipePlugin extPipePlugin : this.extPipePluginMap.values()) {
            extPipePlugin.notifyNewDataArrive(sgName, newDataBeginIndex, newDataCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void monitorPipeData() {
        Thread.currentThread().setName("ExternalPipe-monitorPipeData-" + Thread.currentThread().getId());
        logger.info("monitorPipeData start. Thread={}", (Object)Thread.currentThread().getName());
        if (this.tsFilePipe == null) {
            logger.info("monitorPipeData(), Error! tsFilePipe is null. Thread exit, {}.", (Object)Thread.currentThread().getName());
            return;
        }
        while (true) {
            if (!this.alive) {
                logger.info("monitorPipeData() exits. Thread={}", (Object)Thread.currentThread().getName());
                return;
            }
            try {
                Object object;
                List<PipeData> pipeDataList = this.tsFilePipe.pull(Long.MAX_VALUE);
                if (pipeDataList != null && !pipeDataList.isEmpty() && pipeDataList.get(pipeDataList.size() - 1).getSerialNumber() > this.lastPipeDataSerialNumber) {
                    object = pipeDataList.iterator();
                    while (object.hasNext()) {
                        PipeData pipeData = (PipeData)object.next();
                        long pipeDataSerialNumber = pipeData.getSerialNumber();
                        if (pipeDataSerialNumber <= this.lastPipeDataSerialNumber) continue;
                        if (pipeData instanceof TsFilePipeData) {
                            TsFilePipeData tsFilePipeData = (TsFilePipeData)pipeData;
                            String sgName = tsFilePipeData.getDatabase();
                            String tsFileFullName = tsFilePipeData.getTsFilePath();
                            String modsFileFullName = tsFilePipeData.getModsFilePath();
                            try {
                                this.pipeOpManager.appendTsFileOpBlock(sgName, tsFileFullName, modsFileFullName, pipeDataSerialNumber);
                                this.lastPipeDataSerialNumber = pipeDataSerialNumber;
                            }
                            catch (IOException e) {
                                logger.error("monitorPipeData(), Can not append TsFile: {}" + tsFileFullName);
                            }
                            continue;
                        }
                        if (!(pipeData instanceof DeletionPipeData)) continue;
                        if (!this.pipeOpManager.isEmpty()) break;
                        DeletionPipeData deletionPipeData = (DeletionPipeData)pipeData;
                        this.pipeOpManager.appendDeletionOpBlock(deletionPipeData.getDatabase(), deletionPipeData.getDeletion(), pipeDataSerialNumber);
                        this.lastPipeDataSerialNumber = pipeData.getSerialNumber();
                        break;
                    }
                }
                object = this.commitTriggerLocker;
                // MONITORENTER : this.commitTriggerLocker
                if (this.commitTriggerCounter <= 0L) {
                    try {
                        this.commitTriggerLocker.wait(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.commitTriggerCounter = 0L;
                // MONITOREXIT : object
                this.checkCommitIndex();
            }
            catch (Throwable t) {
                logger.error("monitorPipeData() Exception: ", t);
                continue;
            }
            break;
        }
    }

    public void stopExtPipe(String extPipeTypeName) {
        logger.info("ExtPipePluginManager stop({}).", (Object)extPipeTypeName);
        ExtPipePlugin extPipePlugin = this.extPipePluginMap.get(extPipeTypeName);
        if (extPipePlugin == null) {
            logger.error("ExtPipePluginManager stop(), invalid extPipeTypeName={}", (Object)extPipeTypeName);
            return;
        }
        extPipePlugin.stop();
    }

    private void stopAllThreadPool() {
        this.alive = false;
        this.monitorService.shutdown();
        boolean isTerminated = false;
        try {
            isTerminated = this.monitorService.awaitTermination(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.error("stopAllThreadPool(), Interrupted when terminating monitorService, ", (Throwable)e);
        }
        finally {
            if (!isTerminated) {
                logger.warn("stopAllThreadPool(), for monitorService. Graceful shutdown timed out, so force shutdown.");
                this.monitorService.shutdownNow();
            }
        }
    }

    public void dropExtPipe(String pipeTypeName) {
        logger.info("ExtPipePluginManager drop {}.", (Object)pipeTypeName);
        ExtPipePlugin extPipePlugin = this.extPipePluginMap.get(pipeTypeName);
        if (extPipePlugin == null) {
            logger.error("ExtPipePluginManager dropExtPipe(), invalid pipeTypeName={}", (Object)pipeTypeName);
            return;
        }
        if (extPipePlugin.isAlive()) {
            extPipePlugin.stop();
        }
        this.extPipePluginMap.remove(pipeTypeName);
        if (this.extPipePluginMap.size() <= 0) {
            this.stopAllThreadPool();
            if (this.pipeOpManager != null) {
                this.pipeOpManager.close();
                this.pipeOpManager = null;
            }
        }
    }

    public PipeOpManager getPipeOpManager() {
        return this.pipeOpManager;
    }

    public ExternalPipeStatus getExternalPipeStatus(String extPipeTypeName) {
        ExtPipePlugin extPipePlugin = this.extPipePluginMap.get(extPipeTypeName);
        if (extPipePlugin == null) {
            return null;
        }
        return extPipePlugin.getStatus();
    }
}

