/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.ShutdownException;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.exception.sync.PipeException;
import org.apache.iotdb.commons.exception.sync.PipeNotExistException;
import org.apache.iotdb.commons.exception.sync.PipeSinkException;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.commons.sync.pipe.PipeInfo;
import org.apache.iotdb.commons.sync.pipe.PipeMessage;
import org.apache.iotdb.commons.sync.pipe.PipeStatus;
import org.apache.iotdb.commons.sync.pipe.TsFilePipeInfo;
import org.apache.iotdb.commons.sync.pipesink.PipeSink;
import org.apache.iotdb.commons.sync.transport.SyncIdentityInfo;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipeInfo;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.mpp.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.ISchemaFetcher;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.CreatePipeSinkStatement;
import org.apache.iotdb.db.qp.utils.DateTimeUtils;
import org.apache.iotdb.db.sync.common.ClusterSyncInfoFetcher;
import org.apache.iotdb.db.sync.common.ISyncInfoFetcher;
import org.apache.iotdb.db.sync.common.LocalSyncInfoFetcher;
import org.apache.iotdb.db.sync.externalpipe.ExtPipePluginManager;
import org.apache.iotdb.db.sync.externalpipe.ExtPipePluginRegister;
import org.apache.iotdb.db.sync.sender.manager.ISyncManager;
import org.apache.iotdb.db.sync.sender.pipe.ExternalPipeSink;
import org.apache.iotdb.db.sync.sender.pipe.Pipe;
import org.apache.iotdb.db.sync.sender.pipe.TsFilePipe;
import org.apache.iotdb.db.sync.transport.client.SenderManager;
import org.apache.iotdb.db.sync.transport.server.ReceiverManager;
import org.apache.iotdb.db.utils.sync.SyncPipeUtil;
import org.apache.iotdb.pipe.external.api.IExternalPipeSinkWriterFactory;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TSyncIdentityInfo;
import org.apache.iotdb.service.rpc.thrift.TSyncTransportMetaInfo;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncService
implements IService {
    private static final Logger logger = LoggerFactory.getLogger(SyncService.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final Map<String, Pipe> pipes;
    private final Map<String, ExtPipePluginManager> extPipePluginManagers;
    private final ISyncInfoFetcher syncInfoFetcher;
    private final ReceiverManager receiverManager = new ReceiverManager();

    private SyncService() {
        this.pipes = new ConcurrentHashMap<String, Pipe>();
        this.extPipePluginManagers = new ConcurrentHashMap<String, ExtPipePluginManager>();
        this.syncInfoFetcher = config.isClusterMode() ? ClusterSyncInfoFetcher.getInstance() : LocalSyncInfoFetcher.getInstance();
    }

    public static SyncService getInstance() {
        return SyncServiceHolder.INSTANCE;
    }

    public TSStatus handshake(TSyncIdentityInfo identityInfo, String remoteAddress, IPartitionFetcher partitionFetcher, ISchemaFetcher schemaFetcher) {
        return this.receiverManager.handshake(identityInfo, remoteAddress, partitionFetcher, schemaFetcher);
    }

    public TSStatus transportFile(TSyncTransportMetaInfo metaInfo, ByteBuffer buff) throws TException {
        return this.receiverManager.transportFile(metaInfo, buff);
    }

    public TSStatus transportPipeData(ByteBuffer buff) throws TException {
        return this.receiverManager.transportPipeData(buff);
    }

    public void handleClientExit() {
        this.receiverManager.handleClientExit();
    }

    public PipeSink getPipeSink(String name) throws PipeSinkException {
        return this.syncInfoFetcher.getPipeSink(name);
    }

    public void addPipeSink(CreatePipeSinkStatement createPipeSinkStatement) throws PipeSinkException {
        logger.info("Add PIPESINK {}", (Object)createPipeSinkStatement);
        TSStatus status = this.syncInfoFetcher.addPipeSink(createPipeSinkStatement);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeSinkException(status.message);
        }
    }

    public void dropPipeSink(String name) throws PipeSinkException {
        logger.info("Execute DROP PIPESINK {}", (Object)name);
        TSStatus status = this.syncInfoFetcher.dropPipeSink(name);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeSinkException(status.message);
        }
    }

    public List<PipeSink> getAllPipeSink() {
        return this.syncInfoFetcher.getAllPipeSinks();
    }

    public synchronized void addPipe(PipeInfo pipeInfo) throws PipeException {
        PipeSink runningPipeSink;
        logger.info("Execute CREATE PIPE {}", (Object)pipeInfo);
        long currentTime = DateTimeUtils.currentTime();
        if (pipeInfo instanceof TsFilePipeInfo && ((TsFilePipeInfo)pipeInfo).getDataStartTimestamp() > currentTime) {
            throw new PipeException(String.format("Start time %s is later than current time %s, this is not supported yet.", DateTimeUtils.convertLongToDate(((TsFilePipeInfo)pipeInfo).getDataStartTimestamp()), DateTimeUtils.convertLongToDate(currentTime)));
        }
        TSStatus status = this.syncInfoFetcher.addPipe(pipeInfo);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(status.message);
        }
        try {
            runningPipeSink = this.getPipeSink(pipeInfo.getPipeSinkName());
        }
        catch (PipeSinkException e) {
            logger.error("failed to add PIPE because {}", (Object)e.getMessage(), (Object)e);
            throw new PipeException(String.format("failed to add PIPE because %s", e.getMessage()));
        }
        Pipe runningPipe = SyncPipeUtil.parsePipeInfoAsPipe(pipeInfo, runningPipeSink);
        this.pipes.put(pipeInfo.getPipeName(), runningPipe);
        if (runningPipe.getPipeSink().getType() == PipeSink.PipeSinkType.ExternalPipe) {
            this.startExternalPipeManager(pipeInfo.getPipeName(), false);
        }
    }

    public synchronized void stopPipe(String pipeName) throws PipeException {
        TSStatus status;
        logger.info("Execute stop PIPE {}", (Object)pipeName);
        Pipe runningPipe = this.getPipe(pipeName);
        if (runningPipe.getStatus() == PipeStatus.RUNNING) {
            if (runningPipe.getPipeSink().getType() != PipeSink.PipeSinkType.IoTDB && this.extPipePluginManagers.containsKey(pipeName)) {
                try {
                    String extPipeSinkTypeName = ((ExternalPipeSink)runningPipe.getPipeSink()).getExtPipeSinkTypeName();
                    this.extPipePluginManagers.get(pipeName).stopExtPipe(extPipeSinkTypeName);
                }
                catch (Exception e) {
                    throw new PipeException("Failed to stop externalPipeProcessor. " + e.getMessage());
                }
            }
            runningPipe.stop();
        }
        if ((status = this.syncInfoFetcher.stopPipe(pipeName)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(status.message);
        }
    }

    public synchronized void stopPipe(String pipeName, long createTime) {
        try {
            Pipe runningPipe = this.getPipe(pipeName);
            if (runningPipe.getCreateTime() == createTime) {
                this.stopPipe(pipeName);
            } else {
                logger.warn("Skip execute stop PIPE {} with createTime {} because of createTime mismatch.", (Object)pipeName, (Object)createTime);
            }
        }
        catch (PipeException e) {
            logger.warn("Skip execute stop PIPE {} with createTime {} because {}", new Object[]{pipeName, createTime, e.getMessage()});
        }
    }

    public synchronized void startPipe(String pipeName) throws PipeException {
        TSStatus status;
        logger.info("Execute start PIPE {}", (Object)pipeName);
        Pipe runningPipe = this.getPipe(pipeName);
        if (runningPipe.getStatus() == PipeStatus.STOP) {
            if (runningPipe.getPipeSink().getType() == PipeSink.PipeSinkType.IoTDB) {
                runningPipe.start();
            } else {
                runningPipe.start();
                this.startExternalPipeManager(pipeName, true);
            }
        }
        if ((status = this.syncInfoFetcher.startPipe(pipeName)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(status.message);
        }
    }

    public synchronized void startPipe(String pipeName, long createTime) {
        try {
            Pipe runningPipe = this.getPipe(pipeName);
            if (runningPipe.getCreateTime() == createTime) {
                this.startPipe(pipeName);
            } else {
                logger.warn("Skip execute start PIPE {} with createTime {} because of createTime mismatch.", (Object)pipeName, (Object)createTime);
            }
        }
        catch (PipeException e) {
            logger.warn("Skip execute start PIPE {} with createTime {} because {}", new Object[]{pipeName, createTime, e.getMessage()});
        }
    }

    public synchronized void dropPipe(String pipeName) throws PipeException {
        Pipe runningPipe;
        logger.info("Execute drop PIPE {}", (Object)pipeName);
        try {
            runningPipe = this.getPipe(pipeName);
        }
        catch (PipeNotExistException e) {
            return;
        }
        if (runningPipe.getPipeSink().getType() != PipeSink.PipeSinkType.IoTDB && this.extPipePluginManagers.containsKey(pipeName)) {
            String extPipeSinkTypeName = ((ExternalPipeSink)runningPipe.getPipeSink()).getExtPipeSinkTypeName();
            this.extPipePluginManagers.get(pipeName).dropExtPipe(extPipeSinkTypeName);
            this.extPipePluginManagers.remove(pipeName);
        }
        runningPipe.drop();
        TSStatus status = this.syncInfoFetcher.dropPipe(pipeName);
        this.pipes.remove(pipeName);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(status.message);
        }
    }

    public synchronized void dropPipe(String pipeName, long createTime) {
        try {
            Pipe runningPipe = this.getPipe(pipeName);
            if (runningPipe.getCreateTime() == createTime) {
                this.dropPipe(pipeName);
            } else {
                logger.warn("Skip execute drop PIPE {} with createTime {} because of createTime mismatch.", (Object)pipeName, (Object)createTime);
            }
        }
        catch (PipeException e) {
            logger.warn("Skip execute drop PIPE {} with createTime {} because {}", new Object[]{pipeName, createTime, e.getMessage()});
        }
    }

    public List<PipeInfo> getAllPipeInfos() {
        return this.syncInfoFetcher.getAllPipeInfos();
    }

    private Pipe getPipe(String pipeName) throws PipeNotExistException {
        if (!this.pipes.containsKey(pipeName)) {
            throw new PipeNotExistException(pipeName);
        }
        return this.pipes.get(pipeName);
    }

    public void recordMessage(String pipeName, PipeMessage message) {
        if (!this.pipes.containsKey(pipeName)) {
            logger.warn(String.format("No running PIPE for message %s.", message));
            return;
        }
        TSStatus status = null;
        switch (message.getType()) {
            case ERROR: {
                logger.error("Error occurred when executing PIPE [{}] because {}.", (Object)pipeName, (Object)message.getMessage());
                status = this.syncInfoFetcher.recordMsg(pipeName, message);
                break;
            }
            case WARN: {
                logger.error("Warn occurred when executing PIPE [{}] because {}.", (Object)pipeName, (Object)message.getMessage());
                status = this.syncInfoFetcher.recordMsg(pipeName, message);
                break;
            }
            default: {
                logger.error(String.format("Unknown message type: %s", message));
            }
        }
        if (status != null && status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            logger.error(String.format("Failed to record message: %s", message));
        }
    }

    public List<TShowPipeInfo> showPipe(String pipeName) {
        boolean showAll = StringUtils.isEmpty((CharSequence)pipeName);
        ArrayList<TShowPipeInfo> list = new ArrayList<TShowPipeInfo>();
        for (PipeInfo pipe : SyncService.getInstance().getAllPipeInfos()) {
            if (!showAll && !pipeName.equals(pipe.getPipeName())) continue;
            list.add(pipe.getTShowPipeInfo());
        }
        list.addAll(this.showPipeForReceiver(pipeName));
        return list;
    }

    public List<TShowPipeInfo> showPipeForReceiver(String pipeName) {
        boolean showAll = StringUtils.isEmpty((CharSequence)pipeName);
        ArrayList<TShowPipeInfo> list = new ArrayList<TShowPipeInfo>();
        for (SyncIdentityInfo identityInfo : this.receiverManager.getAllTSyncIdentityInfos()) {
            if (!showAll && !pipeName.equals(identityInfo.getPipeName())) continue;
            TShowPipeInfo tPipeInfo = new TShowPipeInfo(identityInfo.getCreateTime(), identityInfo.getPipeName(), "receiver", identityInfo.getRemoteAddress(), PipeStatus.RUNNING.name(), String.format("Database='%s'", identityInfo.getDatabase()), PipeMessage.PipeMessageType.NORMAL.name());
            list.add(tPipeInfo);
        }
        return list;
    }

    private void startExternalPipeManager(String pipeName, boolean startExtPipe) throws PipeException {
        if (!(this.pipes.get(pipeName) instanceof TsFilePipe)) {
            logger.error("startExternalPipeManager(), runningPipe is not TsFilePipe. " + pipeName);
            return;
        }
        PipeSink pipeSink = this.pipes.get(pipeName).getPipeSink();
        if (!(pipeSink instanceof ExternalPipeSink)) {
            logger.error("startExternalPipeManager(), pipeSink is not ExternalPipeSink." + pipeSink);
            return;
        }
        String extPipeSinkTypeName = ((ExternalPipeSink)pipeSink).getExtPipeSinkTypeName();
        IExternalPipeSinkWriterFactory externalPipeSinkWriterFactory = ExtPipePluginRegister.getInstance().getWriteFactory(extPipeSinkTypeName);
        if (externalPipeSinkWriterFactory == null) {
            logger.error(String.format("startExternalPipeManager(), can not found ExternalPipe plugin for %s.", extPipeSinkTypeName));
            throw new PipeException("Can not found ExternalPipe plugin for " + extPipeSinkTypeName + ".");
        }
        ExtPipePluginManager extPipePluginManager = new ExtPipePluginManager((TsFilePipe)this.pipes.get(pipeName));
        if (!this.extPipePluginManagers.containsKey(pipeName)) {
            this.extPipePluginManagers.put(pipeName, extPipePluginManager);
        }
        if (startExtPipe) {
            try {
                extPipePluginManager.startExtPipe(extPipeSinkTypeName, ((ExternalPipeSink)pipeSink).getSinkParams());
            }
            catch (IOException e) {
                logger.error("Failed to start External Pipe: {}.", (Object)extPipeSinkTypeName, (Object)e);
                throw new PipeException("Failed to start External Pipe: " + extPipeSinkTypeName + ". " + e.getMessage());
            }
        }
    }

    public ExtPipePluginManager getExternalPipeManager(String pipeName) {
        return this.extPipePluginManagers.get(pipeName);
    }

    public void start() throws StartupException {
        ExtPipePluginRegister extPipePluginRegister = ExtPipePluginRegister.getInstance();
        if (extPipePluginRegister == null) {
            throw new StartupException("Load ExternalPipe Plugin error.");
        }
        logger.info("Load {} ExternalPipe Plugin: {}", (Object)extPipePluginRegister.getAllPluginName().size(), extPipePluginRegister.getAllPluginName());
        try {
            this.recover();
        }
        catch (Exception e) {
            logger.error("Recovery error.", (Throwable)e);
            throw new StartupException((Throwable)e);
        }
    }

    public void stop() {
        for (Pipe pipe : this.pipes.values()) {
            try {
                pipe.close();
            }
            catch (PipeException e) {
                logger.warn(String.format("Stop PIPE %s error when stop Sender Service.", pipe.getName()), (Throwable)e);
            }
        }
    }

    public void shutdown(long milliseconds) throws ShutdownException {
        for (Pipe pipe : this.pipes.values()) {
            try {
                pipe.close();
            }
            catch (PipeException e) {
                logger.warn(String.format("Stop PIPE %s error when shutdown Sender Service.", pipe.getName()), (Throwable)e);
                throw new ShutdownException((Throwable)e);
            }
        }
    }

    public ServiceType getID() {
        return ServiceType.SYNC_SERVICE;
    }

    private void recover() throws IOException, PipeException, PipeSinkException {
        List<PipeInfo> allPipeInfos = this.syncInfoFetcher.getAllPipeInfos();
        for (PipeInfo pipeInfo : allPipeInfos) {
            logger.info("Recover PIPE [{}] whose status is {}", (Object)pipeInfo.getPipeName(), (Object)pipeInfo.getStatus().name());
            if (PipeStatus.PARTIAL_CREATE.equals((Object)pipeInfo.getStatus()) || PipeStatus.DROP.equals((Object)pipeInfo.getStatus())) {
                logger.info("Skip PIPE [{}] because its status is {}", (Object)pipeInfo.getPipeName(), (Object)pipeInfo.getStatus().name());
                continue;
            }
            Pipe pipe = SyncPipeUtil.parsePipeInfoAsPipe(pipeInfo, this.syncInfoFetcher.getPipeSink(pipeInfo.getPipeSinkName()));
            this.pipes.put(pipeInfo.getPipeName(), pipe);
            switch (pipeInfo.getStatus()) {
                case RUNNING: {
                    pipe.start();
                    break;
                }
                case STOP: 
                case PARTIAL_START: 
                case PARTIAL_STOP: {
                    pipe.stop();
                    break;
                }
                case PARTIAL_CREATE: 
                case DROP: {
                    throw new PipeException("Unexpected status " + pipeInfo.getStatus().name());
                }
                default: {
                    throw new IOException(String.format("Can not recognize running pipe status %s.", pipe.getStatus()));
                }
            }
            if (pipe.getPipeSink().getType() != PipeSink.PipeSinkType.ExternalPipe) continue;
            this.startExternalPipeManager(pipeInfo.getPipeName(), pipe.getStatus() == PipeStatus.RUNNING);
        }
    }

    public List<ISyncManager> getOrCreateSyncManager(String dataRegionId) {
        ArrayList<ISyncManager> syncManagerList = new ArrayList<ISyncManager>();
        for (Pipe pipe : this.pipes.values()) {
            if (!pipe.isHistoryCollectFinished()) continue;
            syncManagerList.add(pipe.getOrCreateSyncManager(dataRegionId));
        }
        return syncManagerList;
    }

    public synchronized void unregisterDataRegion(String dataRegionId) {
        for (Pipe pipe : this.pipes.values()) {
            pipe.unregisterDataRegion(dataRegionId);
        }
    }

    public SenderManager getSenderManager() {
        return null;
    }

    private static class SyncServiceHolder {
        private static final SyncService INSTANCE = new SyncService();

        private SyncServiceHolder() {
        }
    }
}

