/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.process;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.MultiChildProcessNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.AggregationDescriptor;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.db.mpp.plan.statement.component.Ordering;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class AggregationNode
extends MultiChildProcessNode {
    protected List<AggregationDescriptor> aggregationDescriptorList;
    @Nullable
    protected GroupByTimeParameter groupByTimeParameter;
    protected Ordering scanOrder;

    public AggregationNode(PlanNodeId id, List<AggregationDescriptor> aggregationDescriptorList, @Nullable GroupByTimeParameter groupByTimeParameter, Ordering scanOrder) {
        super(id, new ArrayList<PlanNode>());
        this.aggregationDescriptorList = AggregationNode.getDeduplicatedDescriptors(aggregationDescriptorList);
        this.groupByTimeParameter = groupByTimeParameter;
        this.scanOrder = scanOrder;
    }

    public AggregationNode(PlanNodeId id, List<PlanNode> children, List<AggregationDescriptor> aggregationDescriptorList, @Nullable GroupByTimeParameter groupByTimeParameter, Ordering scanOrder) {
        super(id, children);
        this.aggregationDescriptorList = AggregationNode.getDeduplicatedDescriptors(aggregationDescriptorList);
        this.groupByTimeParameter = groupByTimeParameter;
        this.scanOrder = scanOrder;
    }

    public List<AggregationDescriptor> getAggregationDescriptorList() {
        return this.aggregationDescriptorList;
    }

    @Nullable
    public GroupByTimeParameter getGroupByTimeParameter() {
        return this.groupByTimeParameter;
    }

    public Ordering getScanOrder() {
        return this.scanOrder;
    }

    @Override
    public PlanNode clone() {
        return new AggregationNode(this.getPlanNodeId(), this.getAggregationDescriptorList(), this.getGroupByTimeParameter(), this.getScanOrder());
    }

    @Override
    public List<String> getOutputColumnNames() {
        return this.aggregationDescriptorList.stream().map(AggregationDescriptor::getOutputColumnNames).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public void setAggregationDescriptorList(List<AggregationDescriptor> aggregationDescriptorList) {
        this.aggregationDescriptorList = aggregationDescriptorList;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitAggregation(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.AGGREGATE.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.aggregationDescriptorList.size(), (ByteBuffer)byteBuffer);
        for (AggregationDescriptor aggregationDescriptor : this.aggregationDescriptorList) {
            aggregationDescriptor.serialize(byteBuffer);
        }
        if (this.groupByTimeParameter == null) {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)1, (ByteBuffer)byteBuffer);
            this.groupByTimeParameter.serialize(byteBuffer);
        }
        ReadWriteIOUtils.write((int)this.scanOrder.ordinal(), (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.AGGREGATE.serialize(stream);
        ReadWriteIOUtils.write((int)this.aggregationDescriptorList.size(), (OutputStream)stream);
        for (AggregationDescriptor aggregationDescriptor : this.aggregationDescriptorList) {
            aggregationDescriptor.serialize(stream);
        }
        if (this.groupByTimeParameter == null) {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            this.groupByTimeParameter.serialize(stream);
        }
        ReadWriteIOUtils.write((int)this.scanOrder.ordinal(), (OutputStream)stream);
    }

    public static AggregationNode deserialize(ByteBuffer byteBuffer) {
        ArrayList<AggregationDescriptor> aggregationDescriptorList = new ArrayList<AggregationDescriptor>();
        for (int descriptorSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer); descriptorSize > 0; --descriptorSize) {
            aggregationDescriptorList.add(AggregationDescriptor.deserialize(byteBuffer));
        }
        byte isNull = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
        GroupByTimeParameter groupByTimeParameter = null;
        if (isNull == 1) {
            groupByTimeParameter = GroupByTimeParameter.deserialize(byteBuffer);
        }
        Ordering scanOrder = Ordering.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new AggregationNode(planNodeId, aggregationDescriptorList, groupByTimeParameter, scanOrder);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AggregationNode that = (AggregationNode)o;
        return Objects.equals(this.aggregationDescriptorList, that.aggregationDescriptorList) && Objects.equals(this.groupByTimeParameter, that.groupByTimeParameter) && this.scanOrder == that.scanOrder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.aggregationDescriptorList, this.groupByTimeParameter, this.scanOrder});
    }

    public static List<AggregationDescriptor> getDeduplicatedDescriptors(List<AggregationDescriptor> aggregationDescriptors) {
        HashMap<String, Integer> columnToIndexMap = new HashMap<String, Integer>();
        boolean[] removedIndexes = new boolean[aggregationDescriptors.size()];
        for (int i = 0; i < aggregationDescriptors.size(); ++i) {
            AggregationDescriptor descriptor = aggregationDescriptors.get(i);
            if (!descriptor.getStep().isOutputPartial()) continue;
            List<String> outputColumnNames = descriptor.getOutputColumnNames();
            for (String outputColumn : outputColumnNames) {
                if (columnToIndexMap.containsKey(outputColumn)) {
                    if (outputColumnNames.size() == 2) {
                        removedIndexes[((Integer)columnToIndexMap.get((Object)outputColumn)).intValue()] = true;
                        continue;
                    }
                    removedIndexes[i] = true;
                    continue;
                }
                columnToIndexMap.put(outputColumn, i);
            }
        }
        ArrayList<AggregationDescriptor> deduplicatedDescriptors = new ArrayList<AggregationDescriptor>();
        for (int i = 0; i < aggregationDescriptors.size(); ++i) {
            if (removedIndexes[i]) continue;
            deduplicatedDescriptors.add(aggregationDescriptors.get(i));
        }
        return deduplicatedDescriptors;
    }

    public String toString() {
        return String.format("AggregationNode-%s", this.getPlanNodeId());
    }
}

