/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner;

import java.util.List;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.db.mpp.plan.analyze.TypeProvider;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.SimplePlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.AggregationNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.GroupByLevelNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.GroupByTagNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.SlidingWindowAggregationNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.last.LastQueryCollectNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.last.LastQueryMergeNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.last.LastQueryNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.AlignedLastQueryScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.AlignedSeriesAggregationScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.LastQueryScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.SeriesAggregationScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.AggregationDescriptor;

public class SubPlanTypeExtractor {
    public static TypeProvider extractor(PlanNode root, TypeProvider allTypes) {
        TypeProvider typeProvider = new TypeProvider();
        root.accept(new Visitor(typeProvider, allTypes), null);
        return typeProvider;
    }

    private static class Visitor
    extends SimplePlanVisitor<Void> {
        private final TypeProvider typeProvider;
        private final TypeProvider allTypes;

        public Visitor(TypeProvider typeProvider, TypeProvider allTypes) {
            this.typeProvider = typeProvider;
            this.allTypes = allTypes;
        }

        @Override
        public Void visitPlan(PlanNode node, Void context) {
            node.getOutputColumnNames().forEach(name -> this.typeProvider.setType((String)name, this.allTypes.getType((String)name)));
            for (PlanNode source : node.getChildren()) {
                source.accept(this, context);
            }
            return null;
        }

        @Override
        public Void visitSeriesAggregationScan(SeriesAggregationScanNode node, Void context) {
            String sourcePath = node.getSeriesPath().getFullPath();
            this.typeProvider.setType(sourcePath, this.allTypes.getType(sourcePath));
            return this.visitPlan((PlanNode)node, context);
        }

        @Override
        public Void visitAlignedSeriesAggregationScan(AlignedSeriesAggregationScanNode node, Void context) {
            AlignedPath alignedPath = node.getAlignedPath();
            for (int i = 0; i < alignedPath.getColumnNum(); ++i) {
                String sourcePath = alignedPath.getPathWithMeasurement(i).getFullPath();
                this.typeProvider.setType(sourcePath, this.allTypes.getType(sourcePath));
            }
            return this.visitPlan((PlanNode)node, context);
        }

        @Override
        public Void visitAggregation(AggregationNode node, Void context) {
            this.updateTypeProviderByAggregationDescriptor(node.getAggregationDescriptorList());
            return this.visitPlan((PlanNode)node, context);
        }

        @Override
        public Void visitSlidingWindowAggregation(SlidingWindowAggregationNode node, Void context) {
            this.updateTypeProviderByAggregationDescriptor(node.getAggregationDescriptorList());
            return this.visitPlan((PlanNode)node, context);
        }

        @Override
        public Void visitGroupByLevel(GroupByLevelNode node, Void context) {
            this.updateTypeProviderByAggregationDescriptor(node.getGroupByLevelDescriptors());
            return this.visitPlan((PlanNode)node, context);
        }

        @Override
        public Void visitGroupByTag(GroupByTagNode node, Void context) {
            node.getTagValuesToAggregationDescriptors().values().forEach(this::updateTypeProviderByAggregationDescriptor);
            return this.visitPlan((PlanNode)node, context);
        }

        @Override
        public Void visitLastQueryScan(LastQueryScanNode node, Void context) {
            return null;
        }

        @Override
        public Void visitAlignedLastQueryScan(AlignedLastQueryScanNode node, Void context) {
            return null;
        }

        @Override
        public Void visitLastQuery(LastQueryNode node, Void context) {
            return null;
        }

        @Override
        public Void visitLastQueryMerge(LastQueryMergeNode node, Void context) {
            return null;
        }

        @Override
        public Void visitLastQueryCollect(LastQueryCollectNode node, Void context) {
            return null;
        }

        private void updateTypeProviderByAggregationDescriptor(List<? extends AggregationDescriptor> aggregationDescriptorList) {
            aggregationDescriptorList.stream().flatMap(aggregationDescriptor -> aggregationDescriptor.getInputExpressions().stream()).forEach(expression -> {
                String expressionStr = expression.toString();
                this.typeProvider.setType(expressionStr, this.allTypes.getType(expressionStr));
            });
        }
    }
}

