/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner;

import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.storagegroup.IDataRegionForQuery;
import org.apache.iotdb.db.metadata.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.mpp.exception.MemoryNotEnoughException;
import org.apache.iotdb.db.mpp.execution.driver.DataDriver;
import org.apache.iotdb.db.mpp.execution.driver.DataDriverContext;
import org.apache.iotdb.db.mpp.execution.driver.SchemaDriver;
import org.apache.iotdb.db.mpp.execution.driver.SchemaDriverContext;
import org.apache.iotdb.db.mpp.execution.exchange.ISourceHandle;
import org.apache.iotdb.db.mpp.execution.exchange.MPPDataExchangeService;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.timer.RuleBasedTimeSliceAllocator;
import org.apache.iotdb.db.mpp.plan.analyze.TypeProvider;
import org.apache.iotdb.db.mpp.plan.planner.LocalExecutionPlanContext;
import org.apache.iotdb.db.mpp.plan.planner.MemoryDistributionCalculator;
import org.apache.iotdb.db.mpp.plan.planner.OperatorTreeGenerator;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.utils.SetThreadName;
import org.apache.iotdb.mpp.rpc.thrift.TFragmentInstanceId;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalExecutionPlanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalExecutionPlanner.class);
    private long freeMemoryForOperators = IoTDBDescriptor.getInstance().getConfig().getAllocateMemoryForOperators();

    public static LocalExecutionPlanner getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public DataDriver plan(PlanNode plan, TypeProvider types, FragmentInstanceContext instanceContext, Filter timeFilter, IDataRegionForQuery dataRegion) throws MemoryNotEnoughException {
        LocalExecutionPlanContext context = new LocalExecutionPlanContext(types, instanceContext, dataRegion.getDataTTL());
        Operator root = plan.accept(new OperatorTreeGenerator(), context);
        this.checkMemory(root, instanceContext.getStateMachine());
        this.setMemoryLimitForHandle(instanceContext.getId().toThrift(), plan);
        RuleBasedTimeSliceAllocator timeSliceAllocator = context.getTimeSliceAllocator();
        instanceContext.getOperatorContexts().forEach(operatorContext -> operatorContext.setMaxRunTime(timeSliceAllocator.getMaxRunTime((OperatorContext)operatorContext)));
        DataDriverContext dataDriverContext = new DataDriverContext(instanceContext, context.getPaths(), timeFilter, dataRegion, context.getSourceOperators());
        instanceContext.setDriverContext(dataDriverContext);
        return new DataDriver(root, context.getSinkHandle(), dataDriverContext);
    }

    public SchemaDriver plan(PlanNode plan, FragmentInstanceContext instanceContext, ISchemaRegion schemaRegion) throws MemoryNotEnoughException {
        SchemaDriverContext schemaDriverContext = new SchemaDriverContext(instanceContext, schemaRegion);
        instanceContext.setDriverContext(schemaDriverContext);
        LocalExecutionPlanContext context = new LocalExecutionPlanContext(instanceContext);
        Operator root = plan.accept(new OperatorTreeGenerator(), context);
        this.setMemoryLimitForHandle(instanceContext.getId().toThrift(), plan);
        this.checkMemory(root, instanceContext.getStateMachine());
        RuleBasedTimeSliceAllocator timeSliceAllocator = context.getTimeSliceAllocator();
        instanceContext.getOperatorContexts().forEach(operatorContext -> operatorContext.setMaxRunTime(timeSliceAllocator.getMaxRunTime((OperatorContext)operatorContext)));
        return new SchemaDriver(root, context.getSinkHandle(), schemaDriverContext);
    }

    private void setMemoryLimitForHandle(TFragmentInstanceId fragmentInstanceId, PlanNode plan) {
        MemoryDistributionCalculator visitor = new MemoryDistributionCalculator();
        plan.accept(visitor, null);
        int totalSplit = visitor.calculateTotalSplit();
        if (totalSplit == 0) {
            return;
        }
        long maxBytesOneHandleCanReserve = IoTDBDescriptor.getInstance().getConfig().getMaxBytesPerFragmentInstance() / (long)totalSplit;
        for (ISourceHandle handle : MPPDataExchangeService.getInstance().getMPPDataExchangeManager().getISourceHandle(fragmentInstanceId)) {
            handle.setMaxBytesCanReserve(maxBytesOneHandleCanReserve);
        }
        MPPDataExchangeService.getInstance().getMPPDataExchangeManager().getISinkHandle(fragmentInstanceId).setMaxBytesCanReserve(maxBytesOneHandleCanReserve);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkMemory(Operator root, FragmentInstanceStateMachine stateMachine) throws MemoryNotEnoughException {
        if (!IoTDBDescriptor.getInstance().getConfig().isEnableQueryMemoryEstimation()) {
            return;
        }
        long estimatedMemorySize = root.calculateMaxPeekMemory();
        LocalExecutionPlanner localExecutionPlanner = this;
        synchronized (localExecutionPlanner) {
            if (estimatedMemorySize > this.freeMemoryForOperators) {
                throw new MemoryNotEnoughException(String.format("There is not enough memory to execute current fragment instance, current remaining free memory is %d, estimated memory usage for current fragment instance is %d", this.freeMemoryForOperators, estimatedMemorySize), TSStatusCode.MPP_MEMORY_NOT_ENOUGH.getStatusCode());
            }
            this.freeMemoryForOperators -= estimatedMemorySize;
            LOGGER.debug(String.format("[ConsumeMemory] consume: %d, current remaining memory: %d", estimatedMemorySize, this.freeMemoryForOperators));
        }
        stateMachine.addStateChangeListener(newState -> {
            if (newState.isDone()) {
                try (SetThreadName fragmentInstanceName = new SetThreadName(stateMachine.getFragmentInstanceId().getFullId());){
                    LocalExecutionPlanner localExecutionPlanner = this;
                    synchronized (localExecutionPlanner) {
                        this.freeMemoryForOperators += estimatedMemorySize;
                        LOGGER.debug(String.format("[ReleaseMemory] release: %d, current remaining memory: %d", estimatedMemorySize, this.freeMemoryForOperators));
                    }
                }
            }
        });
    }

    private static class InstanceHolder {
        private static final LocalExecutionPlanner INSTANCE = new LocalExecutionPlanner();

        private InstanceHolder() {
        }
    }
}

