/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.schema;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;

public class SchemaQueryMergeOperator
implements ProcessOperator {
    private final PlanNodeId planNodeId;
    private final OperatorContext operatorContext;
    private final List<Operator> children;
    private int currentIndex;

    public SchemaQueryMergeOperator(PlanNodeId planNodeId, OperatorContext operatorContext, List<Operator> children) {
        this.planNodeId = planNodeId;
        this.operatorContext = operatorContext;
        this.children = children;
        this.currentIndex = 0;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public TsBlock next() {
        if (this.children.get(this.currentIndex).hasNext()) {
            return this.children.get(this.currentIndex).next();
        }
        ++this.currentIndex;
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.currentIndex < this.children.size();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.currentIndex < this.children.size() ? this.children.get(this.currentIndex).isBlocked() : NOT_BLOCKED;
    }

    @Override
    public boolean isFinished() {
        return !this.hasNext();
    }

    @Override
    public void close() throws Exception {
        for (Operator child : this.children) {
            child.close();
        }
    }

    @Override
    public long calculateMaxPeekMemory() {
        long childrenMaxPeekMemory = 0L;
        for (Operator child : this.children) {
            childrenMaxPeekMemory = Math.max(childrenMaxPeekMemory, child.calculateMaxPeekMemory());
        }
        return childrenMaxPeekMemory;
    }

    @Override
    public long calculateMaxReturnSize() {
        long childrenMaxReturnSize = 0L;
        for (Operator child : this.children) {
            childrenMaxReturnSize = Math.max(childrenMaxReturnSize, child.calculateMaxReturnSize());
        }
        return childrenMaxReturnSize;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        long retainedSize = 0L;
        for (Operator child : this.children) {
            retainedSize += child.calculateRetainedSizeAfterCallingNext();
        }
        return retainedSize;
    }
}

