/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.aggregation.timerangeiterator;

import org.apache.iotdb.db.mpp.aggregation.timerangeiterator.ITimeRangeIterator;
import org.apache.iotdb.tsfile.read.common.TimeRange;

public class SingleTimeWindowIterator
implements ITimeRangeIterator {
    private final long startTime;
    private final long endTime;
    private TimeRange curTimeRange;
    private boolean hasCachedTimeRange;

    public SingleTimeWindowIterator(long startTime, long endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
    }

    @Override
    public TimeRange getFirstTimeRange() {
        return new TimeRange(this.startTime, this.endTime);
    }

    @Override
    public boolean hasNextTimeRange() {
        if (this.hasCachedTimeRange) {
            return true;
        }
        if (this.curTimeRange == null) {
            this.curTimeRange = this.getFirstTimeRange();
            this.hasCachedTimeRange = true;
        }
        return this.hasCachedTimeRange;
    }

    @Override
    public TimeRange nextTimeRange() {
        if (this.hasCachedTimeRange || this.hasNextTimeRange()) {
            this.hasCachedTimeRange = false;
            return this.curTimeRange;
        }
        return null;
    }

    @Override
    public boolean isAscending() {
        return false;
    }

    @Override
    public long currentOutputTime() {
        return this.curTimeRange.getMin();
    }

    @Override
    public long getTotalIntervalNum() {
        return 1L;
    }
}

