/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.schemaregion;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iotdb.common.rpc.thrift.TSchemaNode;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.AliasAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.PathAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.metadata.SchemaDirCreationFailureException;
import org.apache.iotdb.db.exception.metadata.SeriesNumberOverflowException;
import org.apache.iotdb.db.exception.metadata.SeriesOverflowException;
import org.apache.iotdb.db.metadata.idtable.IDTable;
import org.apache.iotdb.db.metadata.idtable.IDTableManager;
import org.apache.iotdb.db.metadata.logfile.FakeCRC32Deserializer;
import org.apache.iotdb.db.metadata.logfile.FakeCRC32Serializer;
import org.apache.iotdb.db.metadata.logfile.SchemaLogReader;
import org.apache.iotdb.db.metadata.logfile.SchemaLogWriter;
import org.apache.iotdb.db.metadata.mnode.IEntityMNode;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mtree.MTreeBelowSGCachedImpl;
import org.apache.iotdb.db.metadata.plan.schemaregion.ISchemaRegionPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.SchemaRegionPlanVisitor;
import org.apache.iotdb.db.metadata.plan.schemaregion.impl.SchemaRegionPlanDeserializer;
import org.apache.iotdb.db.metadata.plan.schemaregion.impl.SchemaRegionPlanFactory;
import org.apache.iotdb.db.metadata.plan.schemaregion.impl.SchemaRegionPlanSerializer;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IActivateTemplateInClusterPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IAutoCreateDeviceMNodePlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IChangeAliasPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IChangeTagOffsetPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.ICreateAlignedTimeSeriesPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.ICreateTimeSeriesPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IDeactivateTemplatePlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IDeleteTimeSeriesPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IPreDeactivateTemplatePlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IRollbackPreDeactivateTemplatePlan;
import org.apache.iotdb.db.metadata.rescon.MemoryStatistics;
import org.apache.iotdb.db.metadata.rescon.SchemaStatisticsManager;
import org.apache.iotdb.db.metadata.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.metadata.schemaregion.SchemaRegionUtils;
import org.apache.iotdb.db.metadata.tag.TagManager;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.metadata.utils.MetaUtils;
import org.apache.iotdb.db.mpp.common.schematree.DeviceSchemaInfo;
import org.apache.iotdb.db.qp.physical.sys.ShowDevicesPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTimeSeriesPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.dataset.ShowDevicesResult;
import org.apache.iotdb.db.query.dataset.ShowResult;
import org.apache.iotdb.db.query.dataset.ShowTimeSeriesResult;
import org.apache.iotdb.db.utils.SchemaUtils;
import org.apache.iotdb.external.api.ISeriesNumerMonitor;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaRegionSchemaFileImpl
implements ISchemaRegion {
    private static final Logger logger = LoggerFactory.getLogger(SchemaRegionSchemaFileImpl.class);
    protected static IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private boolean isRecovering = true;
    private volatile boolean initialized = false;
    private boolean isClearing = false;
    private final String storageGroupDirPath;
    private final String schemaRegionDirPath;
    private final String storageGroupFullPath;
    private final SchemaRegionId schemaRegionId;
    private boolean usingMLog = true;
    private SchemaLogWriter<ISchemaRegionPlan> logWriter;
    private final SchemaStatisticsManager schemaStatisticsManager = SchemaStatisticsManager.getInstance();
    private final MemoryStatistics memoryStatistics = MemoryStatistics.getInstance();
    private MTreeBelowSGCachedImpl mtree;
    private final LoadingCache<PartialPath, IMNode> mNodeCache;
    private TagManager tagManager;
    private final ISeriesNumerMonitor seriesNumerMonitor;

    public SchemaRegionSchemaFileImpl(PartialPath storageGroup, SchemaRegionId schemaRegionId, ISeriesNumerMonitor seriesNumerMonitor) throws MetadataException {
        this.storageGroupFullPath = storageGroup.getFullPath();
        this.schemaRegionId = schemaRegionId;
        this.storageGroupDirPath = config.getSchemaDir() + File.separator + this.storageGroupFullPath;
        this.schemaRegionDirPath = this.storageGroupDirPath + File.separator + schemaRegionId.getId();
        int cacheSize = config.getSchemaRegionDeviceNodeCacheSize();
        this.mNodeCache = Caffeine.newBuilder().maximumSize((long)cacheSize).removalListener((path, node, cause) -> {
            if (!this.isClearing) {
                this.mtree.unPinMNode((IMNode)node);
            }
        }).build((CacheLoader)new CacheLoader<PartialPath, IMNode>(){

            public @Nullable IMNode load(@NonNull PartialPath partialPath) throws MetadataException {
                return SchemaRegionSchemaFileImpl.this.mtree.getNodeByPath(partialPath);
            }
        });
        this.seriesNumerMonitor = seriesNumerMonitor;
        this.init();
    }

    @Override
    public synchronized void init() throws MetadataException {
        if (this.initialized) {
            return;
        }
        this.initDir();
        try {
            this.isRecovering = true;
            this.tagManager = new TagManager(this.schemaRegionDirPath);
            this.mtree = new MTreeBelowSGCachedImpl(new PartialPath(this.storageGroupFullPath), this.tagManager::readTags, this.schemaRegionId.getId());
            if (!config.isClusterMode() || !config.getSchemaRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus")) {
                this.usingMLog = true;
                this.initMLog();
            } else {
                this.usingMLog = false;
            }
            this.isRecovering = false;
        }
        catch (IOException e) {
            logger.error("Cannot recover all MTree from {} file, we try to recover as possible as we can", (Object)this.storageGroupFullPath, (Object)e);
        }
        this.initialized = true;
    }

    private void initDir() throws SchemaDirCreationFailureException {
        File schemaRegionFolder;
        File sgSchemaFolder = SystemFileFactory.INSTANCE.getFile(this.storageGroupDirPath);
        if (!sgSchemaFolder.exists()) {
            if (sgSchemaFolder.mkdirs()) {
                logger.info("create database schema folder {}", (Object)this.storageGroupDirPath);
            } else if (!sgSchemaFolder.exists()) {
                logger.error("create database schema folder {} failed.", (Object)this.storageGroupDirPath);
                throw new SchemaDirCreationFailureException(this.storageGroupDirPath);
            }
        }
        if (!(schemaRegionFolder = SystemFileFactory.INSTANCE.getFile(this.schemaRegionDirPath)).exists()) {
            if (schemaRegionFolder.mkdirs()) {
                logger.info("create schema region folder {}", (Object)this.schemaRegionDirPath);
            } else if (!schemaRegionFolder.exists()) {
                logger.error("create schema region folder {} failed.", (Object)this.schemaRegionDirPath);
                throw new SchemaDirCreationFailureException(this.schemaRegionDirPath);
            }
        }
    }

    private void initMLog() throws IOException {
        int lineNumber = this.initFromLog();
        this.logWriter = new SchemaLogWriter<ISchemaRegionPlan>(this.schemaRegionDirPath, "mlog.bin", new FakeCRC32Serializer<ISchemaRegionPlan>(new SchemaRegionPlanSerializer()), config.getSyncMlogPeriodInMs() == 0L);
    }

    public void writeToMLog(ISchemaRegionPlan schemaRegionPlan) throws IOException {
        if (this.usingMLog && !this.isRecovering) {
            this.logWriter.write(schemaRegionPlan);
        }
    }

    @Override
    public void forceMlog() {
        if (!this.initialized) {
            return;
        }
        try {
            this.logWriter.force();
        }
        catch (IOException e) {
            logger.error("Cannot force {} mlog to the schema region", (Object)this.schemaRegionId, (Object)e);
        }
    }

    private int initFromLog() throws IOException {
        File logFile = SystemFileFactory.INSTANCE.getFile(this.schemaRegionDirPath + File.separator + "mlog.bin");
        long time = System.currentTimeMillis();
        if (logFile.exists()) {
            int n;
            int idx = 0;
            SchemaLogReader<ISchemaRegionPlan> mLogReader = new SchemaLogReader<ISchemaRegionPlan>(this.schemaRegionDirPath, "mlog.bin", new FakeCRC32Deserializer<ISchemaRegionPlan>(new SchemaRegionPlanDeserializer()));
            try {
                idx = this.applyMLog(mLogReader);
                logger.debug("spend {} ms to deserialize {} mtree from mlog.bin", (Object)(System.currentTimeMillis() - time), (Object)this.storageGroupFullPath);
                n = idx;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        mLogReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IOException("Failed to parse " + this.storageGroupFullPath + " mlog.bin for err:" + e);
                }
            }
            mLogReader.close();
            return n;
        }
        return 0;
    }

    private int applyMLog(SchemaLogReader<ISchemaRegionPlan> mLogReader) {
        int idx = 0;
        RecoverPlanOperator recoverPlanOperator = new RecoverPlanOperator();
        while (mLogReader.hasNext()) {
            RecoverOperationResult operationResult;
            ISchemaRegionPlan plan;
            try {
                plan = mLogReader.next();
                ++idx;
            }
            catch (Exception e) {
                logger.error("Parse mlog error at lineNumber {} because:", (Object)idx, (Object)e);
                break;
            }
            if (plan == null || !(operationResult = plan.accept(recoverPlanOperator, this)).isFailed()) continue;
            logger.error("Can not operate cmd {} for err:", (Object)plan.getPlanType().name(), (Object)operationResult.getException());
        }
        if (mLogReader.isFileCorrupted()) {
            throw new IllegalStateException("The mlog.bin has been corrupted. Please remove it or fix it, and then restart IoTDB");
        }
        return idx;
    }

    @Override
    public synchronized void clear() {
        this.isClearing = true;
        try {
            if (this.mNodeCache != null) {
                this.mNodeCache.invalidateAll();
            }
            if (this.mtree != null) {
                this.mtree.clear();
            }
            if (this.logWriter != null) {
                this.logWriter.close();
                this.logWriter = null;
            }
            this.tagManager.clear();
            this.isRecovering = true;
            this.initialized = false;
        }
        catch (IOException e) {
            logger.error("Cannot close metadata log writer, because:", (Throwable)e);
        }
        this.isClearing = false;
    }

    @Override
    public String getStorageGroupFullPath() {
        return this.storageGroupFullPath;
    }

    @Override
    public SchemaRegionId getSchemaRegionId() {
        return this.schemaRegionId;
    }

    @Override
    public synchronized void deleteSchemaRegion() throws MetadataException {
        List<IMeasurementMNode> leafMNodes = this.mtree.getAllMeasurementMNode();
        int seriesCount = leafMNodes.size();
        this.schemaStatisticsManager.deleteTimeseries(seriesCount);
        if (this.seriesNumerMonitor != null) {
            this.seriesNumerMonitor.deleteTimeSeries(seriesCount);
        }
        this.clear();
        SchemaRegionUtils.deleteSchemaRegionFolder(this.schemaRegionDirPath, logger);
    }

    @Override
    public boolean createSnapshot(File snapshotDir) {
        if (!this.initialized) {
            logger.warn("Failed to create snapshot of schemaRegion {}, because the schemaRegion has not been initialized.", (Object)this.schemaRegionId);
            return false;
        }
        logger.info("Start create snapshot of schemaRegion {}", (Object)this.schemaRegionId);
        boolean isSuccess = true;
        long startTime = System.currentTimeMillis();
        long mtreeSnapshotStartTime = System.currentTimeMillis();
        isSuccess = isSuccess && this.mtree.createSnapshot(snapshotDir);
        logger.info("MTree snapshot creation of schemaRegion {} costs {}ms.", (Object)this.schemaRegionId, (Object)(System.currentTimeMillis() - mtreeSnapshotStartTime));
        long tagSnapshotStartTime = System.currentTimeMillis();
        isSuccess = isSuccess && this.tagManager.createSnapshot(snapshotDir);
        logger.info("Tag snapshot creation of schemaRegion {} costs {}ms.", (Object)this.schemaRegionId, (Object)(System.currentTimeMillis() - tagSnapshotStartTime));
        logger.info("Snapshot creation of schemaRegion {} costs {}ms.", (Object)this.schemaRegionId, (Object)(System.currentTimeMillis() - startTime));
        logger.info("Successfully create snapshot of schemaRegion {}", (Object)this.schemaRegionId);
        return isSuccess;
    }

    @Override
    public void loadSnapshot(File latestSnapshotRootDir) {
        this.clear();
        logger.info("Start loading snapshot of schemaRegion {}", (Object)this.schemaRegionId);
        long startTime = System.currentTimeMillis();
        try {
            this.usingMLog = false;
            this.isRecovering = true;
            long tagSnapshotStartTime = System.currentTimeMillis();
            this.tagManager = TagManager.loadFromSnapshot(latestSnapshotRootDir, this.schemaRegionDirPath);
            logger.info("Tag snapshot loading of schemaRegion {} costs {}ms.", (Object)this.schemaRegionId, (Object)(System.currentTimeMillis() - tagSnapshotStartTime));
            long mtreeSnapshotStartTime = System.currentTimeMillis();
            this.mtree = MTreeBelowSGCachedImpl.loadFromSnapshot(latestSnapshotRootDir, this.storageGroupFullPath, this.schemaRegionId.getId(), measurementMNode -> {
                if (measurementMNode.getOffset() == -1L) {
                    return;
                }
                try {
                    this.tagManager.recoverIndex(measurementMNode.getOffset(), (IMeasurementMNode)measurementMNode);
                }
                catch (IOException e) {
                    logger.error("Failed to recover tagIndex for {} in schemaRegion {}.", (Object)(this.storageGroupFullPath + "." + measurementMNode.getFullPath()), (Object)this.schemaRegionId);
                }
            }, this.tagManager::readTags);
            logger.info("MTree snapshot loading of schemaRegion {} costs {}ms.", (Object)this.schemaRegionId, (Object)(System.currentTimeMillis() - mtreeSnapshotStartTime));
            this.isRecovering = false;
            this.initialized = true;
            logger.info("Snapshot loading of schemaRegion {} costs {}ms.", (Object)this.schemaRegionId, (Object)(System.currentTimeMillis() - startTime));
            logger.info("Successfully load snapshot of schemaRegion {}", (Object)this.schemaRegionId);
        }
        catch (IOException | MetadataException e) {
            logger.error("Failed to load snapshot for schemaRegion {}  due to {}. Use empty schemaRegion", new Object[]{this.schemaRegionId, e.getMessage(), e});
            try {
                this.initialized = false;
                this.isRecovering = true;
                this.init();
            }
            catch (MetadataException metadataException) {
                logger.error("Error occurred during initializing schemaRegion {}", (Object)this.schemaRegionId, (Object)metadataException);
            }
        }
    }

    public void createTimeseries(ICreateTimeSeriesPlan plan) throws MetadataException {
        this.createTimeseries(plan, -1L);
    }

    public void recoverTimeseries(ICreateTimeSeriesPlan plan, long offset) throws MetadataException {
        boolean done = false;
        while (!done) {
            try {
                this.createTimeseries(plan, offset);
                done = true;
            }
            catch (SeriesOverflowException e) {
                logger.warn("Too many timeseries during recovery from MLog, waiting for SchemaFile swapping.");
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e2) {
                    logger.error("Exception occurs during timeseries recovery.");
                    throw new MetadataException(e2.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createTimeseries(ICreateTimeSeriesPlan plan, long offset) throws MetadataException {
        if (!this.memoryStatistics.isAllowToCreateNewSeries()) {
            logger.error(String.format("Series overflow when creating: [%s]", plan.getPath().getFullPath()));
            throw new SeriesOverflowException();
        }
        if (this.seriesNumerMonitor != null && !this.seriesNumerMonitor.addTimeSeries(1)) {
            throw new SeriesNumberOverflowException();
        }
        try {
            IMeasurementMNode leafMNode;
            PartialPath path = plan.getPath();
            try {
                SchemaUtils.checkDataTypeWithEncoding(plan.getDataType(), plan.getEncoding());
                TSDataType type = plan.getDataType();
                leafMNode = this.mtree.createTimeseriesWithPinnedReturn(path, type, plan.getEncoding(), plan.getCompressor(), plan.getProps(), plan.getAlias());
            }
            catch (Throwable t) {
                if (this.seriesNumerMonitor != null) {
                    this.seriesNumerMonitor.deleteTimeSeries(1);
                }
                throw t;
            }
            try {
                this.mNodeCache.invalidate((Object)path.getDevicePath());
                this.schemaStatisticsManager.addTimeseries(1);
                if (offset != -1L && this.isRecovering) {
                    this.tagManager.recoverIndex(offset, leafMNode);
                } else if (plan.getTags() != null) {
                    this.tagManager.addIndex(plan.getTags(), leafMNode);
                }
                if (!this.isRecovering) {
                    if (plan.getTags() != null && !plan.getTags().isEmpty() || plan.getAttributes() != null && !plan.getAttributes().isEmpty()) {
                        offset = this.tagManager.writeTagFile(plan.getTags(), plan.getAttributes());
                    }
                    plan.setTagOffset(offset);
                    this.writeToMLog(plan);
                }
                if (offset != -1L) {
                    leafMNode.setOffset(offset);
                    this.mtree.updateMNode(leafMNode);
                }
            }
            finally {
                this.mtree.unPinMNode(leafMNode);
            }
        }
        catch (IOException e) {
            throw new MetadataException((Throwable)e);
        }
        if (!(!config.isEnableIDTable() || this.isRecovering && config.isEnableIDTableLogFile())) {
            IDTable idTable = IDTableManager.getInstance().getIDTable(plan.getPath().getDevicePath());
            idTable.createTimeseries(plan);
        }
    }

    private void createTimeseries(PartialPath path, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props) throws MetadataException {
        block2: {
            try {
                this.createTimeseries(SchemaRegionPlanFactory.getCreateTimeSeriesPlan(path, dataType, encoding, compressor, props, null, null, null));
            }
            catch (AliasAlreadyExistException | PathAlreadyExistException e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Ignore PathAlreadyExistException and AliasAlreadyExistException when Concurrent inserting a non-exist time series {}", (Object)path);
            }
        }
    }

    public void createAlignedTimeSeries(PartialPath prefixPath, List<String> measurements, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors) throws MetadataException {
        this.createAlignedTimeSeries(SchemaRegionPlanFactory.getCreateAlignedTimeSeriesPlan(prefixPath, measurements, dataTypes, encodings, compressors, null, null, null));
    }

    public void recoverAlignedTimeSeries(ICreateAlignedTimeSeriesPlan plan) throws MetadataException {
        boolean done = false;
        while (!done) {
            try {
                this.createAlignedTimeSeries(plan);
                done = true;
            }
            catch (SeriesOverflowException e) {
                logger.warn("Too many timeseries during recovery from MLog, waiting for SchemaFile swapping.");
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e2) {
                    logger.error("Exception occurs during timeseries recovery.");
                    throw new MetadataException(e2.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createAlignedTimeSeries(ICreateAlignedTimeSeriesPlan plan) throws MetadataException {
        int seriesCount = plan.getMeasurements().size();
        if (!this.memoryStatistics.isAllowToCreateNewSeries()) {
            throw new SeriesOverflowException();
        }
        if (this.seriesNumerMonitor != null && !this.seriesNumerMonitor.addTimeSeries(seriesCount)) {
            throw new SeriesNumberOverflowException();
        }
        try {
            List<IMeasurementMNode> measurementMNodeList;
            PartialPath prefixPath = plan.getDevicePath();
            List<String> measurements = plan.getMeasurements();
            List<TSDataType> dataTypes = plan.getDataTypes();
            List<TSEncoding> encodings = plan.getEncodings();
            List<Map<String, String>> tagsList = plan.getTagsList();
            List<Map<String, String>> attributesList = plan.getAttributesList();
            try {
                for (int i = 0; i < measurements.size(); ++i) {
                    SchemaUtils.checkDataTypeWithEncoding(dataTypes.get(i), encodings.get(i));
                }
                measurementMNodeList = this.mtree.createAlignedTimeseries(prefixPath, measurements, plan.getDataTypes(), plan.getEncodings(), plan.getCompressors(), plan.getAliasList());
            }
            catch (Throwable t) {
                if (this.seriesNumerMonitor != null) {
                    this.seriesNumerMonitor.deleteTimeSeries(seriesCount);
                }
                throw t;
            }
            try {
                int i;
                this.mNodeCache.invalidate((Object)prefixPath);
                this.schemaStatisticsManager.addTimeseries(seriesCount);
                List<Long> tagOffsets = plan.getTagOffsets();
                for (i = 0; i < measurements.size(); ++i) {
                    if (tagOffsets != null && !plan.getTagOffsets().isEmpty() && this.isRecovering) {
                        if (tagOffsets.get(i) == -1L) continue;
                        this.tagManager.recoverIndex(plan.getTagOffsets().get(i), measurementMNodeList.get(i));
                        continue;
                    }
                    if (tagsList == null || tagsList.isEmpty() || tagsList.get(i) == null) continue;
                    this.tagManager.addIndex(tagsList.get(i), measurementMNodeList.get(i));
                }
                tagOffsets = new ArrayList<Long>();
                if (!this.isRecovering) {
                    if (tagsList != null && !tagsList.isEmpty() || attributesList != null && !attributesList.isEmpty()) {
                        for (int i2 = 0; i2 < measurements.size(); ++i2) {
                            Map<String, String> attributes;
                            Map<String, String> tags = tagsList == null ? null : tagsList.get(i2);
                            Map<String, String> map = attributes = attributesList == null ? null : attributesList.get(i2);
                            if (tags == null && attributes == null) {
                                tagOffsets.add(-1L);
                                continue;
                            }
                            tagOffsets.add(this.tagManager.writeTagFile(tags, attributes));
                        }
                    } else {
                        for (i = 0; i < measurements.size(); ++i) {
                            tagOffsets.add(-1L);
                        }
                    }
                    plan.setTagOffsets(tagOffsets);
                    this.writeToMLog(plan);
                }
                tagOffsets = plan.getTagOffsets();
                for (i = 0; i < measurements.size(); ++i) {
                    if (tagOffsets.get(i) == -1L) continue;
                    measurementMNodeList.get(i).setOffset(tagOffsets.get(i));
                    this.mtree.updateMNode(measurementMNodeList.get(i));
                }
            }
            finally {
                for (IMeasurementMNode measurementMNode : measurementMNodeList) {
                    this.mtree.unPinMNode(measurementMNode);
                }
            }
        }
        catch (IOException e) {
            throw new MetadataException((Throwable)e);
        }
        if (!(!config.isEnableIDTable() || this.isRecovering && config.isEnableIDTableLogFile())) {
            IDTable idTable = IDTableManager.getInstance().getIDTable(plan.getDevicePath());
            idTable.createAlignedTimeseries(plan);
        }
    }

    @Override
    public Map<Integer, MetadataException> checkMeasurementExistence(PartialPath devicePath, List<String> measurementList, List<String> aliasList) {
        return this.mtree.checkMeasurementExistence(devicePath, measurementList, aliasList);
    }

    @Override
    public synchronized Pair<Integer, Set<String>> deleteTimeseries(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        try {
            List<MeasurementPath> allTimeseries = this.mtree.getMeasurementPaths(pathPattern, isPrefixMatch);
            HashSet failedNames = new HashSet();
            int deletedNum = 0;
            for (PartialPath partialPath : allTimeseries) {
                this.deleteSingleTimeseriesInternal(partialPath);
                ++deletedNum;
            }
            return new Pair((Object)deletedNum, failedNames);
        }
        catch (IOException e) {
            throw new MetadataException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long constructSchemaBlackList(PathPatternTree patternTree) throws MetadataException {
        long preDeletedNum = 0L;
        for (PartialPath pathPattern : patternTree.getAllPathPatterns()) {
            List<IMeasurementMNode> measurementMNodeList = this.mtree.getMatchedMeasurementMNode(pathPattern);
            try {
                for (IMeasurementMNode measurementMNode : measurementMNodeList) {
                    try {
                        ++preDeletedNum;
                        measurementMNode.setPreDeleted(true);
                        this.mtree.updateMNode(measurementMNode);
                        this.writeToMLog(SchemaRegionPlanFactory.getPreDeleteTimeSeriesPlan(measurementMNode.getPartialPath()));
                    }
                    catch (IOException e) {
                        throw new MetadataException((Throwable)e);
                    }
                }
            }
            finally {
                for (IMeasurementMNode measurementMNode : measurementMNodeList) {
                    this.mtree.unPinMNode(measurementMNode);
                }
            }
        }
        return preDeletedNum;
    }

    @Override
    public void rollbackSchemaBlackList(PathPatternTree patternTree) throws MetadataException {
        for (PartialPath pathPattern : patternTree.getAllPathPatterns()) {
            for (IMeasurementMNode measurementMNode : this.mtree.getMatchedMeasurementMNode(pathPattern)) {
                try {
                    measurementMNode.setPreDeleted(false);
                    this.mtree.updateMNode(measurementMNode);
                    this.writeToMLog(SchemaRegionPlanFactory.getRollbackPreDeleteTimeSeriesPlan(measurementMNode.getPartialPath()));
                }
                catch (IOException e) {
                    throw new MetadataException((Throwable)e);
                }
                finally {
                    this.mtree.unPinMNode(measurementMNode);
                }
            }
        }
    }

    @Override
    public Set<PartialPath> fetchSchemaBlackList(PathPatternTree patternTree) throws MetadataException {
        HashSet<PartialPath> deviceBasedPathPatternSet = new HashSet<PartialPath>();
        for (PartialPath pathPattern : patternTree.getAllPathPatterns()) {
            for (PartialPath devicePath : this.mtree.getDevicesOfPreDeletedTimeseries(pathPattern)) {
                deviceBasedPathPatternSet.addAll(pathPattern.alterPrefixPath(devicePath));
            }
        }
        return deviceBasedPathPatternSet;
    }

    @Override
    public void deleteTimeseriesInBlackList(PathPatternTree patternTree) throws MetadataException {
        for (PartialPath pathPattern : patternTree.getAllPathPatterns()) {
            for (PartialPath path : this.mtree.getPreDeletedTimeseries(pathPattern)) {
                try {
                    this.deleteSingleTimeseriesInBlackList(path);
                    this.writeToMLog(SchemaRegionPlanFactory.getDeleteTimeSeriesPlan(Collections.singletonList(path)));
                }
                catch (IOException e) {
                    throw new MetadataException((Throwable)e);
                }
            }
        }
    }

    private void deleteSingleTimeseriesInBlackList(PartialPath path) throws MetadataException, IOException {
        Pair<PartialPath, IMeasurementMNode> pair = this.mtree.deleteTimeseriesAndReturnEmptyStorageGroup(path);
        IMeasurementMNode measurementMNode = (IMeasurementMNode)pair.right;
        this.removeFromTagInvertedIndex(measurementMNode);
        IEntityMNode node = measurementMNode.getParent();
        this.mNodeCache.invalidate((Object)node.getPartialPath());
        this.schemaStatisticsManager.deleteTimeseries(1);
        if (this.seriesNumerMonitor != null) {
            this.seriesNumerMonitor.deleteTimeSeries(1);
        }
    }

    public Pair<Integer, Set<String>> deleteTimeseries(PartialPath pathPattern) throws MetadataException {
        return this.deleteTimeseries(pathPattern, false);
    }

    private void deleteSingleTimeseriesInternal(PartialPath p) throws MetadataException, IOException {
        this.deleteOneTimeseriesUpdateStatistics(p);
        if (!this.isRecovering) {
            this.writeToMLog(SchemaRegionPlanFactory.getDeleteTimeSeriesPlan(Collections.singletonList(p)));
        }
    }

    private PartialPath deleteOneTimeseriesUpdateStatistics(PartialPath path) throws MetadataException, IOException {
        Pair<PartialPath, IMeasurementMNode> pair = this.mtree.deleteTimeseriesAndReturnEmptyStorageGroup(path);
        IMeasurementMNode measurementMNode = (IMeasurementMNode)pair.right;
        this.removeFromTagInvertedIndex(measurementMNode);
        PartialPath storageGroupPath = (PartialPath)pair.left;
        IEntityMNode node = measurementMNode.getParent();
        this.mNodeCache.invalidate((Object)node.getPartialPath());
        this.schemaStatisticsManager.deleteTimeseries(1);
        if (this.seriesNumerMonitor != null) {
            this.seriesNumerMonitor.deleteTimeSeries(1);
        }
        return storageGroupPath;
    }

    private IMNode getDeviceNodeWithAutoCreate(PartialPath path) throws IOException, MetadataException {
        try {
            IMNode node = (IMNode)this.mNodeCache.get((Object)path);
            try {
                this.mtree.pinMNode(node);
                return node;
            }
            catch (MetadataException e) {
                return this.mtree.getNodeByPath(path);
            }
        }
        catch (Exception e) {
            if (e.getCause() instanceof MetadataException) {
                if (!config.isAutoCreateSchemaEnabled()) {
                    throw new PathNotExistException(path.getFullPath());
                }
            } else {
                throw e;
            }
            IMNode node = this.mtree.getDeviceNodeWithAutoCreating(path);
            this.writeToMLog(SchemaRegionPlanFactory.getAutoCreateDeviceMNodePlan(node.getPartialPath()));
            return node;
        }
    }

    private void autoCreateDeviceMNode(IAutoCreateDeviceMNodePlan plan) throws MetadataException {
        IMNode node = this.mtree.getDeviceNodeWithAutoCreating(plan.getPath());
        this.mtree.unPinMNode(node);
        try {
            this.writeToMLog(plan);
        }
        catch (IOException e) {
            throw new MetadataException((Throwable)e);
        }
    }

    @Override
    public boolean isPathExist(PartialPath path) {
        try {
            return this.mtree.isPathExist(path);
        }
        catch (MetadataException e) {
            logger.error(e.getMessage());
            return false;
        }
    }

    @Override
    public long getAllTimeseriesCount(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        return this.mtree.getAllTimeseriesCount(pathPattern, isPrefixMatch);
    }

    @Override
    public long getAllTimeseriesCount(PartialPath pathPattern, Map<Integer, Template> templateMap, boolean isPrefixMatch) throws MetadataException {
        return this.mtree.getAllTimeseriesCount(pathPattern, templateMap, isPrefixMatch);
    }

    @Override
    public long getAllTimeseriesCount(PartialPath pathPattern, boolean isPrefixMatch, String key, String value, boolean isContains) throws MetadataException {
        return this.mtree.getAllTimeseriesCount(pathPattern, isPrefixMatch, this.tagManager.getMatchedTimeseriesInIndex(key, value, isContains), true);
    }

    @Override
    public long getDevicesNum(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        return this.mtree.getDevicesNum(pathPattern, isPrefixMatch);
    }

    @Override
    public Map<PartialPath, Long> getMeasurementCountGroupByLevel(PartialPath pathPattern, int level, boolean isPrefixMatch) throws MetadataException {
        return this.mtree.getMeasurementCountGroupByLevel(pathPattern, level, isPrefixMatch);
    }

    @Override
    public Map<PartialPath, Long> getMeasurementCountGroupByLevel(PartialPath pathPattern, int level, boolean isPrefixMatch, String key, String value, boolean isContains) throws MetadataException {
        return this.mtree.getMeasurementCountGroupByLevel(pathPattern, level, isPrefixMatch, this.tagManager.getMatchedTimeseriesInIndex(key, value, isContains), true);
    }

    @Override
    public List<PartialPath> getNodesListInGivenLevel(PartialPath pathPattern, int nodeLevel, boolean isPrefixMatch) throws MetadataException {
        return this.mtree.getNodesListInGivenLevel(pathPattern, nodeLevel, isPrefixMatch);
    }

    @Override
    public Set<TSchemaNode> getChildNodePathInNextLevel(PartialPath pathPattern) throws MetadataException {
        return this.mtree.getChildNodePathInNextLevel(pathPattern);
    }

    @Override
    public Set<String> getChildNodeNameInNextLevel(PartialPath pathPattern) throws MetadataException {
        return this.mtree.getChildNodeNameInNextLevel(pathPattern);
    }

    @Override
    public Set<PartialPath> getBelongedDevices(PartialPath timeseries) throws MetadataException {
        return this.mtree.getDevicesByTimeseries(timeseries);
    }

    @Override
    public Set<PartialPath> getMatchedDevices(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        return this.mtree.getDevices(pathPattern, isPrefixMatch);
    }

    @Override
    public Pair<List<ShowDevicesResult>, Integer> getMatchedDevices(ShowDevicesPlan plan) throws MetadataException {
        return this.mtree.getDevices(plan);
    }

    @Override
    public List<MeasurementPath> getMeasurementPaths(PartialPath pathPattern, boolean isPrefixMatch, boolean withTags) throws MetadataException {
        return (List)this.getMeasurementPathsWithAlias((PartialPath)pathPattern, (int)0, (int)0, (boolean)isPrefixMatch, (boolean)withTags).left;
    }

    @Override
    public Pair<List<MeasurementPath>, Integer> getMeasurementPathsWithAlias(PartialPath pathPattern, int limit, int offset, boolean isPrefixMatch, boolean withTags) throws MetadataException {
        return this.mtree.getMeasurementPathsWithAlias(pathPattern, limit, offset, isPrefixMatch, withTags);
    }

    @Override
    public List<MeasurementPath> fetchSchema(PartialPath pathPattern, Map<Integer, Template> templateMap, boolean withTags) throws MetadataException {
        return this.mtree.fetchSchema(pathPattern, templateMap, withTags);
    }

    @Override
    public Pair<List<ShowTimeSeriesResult>, Integer> showTimeseries(ShowTimeSeriesPlan plan, QueryContext context) throws MetadataException {
        if (plan.getKey() != null && plan.getValue() != null) {
            return this.showTimeseriesWithIndex(plan, context);
        }
        return this.showTimeseriesWithoutIndex(plan, context);
    }

    private Pair<List<ShowTimeSeriesResult>, Integer> showTimeseriesWithIndex(ShowTimeSeriesPlan plan, QueryContext context) throws MetadataException {
        List<IMeasurementMNode> allMatchedNodes = this.tagManager.getMatchedTimeseriesInIndex(plan, context);
        List<Object> res = new LinkedList();
        PartialPath pathPattern = plan.getPath();
        boolean needLast = plan.isOrderByHeat();
        int curOffset = -1;
        int count = 0;
        int limit = needLast ? 0 : plan.getLimit();
        int offset = needLast ? 0 : plan.getOffset();
        for (IMeasurementMNode leaf : allMatchedNodes) {
            if (!((plan.isPrefixMatch() ? pathPattern.prefixMatchFullPath(leaf.getPartialPath()) : pathPattern.matchFullPath(leaf.getPartialPath())) && (limit == 0 && offset == 0 || ++curOffset >= offset && count != limit))) continue;
            try {
                Pair<Map<String, String>, Map<String, String>> tagAndAttributePair = this.tagManager.readTagFile(leaf.getOffset());
                IMeasurementSchema measurementSchema = leaf.getSchema();
                Pair<String, String> deadbandInfo = MetaUtils.parseDeadbandInfo(measurementSchema.getProps());
                res.add(new ShowTimeSeriesResult(leaf.getFullPath(), leaf.getAlias(), this.storageGroupFullPath, measurementSchema.getType(), measurementSchema.getEncodingType(), measurementSchema.getCompressor(), 0L, (Map)tagAndAttributePair.left, (Map)tagAndAttributePair.right, (String)deadbandInfo.left, (String)deadbandInfo.right));
                if (limit == 0) continue;
                ++count;
            }
            catch (IOException e) {
                throw new MetadataException("Something went wrong while deserialize tag info of " + leaf.getFullPath(), (Throwable)e);
            }
        }
        if (needLast) {
            Stream<Object> stream = res.stream();
            limit = plan.getLimit();
            offset = plan.getOffset();
            stream = stream.sorted(Comparator.comparingLong(ShowTimeSeriesResult::getLastTime).reversed().thenComparing(ShowResult::getName));
            if (limit != 0) {
                stream = stream.skip(offset).limit(limit);
            }
            res = stream.collect(Collectors.toList());
        }
        return new Pair(res, (Object)(curOffset + 1));
    }

    private Pair<List<ShowTimeSeriesResult>, Integer> showTimeseriesWithoutIndex(ShowTimeSeriesPlan plan, QueryContext context) throws MetadataException {
        Pair<List<Pair<PartialPath, String[]>>, Integer> ans = this.mtree.getAllMeasurementSchema(plan, context);
        LinkedList<ShowTimeSeriesResult> res = new LinkedList<ShowTimeSeriesResult>();
        for (Pair ansString : (List)ans.left) {
            long tagFileOffset = Long.parseLong(((String[])ansString.right)[5]);
            try {
                Pair<Map<String, String>, Map<String, String>> tagAndAttributePair = new Pair<Map<String, String>, Map<String, String>>(Collections.emptyMap(), Collections.emptyMap());
                if (tagFileOffset >= 0L) {
                    tagAndAttributePair = this.tagManager.readTagFile(tagFileOffset);
                }
                res.add(new ShowTimeSeriesResult(((PartialPath)ansString.left).getFullPath(), ((String[])ansString.right)[0], ((String[])ansString.right)[1], TSDataType.valueOf((String)((String[])ansString.right)[2]), TSEncoding.valueOf((String)((String[])ansString.right)[3]), CompressionType.valueOf((String)((String[])ansString.right)[4]), ((String[])ansString.right)[6] != null ? Long.parseLong(((String[])ansString.right)[6]) : 0L, (Map)tagAndAttributePair.left, (Map)tagAndAttributePair.right, ((String[])ansString.right)[7], ((String[])ansString.right)[8]));
            }
            catch (IOException e) {
                throw new MetadataException("Something went wrong while deserialize tag info of " + ((PartialPath)ansString.left).getFullPath(), (Throwable)e);
            }
        }
        return new Pair(res, (Object)((Integer)ans.right));
    }

    @Override
    public IMNode getDeviceNode(PartialPath path) throws MetadataException {
        try {
            IMNode node = (IMNode)this.mNodeCache.get((Object)path);
            return node;
        }
        catch (Exception e) {
            if (e.getCause() instanceof MetadataException) {
                throw new PathNotExistException(path.getFullPath());
            }
            throw e;
        }
    }

    @Override
    public IMeasurementMNode getMeasurementMNode(PartialPath fullPath) throws MetadataException {
        IMeasurementMNode measurementMNode = this.mtree.getMeasurementMNode(fullPath);
        this.mtree.unPinMNode(measurementMNode);
        return measurementMNode;
    }

    protected IMeasurementMNode getMeasurementMNode(IMNode deviceMNode, String measurementName) throws MetadataException {
        IMNode result = this.mtree.getChildFromPinnedMNode(deviceMNode, measurementName);
        if (result == null) {
            return null;
        }
        this.mtree.unPinMNode(result);
        if (result.isMeasurement()) {
            return result.getAsMeasurementMNode();
        }
        throw new PathAlreadyExistException(deviceMNode.getFullPath() + "." + measurementName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeOffset(PartialPath path, long offset) throws MetadataException {
        block6: {
            IMeasurementMNode measurementMNode = this.mtree.getMeasurementMNode(path);
            try {
                measurementMNode.setOffset(offset);
                this.mtree.updateMNode(measurementMNode);
                if (!this.isRecovering) break block6;
                try {
                    if (this.tagManager.recoverIndex(offset, measurementMNode)) {
                        this.mtree.pinMNode(measurementMNode);
                    }
                }
                catch (IOException e) {
                    throw new MetadataException((Throwable)e);
                }
            }
            finally {
                this.mtree.unPinMNode(measurementMNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeAlias(PartialPath path, String alias) throws MetadataException {
        IMeasurementMNode leafMNode = this.mtree.getMeasurementMNode(path);
        try {
            if (leafMNode.getAlias() != null) {
                leafMNode.getParent().deleteAliasChild(leafMNode.getAlias());
            }
            leafMNode.getParent().addAlias(alias, leafMNode);
            this.mtree.setAlias(leafMNode, alias);
        }
        finally {
            this.mtree.unPinMNode(leafMNode);
        }
        try {
            this.writeToMLog(SchemaRegionPlanFactory.getChangeAliasPlan(path, alias));
        }
        catch (IOException e) {
            throw new MetadataException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upsertTagsAndAttributes(String alias, Map<String, String> tagsMap, Map<String, String> attributesMap, PartialPath fullPath) throws MetadataException, IOException {
        IMeasurementMNode leafMNode = this.mtree.getMeasurementMNode(fullPath);
        try {
            this.upsertAlias(alias, fullPath, leafMNode);
            if (tagsMap == null && attributesMap == null) {
                return;
            }
            if (leafMNode.getOffset() < 0L) {
                long offset = this.tagManager.writeTagFile(tagsMap, attributesMap);
                this.writeToMLog(SchemaRegionPlanFactory.getChangeTagOffsetPlan(fullPath, offset));
                leafMNode.setOffset(offset);
                this.mtree.updateMNode(leafMNode);
                if (tagsMap != null && !tagsMap.isEmpty()) {
                    this.tagManager.addIndex(tagsMap, leafMNode);
                    this.mtree.pinMNode(leafMNode);
                }
                return;
            }
            this.tagManager.updateTagsAndAttributes(tagsMap, attributesMap, leafMNode);
        }
        finally {
            this.mtree.unPinMNode(leafMNode);
        }
    }

    private void upsertAlias(String alias, PartialPath fullPath, IMeasurementMNode leafMNode) throws MetadataException, IOException {
        if (alias != null && !alias.equals(leafMNode.getAlias())) {
            if (!leafMNode.getParent().addAlias(alias, leafMNode)) {
                throw new MetadataException("The alias already exists.");
            }
            if (leafMNode.getAlias() != null) {
                leafMNode.getParent().deleteAliasChild(leafMNode.getAlias());
            }
            this.mtree.setAlias(leafMNode, alias);
            this.writeToMLog(SchemaRegionPlanFactory.getChangeAliasPlan(fullPath, alias));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAttributes(Map<String, String> attributesMap, PartialPath fullPath) throws MetadataException, IOException {
        IMeasurementMNode leafMNode = this.mtree.getMeasurementMNode(fullPath);
        try {
            if (leafMNode.getOffset() < 0L) {
                long offset = this.tagManager.writeTagFile(Collections.emptyMap(), attributesMap);
                this.writeToMLog(SchemaRegionPlanFactory.getChangeTagOffsetPlan(fullPath, offset));
                leafMNode.setOffset(offset);
                this.mtree.updateMNode(leafMNode);
                return;
            }
            this.tagManager.addAttributes(attributesMap, fullPath, leafMNode);
        }
        finally {
            this.mtree.updateMNode(leafMNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTags(Map<String, String> tagsMap, PartialPath fullPath) throws MetadataException, IOException {
        IMeasurementMNode leafMNode = this.mtree.getMeasurementMNode(fullPath);
        try {
            if (leafMNode.getOffset() < 0L) {
                long offset = this.tagManager.writeTagFile(tagsMap, Collections.emptyMap());
                this.writeToMLog(SchemaRegionPlanFactory.getChangeTagOffsetPlan(fullPath, offset));
                leafMNode.setOffset(offset);
                this.mtree.updateMNode(leafMNode);
                this.tagManager.addIndex(tagsMap, leafMNode);
                this.mtree.pinMNode(leafMNode);
                return;
            }
            this.tagManager.addTags(tagsMap, fullPath, leafMNode);
        }
        finally {
            this.mtree.unPinMNode(leafMNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropTagsOrAttributes(Set<String> keySet, PartialPath fullPath) throws MetadataException, IOException {
        IMeasurementMNode leafMNode = this.mtree.getMeasurementMNode(fullPath);
        try {
            if (leafMNode.getOffset() != -1L) {
                this.tagManager.dropTagsOrAttributes(keySet, fullPath, leafMNode);
                this.mtree.unPinMNode(leafMNode);
            }
        }
        finally {
            this.mtree.unPinMNode(leafMNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTagsOrAttributesValue(Map<String, String> alterMap, PartialPath fullPath) throws MetadataException, IOException {
        IMeasurementMNode leafMNode = this.mtree.getMeasurementMNode(fullPath);
        try {
            if (leafMNode.getOffset() < 0L) {
                throw new MetadataException(String.format("TimeSeries [%s] does not have any tag/attribute.", fullPath));
            }
            this.tagManager.setTagsOrAttributesValue(alterMap, fullPath, leafMNode);
        }
        finally {
            this.mtree.unPinMNode(leafMNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameTagOrAttributeKey(String oldKey, String newKey, PartialPath fullPath) throws MetadataException, IOException {
        IMeasurementMNode leafMNode = this.mtree.getMeasurementMNode(fullPath);
        try {
            if (leafMNode.getOffset() < 0L) {
                throw new MetadataException(String.format("TimeSeries [%s] does not have [%s] tag/attribute.", fullPath, oldKey), true);
            }
            this.tagManager.renameTagOrAttributeKey(oldKey, newKey, fullPath, leafMNode);
        }
        finally {
            this.mtree.unPinMNode(leafMNode);
        }
    }

    private void removeFromTagInvertedIndex(IMeasurementMNode node) throws IOException {
        this.tagManager.removeFromTagInvertedIndex(node);
    }

    @Override
    public DeviceSchemaInfo getDeviceSchemaInfoWithAutoCreate(PartialPath devicePath, String[] measurements, Function<Integer, TSDataType> getDataType, TSEncoding[] encodings, CompressionType[] compressionTypes, boolean aligned) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activateSchemaTemplate(IActivateTemplateInClusterPlan plan, Template template) throws MetadataException {
        try {
            IMNode deviceNode = this.getDeviceNodeWithAutoCreate(plan.getActivatePath());
            try {
                this.mtree.activateTemplate(plan.getActivatePath(), template);
                this.writeToMLog(plan);
            }
            finally {
                this.mtree.unPinMNode(deviceNode);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new MetadataException((Throwable)e);
        }
    }

    @Override
    public List<String> getPathsUsingTemplate(PartialPath pathPattern, int templateId) throws MetadataException {
        return this.mtree.getPathsUsingTemplate(pathPattern, templateId);
    }

    @Override
    public long constructSchemaBlackListWithTemplate(IPreDeactivateTemplatePlan plan) throws MetadataException {
        Map<PartialPath, List<Integer>> resultTemplateSetInfo = this.mtree.constructSchemaBlackListWithTemplate(plan.getTemplateSetInfo());
        try {
            this.writeToMLog(SchemaRegionPlanFactory.getPreDeactivateTemplatePlan(resultTemplateSetInfo));
        }
        catch (IOException e) {
            throw new MetadataException((Throwable)e);
        }
        return resultTemplateSetInfo.size();
    }

    @Override
    public void rollbackSchemaBlackListWithTemplate(IRollbackPreDeactivateTemplatePlan plan) throws MetadataException {
        Map<PartialPath, List<Integer>> resultTemplateSetInfo = this.mtree.rollbackSchemaBlackListWithTemplate(plan.getTemplateSetInfo());
        try {
            this.writeToMLog(SchemaRegionPlanFactory.getRollbackPreDeactivateTemplatePlan(resultTemplateSetInfo));
        }
        catch (IOException e) {
            throw new MetadataException((Throwable)e);
        }
    }

    @Override
    public void deactivateTemplateInBlackList(IDeactivateTemplatePlan plan) throws MetadataException {
        Map<PartialPath, List<Integer>> resultTemplateSetInfo = this.mtree.deactivateTemplateInBlackList(plan.getTemplateSetInfo());
        try {
            this.writeToMLog(SchemaRegionPlanFactory.getDeactivateTemplatePlan(resultTemplateSetInfo));
        }
        catch (IOException e) {
            throw new MetadataException((Throwable)e);
        }
    }

    @Override
    public long countPathsUsingTemplate(int templateId, PathPatternTree patternTree) throws MetadataException {
        long result = 0L;
        for (PartialPath pathPattern : patternTree.getAllPathPatterns()) {
            result += this.mtree.countPathsUsingTemplate(pathPattern, templateId);
        }
        return result;
    }

    private class RecoverPlanOperator
    extends SchemaRegionPlanVisitor<RecoverOperationResult, SchemaRegionSchemaFileImpl> {
        private RecoverPlanOperator() {
        }

        @Override
        public RecoverOperationResult visitSchemaRegionPlan(ISchemaRegionPlan plan, SchemaRegionSchemaFileImpl context) {
            throw new UnsupportedOperationException(String.format("SchemaRegionPlan of type %s doesn't support recover operation in SchemaRegionSchemaFileImpl.", plan.getPlanType().name()));
        }

        @Override
        public RecoverOperationResult visitCreateTimeSeries(ICreateTimeSeriesPlan createTimeSeriesPlan, SchemaRegionSchemaFileImpl context) {
            try {
                SchemaRegionSchemaFileImpl.this.recoverTimeseries(createTimeSeriesPlan, createTimeSeriesPlan.getTagOffset());
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }

        @Override
        public RecoverOperationResult visitCreateAlignedTimeSeries(ICreateAlignedTimeSeriesPlan createAlignedTimeSeriesPlan, SchemaRegionSchemaFileImpl context) {
            try {
                SchemaRegionSchemaFileImpl.this.recoverAlignedTimeSeries(createAlignedTimeSeriesPlan);
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }

        @Override
        public RecoverOperationResult visitDeleteTimeSeries(IDeleteTimeSeriesPlan deleteTimeSeriesPlan, SchemaRegionSchemaFileImpl context) {
            try {
                SchemaRegionSchemaFileImpl.this.deleteOneTimeseriesUpdateStatistics(deleteTimeSeriesPlan.getDeletePathList().get(0));
                return RecoverOperationResult.SUCCESS;
            }
            catch (IOException | MetadataException e) {
                return new RecoverOperationResult((Exception)e);
            }
        }

        @Override
        public RecoverOperationResult visitChangeAlias(IChangeAliasPlan changeAliasPlan, SchemaRegionSchemaFileImpl context) {
            try {
                SchemaRegionSchemaFileImpl.this.changeAlias(changeAliasPlan.getPath(), changeAliasPlan.getAlias());
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }

        @Override
        public RecoverOperationResult visitChangeTagOffset(IChangeTagOffsetPlan changeTagOffsetPlan, SchemaRegionSchemaFileImpl context) {
            try {
                SchemaRegionSchemaFileImpl.this.changeOffset(changeTagOffsetPlan.getPath(), changeTagOffsetPlan.getOffset());
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }

        @Override
        public RecoverOperationResult visitAutoCreateDeviceMNode(IAutoCreateDeviceMNodePlan autoCreateDeviceMNodePlan, SchemaRegionSchemaFileImpl context) {
            try {
                SchemaRegionSchemaFileImpl.this.autoCreateDeviceMNode(autoCreateDeviceMNodePlan);
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }
    }

    private static class RecoverOperationResult {
        private static final RecoverOperationResult SUCCESS = new RecoverOperationResult(null);
        private final Exception e;

        private RecoverOperationResult(Exception e) {
            this.e = e;
        }

        private boolean isFailed() {
            return this.e != null;
        }

        private Exception getException() {
            return this.e;
        }
    }
}

