/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.trigger.sink.forward.mqtt;

import org.apache.iotdb.db.engine.trigger.sink.api.Configuration;
import org.apache.iotdb.db.engine.trigger.sink.exception.SinkException;
import org.fusesource.mqtt.client.QoS;

public class MQTTForwardConfiguration
implements Configuration {
    private final String host;
    private final int port;
    private final String username;
    private final String password;
    private final String topic;
    private final long reconnectDelay;
    private final long connectAttemptsMax;
    private final QoS qos;
    private final boolean retain;
    private final int poolSize;
    private final boolean stopIfException;

    public MQTTForwardConfiguration(String host, int port, String username, String password, String topic, long reconnectDelay, long connectAttemptsMax, String qos, boolean retain, int poolSize, boolean stopIfException) throws SinkException {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.topic = topic;
        this.reconnectDelay = reconnectDelay;
        this.connectAttemptsMax = connectAttemptsMax;
        this.qos = MQTTForwardConfiguration.parseQoS(qos);
        this.retain = retain;
        this.poolSize = poolSize;
        this.stopIfException = stopIfException;
    }

    private static QoS parseQoS(String qos) throws SinkException {
        switch (qos.toLowerCase()) {
            case "exactly_once": {
                return QoS.EXACTLY_ONCE;
            }
            case "at_least_once": {
                return QoS.AT_LEAST_ONCE;
            }
            case "at_most_once": {
                return QoS.AT_MOST_ONCE;
            }
        }
        throw new SinkException("Unable to identify QoS config");
    }

    public void checkConfig() throws SinkException {
        if (this.host == null || this.host.isEmpty() || this.port < 0 || this.port > 65535 || this.username == null || this.username.isEmpty() || this.password == null || this.password.isEmpty() || this.topic == null || this.topic.isEmpty()) {
            throw new SinkException("MQTT config item error");
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTopic() {
        return this.topic;
    }

    public long getReconnectDelay() {
        return this.reconnectDelay;
    }

    public long getConnectAttemptsMax() {
        return this.connectAttemptsMax;
    }

    public QoS getQos() {
        return this.qos;
    }

    public boolean isRetain() {
        return this.retain;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public boolean isStopIfException() {
        return this.stopIfException;
    }
}

