/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.writer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.db.engine.compaction.writer.AbstractInnerCompactionWriter;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.tsfile.exception.write.PageException;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;
import org.apache.iotdb.tsfile.write.chunk.AlignedChunkWriterImpl;
import org.apache.iotdb.tsfile.write.chunk.ChunkWriterImpl;

public class FastInnerCompactionWriter
extends AbstractInnerCompactionWriter {
    public FastInnerCompactionWriter(TsFileResource targetFileResource) throws IOException {
        super(targetFileResource);
    }

    @Override
    public void write(TimeColumn timestamps, Column[] columns, int subTaskId, int batchSize) throws IOException {
        throw new RuntimeException("Does not support this method in FastInnerCompactionWriter");
    }

    @Override
    public boolean flushNonAlignedChunk(Chunk chunk, ChunkMetadata chunkMetadata, int subTaskId) throws IOException {
        if (this.chunkPointNumArray[subTaskId] != 0 && this.chunkWriters[subTaskId].checkIsChunkSizeOverThreshold(this.targetChunkSize, this.targetChunkPointNum, false)) {
            this.sealChunk(this.fileWriter, this.chunkWriters[subTaskId], subTaskId);
        }
        if (this.chunkPointNumArray[subTaskId] != 0 || !this.checkIsChunkLargeEnough(chunk)) {
            return false;
        }
        this.flushNonAlignedChunkToFileWriter(this.fileWriter, chunk, chunkMetadata, subTaskId);
        this.isEmptyFile = false;
        this.lastTime[subTaskId] = chunkMetadata.getEndTime();
        return true;
    }

    @Override
    public boolean flushAlignedChunk(Chunk timeChunk, IChunkMetadata timeChunkMetadata, List<Chunk> valueChunks, List<IChunkMetadata> valueChunkMetadatas, int subTaskId) throws IOException {
        if (this.chunkPointNumArray[subTaskId] != 0 && this.chunkWriters[subTaskId].checkIsChunkSizeOverThreshold(this.targetChunkSize, this.targetChunkPointNum, false)) {
            this.sealChunk(this.fileWriter, this.chunkWriters[subTaskId], subTaskId);
        }
        if (this.chunkPointNumArray[subTaskId] != 0 || !this.checkIsAlignedChunkLargeEnough(timeChunk, valueChunks)) {
            return false;
        }
        this.flushAlignedChunkToFileWriter(this.fileWriter, timeChunk, timeChunkMetadata, valueChunks, valueChunkMetadatas, subTaskId);
        this.isEmptyFile = false;
        this.lastTime[subTaskId] = timeChunkMetadata.getEndTime();
        return true;
    }

    @Override
    public boolean flushAlignedPage(ByteBuffer compressedTimePageData, PageHeader timePageHeader, List<ByteBuffer> compressedValuePageDatas, List<PageHeader> valuePageHeaders, int subTaskId) throws IOException, PageException {
        boolean isUnsealedPageOverThreshold = this.chunkWriters[subTaskId].checkIsUnsealedPageOverThreshold(this.pageSizeLowerBoundInCompaction, this.pagePointNumLowerBoundInCompaction, true);
        if (isUnsealedPageOverThreshold) {
            this.chunkWriters[subTaskId].sealCurrentPage();
        }
        if (!isUnsealedPageOverThreshold || !this.checkIsAlignedPageLargeEnough(timePageHeader, valuePageHeaders)) {
            return false;
        }
        this.flushAlignedPageToChunkWriter((AlignedChunkWriterImpl)this.chunkWriters[subTaskId], compressedTimePageData, timePageHeader, compressedValuePageDatas, valuePageHeaders, subTaskId);
        this.isEmptyFile = false;
        this.lastTime[subTaskId] = timePageHeader.getEndTime();
        return true;
    }

    @Override
    public boolean flushNonAlignedPage(ByteBuffer compressedPageData, PageHeader pageHeader, int subTaskId) throws PageException {
        boolean isUnsealedPageOverThreshold = this.chunkWriters[subTaskId].checkIsUnsealedPageOverThreshold(this.pageSizeLowerBoundInCompaction, this.pagePointNumLowerBoundInCompaction, true);
        if (isUnsealedPageOverThreshold) {
            this.chunkWriters[subTaskId].sealCurrentPage();
        }
        if (!isUnsealedPageOverThreshold || !this.checkIsPageLargeEnough(pageHeader)) {
            return false;
        }
        this.flushNonAlignedPageToChunkWriter((ChunkWriterImpl)this.chunkWriters[subTaskId], compressedPageData, pageHeader, subTaskId);
        this.isEmptyFile = false;
        this.lastTime[subTaskId] = pageHeader.getEndTime();
        return true;
    }

    private boolean checkIsAlignedChunkLargeEnough(Chunk timeChunk, List<Chunk> valueChunks) {
        if (this.checkIsChunkLargeEnough(timeChunk)) {
            return true;
        }
        for (Chunk valueChunk : valueChunks) {
            if (valueChunk == null || !this.checkIsChunkLargeEnough(valueChunk)) continue;
            return true;
        }
        return false;
    }

    private boolean checkIsChunkLargeEnough(Chunk chunk) {
        return chunk.getChunkStatistic().getCount() >= this.targetChunkPointNum || this.getChunkSize(chunk) >= this.targetChunkSize;
    }

    private boolean checkIsAlignedPageLargeEnough(PageHeader timePageHeader, List<PageHeader> valuePageHeaders) {
        if (this.checkIsPageLargeEnough(timePageHeader)) {
            return true;
        }
        for (PageHeader valuePageHeader : valuePageHeaders) {
            if (valuePageHeader == null || !this.checkIsPageLargeEnough(valuePageHeader)) continue;
            return true;
        }
        return false;
    }

    private boolean checkIsPageLargeEnough(PageHeader pageHeader) {
        return pageHeader.getStatistics().getCount() >= this.pagePointNumLowerBoundInCompaction || (long)pageHeader.getSerializedPageSize() >= this.pageSizeLowerBoundInCompaction;
    }
}

