/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.exception.ShutdownException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.storagegroup.DataRegion;
import org.apache.iotdb.db.exception.DataRegionException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.metadata.mnode.IStorageGroupMNode;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageEngine
implements IService {
    private static final Logger logger = LoggerFactory.getLogger(StorageEngine.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();

    private StorageEngine() {
    }

    public static StorageEngine getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public void start() {
    }

    public void stop() {
    }

    public void shutdown(long milliseconds) throws ShutdownException {
    }

    public ServiceType getID() {
        return ServiceType.STORAGE_ENGINE_SERVICE;
    }

    public DataRegion getProcessor(PartialPath path) throws StorageEngineException {
        try {
            IStorageGroupMNode storageGroupMNode = IoTDB.schemaProcessor.getStorageGroupNodeByPath(path);
            return this.getStorageGroupProcessorByPath(path, storageGroupMNode);
        }
        catch (MetadataException | DataRegionException e) {
            throw new StorageEngineException((IoTDBException)e);
        }
    }

    private DataRegion getStorageGroupProcessorByPath(PartialPath devicePath, IStorageGroupMNode storageGroupMNode) throws DataRegionException {
        return null;
    }

    public Pair<List<DataRegion>, Map<DataRegion, List<PartialPath>>> mergeLock(List<PartialPath> pathList) throws StorageEngineException {
        HashMap<DataRegion, List> map = new HashMap<DataRegion, List>();
        for (PartialPath path : pathList) {
            map.computeIfAbsent(this.getProcessor(path.getDevicePath()), key -> new ArrayList()).add(path);
        }
        List<DataRegion> list = map.keySet().stream().sorted(Comparator.comparing(DataRegion::getDataRegionId)).collect(Collectors.toList());
        list.forEach(DataRegion::readLock);
        return new Pair(list, map);
    }

    public void mergeUnLock(List<DataRegion> list) {
        list.forEach(DataRegion::readUnlock);
    }

    public String getStorageGroupPath(PartialPath selectedPath) {
        return null;
    }

    static class InstanceHolder {
        private static final StorageEngine INSTANCE = new StorageEngine();

        private InstanceHolder() {
        }
    }
}

