/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.iot.service;

import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.consensus.common.Peer;
import org.apache.iotdb.consensus.common.request.BatchIndexedConsensusRequest;
import org.apache.iotdb.consensus.common.request.ByteBufferConsensusRequest;
import org.apache.iotdb.consensus.common.request.IoTConsensusRequest;
import org.apache.iotdb.consensus.exception.ConsensusGroupModifyPeerException;
import org.apache.iotdb.consensus.iot.IoTConsensus;
import org.apache.iotdb.consensus.iot.IoTConsensusServerImpl;
import org.apache.iotdb.consensus.iot.thrift.IoTConsensusIService;
import org.apache.iotdb.consensus.iot.thrift.TActivatePeerReq;
import org.apache.iotdb.consensus.iot.thrift.TActivatePeerRes;
import org.apache.iotdb.consensus.iot.thrift.TBuildSyncLogChannelReq;
import org.apache.iotdb.consensus.iot.thrift.TBuildSyncLogChannelRes;
import org.apache.iotdb.consensus.iot.thrift.TCleanupTransferredSnapshotReq;
import org.apache.iotdb.consensus.iot.thrift.TCleanupTransferredSnapshotRes;
import org.apache.iotdb.consensus.iot.thrift.TInactivatePeerReq;
import org.apache.iotdb.consensus.iot.thrift.TInactivatePeerRes;
import org.apache.iotdb.consensus.iot.thrift.TLogEntry;
import org.apache.iotdb.consensus.iot.thrift.TRemoveSyncLogChannelReq;
import org.apache.iotdb.consensus.iot.thrift.TRemoveSyncLogChannelRes;
import org.apache.iotdb.consensus.iot.thrift.TSendSnapshotFragmentReq;
import org.apache.iotdb.consensus.iot.thrift.TSendSnapshotFragmentRes;
import org.apache.iotdb.consensus.iot.thrift.TSyncLogEntriesReq;
import org.apache.iotdb.consensus.iot.thrift.TSyncLogEntriesRes;
import org.apache.iotdb.consensus.iot.thrift.TTriggerSnapshotLoadReq;
import org.apache.iotdb.consensus.iot.thrift.TTriggerSnapshotLoadRes;
import org.apache.iotdb.consensus.iot.thrift.TWaitSyncLogCompleteReq;
import org.apache.iotdb.consensus.iot.thrift.TWaitSyncLogCompleteRes;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTConsensusRPCServiceProcessor
implements IoTConsensusIService.AsyncIface {
    private final Logger logger = LoggerFactory.getLogger(IoTConsensusRPCServiceProcessor.class);
    private final IoTConsensus consensus;

    public IoTConsensusRPCServiceProcessor(IoTConsensus consensus) {
        this.consensus = consensus;
    }

    public void syncLogEntries(TSyncLogEntriesReq req, AsyncMethodCallback<TSyncLogEntriesRes> resultHandler) {
        try {
            ConsensusGroupId groupId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)req.getConsensusGroupId());
            IoTConsensusServerImpl impl = this.consensus.getImpl(groupId);
            if (impl == null) {
                String message = String.format("unexpected consensusGroupId %s for TSyncLogEntriesReq which size is %s", groupId, req.getLogEntries().size());
                this.logger.error(message);
                TSStatus status = new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
                status.setMessage(message);
                resultHandler.onComplete((Object)new TSyncLogEntriesRes(Collections.singletonList(status)));
                return;
            }
            if (impl.isReadOnly()) {
                String message = "fail to sync logEntries because system is read-only.";
                this.logger.error(message);
                TSStatus status = new TSStatus(TSStatusCode.SYSTEM_READ_ONLY.getStatusCode());
                status.setMessage(message);
                resultHandler.onComplete((Object)new TSyncLogEntriesRes(Collections.singletonList(status)));
                return;
            }
            if (!impl.isActive()) {
                TSStatus status = new TSStatus(TSStatusCode.WRITE_PROCESS_REJECT.getStatusCode());
                status.setMessage("peer is inactive and not ready to receive sync log request");
                resultHandler.onComplete((Object)new TSyncLogEntriesRes(Collections.singletonList(status)));
                return;
            }
            BatchIndexedConsensusRequest logEntriesInThisBatch = new BatchIndexedConsensusRequest(req.peerId);
            for (TLogEntry entry : req.getLogEntries()) {
                logEntriesInThisBatch.add(impl.buildIndexedConsensusRequestForRemoteRequest(entry.getSearchIndex(), entry.getData().stream().map(entry.isFromWAL() ? IoTConsensusRequest::new : ByteBufferConsensusRequest::new).collect(Collectors.toList())));
            }
            TSStatus writeStatus = impl.getStateMachine().write(logEntriesInThisBatch);
            this.logger.debug("execute TSyncLogEntriesReq for {} with result {}", (Object)req.consensusGroupId, (Object)writeStatus.subStatus);
            resultHandler.onComplete((Object)new TSyncLogEntriesRes(writeStatus.subStatus));
        }
        catch (Exception e) {
            resultHandler.onError(e);
        }
    }

    public void inactivatePeer(TInactivatePeerReq req, AsyncMethodCallback<TInactivatePeerRes> resultHandler) throws TException {
        ConsensusGroupId groupId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)req.getConsensusGroupId());
        IoTConsensusServerImpl impl = this.consensus.getImpl(groupId);
        if (impl == null) {
            String message = String.format("unexpected consensusGroupId %s for inactivatePeer request", groupId);
            this.logger.error(message);
            TSStatus status = new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
            status.setMessage(message);
            resultHandler.onComplete((Object)new TInactivatePeerRes(status));
            return;
        }
        impl.setActive(false);
        resultHandler.onComplete((Object)new TInactivatePeerRes(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode())));
    }

    public void activatePeer(TActivatePeerReq req, AsyncMethodCallback<TActivatePeerRes> resultHandler) throws TException {
        ConsensusGroupId groupId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)req.getConsensusGroupId());
        IoTConsensusServerImpl impl = this.consensus.getImpl(groupId);
        if (impl == null) {
            String message = String.format("unexpected consensusGroupId %s for inactivatePeer request", groupId);
            this.logger.error(message);
            TSStatus status = new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
            status.setMessage(message);
            resultHandler.onComplete((Object)new TActivatePeerRes(status));
            return;
        }
        impl.setActive(true);
        resultHandler.onComplete((Object)new TActivatePeerRes(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode())));
    }

    public void buildSyncLogChannel(TBuildSyncLogChannelReq req, AsyncMethodCallback<TBuildSyncLogChannelRes> resultHandler) throws TException {
        TSStatus responseStatus;
        ConsensusGroupId groupId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)req.getConsensusGroupId());
        IoTConsensusServerImpl impl = this.consensus.getImpl(groupId);
        if (impl == null) {
            String message = String.format("unexpected consensusGroupId %s for buildSyncLogChannel request", groupId);
            this.logger.error(message);
            TSStatus status = new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
            status.setMessage(message);
            resultHandler.onComplete((Object)new TBuildSyncLogChannelRes(status));
            return;
        }
        try {
            impl.buildSyncLogChannel(new Peer(groupId, req.nodeId, req.endPoint));
            responseStatus = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (ConsensusGroupModifyPeerException e) {
            responseStatus = new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
            responseStatus.setMessage(e.getMessage());
        }
        resultHandler.onComplete((Object)new TBuildSyncLogChannelRes(responseStatus));
    }

    public void removeSyncLogChannel(TRemoveSyncLogChannelReq req, AsyncMethodCallback<TRemoveSyncLogChannelRes> resultHandler) throws TException {
        TSStatus responseStatus;
        ConsensusGroupId groupId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)req.getConsensusGroupId());
        IoTConsensusServerImpl impl = this.consensus.getImpl(groupId);
        if (impl == null) {
            String message = String.format("unexpected consensusGroupId %s for buildSyncLogChannel request", groupId);
            this.logger.error(message);
            TSStatus status = new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
            status.setMessage(message);
            resultHandler.onComplete((Object)new TRemoveSyncLogChannelRes(status));
            return;
        }
        try {
            impl.removeSyncLogChannel(new Peer(groupId, req.nodeId, req.endPoint));
            responseStatus = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (ConsensusGroupModifyPeerException e) {
            responseStatus = new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
            responseStatus.setMessage(e.getMessage());
        }
        resultHandler.onComplete((Object)new TRemoveSyncLogChannelRes(responseStatus));
    }

    public void waitSyncLogComplete(TWaitSyncLogCompleteReq req, AsyncMethodCallback<TWaitSyncLogCompleteRes> resultHandler) throws TException {
        long safeIndex;
        ConsensusGroupId groupId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)req.getConsensusGroupId());
        IoTConsensusServerImpl impl = this.consensus.getImpl(groupId);
        if (impl == null) {
            String message = String.format("unexpected consensusGroupId %s for waitSyncLogComplete request", groupId);
            this.logger.error(message);
            TSStatus status = new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
            status.setMessage(message);
            resultHandler.onComplete((Object)new TWaitSyncLogCompleteRes(true, 0L, 0L));
            return;
        }
        long searchIndex = impl.getIndex();
        resultHandler.onComplete((Object)new TWaitSyncLogCompleteRes(searchIndex == (safeIndex = impl.getCurrentSafelyDeletedSearchIndex()), searchIndex, safeIndex));
    }

    public void sendSnapshotFragment(TSendSnapshotFragmentReq req, AsyncMethodCallback<TSendSnapshotFragmentRes> resultHandler) throws TException {
        TSStatus responseStatus;
        ConsensusGroupId groupId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)req.getConsensusGroupId());
        IoTConsensusServerImpl impl = this.consensus.getImpl(groupId);
        if (impl == null) {
            String message = String.format("unexpected consensusGroupId %s for buildSyncLogChannel request", groupId);
            this.logger.error(message);
            TSStatus status = new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
            status.setMessage(message);
            resultHandler.onComplete((Object)new TSendSnapshotFragmentRes(status));
            return;
        }
        try {
            impl.receiveSnapshotFragment(req.snapshotId, req.filePath, req.fileChunk);
            responseStatus = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (ConsensusGroupModifyPeerException e) {
            responseStatus = new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
            responseStatus.setMessage(e.getMessage());
        }
        resultHandler.onComplete((Object)new TSendSnapshotFragmentRes(responseStatus));
    }

    public void triggerSnapshotLoad(TTriggerSnapshotLoadReq req, AsyncMethodCallback<TTriggerSnapshotLoadRes> resultHandler) throws TException {
        ConsensusGroupId groupId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)req.getConsensusGroupId());
        IoTConsensusServerImpl impl = this.consensus.getImpl(groupId);
        if (impl == null) {
            String message = String.format("unexpected consensusGroupId %s for buildSyncLogChannel request", groupId);
            this.logger.error(message);
            TSStatus status = new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
            status.setMessage(message);
            resultHandler.onComplete((Object)new TTriggerSnapshotLoadRes(status));
            return;
        }
        impl.loadSnapshot(req.snapshotId);
        resultHandler.onComplete((Object)new TTriggerSnapshotLoadRes(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode())));
    }

    public void cleanupTransferredSnapshot(TCleanupTransferredSnapshotReq req, AsyncMethodCallback<TCleanupTransferredSnapshotRes> resultHandler) throws TException {
        TSStatus responseStatus;
        ConsensusGroupId groupId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)req.getConsensusGroupId());
        IoTConsensusServerImpl impl = this.consensus.getImpl(groupId);
        if (impl == null) {
            String message = String.format("unexpected consensusGroupId %s for buildSyncLogChannel request", groupId);
            this.logger.error(message);
            TSStatus status = new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
            status.setMessage(message);
            resultHandler.onComplete((Object)new TCleanupTransferredSnapshotRes(status));
            return;
        }
        try {
            impl.cleanupTransferredSnapshot(req.snapshotId);
            responseStatus = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (ConsensusGroupModifyPeerException e) {
            this.logger.error(String.format("failed to cleanup transferred snapshot %s", req.snapshotId), (Throwable)e);
            responseStatus = new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
            responseStatus.setMessage(e.getMessage());
        }
        resultHandler.onComplete((Object)new TCleanupTransferredSnapshotRes(responseStatus));
    }

    public void handleClientExit() {
    }
}

