/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.iot.logdispatcher;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.consensus.iot.logdispatcher.IoTConsensusMemoryManagerMetrics;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTConsensusMemoryManager {
    private static final Logger logger = LoggerFactory.getLogger(IoTConsensusMemoryManager.class);
    private final AtomicLong memorySizeInByte = new AtomicLong(0L);
    private Long maxMemorySizeInByte = Runtime.getRuntime().maxMemory() / 10L;
    private Long maxMemorySizeForQueueInByte = Runtime.getRuntime().maxMemory() / 100L * 6L;
    private static final IoTConsensusMemoryManager INSTANCE = new IoTConsensusMemoryManager();

    private IoTConsensusMemoryManager() {
        MetricService.getInstance().addMetricSet((IMetricSet)new IoTConsensusMemoryManagerMetrics(this));
    }

    public boolean reserve(long size, boolean fromQueue) {
        AtomicBoolean result = new AtomicBoolean(false);
        this.memorySizeInByte.updateAndGet(memorySize -> {
            long remainSize = (fromQueue ? this.maxMemorySizeForQueueInByte : this.maxMemorySizeInByte) - memorySize;
            if (size > remainSize) {
                logger.debug("consensus memory limited. required: {}, used: {}, total: {}", new Object[]{size, memorySize, this.maxMemorySizeInByte});
                result.set(false);
                return memorySize;
            }
            logger.debug("{} add {} bytes, total memory size: {} bytes.", new Object[]{Thread.currentThread().getName(), size, memorySize + size});
            result.set(true);
            return memorySize + size;
        });
        return result.get();
    }

    public void free(long size) {
        long currentUsedMemory = this.memorySizeInByte.addAndGet(-size);
        logger.debug("{} free {} bytes, total memory size: {} bytes.", new Object[]{Thread.currentThread().getName(), size, currentUsedMemory});
    }

    public void init(long maxMemorySize, long maxMemorySizeForQueue) {
        this.maxMemorySizeInByte = maxMemorySize;
        this.maxMemorySizeForQueueInByte = maxMemorySizeForQueue;
    }

    long getMemorySizeInByte() {
        return this.memorySizeInByte.get();
    }

    public static IoTConsensusMemoryManager getInstance() {
        return INSTANCE;
    }
}

