/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.iot.logdispatcher;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.consensus.common.Peer;
import org.apache.iotdb.consensus.ratis.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class IndexController {
    public static final String SEPARATOR = "-";
    private final Logger logger = LoggerFactory.getLogger(IndexController.class);
    private long lastFlushedIndex;
    private long currentIndex;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final String storageDir;
    private final Peer peer;
    private final String prefix;
    private final long initialIndex;
    private final long checkpointGap;

    public IndexController(String storageDir, Peer peer, long initialIndex, long checkpointGap) {
        this.storageDir = storageDir;
        this.peer = peer;
        this.prefix = peer.getNodeId() + SEPARATOR;
        this.checkpointGap = checkpointGap;
        this.initialIndex = initialIndex;
        this.upgrade();
        this.restore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long updateAndGet(long index) {
        try {
            this.lock.writeLock().lock();
            long newCurrentIndex = Math.max(this.currentIndex, index);
            this.logger.debug("update index from currentIndex {} to {} for file prefix {} in {}", new Object[]{this.currentIndex, newCurrentIndex, this.prefix, this.storageDir});
            this.currentIndex = newCurrentIndex;
            this.checkPersist();
            long l = this.currentIndex;
            return l;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public long getCurrentIndex() {
        try {
            this.lock.readLock().lock();
            long l = this.currentIndex;
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public long getLastFlushedIndex() {
        return this.lastFlushedIndex;
    }

    private void checkPersist() {
        if (this.currentIndex - this.lastFlushedIndex >= this.checkpointGap) {
            this.persist();
        }
    }

    private void persist() {
        long flushIndex = this.currentIndex - this.currentIndex % this.checkpointGap;
        File oldFile = new File(this.storageDir, this.prefix + this.lastFlushedIndex);
        File newFile = new File(this.storageDir, this.prefix + flushIndex);
        try {
            if (oldFile.exists()) {
                FileUtils.moveFile((File)oldFile, (File)newFile);
                this.logger.info("version file updated, previous: {}, current: {}", (Object)oldFile.getAbsolutePath(), (Object)newFile.getAbsolutePath());
            } else {
                this.logger.info("failed to flush sync index because previous version file {} does not exists. It may be caused by the target Peer is removed from current group. target file is {}", (Object)oldFile.getAbsolutePath(), (Object)newFile.getAbsolutePath());
            }
            this.lastFlushedIndex = flushIndex;
        }
        catch (IOException e) {
            this.logger.error("Error occurred when flushing next version", (Throwable)e);
        }
    }

    private void upgrade() {
        File directory = new File(this.storageDir);
        String oldPrefix = Utils.fromTEndPointToString(this.peer.getEndpoint()) + SEPARATOR;
        Optional.ofNullable(directory.listFiles((dir, name) -> name.startsWith(oldPrefix))).ifPresent(files -> Arrays.stream(files).forEach(oldFile -> {
            String[] splits = oldFile.getName().split(SEPARATOR);
            long fileVersion = Long.parseLong(splits[splits.length - 1]);
            File newFile = new File(this.storageDir, this.prefix + fileVersion);
            try {
                this.logger.info("version file upgrade, previous: {}, current: {}", (Object)oldFile.getAbsolutePath(), (Object)newFile.getAbsolutePath());
                FileUtils.moveFile((File)oldFile, (File)newFile);
            }
            catch (IOException e) {
                this.logger.error("Error occurred when upgrading version file", (Throwable)e);
            }
        }));
    }

    private void restore() {
        File directory = new File(this.storageDir);
        File[] versionFiles = directory.listFiles((dir, name) -> name.startsWith(this.prefix));
        if (versionFiles != null && versionFiles.length > 0) {
            int i;
            long maxVersion = 0L;
            int maxVersionIndex = 0;
            for (i = 0; i < versionFiles.length; ++i) {
                long fileVersion = Long.parseLong(versionFiles[i].getName().split(SEPARATOR)[1]);
                if (fileVersion <= maxVersion) continue;
                maxVersion = fileVersion;
                maxVersionIndex = i;
            }
            this.lastFlushedIndex = maxVersion;
            for (i = 0; i < versionFiles.length; ++i) {
                if (i == maxVersionIndex) continue;
                try {
                    Files.delete(versionFiles[i].toPath());
                    continue;
                }
                catch (IOException e) {
                    this.logger.error("Delete outdated version file {} failed", (Object)versionFiles[i].getAbsolutePath(), (Object)e);
                }
            }
            this.currentIndex = this.lastFlushedIndex;
        } else {
            this.currentIndex = this.initialIndex;
            File versionFile = new File(directory, this.prefix + this.initialIndex);
            try {
                Files.createFile(versionFile.toPath(), new FileAttribute[0]);
                this.lastFlushedIndex = this.initialIndex;
            }
            catch (IOException e) {
                this.logger.error("Error occurred when creating new file {}", (Object)versionFile.getAbsolutePath(), (Object)e);
            }
        }
    }

    public void cleanupVersionFiles() throws IOException {
        File directory = new File(this.storageDir);
        File[] versionFiles = directory.listFiles((dir, name) -> name.startsWith(this.prefix));
        if (versionFiles != null && versionFiles.length > 0) {
            for (File versionFile : versionFiles) {
                Files.delete(versionFile.toPath());
            }
        }
    }
}

